/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class DataModelExtensionReader
extends RegistryReader {
    private static final String EXTENSION = "DataModelProviderExtension";
    private static final String PROVIDER_ELEMENT = "DataModelProvider";
    private static final String DEFINES_TYPE_ELEMENT = "ProviderDefinesType";
    private static final String IMPLEMENTS_TYPE_ELEMENT = "ProviderImplementsType";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_PROVIDER_TYPE = "providerType";
    private static final String ATTRIBUTE_PROVIDER_ID = "providerID";
    private HashMap providerExtensions;
    private HashMap definesExtensions;
    private HashMap implementsExtensions;
    private boolean hasInitialized = false;

    public DataModelExtensionReader() {
        super("org.eclipse.wst.common.frameworks", EXTENSION);
    }

    public boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(PROVIDER_ELEMENT)) {
            String className;
            String id = element.getAttribute(ATTRIBUTE_ID);
            if (id == null || id.trim().length() == 0) {
                WTPCommonPlugin.logError(new RuntimeException("Extension:DataModelProviderExtension Element:DataModelProvider is missing id"));
            }
            if ((className = element.getAttribute(ATTRIBUTE_CLASS)) == null || className.trim().length() == 0) {
                WTPCommonPlugin.logError(new RuntimeException("Extension:DataModelProviderExtension Element:DataModelProvider is missing class"));
            }
            this.addProviderExtension(id, element);
        } else if (element.getName().equals(DEFINES_TYPE_ELEMENT)) {
            String id;
            String type = element.getAttribute(ATTRIBUTE_PROVIDER_TYPE);
            if (type == null || type.trim().length() == 0) {
                WTPCommonPlugin.logError(new RuntimeException("Extension:DataModelProviderExtension Element:ProviderDefinesType is missing providerType"));
            }
            if ((id = element.getAttribute(ATTRIBUTE_PROVIDER_ID)) == null || id.trim().length() == 0) {
                WTPCommonPlugin.logError(new RuntimeException("Extension:DataModelProviderExtension Element:ProviderDefinesType is missing providerID"));
            }
            this.addDefinesExtension(type, id);
        } else if (element.getName().equals(IMPLEMENTS_TYPE_ELEMENT)) {
            String id;
            String type = element.getAttribute(ATTRIBUTE_PROVIDER_TYPE);
            if (type == null || type.trim().length() == 0) {
                WTPCommonPlugin.logError(new RuntimeException("Extension:DataModelProviderExtension Element:ProviderDefinesType is missing providerType"));
            }
            if ((id = element.getAttribute(ATTRIBUTE_PROVIDER_ID)) == null || id.trim().length() == 0) {
                WTPCommonPlugin.logError(new RuntimeException("Extension:DataModelProviderExtension Element:ProviderDefinesType is missing providerID"));
            }
            this.addImplementsExtension(type, id);
        }
        return true;
    }

    private void addProviderExtension(String id, IConfigurationElement element) {
        if (this.providerExtensions.containsKey(id)) {
            WTPCommonPlugin.logError(new RuntimeException("Duplicate DataModelProvider id " + id));
        }
        this.providerExtensions.put(id, element);
    }

    private void addDefinesExtension(String type, String id) {
        if (this.definesExtensions.containsKey(type)) {
            WTPCommonPlugin.logError(new RuntimeException("Duplicate DataModelProvider providerType " + type));
        }
        this.definesExtensions.put(type, id);
    }

    private void addImplementsExtension(String type, String id) {
        List<String> cache = this.implementsExtensions.containsKey(type) ? (List)this.implementsExtensions.get(type) : new ArrayList<String>();
        cache.add(id);
        this.implementsExtensions.put(type, cache);
    }

    protected IConfigurationElement getProviderExtension(String id) {
        this.readRegistryIfNecessary();
        IConfigurationElement element = (IConfigurationElement)this.providerExtensions.get(id);
        if (element == null) {
            WTPCommonPlugin.logError(new RuntimeException("Extension:DataModelProviderExtension Element:DataModelProvider not found for id: " + id));
        }
        return element;
    }

    protected String getDefinesExtension(String providerType) {
        this.readRegistryIfNecessary();
        String element = (String)this.definesExtensions.get(providerType);
        if (element == null) {
            WTPCommonPlugin.logError(new RuntimeException("Extension:DataModelProviderExtension Element:ProviderDefinesType not found for providerType: " + providerType));
        }
        return element;
    }

    public String[] getProviderDescriptorsForProviderKind(String providerType) {
        List implementsIds;
        this.readRegistryIfNecessary();
        ArrayList<String> providerList = new ArrayList<String>();
        providerList.add(this.getDefinesExtension(providerType));
        if (this.implementsExtensions.containsKey(providerType) && (implementsIds = (List)this.implementsExtensions.get(providerType)) != null && !implementsIds.isEmpty()) {
            providerList.addAll(implementsIds);
        }
        String[] providerArray = new String[providerList.size()];
        int i = 0;
        while (i < providerArray.length) {
            providerArray[i] = (String)providerList.get(i);
            ++i;
        }
        return providerArray;
    }

    private void readRegistryIfNecessary() {
        if (!this.hasInitialized) {
            this.providerExtensions = new HashMap();
            this.definesExtensions = new HashMap();
            this.implementsExtensions = new HashMap();
            this.readRegistry();
            this.hasInitialized = true;
        }
    }

    public IDataModelProvider getProvider(String id) {
        IDataModelProvider provider = null;
        IConfigurationElement element = this.getProviderExtension(id);
        if (element == null) {
            return null;
        }
        try {
            provider = (IDataModelProvider)element.createExecutableExtension(ATTRIBUTE_CLASS);
        }
        catch (CoreException e) {
            WTPCommonPlugin.logError(e);
        }
        return provider;
    }
}

