/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.SubContributionManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;

public abstract class AbstractSection
extends AbstractPropertySection
implements SelectionListener,
Listener {
    protected Composite composite;
    protected PaintListener painter;
    protected XSDSchema xsdSchema;
    protected Object input;
    protected boolean isReadOnly;
    protected boolean listenerEnabled = true;
    protected boolean isSimple;
    protected CustomListener customListener = new CustomListener();
    protected IEditorPart owningEditor;
    private IStatusLineManager statusLine;
    protected boolean isTraversing = false;
    public static final Image ICON_ERROR = XSDEditorPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.isSimple = this.getIsSimple();
        this.createContents(parent);
    }

    protected abstract void createContents(Composite var1);

    protected PaintListener createPainter() {
        return new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(gc.getBackground());
                gc.setBackground(AbstractSection.this.getWidgetFactory().getColors().getColor("org.eclipse.ui.forms.TB_BG"));
                gc.setForeground(AbstractSection.this.getWidgetFactory().getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
            }
        };
    }

    public void dispose() {
        if (this.composite != null && !this.composite.isDisposed() && this.painter != null) {
            this.composite.removePaintListener(this.painter);
        }
        super.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Class<?> clazz;
        Object input;
        super.setInput(part, selection);
        this.isSimple = this.getIsSimple();
        this.input = input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof XSDConcreteComponent) {
            this.xsdSchema = ((XSDConcreteComponent)input).getSchema();
        }
        if (part != null) {
            this.owningEditor = part instanceof IEditorPart ? (IEditorPart)part : part.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.xsd.XSDSchema");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.isReadOnly = this.xsdSchema != this.owningEditor.getAdapter((Class)clazz);
        IEditorInput editorInput = this.owningEditor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput) && !(editorInput instanceof FileStoreEditorInput)) {
            this.isReadOnly = true;
        }
    }

    public void refresh() {
        super.refresh();
        this.composite.setEnabled(!this.isReadOnly);
    }

    public void applyAllListeners(Control control) {
        control.addListener(24, (Listener)this.customListener);
        control.addListener(16, (Listener)this.customListener);
        control.addListener(1, (Listener)this.customListener);
    }

    public void applyModifyListeners(Control control) {
        control.addListener(24, (Listener)this.customListener);
        control.addListener(16, (Listener)this.customListener);
    }

    public void applyKeyListener(Control control) {
        control.addListener(1, (Listener)this.customListener);
    }

    public void removeListeners(Control control) {
        control.removeListener(24, (Listener)this.customListener);
        control.removeListener(16, (Listener)this.customListener);
        control.removeListener(1, (Listener)this.customListener);
    }

    public void doWidgetDefaultSelected(SelectionEvent e) {
    }

    public void doWidgetSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && this.input != null && !this.isReadOnly) {
            this.doWidgetSelected(e);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && this.input != null && !this.isReadOnly) {
            this.doWidgetDefaultSelected(e);
        }
    }

    public boolean isListenerEnabled() {
        return this.listenerEnabled;
    }

    public void setListenerEnabled(boolean v) {
        this.listenerEnabled = v;
    }

    public void handleEvent(Event event) {
        if (this.isListenerEnabled() && !this.isReadOnly) {
            this.doHandleEvent(event);
        }
    }

    protected void doHandleEvent(Event event) {
    }

    protected IEditorPart getActiveEditor() {
        IEditorPart editorPart;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        this.owningEditor = editorPart = workbenchWindow.getActivePage().getActiveEditor();
        return editorPart;
    }

    public CommandStack getCommandStack() {
        Object commandStack;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((commandStack = this.owningEditor.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return (CommandStack)commandStack;
    }

    public boolean getIsSimple() {
        return false;
    }

    private IStatusLineManager getStatusLineManager() {
        if (this.statusLine == null && this.getPart() != null) {
            if (this.getPart().getSite() instanceof IEditorSite) {
                this.statusLine = ((IEditorSite)this.getPart().getSite()).getActionBars().getStatusLineManager();
            } else if (this.getPart().getSite() instanceof IViewSite) {
                this.statusLine = ((IViewSite)this.getPart().getSite()).getActionBars().getStatusLineManager();
            }
            if (this.statusLine instanceof SubStatusLineManager) {
                ((SubStatusLineManager)this.statusLine).setVisible(true);
            }
        }
        return this.statusLine;
    }

    public void setErrorMessage(String text) {
        IStatusLineManager statusLine = this.getStatusLineManager();
        if (statusLine != null) {
            if (text == null || text.length() < 1) {
                statusLine.setErrorMessage(null);
            } else {
                statusLine.setErrorMessage(ICON_ERROR, text);
            }
            if (statusLine instanceof SubContributionManager) {
                ((SubContributionManager)statusLine).setVisible(true);
            }
            statusLine.update(true);
        }
    }

    protected EObject getModel() {
        return (XSDComponent)this.input;
    }

    protected boolean shouldPerformComboSelection(int eventType, Object selectedItem) {
        boolean wasTraversing = this.isTraversing;
        if (this.isTraversing) {
            this.isTraversing = false;
        }
        if (eventType == 14) {
            return selectedItem instanceof String && (Messages._UI_ACTION_BROWSE.equals(selectedItem) || Messages._UI_ACTION_NEW.equals(selectedItem));
        }
        return !wasTraversing || !(selectedItem instanceof String) || !Messages._UI_ACTION_BROWSE.equals(selectedItem) && !Messages._UI_ACTION_NEW.equals(selectedItem);
    }

    class CustomListener
    implements Listener {
        boolean handlingEvent = false;

        CustomListener() {
        }

        public void handleEvent(Event event) {
            if (AbstractSection.this.isListenerEnabled() && !AbstractSection.this.isReadOnly) {
                switch (event.type) {
                    case 1: {
                        if (event.character != '\r' || this.handlingEvent) break;
                        this.handlingEvent = true;
                        AbstractSection.this.doHandleEvent(event);
                        this.handlingEvent = false;
                        break;
                    }
                    case 16: {
                        if (this.handlingEvent) break;
                        this.handlingEvent = true;
                        AbstractSection.this.doHandleEvent(event);
                        this.handlingEvent = false;
                    }
                }
            }
        }
    }
}

