/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.core.internal.util.Utilities;

public class BasicStructuredDocumentRegion
implements IStructuredDocumentRegion {
    private static final String TEXT_STORE_NOT_ASSIGNED = "text store not assigned yet";
    private static final String UNDEFINED = "org.eclipse.wst.sse.core.structuredDocument.UNDEFINED";
    private ITextRegionList _regions = new TextRegionListImpl();
    private static final byte MASK_IS_DELETED = 1;
    private static final byte MASK_IS_ENDED = 2;
    private byte fIsDeletedOrEnded = 0;
    private IStructuredDocument fParentDocument;
    protected int fLength;
    private IStructuredDocumentRegion next = null;
    private IStructuredDocumentRegion previous = null;
    protected int start;

    private ITextRegionList _getRegions() {
        return this._regions;
    }

    public void addRegion(ITextRegion aRegion) {
        this._getRegions().add(aRegion);
    }

    public void adjust(int i) {
        this.start += i;
    }

    public void adjustLength(int i) {
        this.fLength += i;
    }

    public void adjustStart(int i) {
        this.start += i;
    }

    public void adjustTextLength(int i) {
    }

    public boolean containsOffset(int i) {
        return this.getStartOffset() <= i && i < this.getEndOffset();
    }

    public boolean containsOffset(ITextRegion containedRegion, int offset) {
        return this.getStartOffset(containedRegion) <= offset && offset < this.getEndOffset(containedRegion);
    }

    public void equatePositions(ITextRegion region) {
        this.start = region.getStart();
        this.fLength = region.getLength();
    }

    public int getEnd() {
        return this.start + this.fLength;
    }

    public int getEndOffset() {
        return this.getEnd();
    }

    public int getEndOffset(ITextRegion containedRegion) {
        return this.getStartOffset(containedRegion) + containedRegion.getLength();
    }

    public ITextRegion getFirstRegion() {
        if (this._getRegions() == null) {
            return null;
        }
        return this._getRegions().get(0);
    }

    public String getFullText() {
        String result = "";
        try {
            result = this.getParentDocument().get(this.start, this.fLength);
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
        return result;
    }

    public String getFullText(ITextRegion aRegion) {
        String result = "";
        try {
            int regionStart = aRegion.getStart();
            int regionLength = aRegion.getLength();
            result = this.fParentDocument.get(this.start + regionStart, regionLength);
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
        return result;
    }

    public String getFullText(String context) {
        ITextRegion region = null;
        String result = "";
        int length = this.getRegions().size();
        int i = 0;
        while (i < length) {
            region = this.getRegions().get(i);
            if (region.getType() == context) {
                result = String.valueOf(result) + this.getFullText(region);
            }
            ++i;
        }
        return result;
    }

    public ITextRegion getLastRegion() {
        if (this._getRegions() == null) {
            return null;
        }
        return this._getRegions().get(this._getRegions().size() - 1);
    }

    public int getLength() {
        return this.fLength;
    }

    public IStructuredDocumentRegion getNext() {
        return this.next;
    }

    public int getNumberOfRegions() {
        return this._getRegions().size();
    }

    public IStructuredDocument getParentDocument() {
        return this.fParentDocument;
    }

    public IStructuredDocumentRegion getPrevious() {
        return this.previous;
    }

    public ITextRegion getRegionAtCharacterOffset(int offset) {
        ITextRegion result = null;
        if (this._getRegions() != null) {
            int length = this.getRegions().size();
            int i = 0;
            while (i < length) {
                ITextRegion region = this.getRegions().get(i);
                if (this.getStartOffset(region) <= offset && offset < this.getEndOffset(region)) {
                    result = region;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public ITextRegionList getRegions() {
        return this._getRegions();
    }

    public int getStart() {
        return this.start;
    }

    public int getStartOffset() {
        return this.getStart();
    }

    public int getStartOffset(ITextRegion containedRegion) {
        return this.getStartOffset() + containedRegion.getStart();
    }

    public String getText() {
        String result = null;
        try {
            result = this.fParentDocument == null ? TEXT_STORE_NOT_ASSIGNED : this.fParentDocument.get(this.start, this.fLength);
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
        return result;
    }

    public String getText(ITextRegion aRegion) {
        try {
            return this.fParentDocument.get(this.getStartOffset(aRegion), aRegion.getTextLength());
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return "";
        }
    }

    public String getText(String context) {
        ITextRegion region = null;
        String result = "";
        int length = this.getRegions().size();
        int i = 0;
        while (i < length) {
            region = this.getRegions().get(i);
            if (region.getType() == context) {
                result = this.getText(region);
                break;
            }
            ++i;
        }
        return result;
    }

    public int getTextEnd() {
        return this.start + this.fLength;
    }

    public int getTextEndOffset() {
        ITextRegion region = this._getRegions().get(this._getRegions().size() - 1);
        return this.getStartOffset() + region.getTextEnd();
    }

    public int getTextEndOffset(ITextRegion containedRegion) {
        return this.getStartOffset(containedRegion) + containedRegion.getTextLength();
    }

    public int getTextLength() {
        return this.fLength;
    }

    public String getType() {
        ITextRegion firstRegion;
        String result = UNDEFINED;
        ITextRegionList subregions = this.getRegions();
        if (subregions != null && subregions.size() > 0 && (firstRegion = subregions.get(0)) != null) {
            result = firstRegion.getType();
        }
        return result;
    }

    public boolean isDeleted() {
        return (this.fIsDeletedOrEnded & 1) != 0 || this.fParentDocument == null;
    }

    public boolean isEnded() {
        return (this.fIsDeletedOrEnded & 2) != 0;
    }

    public boolean sameAs(IStructuredDocumentRegion region, int shift) {
        boolean result = false;
        if (region != null) {
            if (this == region) {
                result = true;
            } else if (this.getType() == region.getType() && this.sameOffsetsAs(region, shift) && this.sameTextAs(region, shift)) {
                result = true;
            }
        }
        return result;
    }

    public boolean sameAs(ITextRegion oldRegion, IStructuredDocumentRegion newDocumentRegion, ITextRegion newRegion, int shift) {
        boolean result = false;
        if (oldRegion != null && newRegion != null) {
            if (oldRegion == newRegion) {
                result = true;
            } else if (oldRegion.getType() == newRegion.getType() && this.sameOffsetsAs(oldRegion, newDocumentRegion, newRegion, shift) && this.sameTextAs(oldRegion, newDocumentRegion, newRegion, shift)) {
                result = true;
            }
        }
        return result;
    }

    private boolean sameOffsetsAs(IStructuredDocumentRegion region, int shift) {
        return this.getStartOffset() == region.getStartOffset() - shift && this.getEndOffset() == region.getEndOffset() - shift;
    }

    private boolean sameOffsetsAs(ITextRegion oldRegion, IStructuredDocumentRegion documentRegion, ITextRegion newRegion, int shift) {
        return this.getStartOffset(oldRegion) == documentRegion.getStartOffset(newRegion) - shift && this.getEndOffset(oldRegion) == documentRegion.getEndOffset(newRegion) - shift;
    }

    private boolean sameTextAs(IStructuredDocumentRegion region, int shift) {
        boolean result = false;
        try {
            if (this.getText().equals(region.getText())) {
                result = true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            result = false;
        }
        return result;
    }

    private boolean sameTextAs(ITextRegion oldRegion, IStructuredDocumentRegion documentRegion, ITextRegion newRegion, int shift) {
        boolean result = false;
        if (this.getText(oldRegion).equals(documentRegion.getText(newRegion))) {
            result = true;
        }
        return result;
    }

    public void setDeleted(boolean isDeleted) {
        this.fIsDeletedOrEnded = isDeleted ? (byte)(this.fIsDeletedOrEnded | 1) : (byte)(this.fIsDeletedOrEnded & 0xFFFFFFFE);
    }

    public void setEnded(boolean newHasEnd) {
        this.fIsDeletedOrEnded = newHasEnd ? (byte)(this.fIsDeletedOrEnded | 2) : (byte)(this.fIsDeletedOrEnded & 0xFFFFFFFD);
    }

    public void setLength(int newLength) {
        this.fLength = newLength;
    }

    public void setNext(IStructuredDocumentRegion newNext) {
        this.next = newNext;
    }

    public void setParentDocument(IStructuredDocument document) {
        this.fParentDocument = document;
    }

    public void setPrevious(IStructuredDocumentRegion newPrevious) {
        this.previous = newPrevious;
    }

    public void setRegions(ITextRegionList containedRegions) {
        this._regions = containedRegions;
    }

    public void setStart(int newStart) {
        this.start = newStart;
    }

    public String toString() {
        String result = null;
        result = "[" + this.getStart() + ", " + this.getEnd() + "] (" + this.getText() + ")";
        return result;
    }

    private void updateDownStreamRegions(ITextRegion changedRegion, int lengthDifference) {
        ITextRegion region;
        int listLength = this._getRegions().size();
        int startIndex = 0;
        int i = 0;
        while (i < listLength) {
            region = this._getRegions().get(i);
            if (region == changedRegion) {
                startIndex = i;
                break;
            }
            ++i;
        }
        int j = ++startIndex;
        while (j < listLength) {
            region = this._getRegions().get(j);
            region.adjustStart(lengthDifference);
            ++j;
        }
    }

    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion structuredDocumentRegion, String changes, int requestStart, int lengthToReplace) {
        StructuredDocumentEvent result = null;
        int lengthDifference = Utilities.calculateLengthDifference(changes, lengthToReplace);
        ITextRegion region = this.getRegionAtCharacterOffset(requestStart);
        if (region == null && lengthToReplace == 0) {
            region = this._getRegions().get(this._getRegions().size() - 1);
            if (this.getEndOffset(region) == requestStart) {
                result = region.updateRegion(requester, this, changes, requestStart, lengthToReplace);
            }
        } else if (region != null && this.containsOffset(region, requestStart) && this.containsOffset(region, requestStart + lengthToReplace)) {
            result = region.updateRegion(requester, this, changes, requestStart, lengthToReplace);
        }
        if (result != null) {
            Assert.isTrue(result instanceof RegionChangedEvent, "Program Error");
            this.updateDownStreamRegions(((RegionChangedEvent)result).getRegion(), lengthDifference);
            this.setLength(this.getLength() + lengthDifference);
        }
        return result;
    }
}

