/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.target;

import java.util.ArrayList;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.IStateDeltaListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesViewComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBookView;
import org.osgi.framework.Version;

public class StateViewPage
extends Page
implements IStateDeltaListener,
IPluginModelListener {
    private IPropertyChangeListener fPropertyListener;
    private FilteredTree fFilteredTree = null;
    private TreeViewer fTreeViewer = null;
    private PageBookView fView;
    private Composite fComposite;
    private Action fOpenAction;
    private String DIALOG_SETTINGS = "targetStateView";
    private static final String HIDE_RESOLVED = "hideResolved";
    private static final String SHOW_NONLEAF = "hideNonLeaf";
    private ViewerFilter fHideResolvedFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof BundleDescription && !((BundleDescription)element).isResolved() || parentElement instanceof BundleDescription && !((BundleDescription)parentElement).isResolved();
        }
    };
    private ViewerFilter fShowLeaves = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof BundleDescription) {
                return ((BundleDescription)element).getDependents().length == 0;
            }
            return true;
        }
    };

    private boolean isJREPackage(ExportPackageDescription supplier) {
        return (Integer)supplier.getDirective("x-equinox-ee") > 0;
    }

    public StateViewPage(PageBookView view) {
        this.fView = view;
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("Preferences.MainPage.showObjects")) {
                    StateViewPage.this.fTreeViewer.refresh();
                }
            }
        };
    }

    public void createControl(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fComposite.setLayoutData((Object)new GridData(1808));
        this.fFilteredTree = new FilteredTree(this.fComposite, 774, new PatternFilter(), true){

            protected void createControl(Composite parent, int treeStyle) {
                super.createControl(parent, treeStyle);
                FormLayout layout = new FormLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                this.setLayout((Layout)layout);
                FormData data = new FormData();
                data.top = new FormAttachment(0, 2);
                data.left = new FormAttachment(0, 2);
                data.right = new FormAttachment(100, -2);
                this.filterComposite.setLayoutData((Object)data);
                data = new FormData();
                data.top = new FormAttachment((Control)this.filterComposite, 2);
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
                data.bottom = new FormAttachment(100, 0);
                this.treeComposite.setLayoutData((Object)data);
            }
        };
        this.fFilteredTree.setBackground(parent.getDisplay().getSystemColor(25));
        this.fTreeViewer = this.fFilteredTree.getViewer();
        this.fTreeViewer.setContentProvider((IContentProvider)new StateContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new StateLabelProvider());
        this.fTreeViewer.setComparator((ViewerComparator)DependenciesViewComparator.getViewerComparator());
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StateViewPage.this.handleDoubleClick();
            }
        });
        if (this.getSettings().getBoolean(HIDE_RESOLVED)) {
            this.fTreeViewer.addFilter(this.fHideResolvedFilter);
        }
        if (this.getSettings().getBoolean(SHOW_NONLEAF)) {
            this.fTreeViewer.addFilter(this.fShowLeaves);
        }
        PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        PDECore.getDefault().getModelManager().addStateDeltaListener((IStateDeltaListener)this);
        this.setActive(true);
    }

    public Control getControl() {
        return this.fComposite;
    }

    public void setFocus() {
        Text c;
        if (this.fFilteredTree != null && (c = this.fFilteredTree.getFilterControl()) != null && !c.isFocusControl()) {
            c.setFocus();
        }
    }

    protected void handleDoubleClick() {
        BundleDescription desc;
        StructuredSelection selection = (StructuredSelection)this.fTreeViewer.getSelection();
        if (selection.size() == 1 && (desc = this.getBundleDescription(selection.getFirstElement())) != null) {
            ManifestEditor.openPluginEditor(desc.getSymbolicName());
        }
    }

    private BundleDescription getBundleDescription(Object obj) {
        if (obj instanceof BundleSpecification) {
            obj = ((BundleSpecification)obj).getSupplier();
        } else if (obj instanceof ImportPackageSpecification) {
            obj = ((ExportPackageDescription)((ImportPackageSpecification)obj).getSupplier()).getSupplier();
        }
        if (obj instanceof BundleDescription) {
            return (BundleDescription)obj;
        }
        return null;
    }

    protected void setActive(boolean active) {
        if (active) {
            State state = PDECore.getDefault().getModelManager().getState().getState();
            state.resolve(true);
            this.fTreeViewer.setInput((Object)state);
            PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        } else {
            PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        }
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        Action filterResolved = new Action(PDEUIMessages.StateViewPage_showOnlyUnresolved_label, 2){

            public void run() {
                StateViewPage.this.getSettings().put(StateViewPage.HIDE_RESOLVED, this.isChecked());
                if (this.isChecked()) {
                    StateViewPage.this.fTreeViewer.addFilter(StateViewPage.this.fHideResolvedFilter);
                } else {
                    StateViewPage.this.fTreeViewer.removeFilter(StateViewPage.this.fHideResolvedFilter);
                }
            }
        };
        Action filterLeaves = new Action(PDEUIMessages.StateViewPage_showLeaves, 2){

            public void run() {
                StateViewPage.this.getSettings().put(StateViewPage.SHOW_NONLEAF, this.isChecked());
                if (this.isChecked()) {
                    StateViewPage.this.fTreeViewer.addFilter(StateViewPage.this.fShowLeaves);
                } else {
                    StateViewPage.this.fTreeViewer.removeFilter(StateViewPage.this.fShowLeaves);
                }
            }
        };
        filterResolved.setChecked(this.getSettings().getBoolean(HIDE_RESOLVED));
        filterLeaves.setChecked(this.getSettings().getBoolean(SHOW_NONLEAF));
        menuManager.add((IAction)filterResolved);
        menuManager.add((IAction)filterLeaves);
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StateViewPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.fView.getSite().getId(), menuMgr, (ISelectionProvider)this.fTreeViewer);
    }

    private void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        BundleDescription desc = this.getBundleDescription(selection.getFirstElement());
        if (desc != null) {
            if (this.fOpenAction == null) {
                this.fOpenAction = new Action(PDEUIMessages.StateViewPage_openItem){

                    public void run() {
                        StateViewPage.this.handleDoubleClick();
                    }
                };
            }
            menu.add((IAction)this.fOpenAction);
            menu.add((IContributionItem)new Separator("additions"));
        }
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().removeStateDeltaListener((IStateDeltaListener)this);
        this.setActive(false);
        super.dispose();
    }

    public void stateResolved(final StateDelta delta) {
        if (!this.fView.getCurrentPage().equals((Object)this) || this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.fTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (delta == null) {
                    StateViewPage.this.fTreeViewer.refresh();
                } else {
                    BundleDelta[] deltas = delta.getChanges();
                    int i = 0;
                    while (i < deltas.length) {
                        int type = deltas[i].getType();
                        if (type == 2 || type == 8 || type == 1 || type == 16) {
                            StateViewPage.this.fTreeViewer.refresh();
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public void stateChanged(final State newState) {
        if (!this.fView.getCurrentPage().equals((Object)this) || this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.fTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

            public void run() {
                StateViewPage.this.fTreeViewer.setInput((Object)newState);
            }
        });
    }

    private IDialogSettings getSettings() {
        IDialogSettings master = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection(this.DIALOG_SETTINGS);
        if (section == null) {
            section = master.addNewSection(this.DIALOG_SETTINGS);
        }
        return section;
    }

    public void modelsChanged(PluginModelDelta delta) {
        if (this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        if (delta.getAddedEntries().length > 0 || delta.getChangedEntries().length > 0 || delta.getRemovedEntries().length > 0) {
            this.fTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    StateViewPage.this.fTreeViewer.refresh();
                }
            });
        }
    }

    class DependencyGroup {
        Object[] dependencies;

        public DependencyGroup(Object[] constraints) {
            this.dependencies = constraints;
        }

        public Object[] getChildren() {
            return this.dependencies;
        }

        public String toString() {
            return this.dependencies[0] instanceof BundleSpecification ? PDEUIMessages.StateViewPage_requiredBundles : PDEUIMessages.StateViewPage_importedPackages;
        }
    }

    class StateContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        StateContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof BundleDescription) {
                BundleDescription desc = (BundleDescription)parentElement;
                if (desc.isResolved()) {
                    Object[] required = this.getResolvedDependencies((VersionConstraint[])desc.getRequiredBundles());
                    Object[] imported = this.getResolvedDependencies((VersionConstraint[])desc.getImportPackages());
                    ArrayList<DependencyGroup> list = new ArrayList<DependencyGroup>(2);
                    if (required.length > 0) {
                        list.add(new DependencyGroup(required));
                    }
                    if (imported.length > 0) {
                        list.add(new DependencyGroup(imported));
                    }
                    return list.toArray();
                }
                return desc.getContainingState().getResolverErrors(desc);
            }
            if (parentElement instanceof DependencyGroup) {
                return ((DependencyGroup)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof State) {
                return ((State)inputElement).getBundles();
            }
            return new Object[0];
        }

        private Object[] getResolvedDependencies(VersionConstraint[] constraints) {
            ArrayList<VersionConstraint> list = new ArrayList<VersionConstraint>(constraints.length);
            int i = 0;
            while (i < constraints.length) {
                if (constraints[i].isResolved()) {
                    list.add(constraints[i]);
                }
                ++i;
            }
            return list.toArray();
        }
    }

    class StateLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private PDELabelProvider fSharedProvider = PDEPlugin.getDefault().getLabelProvider();

        public StateLabelProvider() {
            this.fSharedProvider.connect((Object)this);
        }

        public void dispose() {
            this.fSharedProvider.disconnect((Object)this);
            super.dispose();
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString styledString = new StyledString();
            if (element instanceof ImportPackageSpecification) {
                ImportPackageSpecification spec = (ImportPackageSpecification)element;
                styledString.append(spec.getName());
                ExportPackageDescription supplier = (ExportPackageDescription)spec.getSupplier();
                if (StateViewPage.this.isJREPackage(supplier)) {
                    styledString.append(PDEUIMessages.StateViewPage_suppliedByJRE);
                } else {
                    styledString.append(PDEUIMessages.StateViewPage_suppliedBy);
                    this.getElementString(supplier.getSupplier(), styledString, false);
                }
            } else {
                this.getElementString(element, styledString, true);
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(element));
            super.update(cell);
        }

        private void getElementString(Object element, StyledString styledString, boolean showLocation) {
            if (element instanceof BundleSpecification) {
                styledString.append(((BundleSpecification)element).getSupplier().toString());
            } else if (element instanceof BundleDescription) {
                BundleDescription description = (BundleDescription)element;
                styledString.append(this.fSharedProvider.getObjectText(description));
                Version version = description.getVersion();
                styledString.append(' ').append(PDELabelProvider.formatVersion(version.toString())).toString();
                if (showLocation && description.getLocation() != null) {
                    styledString.append(" - " + description.getLocation(), StyledString.DECORATIONS_STYLER);
                }
            } else {
                styledString.append(element.toString());
            }
        }

        public Image getImage(Object element) {
            if (element instanceof DependencyGroup) {
                element = ((DependencyGroup)element).getChildren()[0];
            }
            if (element instanceof BundleSpecification) {
                element = ((BundleSpecification)element).getSupplier();
            }
            if (element instanceof BundleDescription) {
                int flags = ((BundleDescription)element).isResolved() ? 0 : 1;
                return ((BundleDescription)element).getHost() == null ? this.fSharedProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags) : this.fSharedProvider.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
            }
            if (element instanceof ImportPackageSpecification) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
            }
            if (element instanceof ResolverError) {
                if (((ResolverError)element).getType() == 8192) {
                    return this.fSharedProvider.get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ);
                }
                return this.fSharedProvider.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            String result = element.toString();
            if (element instanceof ImportPackageSpecification) {
                ImportPackageSpecification spec = (ImportPackageSpecification)element;
                result = spec.getName();
            } else if (element instanceof BundleSpecification) {
                result = ((BundleSpecification)element).getSupplier().toString();
            } else if (element instanceof BundleDescription) {
                BundleDescription description = (BundleDescription)element;
                result = this.fSharedProvider.getObjectText(description);
            }
            return result;
        }
    }
}

