/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CalculateUsesOperation
extends WorkspaceModifyOperation {
    private IProject fProject;
    private IBundlePluginModelBase fModel;

    public CalculateUsesOperation(IProject project, IBundlePluginModelBase model) {
        this.fProject = project;
        this.fModel = model;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            Collection packages = this.getPublicExportedPackages();
            if (packages.isEmpty()) {
                return;
            }
            Map pkgsAndUses = this.findPackageReferences(packages, monitor);
            this.handleSetUsesDirectives(pkgsAndUses);
        }
        finally {
            monitor.done();
        }
    }

    protected Collection getPublicExportedPackages() {
        IBundle bundle = this.fModel.getBundleModel().getBundle();
        IManifestHeader header = bundle.getManifestHeader("Export-Package");
        if (header == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList<String> list = new ArrayList<String>();
        ExportPackageObject[] pkgs = ((ExportPackageHeader)header).getPackages();
        int i = 0;
        while (i < pkgs.length) {
            if (!pkgs[i].isInternal()) {
                list.add(pkgs[i].getName());
            }
            ++i;
        }
        return list;
    }

    protected Map findPackageReferences(Collection packages, IProgressMonitor monitor) {
        IJavaProject jp = JavaCore.create((IProject)this.fProject);
        HashMap pkgsAndUses = new HashMap();
        IPackageFragment[] frags = PDEJavaHelper.getPackageFragments((IJavaProject)jp, (Collection)Collections.EMPTY_SET, (boolean)false);
        monitor.beginTask("", frags.length * 2);
        int i = 0;
        while (i < frags.length) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.CalculateUsesOperation_calculatingDirective, (Object)frags[i].getElementName()));
            if (packages.contains(frags[i].getElementName())) {
                HashSet pkgs = new HashSet();
                pkgsAndUses.put(frags[i].getElementName(), pkgs);
                try {
                    this.findReferences((ITypeRoot[])frags[i].getCompilationUnits(), pkgs, (IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
                    this.findReferences((ITypeRoot[])frags[i].getClassFiles(), pkgs, (IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                }
                catch (JavaModelException javaModelException) {}
            } else {
                monitor.worked(2);
            }
            ++i;
        }
        return pkgsAndUses;
    }

    protected void findReferences(ITypeRoot[] roots, Set pkgs, IProgressMonitor monitor, boolean binary) throws JavaModelException {
        monitor.beginTask("", roots.length);
        int i = 0;
        while (i < roots.length) {
            this.findReferences(roots[i].findPrimaryType(), pkgs, binary);
            monitor.worked(1);
            ++i;
        }
    }

    protected void findReferences(IType type, Set pkgs, boolean binary) throws JavaModelException {
        if (type == null) {
            return;
        }
        if (Flags.isPrivate((int)type.getFlags())) {
            return;
        }
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (!Flags.isPrivate((int)methods[i].getFlags())) {
                String methodSignature = methods[i].getSignature();
                this.addPackages(Signature.getThrownExceptionTypes((String)methodSignature), pkgs, type, binary);
                this.addPackages(Signature.getParameterTypes((String)methodSignature), pkgs, type, binary);
                this.addPackage(Signature.getReturnType((String)methodSignature), pkgs, type, binary);
            }
            ++i;
        }
        IField[] fields = type.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            if (!Flags.isPrivate((int)fields[i2].getFlags())) {
                this.addPackage(fields[i2].getTypeSignature(), pkgs, type, binary);
            }
            ++i2;
        }
        this.addPackage(type.getSuperclassTypeSignature(), pkgs, type, binary);
        this.addPackages(type.getSuperInterfaceTypeSignatures(), pkgs, type, binary);
        IType[] subTypes = type.getTypes();
        int i3 = 0;
        while (i3 < subTypes.length) {
            this.findReferences(subTypes[i3], pkgs, binary);
            ++i3;
        }
    }

    protected final void addPackage(String typeSignature, Set pkgs, IType type, boolean binary) throws JavaModelException {
        if (typeSignature == null) {
            return;
        }
        if (binary) {
            typeSignature = typeSignature.replace('/', '.');
        }
        if (typeSignature.indexOf(46) != -1) {
            try {
                String[][] temp = type.resolveType(new String(Signature.toCharArray((char[])typeSignature.toCharArray())));
                if (temp != null) {
                    pkgs.add(temp[0][0]);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            String pkg = Signature.getSignatureQualifier((String)typeSignature);
            if (pkg.length() > 0) {
                pkgs.add(pkg);
                return;
            }
        } else {
            String typeName = Signature.getSignatureSimpleName((String)typeSignature);
            String[][] result = type.resolveType(typeName);
            if (result != null) {
                pkgs.add(result[0][0]);
            }
        }
    }

    protected final void addPackages(String[] typeSignatures, Set pkgs, IType type, boolean binary) throws JavaModelException {
        int i = 0;
        while (i < typeSignatures.length) {
            this.addPackage(typeSignatures[i], pkgs, type, binary);
            ++i;
        }
    }

    protected void handleSetUsesDirectives(Map pkgsAndUses) {
        if (pkgsAndUses.isEmpty()) {
            return;
        }
        this.setUsesDirectives(pkgsAndUses);
    }

    protected void setUsesDirectives(Map pkgsAndUses) {
        IBundle bundle = this.fModel.getBundleModel().getBundle();
        IManifestHeader header = bundle.getManifestHeader("Export-Package");
        ExportPackageObject[] pkgs = ((ExportPackageHeader)header).getPackages();
        int i = 0;
        while (i < pkgs.length) {
            if (pkgsAndUses.containsKey(pkgs[i].getName())) {
                String value = this.getDirectiveValue(pkgs[i].getName(), pkgsAndUses);
                pkgs[i].setUsesDirective(value);
            }
            ++i;
        }
    }

    protected String getDirectiveValue(String pkgName, Map pkgsAndUses) {
        Set usesPkgs = (Set)pkgsAndUses.get(pkgName);
        usesPkgs.remove(pkgName);
        StringBuffer buffer = null;
        Iterator it = usesPkgs.iterator();
        while (it.hasNext()) {
            String usedPkgName = (String)it.next();
            if (usedPkgName.startsWith("java.")) {
                it.remove();
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer();
            } else {
                buffer.append(',');
            }
            buffer.append(usedPkgName);
            it.remove();
        }
        if (usesPkgs.isEmpty()) {
            pkgsAndUses.remove(pkgName);
        }
        return buffer == null ? null : buffer.toString();
    }
}

