/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchConfigurationHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.log.LogView;

public class LaunchListener
implements ILaunchListener,
IDebugEventSetListener {
    private ArrayList managedLaunches = new ArrayList();
    public static final long MAX_FILE_LENGTH = 0x100000L;
    public static final int OPEN_IN_ERROR_LOG_VIEW = 0;
    public static final int OPEN_IN_SYSTEM_EDITOR = 1;

    public void manage(ILaunch launch) {
        if (this.managedLaunches.size() == 0) {
            this.hookListener(true);
        }
        if (!this.managedLaunches.contains(launch)) {
            this.managedLaunches.add(launch);
        }
    }

    public void launchRemoved(ILaunch launch) {
        this.update(launch, true);
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    private void update(ILaunch launch, boolean remove) {
        if (this.managedLaunches.contains(launch) && (remove || launch.isTerminated())) {
            this.managedLaunches.remove(launch);
            if (this.managedLaunches.size() == 0) {
                this.hookListener(false);
            }
        }
    }

    private void hookListener(boolean add) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        if (add) {
            launchManager.addLaunchListener((ILaunchListener)this);
            debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
        } else {
            launchManager.removeLaunchListener((ILaunchListener)this);
            debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        }
    }

    private void doRestart(ILaunch launch) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
            copy.setAttribute("restart", true);
            copy.launch(launch.getLaunchMode(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void shutdown() {
        this.hookListener(false);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IProcess process;
            ILaunch launch;
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (source instanceof IProcess && event.getKind() == 8 && (launch = (process = (IProcess)source).getLaunch()) != null) {
                try {
                    this.launchTerminated(launch, process.getExitValue());
                }
                catch (DebugException debugException) {}
            }
            ++i;
        }
    }

    private void launchTerminated(final ILaunch launch, int returnValue) {
        if (this.managedLaunches.contains(launch)) {
            this.update(launch, true);
            if (returnValue == 23) {
                this.doRestart(launch);
                return;
            }
            if (returnValue == 15) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Launcher_error_title, (String)PDEUIMessages.Launcher_error_code15);
                    }
                });
                return;
            }
            if (returnValue == 13) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            File log = LaunchListener.getMostRecentLogFile(launch.getLaunchConfiguration());
                            if (log != null && log.exists()) {
                                MessageDialog dialog = new MessageDialog(PDEPlugin.getActiveWorkbenchShell(), PDEUIMessages.Launcher_error_title, null, PDEUIMessages.Launcher_error_code13, 1, new String[]{PDEUIMessages.Launcher_error_displayInLogView, PDEUIMessages.Launcher_error_displayInSystemEditor, IDialogConstants.NO_LABEL}, 0);
                                int dialog_value = dialog.open();
                                if (dialog_value == 0) {
                                    LogView errlog = (LogView)PDEPlugin.getActivePage().showView("org.eclipse.pde.runtime.LogView");
                                    errlog.handleImportPath(log.getAbsolutePath());
                                    errlog.sortByDateDescending();
                                } else if (dialog_value == 1) {
                                    LaunchListener.this.openInEditor(log);
                                }
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                });
            }
        }
    }

    private void openInEditor(File log) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(log.getAbsolutePath()));
        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
            IWorkbenchPage page = ww.getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {}
        }
    }

    static File getMostRecentLogFile(ILaunchConfiguration configuration) throws CoreException {
        File configDir;
        File[] children;
        File latest = null;
        String workspace = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        if (workspace.length() > 0 && !(latest = new File(workspace, ".metadata/.log")).exists()) {
            latest = null;
        }
        if ((children = (configDir = LaunchConfigurationHelper.getConfigurationLocation(configuration)).listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                if (!children[i].isDirectory() && children[i].getName().endsWith(".log") && (latest == null || latest.lastModified() < children[i].lastModified())) {
                    latest = children[i];
                }
                ++i;
            }
        }
        return latest;
    }
}

