/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.util.PDEXMLHelper;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.pde.internal.ui.editor.context.XMLDocumentSetupParticpant;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;

public abstract class XMLInputContext
extends UTF8InputContext {
    protected HashMap fOperationTable = new HashMap();
    protected HashMap fMoveOperations = new HashMap();

    public XMLInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
    }

    protected IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new XMLDocumentSetupParticpant();
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                Object object = objects[i];
                switch (event.getChangeType()) {
                    case 2: {
                        if (!(object instanceof IDocumentElementNode)) break;
                        this.removeNode((IDocumentElementNode)object, ops);
                        break;
                    }
                    case 1: {
                        if (!(object instanceof IDocumentElementNode)) break;
                        this.insertNode((IDocumentElementNode)object, ops);
                        break;
                    }
                    case 3: {
                        if (object instanceof IDocumentElementNode) {
                            IDocumentElementNode node = (IDocumentElementNode)object;
                            IDocumentAttributeNode attr = node.getDocumentAttribute(event.getChangedProperty());
                            if (attr != null) {
                                this.addAttributeOperation(attr, ops, event);
                                break;
                            }
                            if (!(event.getOldValue() instanceof IDocumentElementNode) || !(event.getNewValue() instanceof IDocumentElementNode)) break;
                            this.modifyNode(node, ops, event);
                            break;
                        }
                        if (!(object instanceof IDocumentTextNode)) break;
                        this.addElementContentOperation((IDocumentTextNode)object, ops);
                    }
                }
                ++i;
            }
        }
    }

    private void removeNode(IDocumentElementNode node, ArrayList ops) {
        TextEdit oldMove;
        TextEdit old = (TextEdit)this.fOperationTable.get(node);
        if (old != null) {
            ops.remove(old);
            this.fOperationTable.remove(node);
        }
        if ((oldMove = (TextEdit)this.fMoveOperations.get(node)) != null) {
            ops.remove(oldMove);
            this.fMoveOperations.remove(node);
        }
        if (node.getOffset() > -1) {
            DeleteEdit op = this.getDeleteNodeOperation(node);
            ops.add(op);
            this.fOperationTable.put(node, op);
        } else if (old == null && oldMove == null) {
            this.insertNode(node, ops);
        }
    }

    private void insertNode(IDocumentElementNode node, ArrayList ops) {
        TextEdit old;
        InsertEdit op = null;
        if ((node = this.getHighestNodeToBeWritten(node)).getParentNode() == null) {
            if (node.isRoot()) {
                op = new InsertEdit(0, node.write(true));
            }
        } else if (node.getOffset() > -1) {
            op = new ReplaceEdit(node.getOffset(), node.getLength(), node.write(false));
        } else {
            op = this.insertAfterSibling(node);
            if (op == null) {
                op = this.insertAsFirstChild(node);
            }
        }
        if ((old = (TextEdit)this.fOperationTable.get(node)) != null) {
            ops.remove(old);
        }
        if (op != null) {
            ops.add(op);
            this.fOperationTable.put(node, op);
        }
    }

    private InsertEdit insertAfterSibling(IDocumentElementNode node) {
        for (IDocumentElementNode sibling = node.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getOffset() <= -1) continue;
            node.setLineIndent(sibling.getLineIndent());
            String sep = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocumentProvider().getDocument((Object)this.getInput()));
            return new InsertEdit(sibling.getOffset() + sibling.getLength(), String.valueOf(sep) + node.write(true));
        }
        return null;
    }

    private InsertEdit insertAsFirstChild(IDocumentElementNode node) {
        int offset = node.getParentNode().getOffset();
        int length = this.getNextPosition(this.getDocumentProvider().getDocument((Object)this.getInput()), offset, '>');
        node.setLineIndent(node.getParentNode().getLineIndent() + 3);
        String sep = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocumentProvider().getDocument((Object)this.getInput()));
        return new InsertEdit(offset + length + 1, String.valueOf(sep) + node.write(true));
    }

    private void modifyNode(IDocumentElementNode node, ArrayList ops, IModelChangedEvent event) {
        IDocumentElementNode node2;
        IDocumentElementNode oldNode = (IDocumentElementNode)event.getOldValue();
        IDocumentElementNode newNode = (IDocumentElementNode)event.getNewValue();
        IDocumentElementNode node1 = oldNode.getPreviousSibling() == null || oldNode.equals(newNode.getPreviousSibling()) ? oldNode : newNode;
        IDocumentElementNode iDocumentElementNode = node2 = node1.equals(oldNode) ? newNode : oldNode;
        if (node1.getOffset() < 0 && node2.getOffset() < 2) {
            TextEdit op = (TextEdit)this.fOperationTable.get(node1);
            if (op == null) {
                this.insertNode(node, ops);
            } else {
                TextEdit op2 = (TextEdit)this.fOperationTable.get(node2);
                ops.set(ops.indexOf(op), op2);
                ops.set(ops.indexOf(op2), op);
            }
        } else if (node1.getOffset() > -1 && node2.getOffset() > -1) {
            IRegion region = this.getMoveRegion(node1);
            MoveSourceEdit source = new MoveSourceEdit(region.getOffset(), region.getLength());
            region = this.getMoveRegion(node2);
            source.setTargetEdit(new MoveTargetEdit(region.getOffset()));
            MoveSourceEdit op = (MoveSourceEdit)this.fMoveOperations.get(node1);
            if (op != null) {
                ops.set(ops.indexOf(op), source);
            } else {
                op = (MoveSourceEdit)this.fMoveOperations.get(node2);
                if (op != null && op.getTargetEdit().getOffset() == source.getOffset()) {
                    this.fMoveOperations.remove(node2);
                    ops.remove(op);
                    return;
                }
                ops.add(source);
            }
            this.fMoveOperations.put(node1, source);
        } else {
            this.insertNode(node1.getOffset() < 0 ? node1 : node2, ops);
        }
    }

    private IRegion getMoveRegion(IDocumentElementNode node) {
        int offset = node.getOffset();
        int length = node.getLength();
        int i = 1;
        try {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
            while (true) {
                char ch;
                if (!Character.isWhitespace(ch = doc.get(offset - i, 1).toCharArray()[0])) {
                    --i;
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return new Region(offset - i, length + i);
    }

    private void addAttributeOperation(IDocumentAttributeNode attr, ArrayList ops, IModelChangedEvent event) {
        TextEdit oldOp;
        int offset = attr.getValueOffset();
        Object newValue = event.getNewValue();
        IDocumentAttributeNode changedObject = attr;
        ReplaceEdit op = null;
        if (offset > -1) {
            if (newValue == null || newValue.toString().length() == 0) {
                int length = attr.getValueOffset() + attr.getValueLength() + 1 - attr.getNameOffset();
                op = this.getAttributeDeleteEditOperation(attr.getNameOffset(), length);
            } else {
                op = new ReplaceEdit(offset, attr.getValueLength(), this.getWritableAttributeNodeValue(event.getNewValue().toString()));
            }
        }
        if (op == null) {
            IDocumentElementNode node = attr.getEnclosingElement();
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
            if (node.getOffset() > -1) {
                changedObject = node;
                int len = this.getNextPosition(doc, node.getOffset(), '>');
                op = new ReplaceEdit(node.getOffset(), len + 1, node.writeShallow(this.shouldTerminateElement(doc, node.getOffset() + len)));
            } else {
                this.insertNode(node, ops);
                return;
            }
        }
        if ((oldOp = (TextEdit)this.fOperationTable.get(changedObject)) != null) {
            ops.remove(oldOp);
        }
        ops.add(op);
        this.fOperationTable.put(changedObject, op);
    }

    private void addElementContentOperation(IDocumentTextNode textNode, ArrayList ops) {
        ReplaceEdit op = null;
        IDocumentTextNode changedObject = textNode;
        if (textNode.getOffset() > -1) {
            String newText = this.getWritableTextNodeString(textNode);
            op = new ReplaceEdit(textNode.getOffset(), textNode.getLength(), newText);
        } else {
            IDocumentElementNode parent = textNode.getEnclosingElement();
            if (parent.getOffset() > -1) {
                IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
                try {
                    String endChars = doc.get(parent.getOffset() + parent.getLength() - 2, 2);
                    if ("/>".equals(endChars)) {
                        this.insertNode(parent, ops);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {}
                changedObject = parent;
                String sep = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocumentProvider().getDocument((Object)this.getInput()));
                StringBuffer buffer = new StringBuffer(sep);
                int i = 0;
                while (i < parent.getLineIndent()) {
                    buffer.append(" ");
                    ++i;
                }
                buffer.append("   " + this.getWritableTextNodeString(textNode));
                int offset = parent.getOffset();
                int length = this.getNextPosition(doc, offset, '>');
                op = new InsertEdit(offset + length + 1, buffer.toString());
            } else {
                this.insertNode(parent, ops);
                return;
            }
        }
        TextEdit oldOp = (TextEdit)this.fOperationTable.get(changedObject);
        if (oldOp != null) {
            ops.remove(oldOp);
        }
        ops.add(op);
        this.fOperationTable.put(changedObject, op);
    }

    private boolean shouldTerminateElement(IDocument doc, int offset) {
        try {
            return doc.get(offset - 1, 1).toCharArray()[0] == '/';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private int getNextPosition(IDocument doc, int offset, char ch) {
        int i = 0;
        try {
            i = 0;
            while (i + offset < doc.getLength()) {
                if (ch != doc.getChar(offset + i)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        return i;
    }

    private DeleteEdit getAttributeDeleteEditOperation(int offset, int length) {
        try {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
            int i = offset - 1;
            while (i >= 0) {
                char character = doc.getChar(i);
                if (Character.isWhitespace(character)) {
                    ++length;
                    --offset;
                    --i;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        return new DeleteEdit(offset, length);
    }

    private DeleteEdit getDeleteNodeOperation(IDocumentElementNode node) {
        int offset = node.getOffset();
        int length = node.getLength();
        try {
            int extraLength;
            int startOffset;
            int startLineOffset;
            int startLine;
            IDocument doc;
            block5: {
                doc = this.getDocumentProvider().getDocument((Object)this.getInput());
                startLine = doc.getLineOfOffset(offset);
                startLineOffset = doc.getLineOffset(startLine);
                startOffset = offset - 1;
                while (startOffset >= startLineOffset) {
                    if (!Character.isWhitespace(doc.getChar(startOffset))) break;
                    --startOffset;
                }
                ++startOffset;
                int endLine = doc.getLineOfOffset(offset + length);
                int endLineDelimLength = doc.getLineDelimiter(endLine).length();
                extraLength = length;
                do {
                    if (Character.isWhitespace(doc.getChar(offset + ++extraLength))) continue;
                    --extraLength;
                    break block5;
                } while (doc.getLineOfOffset(offset + extraLength) <= endLine);
                extraLength -= endLineDelimLength;
            }
            if (startOffset == startLineOffset) {
                startOffset -= doc.getLineDelimiter(startLine - 1).length();
            }
            length = extraLength + (offset - startOffset);
            offset = startOffset;
        }
        catch (BadLocationException badLocationException) {}
        return new DeleteEdit(offset, length);
    }

    protected void printDeletionRange(int offset, int length) {
        try {
            String string = this.getDocumentProvider().getDocument((Object)this.getInput()).get(offset, length);
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < string.length()) {
                char c = string.charAt(i);
                if (c == '\n') {
                    buffer.append("\\n");
                } else if (c == '\r') {
                    buffer.append("\\r");
                } else if (c == '\t') {
                    buffer.append("\\t");
                } else if (c == ' ') {
                    buffer.append('*');
                } else {
                    buffer.append(c);
                }
                ++i;
            }
            System.out.println(buffer.toString());
        }
        catch (BadLocationException badLocationException) {}
    }

    private IDocumentElementNode getHighestNodeToBeWritten(IDocumentElementNode node) {
        IDocumentElementNode parent = node.getParentNode();
        if (parent == null) {
            return node;
        }
        if (parent.getOffset() > -1) {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
            try {
                String endChars = doc.get(parent.getOffset() + parent.getLength() - 2, 2);
                return "/>".equals(endChars) ? parent : node;
            }
            catch (BadLocationException badLocationException) {
                return node;
            }
        }
        return this.getHighestNodeToBeWritten(parent);
    }

    protected void flushModel(IDocument doc) {
        Object object;
        this.removeUnnecessaryOperations();
        if (this.fOperationTable.size() == 1 && (object = this.fOperationTable.keySet().iterator().next()) instanceof IDocumentElementNode && this.fEditOperations.get(0) instanceof InsertEdit && ((IDocumentElementNode)object).getParentNode() == null) {
            doc.set(((IDocumentElementNode)object).write(true));
            this.fOperationTable.clear();
            this.fEditOperations.clear();
            return;
        }
        this.reorderInsertEdits(this.fEditOperations);
        this.fOperationTable.clear();
        this.fMoveOperations.clear();
        super.flushModel(doc);
    }

    protected abstract void reorderInsertEdits(ArrayList var1);

    protected void removeUnnecessaryOperations() {
        Iterator iter = this.fOperationTable.values().iterator();
        while (iter.hasNext()) {
            Object op;
            IDocumentElementNode node;
            Object object = iter.next();
            if (!(object instanceof IDocumentElementNode) || (node = (IDocumentElementNode)object).getOffset() <= -1) continue;
            IDocumentAttributeNode[] attrs = node.getNodeAttributes();
            int i = 0;
            while (i < attrs.length) {
                op = this.fOperationTable.remove(attrs[i]);
                if (op != null) {
                    this.fEditOperations.remove(op);
                }
                ++i;
            }
            IDocumentTextNode textNode = node.getTextNode();
            if (textNode == null || (op = this.fOperationTable.remove(textNode)) == null) continue;
            this.fEditOperations.remove(op);
        }
    }

    protected String getWritableAttributeNodeValue(String source) {
        return PDEXMLHelper.getWritableString((String)source);
    }

    protected String getWritableTextNodeString(IDocumentTextNode textNode) {
        return textNode.write();
    }

    protected HashMap getOperationTable() {
        return this.fOperationTable;
    }
}

