/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenManifestAction
implements IWorkbenchWindowActionDelegate {
    private ISelection fSelection;
    static /* synthetic */ Class class$0;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.fSelection;
            Iterator it = ssel.iterator();
            final ArrayList<IProject> projects = new ArrayList<IProject>();
            while (it.hasNext()) {
                Object element = it.next();
                IProject proj = null;
                if (element instanceof IFile) {
                    proj = ((IFile)element).getProject();
                } else if (element instanceof IProject) {
                    proj = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)element;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IProject");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    proj = (IProject)iAdaptable.getAdapter((Class)clazz);
                }
                if (proj == null || !WorkspaceModelManager.isPluginProject((IProject)proj)) continue;
                projects.add(proj);
            }
            if (projects.size() > 0) {
                BusyIndicator.showWhile((Display)PDEPlugin.getActiveWorkbenchShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        Iterator it = projects.iterator();
                        while (it.hasNext()) {
                            IProject project = (IProject)it.next();
                            IFile file = project.getFile("META-INF/MANIFEST.MF");
                            if (file == null || !file.exists()) {
                                file = project.getFile("plugin.xml");
                            }
                            if (file == null || !file.exists()) {
                                file = project.getFile("fragment.xml");
                            }
                            if (file == null || !file.exists()) {
                                MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OpenManifestsAction_title, (String)NLS.bind((String)PDEUIMessages.OpenManifestsAction_cannotFind, (Object)project.getName()));
                                continue;
                            }
                            try {
                                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)file, (String)"org.eclipse.pde.ui.manifestEditor");
                            }
                            catch (PartInitException partInitException) {
                                MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OpenManifestsAction_title, (String)NLS.bind((String)PDEUIMessages.OpenManifestsAction_cannotOpen, (Object)project.getName()));
                            }
                        }
                    }
                });
            } else {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OpenManifestsAction_title, (String)PDEUIMessages.OpenManifestAction_noManifest);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }
}

