/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.importexport.RemoteImportExportPlugin;
import org.eclipse.rse.internal.importexport.files.IRemoteFileExportDescriptionWriter;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RemoteFileExportDescriptionWriter
implements IRemoteFileExportDescriptionWriter {
    protected OutputStream fOutputStream;

    public RemoteFileExportDescriptionWriter(OutputStream outputStream) {
        Assert.isNotNull((Object)outputStream);
        this.fOutputStream = new BufferedOutputStream(outputStream);
    }

    public void write(RemoteFileExportData exportData) throws CoreException {
        try {
            this.writeXML(exportData);
        }
        catch (IOException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
        }
    }

    public void writeXML(RemoteFileExportData exportData) throws IOException {
        Assert.isNotNull((Object)exportData);
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        Document document = docBuilder.newDocument();
        Element xmlFileDesc = document.createElement("rexpfd");
        document.appendChild(xmlFileDesc);
        this.xmlWriteDestinationLocation(exportData, document, xmlFileDesc);
        this.xmlWriteOptions(exportData, document, xmlFileDesc);
        this.xmlWriteSelectedElements(exportData, document, xmlFileDesc);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(this.fOutputStream);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    private void xmlWriteDestinationLocation(RemoteFileExportData exportData, Document document, Element xmlFileDesc) throws DOMException {
        Element destination = document.createElement("destination");
        xmlFileDesc.appendChild(destination);
        destination.setAttribute("path", exportData.getDestination());
    }

    private void xmlWriteOptions(RemoteFileExportData exportData, Document document, Element xmlFileDesc) throws DOMException {
        Element options = document.createElement("options");
        xmlFileDesc.appendChild(options);
        options.setAttribute("reviewSynchronize", "" + exportData.isReviewSynchronize());
        options.setAttribute("overWriteExistingFiles", "" + exportData.isOverWriteExistingFiles());
        options.setAttribute("createDirectoryStructure", "" + exportData.isCreateDirectoryStructure());
        options.setAttribute("createSelectedOnly", "" + exportData.isCreateSelectionOnly());
        options.setAttribute("saveSettings", "" + exportData.isSaveSettings());
        options.setAttribute("descriptionFilePath", exportData.getDescriptionFilePath());
    }

    private void xmlWriteSelectedElements(RemoteFileExportData exportData, Document document, Element xmlFileDesc) throws DOMException {
        Element selectedElements = document.createElement("selectedElements");
        xmlFileDesc.appendChild(selectedElements);
        List elements = exportData.getElements();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IResource)) continue;
            this.add((IResource)element, selectedElements, document);
        }
    }

    private void add(IResource resource, Element parent, Document document) {
        Element element = null;
        if (resource.getType() == 4) {
            element = document.createElement("project");
            parent.appendChild(element);
            element.setAttribute("name", resource.getName());
            return;
        }
        if (resource.getType() == 1) {
            element = document.createElement("file");
        } else if (resource.getType() == 2) {
            element = document.createElement("folder");
        }
        if (element != null) {
            parent.appendChild(element);
            element.setAttribute("path", resource.getFullPath().toString());
        }
    }

    public void close() throws CoreException {
        if (this.fOutputStream != null) {
            try {
                this.fOutputStream.close();
            }
            catch (IOException ex) {
                String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
                throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
            }
        }
    }

    public IStatus getStatus() {
        return new Status(0, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, "", null);
    }
}

