/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.gen;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.gen.internal2.ORMGenCustomizer;
import org.eclipse.jpt.gen.internal2.ORMGenTable;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.ui.internal.wizards.gen.TableGenPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class DefaultTableGenerationWizardPage
extends NewTypeWizardPage {
    private JpaProject jpaProject;
    private ORMGenTable defaultsTable;
    private ORMGenCustomizer customizer;
    private TableGenPanel defaultTableGenPanel;

    protected DefaultTableGenerationWizardPage(JpaProject jpaProject) {
        super(true, "DefaultTableGenerationWizardPage");
        this.jpaProject = jpaProject;
        this.setTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_title);
        this.setDescription(JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_desc);
    }

    void init(IStructuredSelection selection) {
        Object jelem = null;
        jelem = selection.getFirstElement() instanceof IJavaElement ? (IJavaElement)selection.getFirstElement() : this.jpaProject.getJavaProject();
        if (jelem != null) {
            this.initContainerPage((IJavaElement)jelem);
            this.initTypePage((IJavaElement)jelem);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.dialog_customizeDefaultEntityGeneration");
        this.defaultTableGenPanel = new TableGenPanel(composite, 4, true, (WizardPage)this);
        this.createDomainJavaClassesPropertiesGroup(composite, 4);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        ORMGenCustomizer customizer;
        super.setVisible(visible);
        if (visible && this.customizer != (customizer = this.getCustomizer())) {
            ORMGenTable newTable;
            this.customizer = customizer;
            this.defaultsTable = newTable = this.getCustomizer().createGenTable(null);
            this.defaultTableGenPanel.setORMGenTable(newTable);
            String baseClass = this.defaultsTable.getExtends() == null ? "" : this.defaultsTable.getExtends();
            this.setSuperClass(baseClass, true);
            this.setSuperInterfaces(this.defaultsTable.getImplements(), true);
            IPackageFragmentRoot root = this.getSourceFolder(this.defaultsTable.getSourceFolder());
            String initPackageName = this.getPackageText();
            if (initPackageName.length() == 0) {
                this.setPackageName(root, this.defaultsTable.getPackage());
            }
            this.setPackageFragmentRoot(root, true);
        }
    }

    private IPackageFragmentRoot getSourceFolder(String srcFodler) {
        IPackageFragmentRoot packageFragmentRoot = null;
        try {
            IJavaProject javaProject = this.jpaProject.getJavaProject();
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1) {
                    if (i == 0) {
                        packageFragmentRoot = roots[i];
                    }
                    if (roots[i].getPath().toString().equals("/" + srcFodler)) {
                        packageFragmentRoot = roots[i];
                        break;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JptUiPlugin.log(e);
        }
        return packageFragmentRoot;
    }

    private void setPackageName(IPackageFragmentRoot packageFragmentRoot, String packageName) {
        if (packageName == null || packageName.length() == 0 || packageFragmentRoot == null) {
            return;
        }
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
        this.setPackageFragment(packageFragment, true);
    }

    protected void createDomainJavaClassesPropertiesGroup(Composite composite, int columns) {
        Group parent = new Group(composite, 0);
        parent.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_domainJavaClass);
        parent.setLayout((Layout)new GridLayout(columns, false));
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        parent.setLayoutData((Object)layoutData);
        this.createPackageControls((Composite)parent, columns);
        this.createContainerControls((Composite)parent, columns);
        this.createSuperClassControls((Composite)parent, columns);
        this.createSuperInterfacesControls((Composite)parent, columns);
    }

    protected IStatus packageChanged() {
        IStatus status = super.packageChanged();
        IPackageFragment packageFragment = this.getPackageFragment();
        if (this.defaultsTable != null && !status.matches(4)) {
            this.defaultsTable.setPackage(packageFragment.getElementName());
        }
        return status;
    }

    protected IStatus superClassChanged() {
        String oldBaseClass;
        IStatus status = super.superClassChanged();
        String baseClass = this.getSuperClass();
        if (baseClass != null && this.defaultsTable != null && !status.matches(4) && !baseClass.equals(oldBaseClass = this.defaultsTable.getExtends())) {
            this.defaultsTable.setExtends(baseClass);
        }
        return status;
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        String srcFolder = this.getPackageFragmentRootText();
        if (!status.matches(4) && this.defaultsTable != null) {
            this.defaultsTable.setSourceFolder(srcFolder);
        }
        return status;
    }

    protected IPackageFragmentRoot chooseContainer() {
        IPackageFragmentRoot initElement = this.getPackageFragmentRoot();
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((IStatus)e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((IStatus)e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IProject)this.jpaProject.getProject()));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (this.fContainerStatus.matches(4)) {
            this.updateStatus(this.fContainerStatus);
        } else if (!this.fPackageStatus.matches(0)) {
            this.updateStatus(this.fPackageStatus);
        } else if (this.fSuperClassStatus.matches(4)) {
            this.updateStatus(this.fSuperClassStatus);
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
    }

    protected IStatus superInterfacesChanged() {
        IStatus ret = super.superInterfacesChanged();
        if (ret.isOK()) {
            List interfaces = this.getSuperInterfaces();
            if (this.defaultsTable != null) {
                this.defaultsTable.setImplements(interfaces);
            }
        }
        return ret;
    }

    private ORMGenCustomizer getCustomizer() {
        GenerateEntitiesFromSchemaWizard wizard = (GenerateEntitiesFromSchemaWizard)this.getWizard();
        return wizard.getCustomizer();
    }

    public final void performHelp() {
        this.getHelpSystem().displayHelp("org.eclipse.jpt.ui.GenerateEntitiesFromSchemaWizard");
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }
}

