/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.details.TypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.AbstractJpaDetailsPage;
import org.eclipse.jpt.ui.internal.mappings.details.PersistentTypeMapAsComposite;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.model.value.FilteringPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentTypeDetailsPage
extends AbstractJpaDetailsPage<PersistentType> {
    private JpaComposite currentMappingComposite;
    private String currentMappingKey;
    private Map<String, JpaComposite> mappingComposites;
    private PageBook typeMappingPageBook;

    public PersistentTypeDetailsPage(Composite parent, WidgetFactory widgetFactory) {
        super(parent, widgetFactory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.mappingComposites = new HashMap<String, JpaComposite>();
    }

    @Override
    protected void initializeLayout(Composite container) {
        new PersistentTypeMapAsComposite(this, this.addSubPane(container, 0, 0, 5, 0));
        this.buildTypeMappingPageBook(container);
    }

    protected PageBook buildTypeMappingPageBook(Composite parent) {
        this.typeMappingPageBook = new PageBook(parent, 0);
        this.typeMappingPageBook.showPage((Control)this.addLabel((Composite)this.typeMappingPageBook, ""));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.typeMappingPageBook.setLayoutData((Object)gridData);
        return this.typeMappingPageBook;
    }

    private TypeMappingUiProvider<? extends TypeMapping> getTypeMappingUiProvider(String key) {
        return this.getJpaPlatformUi().getTypeMappingUiProvider(key, ((PersistentType)this.getSubject()).getContentType());
    }

    private PropertyValueModel<TypeMapping> buildMappingHolder(String key) {
        return new FilteringPropertyValueModel(this.buildGenericMappingHolder(), this.buildMappingFilter(key));
    }

    private PropertyAspectAdapter<PersistentType, TypeMapping> buildGenericMappingHolder() {
        return new PropertyAspectAdapter<PersistentType, TypeMapping>(this.getSubjectHolder(), new String[]{"mapping"}){

            protected TypeMapping buildValue_() {
                return ((PersistentType)this.subject).getMapping();
            }
        };
    }

    private Filter<TypeMapping> buildMappingFilter(final String key) {
        return new Filter<TypeMapping>(){

            public boolean accept(TypeMapping value) {
                return value == null || key.equals(value.getKey());
            }
        };
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.updateMappingPage();
    }

    private void populateMappingPage(String mappingKey) {
        if (this.currentMappingKey == mappingKey) {
            return;
        }
        if (this.currentMappingComposite != null) {
            this.log("/debug/ui/detailsView", "PersistentTypeDetailsPage.populateMappingPage() disposing of current page: " + this.currentMappingKey);
            try {
                this.currentMappingComposite.dispose();
                this.currentMappingComposite = null;
            }
            catch (Exception e) {
                JptUiPlugin.log(e);
            }
        }
        this.currentMappingKey = mappingKey;
        if (this.currentMappingKey != null) {
            this.currentMappingComposite = this.getMappingCompositeFor(mappingKey);
            try {
                this.log("/debug/ui/detailsView", "PersistentTypeDetailsPage.populateMappingPage() populating new page: " + this.currentMappingKey);
                this.currentMappingComposite.populate();
                this.typeMappingPageBook.showPage(this.currentMappingComposite.getControl());
            }
            catch (Exception e) {
                JptUiPlugin.log(e);
                this.log("/debug/ui/detailsView", "PersistentTypeDetailsPage.populateMappingPage() error encountered");
                try {
                    this.currentMappingComposite.dispose();
                }
                catch (Exception exception) {
                    JptUiPlugin.log(e);
                }
                this.mappingComposites.remove(this.currentMappingComposite);
                this.currentMappingComposite = null;
                this.typeMappingPageBook.showPage((Control)this.addLabel((Composite)this.typeMappingPageBook, ""));
            }
        } else {
            this.log("/debug/ui/detailsView", "PersistentTypeDetailsPage.populateMappingPage() no page to show");
            this.typeMappingPageBook.showPage((Control)this.addLabel((Composite)this.typeMappingPageBook, ""));
        }
        this.repaintDetailsView((Composite)this.typeMappingPageBook);
    }

    private JpaComposite getMappingCompositeFor(String key) {
        JpaComposite mappingComposite = this.mappingComposites.get(key);
        if (mappingComposite != null) {
            return mappingComposite;
        }
        mappingComposite = this.buildMappingComposite(this.typeMappingPageBook, key);
        if (mappingComposite != null) {
            this.mappingComposites.put(key, mappingComposite);
        }
        return mappingComposite;
    }

    protected JpaComposite buildMappingComposite(PageBook pageBook, String key) {
        TypeMappingUiProvider<? extends TypeMapping> uiProvider = this.getTypeMappingUiProvider(key);
        return uiProvider.buildPersistentTypeMappingComposite(this.getJpaUiFactory(), this.buildMappingHolder(key), (Composite)pageBook, this.getWidgetFactory());
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("mapping");
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "mapping") {
            this.updateMappingPage();
        }
    }

    private void updateMappingPage() {
        TypeMapping mapping = this.getSubject() != null ? ((PersistentType)this.getSubject()).getMapping() : null;
        this.populateMappingPage(mapping == null ? null : mapping.getKey());
    }

    @Override
    protected void doDispose() {
        this.log("/debug/ui/detailsView", "PersistentTypeDetailsPage.doDispose()");
        if (this.currentMappingComposite != null) {
            this.currentMappingComposite.dispose();
            this.currentMappingComposite = null;
        }
        this.mappingComposites.clear();
        super.doDispose();
    }
}

