/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.nls.Messages;

public class ExpressionArguments {
    private Object m_values;

    public ExpressionArguments(Object argValues) {
        this.setValues(argValues);
    }

    public ExpressionArguments() {
    }

    public boolean hasValues() {
        if (this.m_values == null) {
            return false;
        }
        if (this.m_values instanceof Collection) {
            return !((Collection)this.m_values).isEmpty();
        }
        return true;
    }

    public int valueCount() {
        if (this.m_values == null) {
            return 0;
        }
        if (!(this.m_values instanceof Collection)) {
            return 1;
        }
        return ((Collection)this.m_values).size();
    }

    public Object getValues() {
        return this.m_values;
    }

    public Object getValue(int index) {
        if (index < 0 || index >= this.valueCount()) {
            return null;
        }
        if (!(this.m_values instanceof List)) {
            return index == 0 ? this.m_values : null;
        }
        return ((List)this.m_values).get(index);
    }

    public ExpressionArguments addValue(Object aValue) {
        if (this.m_values == null) {
            this.m_values = new ArrayList(3);
        } else if (!(this.m_values instanceof List)) {
            throw new UnsupportedOperationException(Messages.querySpec_UNABLE_ADD_TO_NON_LIST_COLLECTION);
        }
        ((List)this.m_values).add(aValue);
        return this;
    }

    public ExpressionArguments addValue(int value) {
        return this.addValue((Object)value);
    }

    public ExpressionArguments addValue(double value) {
        return this.addValue((Object)value);
    }

    public ExpressionArguments addValue(boolean value) {
        return this.addValue((Object)value);
    }

    public void setValues(Object argValues) {
        this.m_values = argValues;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(super.toString()) + " Value(s): (");
        if (this.m_values instanceof List) {
            List valuesList = (List)this.m_values;
            int i = 0;
            while (i < valuesList.size()) {
                if (i > 0) {
                    buffer.append(" | ");
                }
                buffer.append(valuesList.get(i));
                ++i;
            }
        } else {
            buffer.append(this.m_values);
        }
        buffer.append(") ");
        return buffer.toString();
    }
}

