/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServerWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.command.SetDeployDirectoryCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.SetInstanceDirectoryCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.SetTestEnvironmentCommand;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ServerLocationEditorSection
extends ServerEditorSection {
    protected Section section;
    protected TomcatServer tomcatServer;
    protected Hyperlink setDefaultDeployDir;
    protected boolean defaultDeployDirIsSet;
    protected Button serverDirMetadata;
    protected Button serverDirInstall;
    protected Button serverDirCustom;
    protected Text serverDir;
    protected Button serverDirBrowse;
    protected Text deployDir;
    protected Button deployDirBrowse;
    protected boolean updating;
    protected PropertyChangeListener listener;
    protected IPublishListener publishListener;
    protected IPath workspacePath;
    protected IPath defaultDeployPath;
    protected boolean allowRestrictedEditing;
    protected IPath tempDirPath;
    protected IPath installDirPath;
    private static final String METADATADIR = ".metadata";
    static /* synthetic */ Class class$0;

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (ServerLocationEditorSection.this.updating) {
                    return;
                }
                ServerLocationEditorSection.this.updating = true;
                if ("instanceDir".equals(event.getPropertyName()) || "testEnvironment".equals(event.getPropertyName())) {
                    ServerLocationEditorSection.this.updateServerDirButtons();
                    ServerLocationEditorSection.this.updateServerDirFields();
                    ServerLocationEditorSection.this.validate();
                } else if ("deployDir".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    ServerLocationEditorSection.this.deployDir.setText(s);
                    ServerLocationEditorSection.this.updateDefaultDeployLink();
                    ServerLocationEditorSection.this.validate();
                }
                ServerLocationEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
        this.publishListener = new PublishAdapter(){

            public void publishFinished(IServer server2, IStatus status) {
                boolean flag = false;
                if (status.isOK() && server2.getModules().length == 0) {
                    flag = true;
                }
                if (flag != ServerLocationEditorSection.this.allowRestrictedEditing) {
                    ServerLocationEditorSection.this.allowRestrictedEditing = flag;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            boolean customServerDir = false;
                            if (!2.access$0(this.this$1).serverDirCustom.isDisposed()) {
                                customServerDir = 2.access$0(this.this$1).serverDirCustom.getSelection();
                            }
                            if (!2.access$0(this.this$1).serverDirMetadata.isDisposed()) {
                                2.access$0(this.this$1).serverDirMetadata.setEnabled(2.access$0(this.this$1).allowRestrictedEditing);
                            }
                            if (!2.access$0(this.this$1).serverDirInstall.isDisposed()) {
                                2.access$0(this.this$1).serverDirInstall.setEnabled(2.access$0(this.this$1).allowRestrictedEditing);
                            }
                            if (!2.access$0(this.this$1).serverDirCustom.isDisposed()) {
                                2.access$0(this.this$1).serverDirCustom.setEnabled(2.access$0(this.this$1).allowRestrictedEditing);
                            }
                            if (!2.access$0(this.this$1).serverDir.isDisposed()) {
                                2.access$0(this.this$1).serverDir.setEnabled(2.access$0(this.this$1).allowRestrictedEditing && customServerDir);
                            }
                            if (!2.access$0(this.this$1).serverDirBrowse.isDisposed()) {
                                2.access$0(this.this$1).serverDirBrowse.setEnabled(2.access$0(this.this$1).allowRestrictedEditing && customServerDir);
                            }
                            if (!2.access$0(this.this$1).setDefaultDeployDir.isDisposed()) {
                                2.access$0(this.this$1).setDefaultDeployDir.setEnabled(2.access$0(this.this$1).allowRestrictedEditing);
                            }
                            if (!2.access$0(this.this$1).deployDir.isDisposed()) {
                                2.access$0(this.this$1).deployDir.setEnabled(2.access$0(this.this$1).allowRestrictedEditing);
                            }
                            if (!2.access$0(this.this$1).deployDirBrowse.isDisposed()) {
                                2.access$0(this.this$1).deployDirBrowse.setEnabled(2.access$0(this.this$1).allowRestrictedEditing);
                            }
                        }
                    });
                }
            }

            static /* synthetic */ ServerLocationEditorSection access$0(2 var0) {
                return var0.ServerLocationEditorSection.this;
            }
        };
        this.server.getOriginal().addPublishListener(this.publishListener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.section = toolkit.createSection(parent, 458);
        this.section.setText(Messages.serverEditorLocationsSection);
        this.section.setDescription(Messages.serverEditorLocationsDescription);
        this.section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.jst.server.tomcat.ui.teig0000");
        whs.setHelp((Control)this.section, "org.eclipse.jst.server.tomcat.ui.teig0000");
        toolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
        this.serverDirMetadata = toolkit.createButton(composite, NLS.bind((String)Messages.serverEditorServerDirMetadata, (Object)Messages.serverEditorDoesNotModify), 16);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.serverDirMetadata.setLayoutData((Object)data);
        this.serverDirMetadata.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerLocationEditorSection.this.updating || !ServerLocationEditorSection.this.serverDirMetadata.getSelection()) {
                    return;
                }
                ServerLocationEditorSection.this.updating = true;
                ServerLocationEditorSection.this.execute((IUndoableOperation)new SetTestEnvironmentCommand((ITomcatServerWorkingCopy)ServerLocationEditorSection.this.tomcatServer, true));
                ServerLocationEditorSection.this.updateServerDirFields();
                ServerLocationEditorSection.this.updating = false;
                ServerLocationEditorSection.this.validate();
            }
        });
        this.serverDirInstall = toolkit.createButton(composite, NLS.bind((String)Messages.serverEditorServerDirInstall, (Object)Messages.serverEditorTakesControl), 16);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.serverDirInstall.setLayoutData((Object)data);
        this.serverDirInstall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerLocationEditorSection.this.updating || !ServerLocationEditorSection.this.serverDirInstall.getSelection()) {
                    return;
                }
                ServerLocationEditorSection.this.updating = true;
                ServerLocationEditorSection.this.execute((IUndoableOperation)new SetTestEnvironmentCommand((ITomcatServerWorkingCopy)ServerLocationEditorSection.this.tomcatServer, false));
                ServerLocationEditorSection.this.updateServerDirFields();
                ServerLocationEditorSection.this.updating = false;
                ServerLocationEditorSection.this.validate();
            }
        });
        this.serverDirCustom = toolkit.createButton(composite, NLS.bind((String)Messages.serverEditorServerDirCustom, (Object)Messages.serverEditorDoesNotModify), 16);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.serverDirCustom.setLayoutData((Object)data);
        this.serverDirCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerLocationEditorSection.this.updating || !ServerLocationEditorSection.this.serverDirCustom.getSelection()) {
                    return;
                }
                ServerLocationEditorSection.this.updating = true;
                ServerLocationEditorSection.this.execute((IUndoableOperation)new SetTestEnvironmentCommand((ITomcatServerWorkingCopy)ServerLocationEditorSection.this.tomcatServer, true));
                ServerLocationEditorSection.this.updateServerDirFields();
                ServerLocationEditorSection.this.updating = false;
                ServerLocationEditorSection.this.validate();
            }
        });
        Label label = this.createLabel(toolkit, composite, Messages.serverEditorServerDir);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.serverDir = toolkit.createText(composite, null, 4);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 75;
        this.serverDir.setLayoutData((Object)data);
        this.serverDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerLocationEditorSection.this.updating) {
                    return;
                }
                ServerLocationEditorSection.this.updating = true;
                ServerLocationEditorSection.this.execute((IUndoableOperation)new SetInstanceDirectoryCommand((ITomcatServerWorkingCopy)ServerLocationEditorSection.this.tomcatServer, ServerLocationEditorSection.this.getServerDir()));
                ServerLocationEditorSection.this.updating = false;
                ServerLocationEditorSection.this.validate();
            }
        });
        this.serverDirBrowse = toolkit.createButton(composite, Messages.editorBrowse, 8);
        this.serverDirBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(ServerLocationEditorSection.this.serverDir.getShell());
                dialog.setMessage(Messages.serverEditorBrowseDeployMessage);
                dialog.setFilterPath(ServerLocationEditorSection.this.serverDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null && !selectedDirectory.equals(ServerLocationEditorSection.this.serverDir.getText())) {
                    ServerLocationEditorSection.this.updating = true;
                    Path path = new Path(selectedDirectory);
                    if (ServerLocationEditorSection.this.workspacePath.isPrefixOf((IPath)path)) {
                        int cnt = path.matchingFirstSegments(ServerLocationEditorSection.this.workspacePath);
                        path = path.removeFirstSegments(cnt).setDevice(null);
                        selectedDirectory = path.toOSString();
                    }
                    ServerLocationEditorSection.this.execute((IUndoableOperation)new SetInstanceDirectoryCommand((ITomcatServerWorkingCopy)ServerLocationEditorSection.this.tomcatServer, selectedDirectory));
                    ServerLocationEditorSection.this.updateServerDirButtons();
                    ServerLocationEditorSection.this.updateServerDirFields();
                    ServerLocationEditorSection.this.updating = false;
                    ServerLocationEditorSection.this.validate();
                }
            }
        });
        this.serverDirBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.setDefaultDeployDir = toolkit.createHyperlink(composite, NLS.bind((String)Messages.serverEditorSetDefaultDeployDirLink, (Object)""), 64);
        this.setDefaultDeployDir.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ServerLocationEditorSection.this.updating = true;
                ServerLocationEditorSection.this.execute((IUndoableOperation)new SetDeployDirectoryCommand((ITomcatServerWorkingCopy)ServerLocationEditorSection.this.tomcatServer, "wtpwebapps"));
                ServerLocationEditorSection.this.deployDir.setText("wtpwebapps");
                ServerLocationEditorSection.this.updateDefaultDeployLink();
                ServerLocationEditorSection.this.updating = false;
                ServerLocationEditorSection.this.validate();
            }
        });
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.setDefaultDeployDir.setLayoutData((Object)data);
        label = this.createLabel(toolkit, composite, Messages.serverEditorDeployDir);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.deployDir = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, true, false);
        this.deployDir.setLayoutData((Object)data);
        this.deployDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerLocationEditorSection.this.updating) {
                    return;
                }
                ServerLocationEditorSection.this.updating = true;
                ServerLocationEditorSection.this.execute((IUndoableOperation)new SetDeployDirectoryCommand((ITomcatServerWorkingCopy)ServerLocationEditorSection.this.tomcatServer, ServerLocationEditorSection.this.deployDir.getText().trim()));
                ServerLocationEditorSection.this.updateDefaultDeployLink();
                ServerLocationEditorSection.this.updating = false;
                ServerLocationEditorSection.this.validate();
            }
        });
        this.deployDirBrowse = toolkit.createButton(composite, Messages.editorBrowse, 8);
        this.deployDirBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(ServerLocationEditorSection.this.deployDir.getShell());
                dialog.setMessage(Messages.serverEditorBrowseDeployMessage);
                dialog.setFilterPath(ServerLocationEditorSection.this.deployDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null && !selectedDirectory.equals(ServerLocationEditorSection.this.deployDir.getText())) {
                    ServerLocationEditorSection.this.updating = true;
                    ServerLocationEditorSection.this.execute((IUndoableOperation)new SetDeployDirectoryCommand((ITomcatServerWorkingCopy)ServerLocationEditorSection.this.tomcatServer, selectedDirectory));
                    ServerLocationEditorSection.this.deployDir.setText(selectedDirectory);
                    ServerLocationEditorSection.this.updating = false;
                    ServerLocationEditorSection.this.validate();
                }
            }
        });
        this.deployDirBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.initialize();
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
            if (this.server.getOriginal() != null) {
                this.server.getOriginal().removePublishListener(this.publishListener);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.workspacePath = root.getLocation();
        this.defaultDeployPath = new Path("wtpwebapps");
        if (this.server != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.tomcatServer = (TomcatServer)this.server.loadAdapter((Class)clazz, null);
            this.addChangeListeners();
        }
        this.initialize();
    }

    protected void initialize() {
        if (this.serverDir == null || this.tomcatServer == null) {
            return;
        }
        this.updating = true;
        IRuntime runtime = this.server.getRuntime();
        if (runtime != null && runtime.getRuntimeType().getId().indexOf("32") < 0) {
            this.section.setDescription(Messages.serverEditorLocationsDescription2);
        }
        if (runtime != null) {
            this.installDirPath = runtime.getLocation();
        }
        this.allowRestrictedEditing = false;
        IPath basePath = this.tomcatServer.getRuntimeBaseDirectory();
        if (!this.readOnly && (basePath != null && !basePath.append("conf").toFile().exists() || this.server.getOriginal().getServerPublishState() == 1 && this.server.getOriginal().getModules().length == 0)) {
            this.allowRestrictedEditing = true;
        }
        this.updateServerDirButtons();
        this.updateServerDirFields();
        this.serverDirMetadata.setEnabled(this.allowRestrictedEditing);
        this.serverDirInstall.setEnabled(this.allowRestrictedEditing);
        this.serverDirCustom.setEnabled(this.allowRestrictedEditing);
        this.updateDefaultDeployLink();
        this.deployDir.setText(this.tomcatServer.getDeployDirectory());
        this.setDefaultDeployDir.setEnabled(this.allowRestrictedEditing);
        this.deployDir.setEnabled(this.allowRestrictedEditing);
        this.deployDirBrowse.setEnabled(this.allowRestrictedEditing);
        this.updating = false;
        this.validate();
    }

    protected String getServerDir() {
        String dir = null;
        if (this.serverDir != null) {
            dir = this.serverDir.getText().trim();
            Path path = new Path(dir);
            if (this.tempDirPath != null && this.tempDirPath.equals((Object)path)) {
                dir = null;
            } else if (this.workspacePath.isPrefixOf((IPath)path)) {
                int cnt = path.matchingFirstSegments(this.workspacePath);
                path = path.removeFirstSegments(cnt).setDevice(null);
                dir = path.toOSString();
            }
        }
        return dir;
    }

    protected void updateServerDirButtons() {
        if (this.tomcatServer.getInstanceDirectory() == null) {
            IPath path = this.tomcatServer.getRuntimeBaseDirectory();
            if (path != null && path.equals((Object)this.installDirPath)) {
                this.serverDirInstall.setSelection(true);
                this.serverDirMetadata.setSelection(false);
                this.serverDirCustom.setSelection(false);
            } else {
                this.serverDirMetadata.setSelection(true);
                this.serverDirInstall.setSelection(false);
                this.serverDirCustom.setSelection(false);
            }
        } else {
            this.serverDirCustom.setSelection(true);
            this.serverDirMetadata.setSelection(false);
            this.serverDirInstall.setSelection(false);
        }
    }

    protected void updateServerDirFields() {
        this.updateServerDir();
        boolean customServerDir = this.serverDirCustom.getSelection();
        this.serverDir.setEnabled(this.allowRestrictedEditing && customServerDir);
        this.serverDirBrowse.setEnabled(this.allowRestrictedEditing && customServerDir);
    }

    protected void updateServerDir() {
        IPath path = this.tomcatServer.getRuntimeBaseDirectory();
        if (path == null) {
            this.serverDir.setText("");
        } else if (this.workspacePath.isPrefixOf(path)) {
            int cnt = path.matchingFirstSegments(this.workspacePath);
            path = path.removeFirstSegments(cnt).setDevice(null);
            this.serverDir.setText(path.toOSString());
            if (this.tempDirPath == null && this.tomcatServer.isTestEnvironment() && this.tomcatServer.getInstanceDirectory() == null) {
                this.tempDirPath = path;
            }
        } else {
            this.serverDir.setText(path.toOSString());
        }
    }

    protected void updateDefaultDeployLink() {
        boolean newState = this.defaultDeployPath.equals((Object)new Path(this.tomcatServer.getDeployDirectory()));
        if (newState != this.defaultDeployDirIsSet) {
            this.setDefaultDeployDir.setText(newState ? Messages.serverEditorSetDefaultDeployDirLink2 : Messages.serverEditorSetDefaultDeployDirLink);
            this.defaultDeployDirIsSet = newState;
        }
    }

    public IStatus[] getSaveStatus() {
        if (this.tomcatServer != null) {
            String dir = this.tomcatServer.getInstanceDirectory();
            if (dir != null) {
                Path path = new Path(dir);
                if (dir.length() == 0 || this.workspacePath.equals((Object)path)) {
                    return new IStatus[]{new Status(4, "org.eclipse.jst.server.tomcat.ui", Messages.errorServerDirIsRoot)};
                }
                if (this.workspacePath.isPrefixOf((IPath)path) || !path.isAbsolute() && METADATADIR.equals(path.segment(0))) {
                    int cnt = path.matchingFirstSegments(this.workspacePath);
                    if (METADATADIR.equals(path.segment(cnt))) {
                        return new IStatus[]{new Status(4, "org.eclipse.jst.server.tomcat.ui", NLS.bind((String)Messages.errorServerDirUnderRoot, (Object)METADATADIR))};
                    }
                } else if (path.equals((Object)this.installDirPath)) {
                    return new IStatus[]{new Status(4, "org.eclipse.jst.server.tomcat.ui", NLS.bind((String)Messages.errorServerDirCustomNotInstall, (Object)NLS.bind((String)Messages.serverEditorServerDirInstall, (Object)"").trim()))};
                }
            } else {
                IPath path = this.tomcatServer.getRuntimeBaseDirectory();
                if (!path.equals((Object)this.installDirPath) && !this.serverDirMetadata.getSelection()) {
                    return new IStatus[]{new Status(4, "org.eclipse.jst.server.tomcat.ui", NLS.bind((String)Messages.errorServerDirCustomNotMetadata, (Object)NLS.bind((String)Messages.serverEditorServerDirMetadata, (Object)"").trim()))};
                }
            }
            if ((dir = this.tomcatServer.getDeployDirectory()) == null || dir.length() == 0) {
                return new IStatus[]{new Status(4, "org.eclipse.jst.server.tomcat.ui", Messages.errorDeployDirNotSpecified)};
            }
        }
        return super.getSaveStatus();
    }

    protected void validate() {
        if (this.tomcatServer != null) {
            String dir = this.tomcatServer.getInstanceDirectory();
            if (dir != null) {
                Path path = new Path(dir);
                if (dir.length() == 0 || this.workspacePath.equals((Object)path)) {
                    this.setErrorMessage(Messages.errorServerDirIsRoot);
                    return;
                }
                if (this.workspacePath.isPrefixOf((IPath)path) || !path.isAbsolute() && METADATADIR.equals(path.segment(0))) {
                    int cnt = path.matchingFirstSegments(this.workspacePath);
                    if (METADATADIR.equals(path.segment(cnt))) {
                        this.setErrorMessage(NLS.bind((String)Messages.errorServerDirUnderRoot, (Object)METADATADIR));
                        return;
                    }
                } else if (path.equals((Object)this.installDirPath)) {
                    this.setErrorMessage(NLS.bind((String)Messages.errorServerDirCustomNotInstall, (Object)NLS.bind((String)Messages.serverEditorServerDirInstall, (Object)"").trim()));
                    return;
                }
            } else {
                IPath path = this.tomcatServer.getRuntimeBaseDirectory();
                if (path != null && !path.equals((Object)this.installDirPath) && !this.serverDirMetadata.getSelection()) {
                    this.setErrorMessage(NLS.bind((String)Messages.errorServerDirCustomNotMetadata, (Object)NLS.bind((String)Messages.serverEditorServerDirMetadata, (Object)"").trim()));
                }
            }
            if ((dir = this.tomcatServer.getDeployDirectory()) == null || dir.length() == 0) {
                this.setErrorMessage(Messages.errorDeployDirNotSpecified);
                return;
            }
        }
        this.setErrorMessage(null);
    }
}

