/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class VirtualReference
implements IVirtualReference {
    private IVirtualComponent referencedComponent;
    private IVirtualComponent enclosingComponent;
    private IPath runtimePath;
    private int dependencyType;
    private String archiveName;

    public VirtualReference() {
    }

    public VirtualReference(IVirtualComponent anEnclosingComponent, IVirtualComponent aReferencedComponent) {
        this(anEnclosingComponent, aReferencedComponent, (IPath)new Path(String.valueOf('/')), 0);
    }

    public VirtualReference(IVirtualComponent anEnclosingComponent, IVirtualComponent aReferencedComponent, IPath aRuntimePath) {
        this(anEnclosingComponent, aReferencedComponent, aRuntimePath, 0);
    }

    public VirtualReference(IVirtualComponent anEnclosingComponent, IVirtualComponent aReferencedComponent, IPath aRuntimePath, int aDependencyType) {
        this.enclosingComponent = anEnclosingComponent;
        this.referencedComponent = aReferencedComponent;
        this.runtimePath = aRuntimePath;
        this.dependencyType = aDependencyType;
    }

    public void create(int updateFlags, IProgressMonitor aMonitor) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.enclosingComponent.getProject());
            WorkbenchComponent component = core.getComponent();
            EList referencedComponents = component.getReferencedComponents();
            ReferencedComponent refComp = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createReferencedComponent();
            if (!this.referencedComponent.isBinary()) {
                refComp.setHandle(ModuleURIUtil.fullyQualifyURI(this.referencedComponent.getProject()));
            } else {
                refComp.setHandle(ModuleURIUtil.archiveComponentfullyQualifyURI(this.referencedComponent.getName()));
            }
            refComp.setRuntimePath(this.runtimePath);
            refComp.setDependencyType(DependencyType.get(this.dependencyType));
            refComp.setArchiveName(this.archiveName);
            if (!referencedComponents.contains(refComp)) {
                referencedComponents.add(refComp);
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(aMonitor);
                core.dispose();
            }
        }
    }

    public void setRuntimePath(IPath aRuntimePath) {
        this.runtimePath = aRuntimePath;
    }

    public IPath getRuntimePath() {
        return this.runtimePath;
    }

    public void setDependencyType(int aDependencyType) {
        this.dependencyType = aDependencyType;
    }

    public int getDependencyType() {
        return this.dependencyType;
    }

    public boolean exists() {
        return false;
    }

    public IVirtualComponent getEnclosingComponent() {
        return this.enclosingComponent;
    }

    public IVirtualComponent getReferencedComponent() {
        return this.referencedComponent;
    }

    public void setReferencedComponent(IVirtualComponent aReferencedComponent, EObject dependentObject) {
        if (aReferencedComponent == null) {
            return;
        }
        StructureEdit enclosingCore = null;
        StructureEdit refCore = null;
        try {
            enclosingCore = StructureEdit.getStructureEditForWrite(this.enclosingComponent.getProject());
            refCore = StructureEdit.getStructureEditForWrite(this.referencedComponent.getProject());
            WorkbenchComponent enclosingComp = enclosingCore.getComponent();
            WorkbenchComponent refComp = refCore.getComponent();
            ReferencedComponent actualReferencedComponent = enclosingCore.findReferencedComponent(enclosingComp, refComp);
            if (actualReferencedComponent != null) {
                this.referencedComponent = aReferencedComponent;
                if (!this.referencedComponent.isBinary()) {
                    actualReferencedComponent.setHandle(ModuleURIUtil.fullyQualifyURI(this.referencedComponent.getProject()));
                } else {
                    actualReferencedComponent.setHandle(ModuleURIUtil.archiveComponentfullyQualifyURI(this.referencedComponent.getName()));
                }
                actualReferencedComponent.setDependentObject(dependentObject);
            }
        }
        finally {
            if (enclosingCore != null) {
                enclosingCore.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                enclosingCore.dispose();
            }
            if (refCore != null) {
                refCore.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                refCore.dispose();
            }
        }
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }
}

