/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;

public class FeatureBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "Feature";
    private String fId;
    private String fVersion;
    private String fHome;
    static /* synthetic */ Class class$0;

    FeatureBundleContainer(String home, String name, String version) {
        this.fId = name;
        this.fVersion = version;
        this.fHome = home;
    }

    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.resolveHomeLocation().toOSString();
        }
        return this.fHome;
    }

    public String getType() {
        return TYPE;
    }

    public String getFeatureId() {
        return this.fId;
    }

    public String getFeatureVersion() {
        return this.fVersion;
    }

    private IPath resolveHomeLocation() throws CoreException {
        return new Path(this.resolveVariables(this.fHome));
    }

    private File resolveFeatureLocation() throws CoreException {
        File features = this.resolveHomeLocation().append("features").toFile();
        if (!features.exists() || features.isFile()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.FeatureBundleContainer_0, (Object)features.toString())));
        }
        if (this.fVersion != null) {
            StringBuffer buf = new StringBuffer();
            String name = buf.append(this.fId).append("_").append(this.fVersion).toString();
            return new File(features, name);
        }
        String[] list = features.list();
        ArrayList<String> versions = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        String prefix = buf.append(this.fId).append("_").toString();
        int i = 0;
        while (i < list.length) {
            String name = list[i];
            if (name.startsWith(prefix)) {
                versions.add(name);
            }
            ++i;
        }
        if (versions.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.FeatureBundleContainer_1, (Object)this.fId)));
        }
        Collections.sort(versions);
        String name = (String)versions.get(versions.size() - 1);
        return new File(features, name);
    }

    protected IResolvedBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        IBaseModel model = null;
        try {
            ITargetPlatformService service;
            if (monitor.isCanceled()) {
                IResolvedBundle[] iResolvedBundleArray = new IResolvedBundle[]{};
                return iResolvedBundleArray;
            }
            File location = this.resolveFeatureLocation();
            File manifest = new File(location, "feature.xml");
            if (!manifest.exists() || !manifest.isFile()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.FeatureBundleContainer_2, (Object)this.fId)));
            }
            model = ExternalFeatureModelManager.createModel(manifest);
            if (model == null || !model.isLoaded()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.FeatureBundleContainer_2, (Object)this.fId)));
            }
            PDECore pDECore = PDECore.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((service = (ITargetPlatformService)pDECore.acquireService(clazz.getName())) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.FeatureBundleContainer_4));
            }
            File dir = new File(manifest.getParentFile().getParentFile().getParentFile(), "plugins");
            if (!dir.exists() || !dir.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.FeatureBundleContainer_5, (Object)this.fId)));
            }
            if (monitor.isCanceled()) {
                IResolvedBundle[] iResolvedBundleArray = new IResolvedBundle[]{};
                return iResolvedBundleArray;
            }
            IBundleContainer container = service.newDirectoryContainer(dir.getAbsolutePath());
            container.resolve(definition, monitor);
            IResolvedBundle[] bundles = container.getBundles();
            IFeature feature = model.getFeature();
            IFeaturePlugin[] plugins = feature.getPlugins();
            ArrayList<BundleInfo> matchInfos = new ArrayList<BundleInfo>(plugins.length);
            int i = 0;
            while (i < plugins.length) {
                if (monitor.isCanceled()) {
                    IResolvedBundle[] iResolvedBundleArray = new IResolvedBundle[]{};
                    return iResolvedBundleArray;
                }
                IFeaturePlugin plugin = plugins[i];
                if (this.isMatch(definition.getArch(), plugin.getArch(), Platform.getOSArch()) && this.isMatch(definition.getNL(), plugin.getNL(), Platform.getNL()) && this.isMatch(definition.getOS(), plugin.getOS(), Platform.getOS()) && this.isMatch(definition.getWS(), plugin.getWS(), Platform.getWS())) {
                    matchInfos.add(new BundleInfo(plugin.getId(), plugin.getVersion(), null, -1, false));
                }
                ++i;
            }
            i = 0;
            while (i < bundles.length) {
                bundles[i].setParentContainer(this);
                ++i;
            }
            IResolvedBundle[] iResolvedBundleArray = AbstractBundleContainer.getMatchingBundles(bundles, matchInfos.toArray(new BundleInfo[matchInfos.size()]), null, this);
            return iResolvedBundleArray;
        }
        finally {
            if (model != null) {
                model.dispose();
            }
        }
    }

    private boolean isMatch(String targetValue, String fragmentValue, String runningValue) {
        if (fragmentValue == null) {
            return true;
        }
        if (targetValue == null) {
            return runningValue.equals(fragmentValue);
        }
        return targetValue.equals(fragmentValue);
    }

    public boolean isContentEqual(AbstractBundleContainer container) {
        if (container instanceof FeatureBundleContainer) {
            FeatureBundleContainer fbc = (FeatureBundleContainer)container;
            return this.fHome.equals(fbc.fHome) && this.fId.equals(fbc.fId) && this.isNullOrEqual(this.fVersion, this.fVersion) && super.isContentEqual(container);
        }
        return false;
    }

    private boolean isNullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public String toString() {
        return "Feature " + this.fId + ' ' + this.fVersion + ' ' + this.fHome + ' ' + (this.getIncludedBundles() == null ? "All" : Integer.toString(this.getIncludedBundles().length)) + " included";
    }

    public String[] getVMArguments() {
        return null;
    }
}

