/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.osgi;

import javax.persistence.Persistence;
import javax.persistence.spi.PersistenceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ProviderTrackerCustomizer
implements ServiceTrackerCustomizer {
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    private BundleContext ctx;

    public ProviderTrackerCustomizer(BundleContext bundleContext) {
        this.ctx = bundleContext;
    }

    public Object addingService(ServiceReference serviceReference) {
        this.log("New service detected...");
        String string = this.getProviderName(serviceReference);
        PersistenceProvider persistenceProvider = (PersistenceProvider)this.ctx.getService(serviceReference);
        Persistence.addProvider(persistenceProvider);
        this.log("Added service " + string);
        return persistenceProvider;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
        this.removedService(serviceReference, object);
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        this.log("Removing service...");
        String string = this.getProviderName(serviceReference);
        Persistence.removeProvider(string);
        this.log("Removed service " + string + " service object: " + object);
    }

    private String getProviderName(ServiceReference serviceReference) {
        String string = (String)serviceReference.getProperty(PERSISTENCE_PROVIDER);
        if (string == null) {
            System.out.println("Provider service registered without name property");
            throw new RuntimeException("Provider service registered without name property");
        }
        return string;
    }

    private void log(String string) {
        System.out.println("ProviderTracker: " + string);
    }
}

