/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.BundleDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorCategory;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptorKind;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.Icon;
import org.eclipse.mylyn.internal.discovery.core.model.Overview;
import org.eclipse.mylyn.internal.discovery.core.model.RemoteBundleDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.util.DiscoveryCategoryComparator;
import org.eclipse.mylyn.internal.discovery.core.util.DiscoveryConnectorComparator;
import org.eclipse.mylyn.internal.discovery.ui.DiscoveryImages;
import org.eclipse.mylyn.internal.discovery.ui.util.DiscoveryUiUtil;
import org.eclipse.mylyn.internal.discovery.ui.wizards.ConnectorDiscoveryWizard;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.eclipse.mylyn.internal.discovery.ui.wizards.OverviewToolTip;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.GradientCanvas;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.themes.IThemeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorDiscoveryWizardMainPage
extends WizardPage {
    private static final String DEFAULT_DIRECTORY_URL = "http://www.eclipse.org/mylyn/discovery/directory.xml";
    private static final String SYSTEM_PROPERTY_DIRECTORY_URL = "mylyn.discovery.directory";
    private static final String COLOR_WHITE = "white";
    private static final String COLOR_DARK_GRAY = "DarkGray";
    private static Boolean useNativeSearchField;
    private final List<ConnectorDescriptor> installableConnectors = new ArrayList<ConnectorDescriptor>();
    private ConnectorDiscovery discovery;
    private Composite body;
    private final List<Resource> disposables = new ArrayList<Resource>();
    private Font h2Font;
    private Font h1Font;
    private Color colorWhite;
    private Text filterText;
    private WorkbenchJob refreshJob;
    private String previousFilterText = "";
    private Pattern filterPattern;
    private Label clearFilterTextControl;
    private Set<String> installedFeatures;
    private Image infoImage;
    private Cursor handCursor;
    private Color colorCategoryGradientStart;
    private Color colorCategoryGradientEnd;
    private Color colorDisabled;
    private ScrolledComposite bodyScrolledComposite;

    public ConnectorDiscoveryWizardMainPage() {
        super(ConnectorDiscoveryWizardMainPage.class.getSimpleName());
        this.setTitle(Messages.ConnectorDiscoveryWizardMainPage_connectorDiscovery);
        this.setDescription(Messages.ConnectorDiscoveryWizardMainPage_pageDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.createRefreshJob();
        Composite container = new Composite(parent, 0);
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ConnectorDiscoveryWizardMainPage.this.refreshJob.cancel();
            }
        });
        container.setLayout((Layout)new GridLayout(1, false));
        Composite header = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(header);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)header);
        if (this.getWizard().isShowConnectorDescriptorKindFilter() || this.getWizard().isShowConnectorDescriptorTextFilter()) {
            Composite filterContainer = new Composite(header, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterContainer);
            int numColumns = 1;
            if (this.getWizard().isShowConnectorDescriptorKindFilter()) {
                numColumns += ConnectorDescriptorKind.values().length;
            }
            if (this.getWizard().isShowConnectorDescriptorTextFilter()) {
                ++numColumns;
            }
            GridLayoutFactory.fillDefaults().numColumns(numColumns).applyTo(filterContainer);
            Label label = new Label(filterContainer, 0);
            label.setText(Messages.ConnectorDiscoveryWizardMainPage_filterLabel);
            if (this.getWizard().isShowConnectorDescriptorTextFilter()) {
                Composite textFilterContainer;
                boolean nativeSearch = ConnectorDiscoveryWizardMainPage.useNativeSearchField(header);
                if (nativeSearch) {
                    textFilterContainer = new Composite(filterContainer, 0);
                } else {
                    textFilterContainer = new Composite(filterContainer, 2048);
                    textFilterContainer.setBackground(header.getDisplay().getSystemColor(25));
                }
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textFilterContainer);
                GridLayoutFactory.fillDefaults().numColumns(2).applyTo(textFilterContainer);
                this.filterText = nativeSearch ? new Text(textFilterContainer, 2436) : new Text(textFilterContainer, 4);
                this.filterText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ConnectorDiscoveryWizardMainPage.this.filterTextChanged();
                    }
                });
                if (nativeSearch) {
                    this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                            if (e.detail == 256) {
                                ConnectorDiscoveryWizardMainPage.this.clearFilterText();
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.filterText);
                } else {
                    GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterText);
                    this.clearFilterTextControl = this.createClearFilterTextControl(textFilterContainer, this.filterText);
                    this.clearFilterTextControl.setVisible(false);
                }
            }
            if (this.getWizard().isShowConnectorDescriptorKindFilter()) {
                ConnectorDescriptorKind[] connectorDescriptorKindArray = ConnectorDescriptorKind.values();
                int n = connectorDescriptorKindArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final ConnectorDescriptorKind kind = connectorDescriptorKindArray[n2];
                    final Button checkbox = new Button(filterContainer, 32);
                    checkbox.setSelection(this.getWizard().isVisible(kind));
                    checkbox.setText(this.getFilterLabel(kind));
                    checkbox.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            boolean selection = checkbox.getSelection();
                            ConnectorDiscoveryWizardMainPage.this.getWizard().setVisibility(kind, selection);
                            ConnectorDiscoveryWizardMainPage.this.connectorDescriptorKindVisibilityUpdated();
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                    ++n2;
                }
            }
        }
        this.body = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 480).applyTo((Control)this.body);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private static boolean useNativeSearchField(Composite composite) {
        if (useNativeSearchField == null) {
            useNativeSearchField = Boolean.FALSE;
            Text testText = null;
            try {
                testText = new Text(composite, 384);
                useNativeSearchField = new Boolean((testText.getStyle() & 0x100) != 0);
            }
            finally {
                if (testText != null) {
                    testText.dispose();
                }
            }
        }
        return useNativeSearchField;
    }

    private void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ConnectorDiscoveryWizardMainPage.this.filterText.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = ConnectorDiscoveryWizardMainPage.this.filterText.getText();
                text = text.trim();
                if (!ConnectorDiscoveryWizardMainPage.this.previousFilterText.equals(text)) {
                    ConnectorDiscoveryWizardMainPage.this.previousFilterText = text;
                    ConnectorDiscoveryWizardMainPage.this.filterPattern = ConnectorDiscoveryWizardMainPage.this.createPattern(ConnectorDiscoveryWizardMainPage.this.previousFilterText);
                    if (ConnectorDiscoveryWizardMainPage.this.clearFilterTextControl != null) {
                        ConnectorDiscoveryWizardMainPage.this.clearFilterTextControl.setVisible(ConnectorDiscoveryWizardMainPage.this.filterPattern != null);
                    }
                    ConnectorDiscoveryWizardMainPage.this.createBodyContents();
                }
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
    }

    protected Pattern createPattern(String filterText) {
        if (filterText == null || filterText.length() == 0) {
            return null;
        }
        String regex = filterText;
        regex.replace("\\", "\\\\").replace("?", ".").replace("*", ".*?");
        return Pattern.compile(regex, 34);
    }

    private Label createClearFilterTextControl(Composite filterContainer, final Text filterText) {
        final Image inactiveImage = CommonImages.FIND_CLEAR_DISABLED.createImage();
        final Image activeImage = CommonImages.FIND_CLEAR.createImage();
        final Image pressedImage = new Image((Device)filterContainer.getDisplay(), activeImage, 2);
        final Label clearButton = new Label(filterContainer, 0);
        clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        clearButton.setImage(inactiveImage);
        clearButton.setToolTipText(Messages.ConnectorDiscoveryWizardMainPage_clearButton_toolTip);
        clearButton.setBackground(filterContainer.getDisplay().getSystemColor(25));
        clearButton.addMouseListener((MouseListener)new MouseAdapter(){
            private MouseMoveListener fMoveListener;

            public void mouseDown(MouseEvent e) {
                clearButton.setImage(pressedImage);
                this.fMoveListener = new MouseMoveListener(){
                    private boolean fMouseInButton = true;

                    public void mouseMove(MouseEvent e) {
                        boolean mouseInButton = this.isMouseInButton(e);
                        if (mouseInButton != this.fMouseInButton) {
                            this.fMouseInButton = mouseInButton;
                            clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                        }
                    }
                };
                clearButton.addMouseMoveListener(this.fMoveListener);
            }

            public void mouseUp(MouseEvent e) {
                if (this.fMoveListener != null) {
                    clearButton.removeMouseMoveListener(this.fMoveListener);
                    this.fMoveListener = null;
                    boolean mouseInButton = this.isMouseInButton(e);
                    clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                    if (mouseInButton) {
                        ConnectorDiscoveryWizardMainPage.this.clearFilterText();
                        filterText.setFocus();
                    }
                }
            }

            private boolean isMouseInButton(MouseEvent e) {
                Point buttonSize = clearButton.getSize();
                return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
            }
        });
        clearButton.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                clearButton.setImage(activeImage);
            }

            public void mouseExit(MouseEvent e) {
                clearButton.setImage(inactiveImage);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        clearButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                inactiveImage.dispose();
                activeImage.dispose();
                pressedImage.dispose();
            }
        });
        clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.ConnectorDiscoveryWizardMainPage_clearButton_accessibleListener;
            }
        });
        clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }
        });
        return clearButton;
    }

    public ConnectorDiscoveryWizard getWizard() {
        return (ConnectorDiscoveryWizard)super.getWizard();
    }

    private void clearFilterText() {
        this.filterText.setText("");
        this.filterTextChanged();
    }

    private void filterTextChanged() {
        this.refreshJob.cancel();
        this.refreshJob.schedule(200L);
    }

    private String getFilterLabel(ConnectorDescriptorKind kind) {
        switch (kind) {
            case DOCUMENT: {
                return Messages.ConnectorDiscoveryWizardMainPage_filter_documents;
            }
            case TASK: {
                return Messages.ConnectorDiscoveryWizardMainPage_filter_tasks;
            }
            case VCS: {
                return Messages.ConnectorDiscoveryWizardMainPage_filter_vcs;
            }
        }
        throw new IllegalStateException(kind.name());
    }

    public void connectorDescriptorKindVisibilityUpdated() {
        this.createBodyContents();
    }

    public void dispose() {
        super.dispose();
        for (Resource resource : this.disposables) {
            resource.dispose();
        }
        this.clearDisposables();
        if (this.discovery != null) {
            this.discovery.dispose();
        }
    }

    private void clearDisposables() {
        this.disposables.clear();
        this.h1Font = null;
        this.h2Font = null;
        this.infoImage = null;
        this.handCursor = null;
        this.colorCategoryGradientStart = null;
        this.colorCategoryGradientEnd = null;
    }

    public void createBodyContents() {
        Control[] controlArray = this.body.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.clearDisposables();
        this.initializeCursors();
        this.initializeImages();
        this.initializeFonts();
        this.initializeColors();
        GridLayoutFactory.fillDefaults().applyTo(this.body);
        this.bodyScrolledComposite = new ScrolledComposite(this.body, 2816);
        this.configureLook((Control)this.bodyScrolledComposite, this.colorWhite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.bodyScrolledComposite);
        final Composite scrolledContents = new Composite((Composite)this.bodyScrolledComposite, 0);
        this.configureLook((Control)scrolledContents, this.colorWhite);
        scrolledContents.setRedraw(false);
        try {
            this.createDiscoveryContents(scrolledContents);
        }
        finally {
            scrolledContents.layout(true);
            scrolledContents.setRedraw(true);
        }
        Point size = scrolledContents.computeSize(this.body.getSize().x, -1, true);
        scrolledContents.setSize(size);
        this.bodyScrolledComposite.setExpandHorizontal(true);
        this.bodyScrolledComposite.setMinWidth(100);
        this.bodyScrolledComposite.setExpandVertical(true);
        this.bodyScrolledComposite.setMinHeight(1);
        this.bodyScrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = scrolledContents.computeSize(((ConnectorDiscoveryWizardMainPage)ConnectorDiscoveryWizardMainPage.this).body.getSize().x - 20, -1, true);
                scrolledContents.setSize(size);
                ConnectorDiscoveryWizardMainPage.this.bodyScrolledComposite.setMinHeight(size.y);
            }
        });
        this.bodyScrolledComposite.setContent((Control)scrolledContents);
        Dialog.applyDialogFont((Control)this.body);
        this.body.layout(true);
    }

    private void initializeCursors() {
        if (this.handCursor == null) {
            this.handCursor = new Cursor((Device)this.getShell().getDisplay(), 21);
            this.disposables.add((Resource)this.handCursor);
        }
    }

    private void initializeImages() {
        if (this.infoImage == null) {
            this.infoImage = DiscoveryImages.MESSAGE_INFO.createImage();
            this.disposables.add((Resource)this.infoImage);
        }
    }

    private void initializeColors() {
        ColorRegistry colorRegistry;
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        if (this.colorWhite == null) {
            colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_WHITE)) {
                colorRegistry.put(COLOR_WHITE, new RGB(255, 255, 255));
            }
            this.colorWhite = colorRegistry.get(COLOR_WHITE);
        }
        if (this.colorDisabled == null) {
            colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_DARK_GRAY)) {
                colorRegistry.put(COLOR_DARK_GRAY, new RGB(105, 105, 105));
            }
            this.colorDisabled = colorRegistry.get(COLOR_DARK_GRAY);
        }
        if (this.colorCategoryGradientStart == null) {
            this.colorCategoryGradientStart = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.start");
            this.colorCategoryGradientEnd = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
        }
    }

    private void initializeFonts() {
        FontData data;
        int n;
        int n2;
        FontData[] fontDataArray;
        FontData[] fontData;
        Font baseFont;
        if (this.h2Font == null) {
            baseFont = JFaceResources.getDialogFont();
            fontDataArray = fontData = baseFont.getFontData();
            n2 = fontData.length;
            n = 0;
            while (n < n2) {
                data = fontDataArray[n];
                data.setStyle(data.getStyle() | 1);
                data.height *= 1.25f;
                ++n;
            }
            this.h2Font = new Font((Device)Display.getCurrent(), fontData);
            this.disposables.add((Resource)this.h2Font);
        }
        if (this.h1Font == null) {
            baseFont = JFaceResources.getDialogFont();
            fontDataArray = fontData = baseFont.getFontData();
            n2 = fontData.length;
            n = 0;
            while (n < n2) {
                data = fontDataArray[n];
                data.setStyle(data.getStyle() | 1);
                data.height *= 1.35f;
                ++n;
            }
            this.h1Font = new Font((Device)Display.getCurrent(), fontData);
            this.disposables.add((Resource)this.h1Font);
        }
    }

    private void createDiscoveryContents(Composite container) {
        Color background = container.getBackground();
        if (this.discovery == null || this.isEmpty(this.discovery)) {
            Label helpTextControl;
            GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(container);
            boolean atLeastOneKindFiltered = false;
            ConnectorDescriptorKind[] connectorDescriptorKindArray = ConnectorDescriptorKind.values();
            int n = connectorDescriptorKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectorDescriptorKind kind = connectorDescriptorKindArray[n2];
                if (!this.getWizard().isVisible(kind)) {
                    atLeastOneKindFiltered = true;
                    break;
                }
                ++n2;
            }
            if (this.filterPattern != null) {
                Link link = new Link(container, 64);
                link.setFont(container.getFont());
                link.setText(Messages.ConnectorDiscoveryWizardMainPage_noMatchingItems_withFilterText);
                link.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        ConnectorDiscoveryWizardMainPage.this.clearFilterText();
                        ConnectorDiscoveryWizardMainPage.this.filterText.setFocus();
                    }
                });
                helpTextControl = link;
            } else {
                Label helpText = new Label(container, 64);
                helpText.setFont(container.getFont());
                if (atLeastOneKindFiltered) {
                    helpText.setText(Messages.ConnectorDiscoveryWizardMainPage_noMatchingItems_filteredType);
                } else {
                    helpText.setText(Messages.ConnectorDiscoveryWizardMainPage_noMatchingItems_noFilter);
                }
                helpTextControl = helpText;
            }
            this.configureLook((Control)helpTextControl, background);
            GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)helpTextControl);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(container);
            ArrayList categories = new ArrayList(this.discovery.getCategories());
            Collections.sort(categories, new DiscoveryCategoryComparator());
            Composite categoryChildrenContainer = null;
            for (DiscoveryCategory category : categories) {
                Image image;
                if (this.isEmpty(category)) continue;
                GradientCanvas categoryHeaderContainer = new GradientCanvas(container, 0);
                categoryHeaderContainer.setSeparatorVisible(true);
                categoryHeaderContainer.setSeparatorAlignment(128);
                categoryHeaderContainer.setBackgroundGradient(new Color[]{this.colorCategoryGradientStart, this.colorCategoryGradientEnd}, new int[]{100}, true);
                categoryHeaderContainer.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", this.colorCategoryGradientStart);
                categoryHeaderContainer.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", this.colorCategoryGradientEnd);
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)categoryHeaderContainer);
                GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).equalWidth(false).applyTo((Composite)categoryHeaderContainer);
                Label iconLabel = new Label((Composite)categoryHeaderContainer, 0);
                if (category.getIcon() != null && (image = this.computeIconImage(category.getSource(), category.getIcon(), 48, true)) != null) {
                    iconLabel.setImage(image);
                }
                iconLabel.setBackground(null);
                GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)iconLabel);
                Label nameLabel = new Label((Composite)categoryHeaderContainer, 0);
                nameLabel.setFont(this.h1Font);
                nameLabel.setText(category.getName());
                nameLabel.setBackground(null);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameLabel);
                if (this.hasTooltip(category)) {
                    ToolBar toolBar = new ToolBar((Composite)categoryHeaderContainer, 0x800000);
                    toolBar.setBackground(null);
                    ToolItem infoButton = new ToolItem(toolBar, 8);
                    infoButton.setImage(this.infoImage);
                    infoButton.setToolTipText(Messages.ConnectorDiscoveryWizardMainPage_tooltip_showOverview);
                    this.hookTooltip((Control)toolBar, infoButton, (Control)categoryHeaderContainer, (Control)nameLabel, category.getSource(), category.getOverview());
                    GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
                } else {
                    new Label((Composite)categoryHeaderContainer, 0).setText(" ");
                }
                Label description = new Label((Composite)categoryHeaderContainer, 64);
                GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)description);
                description.setBackground(null);
                description.setText(category.getDescription());
                categoryChildrenContainer = new Composite(container, 0);
                this.configureLook((Control)categoryChildrenContainer, background);
                GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)categoryChildrenContainer);
                GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(categoryChildrenContainer);
                int numChildren = 0;
                ArrayList connectors = new ArrayList(category.getConnectors());
                Collections.sort(connectors, new DiscoveryConnectorComparator((ConnectorCategory)category));
                for (DiscoveryConnector connector : connectors) {
                    if (this.isFiltered((ConnectorDescriptor)connector)) continue;
                    if (++numChildren > 1) {
                        Composite border = new Composite(categoryChildrenContainer, 0);
                        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 1).applyTo((Control)border);
                        GridLayoutFactory.fillDefaults().applyTo(border);
                        border.addPaintListener((PaintListener)new ConnectorBorderPaintListener());
                    }
                    ConnectorDescriptorItemUi itemUi = new ConnectorDescriptorItemUi(connector, categoryChildrenContainer, background);
                    itemUi.updateAvailability();
                }
            }
            Composite border = new Composite(categoryChildrenContainer, 0);
            GridDataFactory.fillDefaults().grab(true, false).hint(-1, 1).applyTo((Control)border);
            GridLayoutFactory.fillDefaults().applyTo(border);
            border.addPaintListener((PaintListener)new ConnectorBorderPaintListener());
        }
        container.layout(true);
        container.redraw();
    }

    private void configureLook(Control control, Color background) {
        control.setBackground(background);
    }

    private void hookTooltip(final Control tooltipControl, ToolItem tipActivator, final Control exitControl, final Control titleControl, AbstractDiscoverySource source, Overview overview) {
        final OverviewToolTip toolTip = new OverviewToolTip(tooltipControl, source, overview);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: 
                    case 37: {
                        toolTip.hide();
                    }
                }
            }
        };
        tipActivator.addListener(12, listener);
        tipActivator.addListener(37, listener);
        tipActivator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point titleAbsLocation = titleControl.getParent().toDisplay(titleControl.getLocation());
                Point containerAbsLocation = tooltipControl.getParent().toDisplay(tooltipControl.getLocation());
                Rectangle bounds = titleControl.getBounds();
                int relativeX = titleAbsLocation.x - containerAbsLocation.x;
                int relativeY = titleAbsLocation.y - containerAbsLocation.y;
                toolTip.show(new Point(relativeX, relativeY += bounds.height + 3));
            }
        });
        Listener exitListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        toolTip.hide();
                        break;
                    }
                    case 7: {
                        Rectangle containerBounds = exitControl.getBounds();
                        Point displayLocation = exitControl.getParent().toDisplay(containerBounds.x, containerBounds.y);
                        containerBounds.x = displayLocation.x;
                        containerBounds.y = displayLocation.y;
                        if (containerBounds.contains(Display.getCurrent().getCursorLocation())) break;
                        toolTip.hide();
                    }
                }
            }
        };
        this.hookRecursively(exitControl, exitListener);
    }

    private void hookRecursively(Control control, Listener listener) {
        control.addListener(12, listener);
        control.addListener(32, listener);
        control.addListener(5, listener);
        control.addListener(7, listener);
        control.addListener(3, listener);
        control.addListener(37, listener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.hookRecursively(child, listener);
                ++n2;
            }
        }
    }

    private boolean hasTooltip(DiscoveryConnector connector) {
        return connector.getOverview() != null && connector.getOverview().getSummary() != null && connector.getOverview().getSummary().length() > 0;
    }

    private boolean hasTooltip(DiscoveryCategory category) {
        return category.getOverview() != null && category.getOverview().getSummary() != null && category.getOverview().getSummary().length() > 0;
    }

    private boolean isEmpty(ConnectorDiscovery discovery) {
        for (DiscoveryCategory category : discovery.getCategories()) {
            if (this.isEmpty(category)) continue;
            return false;
        }
        return true;
    }

    private boolean isEmpty(DiscoveryCategory category) {
        if (category.getConnectors().isEmpty()) {
            return true;
        }
        for (ConnectorDescriptor descriptor : category.getConnectors()) {
            if (this.isFiltered(descriptor)) continue;
            return false;
        }
        return true;
    }

    private boolean isFiltered(ConnectorDescriptor descriptor) {
        boolean kindFiltered = true;
        for (ConnectorDescriptorKind kind : descriptor.getKind()) {
            if (!this.getWizard().isVisible(kind)) continue;
            kindFiltered = false;
            break;
        }
        if (kindFiltered) {
            return true;
        }
        if (this.installedFeatures != null && this.installedFeatures.contains(descriptor.getId())) {
            return true;
        }
        return this.filterPattern != null && !this.filterMatches(descriptor.getName()) && !this.filterMatches(descriptor.getDescription()) && !this.filterMatches(descriptor.getProvider()) && !this.filterMatches(descriptor.getLicense());
    }

    private boolean filterMatches(String text) {
        return text != null && this.filterPattern.matcher(text).find();
    }

    private Image computeIconImage(AbstractDiscoverySource discoverySource, Icon icon, int dimension, boolean fallback) {
        ImageDescriptor descriptor;
        Image image;
        URL resource;
        String imagePath;
        switch (dimension) {
            case 64: {
                imagePath = icon.getImage64();
                if (imagePath != null || !fallback) break;
            }
            case 48: {
                imagePath = icon.getImage48();
                if (imagePath != null || !fallback) break;
            }
            case 32: {
                imagePath = icon.getImage32();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (imagePath != null && imagePath.length() > 0 && (resource = discoverySource.getResource(imagePath)) != null && (image = (descriptor = ImageDescriptor.createFromURL((URL)resource)).createImage()) != null) {
            this.disposables.add((Resource)image);
            return image;
        }
        return null;
    }

    private void maybeUpdateDiscovery() {
        if (!this.getControl().isDisposed() && this.isCurrentPage() && this.discovery == null) {
            IStatus status;
            final Dictionary<Object, Object> environment = this.getWizard().getEnvironment();
            boolean wasCancelled = false;
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (ConnectorDiscoveryWizardMainPage.this.installedFeatures == null) {
                            IBundleGroupProvider[] bundleGroupProviders;
                            HashSet<String> installedFeatures = new HashSet<String>();
                            IBundleGroupProvider[] iBundleGroupProviderArray = bundleGroupProviders = Platform.getBundleGroupProviders();
                            int n = bundleGroupProviders.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IBundleGroup[] bundleGroups;
                                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                IBundleGroup[] iBundleGroupArray = bundleGroups = provider.getBundleGroups();
                                int n3 = bundleGroups.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IBundleGroup group = iBundleGroupArray[n4];
                                    installedFeatures.add(group.getIdentifier());
                                    ++n4;
                                }
                                ++n2;
                            }
                            ConnectorDiscoveryWizardMainPage.this.installedFeatures = installedFeatures;
                        }
                        ConnectorDiscovery connectorDiscovery = new ConnectorDiscovery();
                        connectorDiscovery.getDiscoveryStrategies().add(new BundleDiscoveryStrategy());
                        RemoteBundleDiscoveryStrategy remoteDiscoveryStrategy = new RemoteBundleDiscoveryStrategy();
                        remoteDiscoveryStrategy.setDirectoryUrl(System.getProperty(ConnectorDiscoveryWizardMainPage.SYSTEM_PROPERTY_DIRECTORY_URL, ConnectorDiscoveryWizardMainPage.DEFAULT_DIRECTORY_URL));
                        connectorDiscovery.getDiscoveryStrategies().add(remoteDiscoveryStrategy);
                        connectorDiscovery.setEnvironment(environment);
                        connectorDiscovery.setVerifyUpdateSiteAvailability(false);
                        try {
                            try {
                                connectorDiscovery.performDiscovery(monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            ConnectorDiscoveryWizardMainPage.this.discovery = connectorDiscovery;
                        }
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                status = this.computeStatus(e, Messages.ConnectorDiscoveryWizardMainPage_unexpectedException);
                DiscoveryUiUtil.logAndDisplayStatus(this.getShell(), Messages.ConnectorDiscoveryWizardMainPage_errorTitle, status);
            }
            catch (InterruptedException interruptedException) {
                wasCancelled = true;
            }
            if (this.discovery != null) {
                this.discoveryUpdated(wasCancelled);
                if (!this.discovery.getConnectors().isEmpty()) {
                    try {
                        this.getContainer().run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                ConnectorDiscoveryWizardMainPage.this.discovery.verifySiteAvailability(monitor);
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        status = this.computeStatus(e, Messages.ConnectorDiscoveryWizardMainPage_unexpectedException);
                        DiscoveryUiUtil.logAndDisplayStatus(this.getShell(), Messages.ConnectorDiscoveryWizardMainPage_errorTitle, status);
                    }
                    catch (InterruptedException interruptedException) {
                        wasCancelled = true;
                    }
                }
                this.createBodyContents();
            }
            this.body.setData("discoveryComplete", (Object)"true");
        }
    }

    private IStatus computeStatus(InvocationTargetException e, String message) {
        Throwable cause = e.getCause();
        Object statusCause = !(cause instanceof CoreException) ? ((CoreException)cause).getStatus() : new Status(4, "org.eclipse.mylyn.discovery.ui", cause.getMessage(), cause);
        if (statusCause.getMessage() != null) {
            message = NLS.bind((String)Messages.ConnectorDiscoveryWizardMainPage_message_with_cause, (Object)message, (Object)statusCause.getMessage());
        }
        MultiStatus status = new MultiStatus("org.eclipse.mylyn.discovery.ui", 0, new IStatus[]{statusCause}, message, cause);
        return status;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.discovery == null) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ConnectorDiscoveryWizardMainPage.this.maybeUpdateDiscovery();
                }
            });
        }
    }

    private void discoveryUpdated(boolean wasCancelled) {
        this.createBodyContents();
        if (this.discovery != null && !wasCancelled) {
            int categoryWithConnectorCount = 0;
            for (DiscoveryCategory category : this.discovery.getCategories()) {
                categoryWithConnectorCount += category.getConnectors().size();
            }
            if (categoryWithConnectorCount == 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ConnectorDiscoveryWizardMainPage_noConnectorsFound, (String)Messages.ConnectorDiscoveryWizardMainPage_noConnectorsFound_description);
            }
        }
    }

    public List<ConnectorDescriptor> getInstallableConnectors() {
        return this.installableConnectors;
    }

    private void modifySelection(DiscoveryConnector connector, boolean selected) {
        connector.setSelected(selected);
        if (selected) {
            this.installableConnectors.add((ConnectorDescriptor)connector);
        } else {
            this.installableConnectors.remove(connector);
        }
        this.setPageComplete(!this.installableConnectors.isEmpty());
    }

    public class ConnectorBorderPaintListener
    implements PaintListener {
        public void paintControl(PaintEvent e) {
            Composite composite = (Composite)e.widget;
            Rectangle bounds = composite.getBounds();
            GC gc = e.gc;
            gc.setLineStyle(3);
            gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
        }
    }

    private class ConnectorDescriptorItemUi
    implements PropertyChangeListener,
    Runnable {
        private final DiscoveryConnector connector;
        private final Button checkbox;
        private final Label iconLabel;
        private final Label nameLabel;
        private ToolItem infoButton;
        private final Label providerLabel;
        private final Label description;
        private final Composite checkboxContainer;
        private final Composite connectorContainer;
        private final Display display;
        private Image iconImage;
        private Image warningIconImage;

        public ConnectorDescriptorItemUi(DiscoveryConnector connector, Composite categoryChildrenContainer, Color background) {
            this.display = categoryChildrenContainer.getDisplay();
            this.connector = connector;
            connector.addPropertyChangeListener((PropertyChangeListener)this);
            this.connectorContainer = new Composite(categoryChildrenContainer, 0);
            ConnectorDiscoveryWizardMainPage.this.configureLook((Control)this.connectorContainer, background);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.connectorContainer);
            GridLayout layout = new GridLayout(4, false);
            layout.marginLeft = 7;
            layout.marginTop = 2;
            layout.marginBottom = 2;
            this.connectorContainer.setLayout((Layout)layout);
            this.checkboxContainer = new Composite(this.connectorContainer, 0);
            ConnectorDiscoveryWizardMainPage.this.configureLook((Control)this.checkboxContainer, background);
            GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)this.checkboxContainer);
            GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(2).applyTo(this.checkboxContainer);
            this.checkbox = new Button(this.checkboxContainer, 32);
            this.checkbox.setText(" ");
            this.checkbox.setData("connectorId", (Object)connector.getId());
            ConnectorDiscoveryWizardMainPage.this.configureLook((Control)this.checkbox, background);
            this.checkbox.setSelection(ConnectorDiscoveryWizardMainPage.this.installableConnectors.contains(connector));
            this.checkbox.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ConnectorDiscoveryWizardMainPage.this.bodyScrolledComposite.showControl((Control)ConnectorDescriptorItemUi.this.connectorContainer);
                }
            });
            GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.checkbox);
            this.iconLabel = new Label(this.checkboxContainer, 0);
            ConnectorDiscoveryWizardMainPage.this.configureLook((Control)this.iconLabel, background);
            GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.iconLabel);
            if (connector.getIcon() != null) {
                this.iconImage = ConnectorDiscoveryWizardMainPage.this.computeIconImage(connector.getSource(), connector.getIcon(), 32, false);
                if (this.iconImage != null) {
                    this.iconLabel.setImage(this.iconImage);
                }
            }
            this.nameLabel = new Label(this.connectorContainer, 0);
            ConnectorDiscoveryWizardMainPage.this.configureLook((Control)this.nameLabel, background);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameLabel);
            this.nameLabel.setFont(ConnectorDiscoveryWizardMainPage.this.h2Font);
            this.nameLabel.setText(connector.getName());
            this.providerLabel = new Label(this.connectorContainer, 0);
            ConnectorDiscoveryWizardMainPage.this.configureLook((Control)this.providerLabel, background);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.providerLabel);
            this.providerLabel.setText(NLS.bind((String)Messages.ConnectorDiscoveryWizardMainPage_provider_and_license, (Object)connector.getProvider(), (Object)connector.getLicense()));
            if (ConnectorDiscoveryWizardMainPage.this.hasTooltip(connector)) {
                ToolBar toolBar = new ToolBar(this.connectorContainer, 0x800000);
                toolBar.setBackground(background);
                this.infoButton = new ToolItem(toolBar, 8);
                this.infoButton.setImage(ConnectorDiscoveryWizardMainPage.this.infoImage);
                this.infoButton.setToolTipText(Messages.ConnectorDiscoveryWizardMainPage_tooltip_showOverview);
                ConnectorDiscoveryWizardMainPage.this.hookTooltip((Control)toolBar, this.infoButton, (Control)this.connectorContainer, (Control)this.nameLabel, connector.getSource(), connector.getOverview());
                GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
            } else {
                new Label(this.connectorContainer, 0).setText(" ");
            }
            this.description = new Label(this.connectorContainer, 64);
            ConnectorDiscoveryWizardMainPage.this.configureLook((Control)this.description, background);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).hint(100, -1).applyTo((Control)this.description);
            String descriptionText = connector.getDescription();
            int maxDescriptionLength = 162;
            if (descriptionText.length() > maxDescriptionLength) {
                descriptionText = descriptionText.substring(0, maxDescriptionLength);
            }
            this.description.setText(descriptionText.replaceAll("(\\r\\n)|\\n|\\r", " "));
            this.providerLabel.setForeground(ConnectorDiscoveryWizardMainPage.this.colorDisabled);
            this.checkbox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ConnectorDescriptorItemUi.this.checkbox.getSelection();
                    ConnectorDescriptorItemUi.this.maybeModifySelection(selected);
                }
            });
            MouseAdapter connectorItemMouseListener = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    boolean selected;
                    boolean bl = selected = !ConnectorDescriptorItemUi.this.checkbox.getSelection();
                    if (ConnectorDescriptorItemUi.this.maybeModifySelection(selected)) {
                        ConnectorDescriptorItemUi.this.checkbox.setSelection(selected);
                    }
                }
            };
            this.checkboxContainer.addMouseListener((MouseListener)connectorItemMouseListener);
            this.connectorContainer.addMouseListener((MouseListener)connectorItemMouseListener);
            this.iconLabel.addMouseListener((MouseListener)connectorItemMouseListener);
            this.nameLabel.addMouseListener((MouseListener)connectorItemMouseListener);
            this.providerLabel.addMouseListener((MouseListener)connectorItemMouseListener);
            this.description.addMouseListener((MouseListener)connectorItemMouseListener);
        }

        protected boolean maybeModifySelection(boolean selected) {
            if (selected) {
                if (this.connector.getAvailable() == null) {
                    return false;
                }
                if (!this.connector.getAvailable().booleanValue()) {
                    MessageDialog.openWarning((Shell)ConnectorDiscoveryWizardMainPage.this.getShell(), (String)Messages.ConnectorDiscoveryWizardMainPage_warningTitleConnectorUnavailable, (String)NLS.bind((String)Messages.ConnectorDiscoveryWizardMainPage_warningMessageConnectorUnavailable, (Object)this.connector.getName()));
                    return false;
                }
            }
            ConnectorDiscoveryWizardMainPage.this.modifySelection(this.connector, selected);
            return true;
        }

        public void updateAvailability() {
            boolean enabled = this.connector.getAvailable() != null && this.connector.getAvailable() != false;
            this.checkbox.setEnabled(enabled);
            this.nameLabel.setEnabled(enabled);
            this.providerLabel.setEnabled(enabled);
            this.description.setEnabled(enabled);
            Color foreground = enabled ? this.connectorContainer.getForeground() : ConnectorDiscoveryWizardMainPage.this.colorDisabled;
            this.nameLabel.setForeground(foreground);
            this.description.setForeground(foreground);
            if (this.iconImage != null) {
                boolean unavailable;
                boolean bl = unavailable = !enabled && this.connector.getAvailable() != null;
                if (unavailable) {
                    if (this.warningIconImage == null) {
                        this.warningIconImage = new DecorationOverlayIcon(this.iconImage, DiscoveryImages.OVERLAY_WARNING_32, 0).createImage();
                        ConnectorDiscoveryWizardMainPage.this.disposables.add(this.warningIconImage);
                    }
                    this.iconLabel.setImage(this.warningIconImage);
                } else if (this.warningIconImage != null) {
                    this.iconLabel.setImage(this.iconImage);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.display.asyncExec((Runnable)this);
        }

        public void run() {
            if (!this.connectorContainer.isDisposed()) {
                this.updateAvailability();
            }
        }
    }
}

