/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.AuthorizationIdentifierASALoader;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABaseUserImpl;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseUser
extends SybaseASABaseUserImpl
implements ICatalogObject {
    private static final long serialVersionUID = -9099341886539383531L;
    protected Boolean privilegesLoaded = Boolean.FALSE;
    protected Boolean userInfoLoaded = Boolean.FALSE;
    protected Boolean ownedSchemaLoaded = Boolean.FALSE;
    private SoftReference groupLoaderRef;
    private Database database;

    public SybaseASACatalogBaseUser(ICatalogObject catalogDatabase) {
        this.database = (Database)catalogDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.privilegesLoaded;
        synchronized (bl) {
            if (this.privilegesLoaded.booleanValue()) {
                this.privilegesLoaded = Boolean.FALSE;
            }
        }
        bl = this.userInfoLoaded;
        synchronized (bl) {
            if (this.userInfoLoaded.booleanValue()) {
                this.userInfoLoaded = Boolean.FALSE;
            }
        }
        bl = this.ownedSchemaLoaded;
        synchronized (bl) {
            if (this.ownedSchemaLoaded.booleanValue()) {
                this.ownedSchemaLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 12: {
                this.getReceivedPrivilege();
                break;
            }
            case 3: {
                this.getDescription();
                break;
            }
            case 7: {
                this.getOwnedSchema();
            }
        }
        return super.eIsSet(eFeature);
    }

    public Database getCatalogDatabase() {
        return this.database;
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.database).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getReceivedPrivilege() {
        Boolean bl = this.privilegesLoaded;
        synchronized (bl) {
            if (!this.privilegesLoaded.booleanValue()) {
                this.privilegesLoaded = Boolean.TRUE;
            }
        }
        return super.getReceivedPrivilege();
    }

    private AuthorizationIdentifierASALoader getAuthIdLoader() {
        AuthorizationIdentifierASALoader loader;
        AuthorizationIdentifierASALoader authorizationIdentifierASALoader = loader = this.groupLoaderRef == null ? null : (AuthorizationIdentifierASALoader)this.groupLoaderRef.get();
        if (loader == null) {
            loader = this.createAuthIdLoader();
            this.groupLoaderRef = new SoftReference<AuthorizationIdentifierASALoader>(loader);
        }
        return loader;
    }

    private AuthorizationIdentifierASALoader createAuthIdLoader() {
        return new AuthorizationIdentifierASALoader((AuthorizationIdentifier)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getOwnedSchema() {
        Boolean bl = this.ownedSchemaLoaded;
        synchronized (bl) {
            if (!this.ownedSchemaLoaded.booleanValue()) {
                EList ownedSchemas = super.getOwnedSchema();
                ownedSchemas.clear();
                Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.database.getSchemas(), this.getName());
                ownedSchemas.add((Object)schema);
                this.ownedSchemaLoaded = Boolean.TRUE;
            }
        }
        return super.getOwnedSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        Boolean bl = this.userInfoLoaded;
        synchronized (bl) {
            if (!this.userInfoLoaded.booleanValue()) {
                this.getAuthIdLoader().loadAuthInfo();
                this.userInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getDescription();
    }
}

