/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.AuthorizedObjectPrivilegeASALoader;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.SybaseASABaseColumnLoader;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SystemDefinedDefaultType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.TypeOfDefault;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABaseColumnImpl;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseColumn
extends SybaseASABaseColumnImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 5633548650842443769L;
    protected static final int columnLoadInfoIndex = 0;
    protected static final int constraintLoadInfoIndex = 1;
    protected static final int privilegesLoadInfoIndex = 2;
    private SoftReference authIdLoaderRef;
    private SoftReference columnLoaderRef;

    public Database getCatalogDatabase() {
        return this.getTable().getSchema().getDatabase();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        ISybaseASACatalogBaseColumnOwner table = (ISybaseASACatalogBaseColumnOwner)this.getTable();
        if (this.isNeedRefresh()) {
            Boolean bl = table.isColumnInfoLoaded();
            synchronized (bl) {
                table.setColumnInfoLoaded(Boolean.FALSE);
            }
            bl = table.isColumnConstraintLoaded();
            synchronized (bl) {
                table.setColumnConstraintLoaded(Boolean.FALSE);
            }
            bl = table.isColumnPrivilegeLoaded();
            synchronized (bl) {
                table.setColumnPrivilegeLoaded(Boolean.FALSE);
            }
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 19: {
                this.isUnique();
                break;
            }
            case 7: {
                this.getContainedType();
                break;
            }
            case 8: {
                this.getReferencedType();
                break;
            }
            case 13: {
                this.isNullable();
                break;
            }
            case 3: {
                this.getDescription();
                break;
            }
            case 11: {
                this.getGenerateExpression();
                break;
            }
            case 14: {
                this.getDefaultValue();
                break;
            }
            case 18: {
                this.getTypeOfDefault();
                break;
            }
            case 17: {
                this.getColumnConstraint();
                break;
            }
            case 6: {
                this.getPrivileges();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnique() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        return super.isUnique();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLDataType getContainedType() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        return super.getContainedType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDefinedType getReferencedType() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        return super.getReferencedType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataType getDataType() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        return super.getDataType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNullable() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        return super.isNullable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        return super.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueExpression getGenerateExpression() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        return super.getGenerateExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultValue() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        return super.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeOfDefault getTypeOfDefault() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        return super.getTypeOfDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentitySpecifier getIdentitySpecifier() {
        Boolean columnInfoLoaded;
        Boolean bl = columnInfoLoaded = this.columnInfoLoaded();
        synchronized (bl) {
            if (!columnInfoLoaded.booleanValue()) {
                this.getColumnLoader().loadColumnInfo();
                columnInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(0, columnInfoLoaded);
        boolean identity = this.getTypeOfDefault() == TypeOfDefault.SYSTEM_DEFINED_LITERAL && this.getDefaultValue().equalsIgnoreCase(SystemDefinedDefaultType.AUTOINCREMENT_LITERAL.getLiteral());
        this.setIdentitySpecifier(identity ? SQLSchemaFactory.eINSTANCE.createIdentitySpecifier() : null);
        return super.getIdentitySpecifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getColumnConstraint() {
        Boolean constraintInfoLoaded;
        Boolean bl = constraintInfoLoaded = this.constraintInfoLoaded();
        synchronized (bl) {
            if (!constraintInfoLoaded.booleanValue()) {
                HashMap<String, EList> existingConstraints = new HashMap<String, EList>();
                for (SybaseASACatalogBaseColumn column : this.getTable().getColumns()) {
                    existingConstraints.put(column.getName(), column.superGetColumnConstraint());
                }
                HashMap constraints = this.getColumnLoader().loadColumnCheckConstraint(existingConstraints);
                EList columns = this.getTable().getColumns();
                int i = 0;
                while (i < columns.size()) {
                    SybaseASACatalogBaseColumn column = (SybaseASACatalogBaseColumn)((Object)columns.get(i));
                    String columnName = column.getName();
                    ArrayList constraintList = (ArrayList)constraints.get(columnName);
                    if (constraintList == null) {
                        constraintList = new ArrayList();
                    }
                    boolean deliver = column.eDeliver();
                    column.eSetDeliver(false);
                    EList columnConstraints = column.superGetColumnConstraint();
                    columnConstraints.clear();
                    columnConstraints.addAll(constraintList);
                    column.eSetDeliver(deliver);
                    ++i;
                }
                constraintInfoLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(1, constraintInfoLoaded);
        return super.getColumnConstraint();
    }

    protected EList superGetColumnConstraint() {
        return super.getColumnConstraint();
    }

    private SybaseASABaseColumnLoader getColumnLoader() {
        SybaseASABaseColumnLoader loader;
        SybaseASABaseColumnLoader sybaseASABaseColumnLoader = loader = this.columnLoaderRef == null ? null : (SybaseASABaseColumnLoader)this.columnLoaderRef.get();
        if (loader == null) {
            loader = this.createColumnLoader();
            this.columnLoaderRef = new SoftReference<SybaseASABaseColumnLoader>(loader);
        }
        return loader;
    }

    private SybaseASABaseColumnLoader createColumnLoader() {
        return new SybaseASABaseColumnLoader((SybaseASABaseColumn)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getPrivileges() {
        Boolean privilegesLoaded;
        Boolean bl = privilegesLoaded = this.privilegesInfoLoaded();
        synchronized (bl) {
            if (!privilegesLoaded.booleanValue()) {
                HashMap privileges = this.getPrivilegeLoader().loadTableColumnPrivilege();
                EList columns = this.getTable().getColumns();
                int i = 0;
                while (i < columns.size()) {
                    SybaseASACatalogBaseColumn column = (SybaseASACatalogBaseColumn)((Object)columns.get(i));
                    String columnName = column.getName();
                    ArrayList privilegeList = (ArrayList)privileges.get(columnName);
                    if (privilegeList == null) {
                        privilegeList = new ArrayList();
                    }
                    boolean deliver = column.eDeliver();
                    column.eSetDeliver(false);
                    EList columnPrivileges = column.superGetPrivileges();
                    columnPrivileges.clear();
                    columnPrivileges.addAll(privilegeList);
                    column.eSetDeliver(deliver);
                    ++i;
                }
                privilegesLoaded = Boolean.TRUE;
            }
        }
        this.setColumnLoadInfo(2, privilegesLoaded);
        return super.getPrivileges();
    }

    protected EList superGetPrivileges() {
        return super.getPrivileges();
    }

    private AuthorizedObjectPrivilegeASALoader getPrivilegeLoader() {
        AuthorizedObjectPrivilegeASALoader loader;
        AuthorizedObjectPrivilegeASALoader authorizedObjectPrivilegeASALoader = loader = this.authIdLoaderRef == null ? null : (AuthorizedObjectPrivilegeASALoader)this.authIdLoaderRef.get();
        if (loader == null) {
            loader = this.createPrivilegeLoader();
            this.authIdLoaderRef = new SoftReference<AuthorizedObjectPrivilegeASALoader>(loader);
        }
        return loader;
    }

    private AuthorizedObjectPrivilegeASALoader createPrivilegeLoader() {
        return new AuthorizedObjectPrivilegeASALoader((SQLObject)this);
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    protected Boolean columnInfoLoaded() {
        return this.getColumnLoadInfo(0);
    }

    protected Boolean constraintInfoLoaded() {
        return this.getColumnLoadInfo(1);
    }

    protected Boolean privilegesInfoLoaded() {
        return this.getColumnLoadInfo(2);
    }

    protected Boolean getColumnLoadInfo(int index) {
        ISybaseASACatalogBaseColumnOwner table = (ISybaseASACatalogBaseColumnOwner)this.getTable();
        switch (index) {
            case 0: {
                return table.isColumnInfoLoaded();
            }
            case 1: {
                return table.isColumnConstraintLoaded();
            }
            case 2: {
                return table.isColumnPrivilegeLoaded();
            }
        }
        return Boolean.FALSE;
    }

    protected void setColumnLoadInfo(int index, Boolean info) {
        ISybaseASACatalogBaseColumnOwner table = (ISybaseASACatalogBaseColumnOwner)this.getTable();
        switch (index) {
            case 0: {
                table.setColumnInfoLoaded(info);
                break;
            }
            case 1: {
                table.setColumnConstraintLoaded(info);
                break;
            }
            case 2: {
                table.setColumnPrivilegeLoaded(info);
            }
        }
    }

    private boolean isNeedRefresh() {
        ISybaseASACatalogBaseColumnOwner table = (ISybaseASACatalogBaseColumnOwner)this.getTable();
        return table.isColumnConstraintLoaded() != false || table.isColumnInfoLoaded() != false || table.isColumnPrivilegeLoaded() != false;
    }

    public static interface ISybaseASACatalogBaseColumnOwner {
        public Boolean isColumnInfoLoaded();

        public void setColumnInfoLoaded(Boolean var1);

        public Boolean isColumnConstraintLoaded();

        public void setColumnConstraintLoaded(Boolean var1);

        public Boolean isColumnPrivilegeLoaded();

        public void setColumnPrivilegeLoaded(Boolean var1);
    }
}

