/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NamedColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceNamedColumnAnnotation
extends SourceAnnotation<Member>
implements NamedColumnAnnotation {
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildStringElementAdapter(this.getNameElementName());
    private final AnnotationElementAdapter<String> nameAdapter = this.buildShortCircuitElementAdapter(this.nameDeclarationAdapter);
    private String name;
    private final DeclarationAnnotationElementAdapter<String> columnDefinitionDeclarationAdapter = this.buildStringElementAdapter(this.getColumnDefinitionElementName());
    private final AnnotationElementAdapter<String> columnDefinitionAdapter = this.buildShortCircuitElementAdapter(this.columnDefinitionDeclarationAdapter);
    private String columnDefinition;

    SourceNamedColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, (AnnotationAdapter)new MemberAnnotationAdapter(member, daa));
    }

    SourceNamedColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    DeclarationAnnotationElementAdapter<String> buildStringElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(this.daa, elementName);
    }

    DeclarationAnnotationElementAdapter<Boolean> buildBooleanElementAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(this.daa, elementName, BooleanExpressionConverter.instance());
    }

    DeclarationAnnotationElementAdapter<Integer> buildIntegerElementAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Integer>(this.daa, elementName, NumberIntegerExpressionConverter.instance());
    }

    AnnotationElementAdapter<String> buildShortCircuitElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>(this.member, daea);
    }

    AnnotationElementAdapter<Boolean> buildShortCircuitBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new ShortCircuitAnnotationElementAdapter<Boolean>(this.member, daea);
    }

    AnnotationElementAdapter<Integer> buildShortCircuitIntegerElementAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new ShortCircuitAnnotationElementAdapter<Integer>(this.member, daea);
    }

    AnnotationElementAdapter<String> buildShortCircuitStringElementAdapter(String elementName) {
        return this.buildShortCircuitElementAdapter(this.buildStringElementAdapter(elementName));
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.columnDefinition = this.buildColumnDefinition(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setName(this.buildName(astRoot));
        this.setColumnDefinition(this.buildColumnDefinition(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasNotChanged(this.name, name)) {
            return;
        }
        String old = this.name;
        this.name = name;
        this.nameAdapter.setValue(name);
        this.firePropertyChanged("name", old, name);
    }

    private String buildName(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    abstract String getNameElementName();

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String columnDefinition) {
        if (this.attributeValueHasNotChanged(this.columnDefinition, columnDefinition)) {
            return;
        }
        String old = this.columnDefinition;
        this.columnDefinition = columnDefinition;
        this.columnDefinitionAdapter.setValue(columnDefinition);
        this.firePropertyChanged("columnDefinition", old, columnDefinition);
    }

    private String buildColumnDefinition(CompilationUnit astRoot) {
        return this.columnDefinitionAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getColumnDefinitionTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.columnDefinitionDeclarationAdapter, astRoot);
    }

    abstract String getColumnDefinitionElementName();

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        NamedColumnAnnotation oldColumn = (NamedColumnAnnotation)((Object)oldAnnotation);
        this.setName(oldColumn.getName());
        this.setColumnDefinition(oldColumn.getColumnDefinition());
    }
}

