/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JoinColumnsAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceJoinColumnsAnnotation
extends SourceAnnotation<Member>
implements JoinColumnsAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinColumns");
    private final Vector<NestableJoinColumnAnnotation> joinColumns = new Vector();

    public SourceJoinColumnsAnnotation(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.JoinColumns";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        AnnotationContainerTools.initialize(this, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        AnnotationContainerTools.update(this, astRoot);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.joinColumns);
    }

    @Override
    public String getContainerAnnotationName() {
        return this.getAnnotationName();
    }

    @Override
    public Annotation getContainerJdtAnnotation(CompilationUnit astRoot) {
        return this.getJdtAnnotation(astRoot);
    }

    @Override
    public String getElementName() {
        return "value";
    }

    @Override
    public String getNestableAnnotationName() {
        return "javax.persistence.JoinColumn";
    }

    @Override
    public ListIterator<NestableJoinColumnAnnotation> nestedAnnotations() {
        return new CloneListIterator(this.joinColumns);
    }

    @Override
    public int nestedAnnotationsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumnAnnotation addNestedAnnotationInternal() {
        NestableJoinColumnAnnotation joinColumn = this.buildJoinColumn(this.joinColumns.size());
        this.joinColumns.add(joinColumn);
        return joinColumn;
    }

    private NestableJoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.createNestedJoinColumn(this, this.member, index, this.daa);
    }

    @Override
    public void nestedAnnotationAdded(int index, NestableJoinColumnAnnotation nestedAnnotation) {
        this.fireItemAdded("joinColumns", index, nestedAnnotation);
    }

    @Override
    public NestableJoinColumnAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("joinColumns", targetIndex, sourceIndex);
    }

    @Override
    public NestableJoinColumnAnnotation removeNestedAnnotationInternal(int index) {
        return this.joinColumns.remove(index);
    }

    @Override
    public void nestedAnnotationRemoved(int index, NestableJoinColumnAnnotation nestedAnnotation) {
        this.fireItemRemoved("joinColumns", index, nestedAnnotation);
    }
}

