/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.GeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceGeneratorAnnotation
extends SourceAnnotation<Member>
implements GeneratorAnnotation {
    final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.getNameAdapter();
    final AnnotationElementAdapter<String> nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
    String name;
    final DeclarationAnnotationElementAdapter<Integer> initialValueDeclarationAdapter = this.getInitialValueAdapter();
    final AnnotationElementAdapter<Integer> initialValueAdapter = this.buildIntegerAdapter(this.initialValueDeclarationAdapter);
    Integer initialValue;
    final DeclarationAnnotationElementAdapter<Integer> allocationSizeDeclarationAdapter = this.getAllocationSizeAdapter();
    final AnnotationElementAdapter<Integer> allocationSizeAdapter = this.buildIntegerAdapter(this.allocationSizeDeclarationAdapter);
    Integer allocationSize;

    SourceGeneratorAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        super(parent, member, daa);
    }

    AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>(this.member, daea);
    }

    AnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new ShortCircuitAnnotationElementAdapter<Integer>(this.member, daea);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.initialValue = this.buildInitialValue(astRoot);
        this.allocationSize = this.buildAllocationSize(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setName(this.buildName(astRoot));
        this.setInitialValue(this.buildInitialValue(astRoot));
        this.setAllocationSize(this.buildAllocationSize(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasNotChanged(this.name, name)) {
            return;
        }
        String old = this.name;
        this.name = name;
        this.nameAdapter.setValue(name);
        this.firePropertyChanged("name", old, name);
    }

    private String buildName(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<String> getNameAdapter();

    @Override
    public Integer getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(Integer initialValue) {
        if (this.attributeValueHasNotChanged(this.initialValue, initialValue)) {
            return;
        }
        Integer old = this.initialValue;
        this.initialValue = initialValue;
        this.initialValueAdapter.setValue(initialValue);
        this.firePropertyChanged("initialValue", old, initialValue);
    }

    private Integer buildInitialValue(CompilationUnit astRoot) {
        return this.initialValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getInitialValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.initialValueDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter();

    @Override
    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    @Override
    public void setAllocationSize(Integer allocationSize) {
        if (this.attributeValueHasNotChanged(this.allocationSize, allocationSize)) {
            return;
        }
        Integer old = this.allocationSize;
        this.allocationSize = allocationSize;
        this.allocationSizeAdapter.setValue(allocationSize);
        this.firePropertyChanged("allocationSize", old, allocationSize);
    }

    private Integer buildAllocationSize(CompilationUnit astRoot) {
        return this.allocationSizeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getAllocationSizeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.allocationSizeDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter();

    static DeclarationAnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(annotationAdapter, elementName);
    }

    static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Integer>(annotationAdapter, elementName, NumberIntegerExpressionConverter.instance());
    }
}

