/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.BaseTableAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraintAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceBaseTableAnnotation
extends SourceAnnotation<Member>
implements BaseTableAnnotation {
    final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    final AnnotationElementAdapter<String> nameAdapter;
    String name;
    final DeclarationAnnotationElementAdapter<String> schemaDeclarationAdapter;
    final AnnotationElementAdapter<String> schemaAdapter;
    String schema;
    final DeclarationAnnotationElementAdapter<String> catalogDeclarationAdapter;
    final AnnotationElementAdapter<String> catalogAdapter;
    String catalog;
    final Vector<NestableUniqueConstraintAnnotation> uniqueConstraints = new Vector();
    final UniqueConstraintsAnnotationContainer uniqueConstraintsContainer = new UniqueConstraintsAnnotationContainer();

    SourceBaseTableAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, (AnnotationAdapter)new MemberAnnotationAdapter(member, daa));
    }

    SourceBaseTableAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.getNameAdapter(daa);
        this.schemaDeclarationAdapter = this.getSchemaAdapter(daa);
        this.catalogDeclarationAdapter = this.getCatalogAdapter(daa);
        this.nameAdapter = this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
        this.schemaAdapter = this.buildAnnotationElementAdapter(this.schemaDeclarationAdapter);
        this.catalogAdapter = this.buildAnnotationElementAdapter(this.catalogDeclarationAdapter);
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>(this.member, daea);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.schema = this.buildSchema(astRoot);
        this.catalog = this.buildCatalog(astRoot);
        AnnotationContainerTools.initialize(this.uniqueConstraintsContainer, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setName(this.buildName(astRoot));
        this.setSchema(this.buildSchema(astRoot));
        this.setCatalog(this.buildCatalog(astRoot));
        AnnotationContainerTools.update(this.uniqueConstraintsContainer, astRoot);
    }

    abstract String getUniqueConstraintsElementName();

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasNotChanged(this.name, name)) {
            return;
        }
        String old = this.name;
        this.name = name;
        this.nameAdapter.setValue(name);
        this.firePropertyChanged("name", old, name);
    }

    private String buildName(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<String> getNameAdapter(DeclarationAnnotationAdapter var1);

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        if (this.attributeValueHasNotChanged(this.schema, schema)) {
            return;
        }
        String old = this.schema;
        this.schema = schema;
        this.schemaAdapter.setValue(schema);
        this.firePropertyChanged("schema", old, schema);
    }

    private String buildSchema(CompilationUnit astRoot) {
        return this.schemaAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.schemaDeclarationAdapter, astRoot);
    }

    @Override
    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.schemaDeclarationAdapter, pos, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<String> getSchemaAdapter(DeclarationAnnotationAdapter var1);

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        if (this.attributeValueHasNotChanged(this.catalog, catalog)) {
            return;
        }
        String old = this.catalog;
        this.catalog = catalog;
        this.catalogAdapter.setValue(catalog);
        this.firePropertyChanged("catalog", old, catalog);
    }

    private String buildCatalog(CompilationUnit astRoot) {
        return this.catalogAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.catalogDeclarationAdapter, astRoot);
    }

    @Override
    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.catalogDeclarationAdapter, pos, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<String> getCatalogAdapter(DeclarationAnnotationAdapter var1);

    @Override
    public ListIterator<UniqueConstraintAnnotation> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    ListIterator<NestableUniqueConstraintAnnotation> nestableUniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public NestableUniqueConstraintAnnotation uniqueConstraintAt(int index) {
        return this.uniqueConstraints.get(index);
    }

    @Override
    public int indexOfUniqueConstraint(UniqueConstraintAnnotation uniqueConstraint) {
        return this.uniqueConstraints.indexOf(uniqueConstraint);
    }

    @Override
    public NestableUniqueConstraintAnnotation addUniqueConstraint(int index) {
        return (NestableUniqueConstraintAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.uniqueConstraintsContainer);
    }

    NestableUniqueConstraintAnnotation addUniqueConstraintInternal() {
        NestableUniqueConstraintAnnotation uniqueConstraint = this.buildUniqueConstraint(this.uniqueConstraints.size());
        this.uniqueConstraints.add(uniqueConstraint);
        return uniqueConstraint;
    }

    abstract NestableUniqueConstraintAnnotation buildUniqueConstraint(int var1);

    void uniqueConstraintAdded(int index, NestableUniqueConstraintAnnotation constraint) {
        this.fireItemAdded("uniqueConstraints", index, constraint);
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.uniqueConstraintsContainer);
    }

    NestableUniqueConstraintAnnotation moveUniqueConstraintInternal(int targetIndex, int sourceIndex) {
        return (NestableUniqueConstraintAnnotation)CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void uniqueConstraintMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("uniqueConstraints", targetIndex, sourceIndex);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.uniqueConstraintsContainer);
    }

    NestableUniqueConstraintAnnotation removeUniqueConstraintInternal(int index) {
        return this.uniqueConstraints.remove(index);
    }

    void uniqueConstraintRemoved(int index, NestableUniqueConstraintAnnotation constraint) {
        this.fireItemRemoved("uniqueConstraints", index, constraint);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UniqueConstraintsAnnotationContainer
    implements AnnotationContainer<NestableUniqueConstraintAnnotation> {
        UniqueConstraintsAnnotationContainer() {
        }

        @Override
        public String getContainerAnnotationName() {
            return SourceBaseTableAnnotation.this.getAnnotationName();
        }

        @Override
        public Annotation getContainerJdtAnnotation(CompilationUnit astRoot) {
            return SourceBaseTableAnnotation.this.getJdtAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return SourceBaseTableAnnotation.this.getUniqueConstraintsElementName();
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.UniqueConstraint";
        }

        @Override
        public ListIterator<NestableUniqueConstraintAnnotation> nestedAnnotations() {
            return SourceBaseTableAnnotation.this.nestableUniqueConstraints();
        }

        @Override
        public int nestedAnnotationsSize() {
            return SourceBaseTableAnnotation.this.uniqueConstraintsSize();
        }

        @Override
        public NestableUniqueConstraintAnnotation addNestedAnnotationInternal() {
            return SourceBaseTableAnnotation.this.addUniqueConstraintInternal();
        }

        @Override
        public void nestedAnnotationAdded(int index, NestableUniqueConstraintAnnotation nestedAnnotation) {
            SourceBaseTableAnnotation.this.uniqueConstraintAdded(index, nestedAnnotation);
        }

        @Override
        public NestableUniqueConstraintAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
            return SourceBaseTableAnnotation.this.moveUniqueConstraintInternal(targetIndex, sourceIndex);
        }

        @Override
        public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
            SourceBaseTableAnnotation.this.uniqueConstraintMoved(targetIndex, sourceIndex);
        }

        @Override
        public NestableUniqueConstraintAnnotation removeNestedAnnotationInternal(int index) {
            return SourceBaseTableAnnotation.this.removeUniqueConstraintInternal(index);
        }

        @Override
        public void nestedAnnotationRemoved(int index, NestableUniqueConstraintAnnotation nestedAnnotation) {
            SourceBaseTableAnnotation.this.uniqueConstraintRemoved(index, nestedAnnotation);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

