/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmBaseColumn;
import org.eclipse.jpt.core.resource.orm.XmlColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmColumn
extends AbstractOrmBaseColumn<XmlColumn>
implements OrmColumn {
    protected Integer specifiedLength;
    protected Integer specifiedPrecision;
    protected Integer specifiedScale;

    public GenericOrmColumn(XmlContextNode parent, OrmColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public OrmColumn.Owner getOwner() {
        return (OrmColumn.Owner)super.getOwner();
    }

    @Override
    public void initializeFrom(Column oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedLength(oldColumn.getSpecifiedLength());
        this.setSpecifiedPrecision(oldColumn.getSpecifiedPrecision());
        this.setSpecifiedScale(oldColumn.getSpecifiedScale());
    }

    @Override
    public int getLength() {
        return this.getSpecifiedLength() == null ? this.getDefaultLength() : this.getSpecifiedLength().intValue();
    }

    @Override
    public int getDefaultLength() {
        return 255;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        if (oldSpecifiedLength != newSpecifiedLength) {
            if (this.getResourceColumn() != null) {
                this.getResourceColumn().setLength(newSpecifiedLength);
                if (this.getResourceColumn().isUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedLength != null) {
                this.addResourceColumn();
                this.getResourceColumn().setLength(newSpecifiedLength);
            }
        }
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    protected void setSpecifiedLength_(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    @Override
    public int getPrecision() {
        return this.getSpecifiedPrecision() == null ? this.getDefaultPrecision() : this.getSpecifiedPrecision().intValue();
    }

    @Override
    public int getDefaultPrecision() {
        return 0;
    }

    @Override
    public Integer getSpecifiedPrecision() {
        return this.specifiedPrecision;
    }

    @Override
    public void setSpecifiedPrecision(Integer newSpecifiedPrecision) {
        Integer oldSpecifiedPrecision = this.specifiedPrecision;
        this.specifiedPrecision = newSpecifiedPrecision;
        if (oldSpecifiedPrecision != newSpecifiedPrecision) {
            if (this.getResourceColumn() != null) {
                this.getResourceColumn().setPrecision(newSpecifiedPrecision);
                if (this.getResourceColumn().isUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedPrecision != null) {
                this.addResourceColumn();
                this.getResourceColumn().setPrecision(newSpecifiedPrecision);
            }
        }
        this.firePropertyChanged("specifiedPrecision", oldSpecifiedPrecision, newSpecifiedPrecision);
    }

    protected void setSpecifiedPrecision_(Integer newSpecifiedPrecision) {
        Integer oldSpecifiedPrecision = this.specifiedPrecision;
        this.specifiedPrecision = newSpecifiedPrecision;
        this.firePropertyChanged("specifiedPrecision", oldSpecifiedPrecision, newSpecifiedPrecision);
    }

    @Override
    public int getScale() {
        return this.getSpecifiedScale() == null ? this.getDefaultScale() : this.getSpecifiedScale().intValue();
    }

    @Override
    public int getDefaultScale() {
        return 0;
    }

    @Override
    public Integer getSpecifiedScale() {
        return this.specifiedScale;
    }

    @Override
    public void setSpecifiedScale(Integer newSpecifiedScale) {
        Integer oldSpecifiedScale = this.specifiedScale;
        this.specifiedScale = newSpecifiedScale;
        if (oldSpecifiedScale != newSpecifiedScale) {
            if (this.getResourceColumn() != null) {
                this.getResourceColumn().setScale(newSpecifiedScale);
                if (this.getResourceColumn().isUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedScale != null) {
                this.addResourceColumn();
                this.getResourceColumn().setScale(newSpecifiedScale);
            }
        }
        this.firePropertyChanged("specifiedScale", oldSpecifiedScale, newSpecifiedScale);
    }

    protected void setSpecifiedScale_(Integer newSpecifiedScale) {
        Integer oldSpecifiedScale = this.specifiedScale;
        this.specifiedScale = newSpecifiedScale;
        this.firePropertyChanged("specifiedScale", oldSpecifiedScale, newSpecifiedScale);
    }

    @Override
    protected XmlColumn getResourceColumn() {
        return this.getOwner().getResourceColumn();
    }

    @Override
    protected void addResourceColumn() {
        this.getOwner().addResourceColumn();
    }

    @Override
    protected void removeResourceColumn() {
        this.getOwner().removeResourceColumn();
    }

    @Override
    public void initialize(XmlColumn column) {
        super.initialize(column);
        this.specifiedLength = this.getResourceLength(column);
        this.specifiedPrecision = this.getResourcePrecision(column);
        this.specifiedScale = this.getResourceScale(column);
    }

    @Override
    public void update(XmlColumn column) {
        super.update(column);
        this.setSpecifiedLength_(this.getResourceLength(column));
        this.setSpecifiedPrecision_(this.getResourcePrecision(column));
        this.setSpecifiedScale_(this.getResourceScale(column));
    }

    protected Integer getResourceLength(XmlColumn column) {
        return column == null ? null : column.getLength();
    }

    protected Integer getResourcePrecision(XmlColumn column) {
        return column == null ? null : column.getPrecision();
    }

    protected Integer getResourceScale(XmlColumn column) {
        return column == null ? null : column.getScale();
    }
}

