/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTypeMapping<T extends XmlTypeMapping>
extends AbstractXmlContextNode
implements OrmTypeMapping {
    protected String class_;
    public boolean defaultMetadataComplete;
    protected Boolean specifiedMetadataComplete;
    protected final T resourceTypeMapping;

    protected AbstractOrmTypeMapping(OrmPersistentType parent, T resourceMapping) {
        super(parent);
        this.resourceTypeMapping = resourceMapping;
        this.class_ = this.getResourceClassName();
        this.specifiedMetadataComplete = this.getResourceMetadataComplete();
        this.defaultMetadataComplete = this.getPersistentType().isDefaultMetadataComplete();
    }

    @Override
    public OrmPersistentType getParent() {
        return (OrmPersistentType)super.getParent();
    }

    @Override
    public OrmPersistentType getPersistentType() {
        return this.getParent();
    }

    protected JavaPersistentType getJavaPersistentType() {
        return this.getPersistentType().getJavaPersistentType();
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public String getClass_() {
        return this.class_;
    }

    @Override
    public void setClass(String newClass) {
        String oldClass = this.class_;
        this.class_ = newClass;
        this.resourceTypeMapping.setClassName(newClass);
        this.firePropertyChanged("class", oldClass, newClass);
        this.getPersistentType().classChanged(oldClass, newClass);
    }

    @Override
    public boolean isMetadataComplete() {
        if (this.isDefaultMetadataComplete()) {
            return true;
        }
        return this.getSpecifiedMetadataComplete() == null ? this.isDefaultMetadataComplete() : this.getSpecifiedMetadataComplete().booleanValue();
    }

    @Override
    public boolean isDefaultMetadataComplete() {
        return this.defaultMetadataComplete;
    }

    protected void setDefaultMetadataComplete(boolean newDefaultMetadataComplete) {
        boolean oldMetadataComplete = this.defaultMetadataComplete;
        this.defaultMetadataComplete = newDefaultMetadataComplete;
        this.firePropertyChanged("defaultMetadataComplete", oldMetadataComplete, newDefaultMetadataComplete);
    }

    @Override
    public Boolean getSpecifiedMetadataComplete() {
        return this.specifiedMetadataComplete;
    }

    @Override
    public void setSpecifiedMetadataComplete(Boolean newSpecifiedMetadataComplete) {
        Boolean oldMetadataComplete = this.specifiedMetadataComplete;
        this.specifiedMetadataComplete = newSpecifiedMetadataComplete;
        this.resourceTypeMapping.setMetadataComplete(newSpecifiedMetadataComplete);
        this.firePropertyChanged("specifiedMetadataComplete", oldMetadataComplete, newSpecifiedMetadataComplete);
    }

    @Override
    public void initializeFrom(OrmTypeMapping oldMapping) {
        this.setClass(oldMapping.getClass_());
        this.setSpecifiedMetadataComplete(oldMapping.getSpecifiedMetadataComplete());
        this.setDefaultMetadataComplete(oldMapping.isDefaultMetadataComplete());
    }

    @Override
    public Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public Table getDbTable(String tableName) {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    @Override
    public Iterator<OrmPersistentAttribute> overridableAttributes() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return this.namesOf(this.overridableAttributes());
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAttributes() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return this.namesOf(this.allOverridableAttributes());
    }

    @Override
    public Iterator<OrmPersistentAttribute> overridableAssociations() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return this.namesOf(this.overridableAssociations());
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAssociations() {
        return EmptyIterator.instance();
    }

    private Iterator<String> namesOf(Iterator<? extends PersistentAttribute> attributes) {
        return new TransformationIterator<PersistentAttribute, String>(attributes){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return this.namesOf(this.allOverridableAssociations());
    }

    public T getResourceTypeMapping() {
        return this.resourceTypeMapping;
    }

    @Override
    public void update() {
        this.setClass(this.getResourceClassName());
        this.setSpecifiedMetadataComplete(this.getResourceMetadataComplete());
        this.setDefaultMetadataComplete(this.getPersistentType().isDefaultMetadataComplete());
    }

    protected String getResourceClassName() {
        return this.resourceTypeMapping.getClassName();
    }

    protected Boolean getResourceMetadataComplete() {
        return this.resourceTypeMapping.getMetadataComplete();
    }

    @Override
    public IContentType getContentType() {
        return this.getPersistentType().getContentType();
    }

    public JpaStructureNode getStructureNode(int offset) {
        if (this.resourceTypeMapping.containsOffset(offset)) {
            return this.getPersistentType();
        }
        return null;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.resourceTypeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getClassTextRange() {
        return this.resourceTypeMapping.getClassTextRange();
    }

    @Override
    public TextRange getAttributesTextRange() {
        return this.resourceTypeMapping.getAttributesTextRange();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.resourceTypeMapping != null && this.resourceTypeMapping.containsOffset(textOffset);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages);
    }

    protected void validateClass(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.class_)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CLASS", this, this.getClassTextRange()));
            return;
        }
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return this.getPersistenceUnit().shouldValidateAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.resourceTypeMapping.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }
}

