/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaValidation;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmBaseJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmDiscriminatorColumn;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmSecondaryTable;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTable;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeOverride;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlSecondaryTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.orm.Inheritance;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverrideImpl;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlIdClass;
import org.eclipse.jpt.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumnImpl;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTableImpl;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGeneratorImpl;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGeneratorImpl;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.DatabaseObject;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmEntity
extends AbstractOrmTypeMapping<XmlEntity>
implements OrmEntity {
    protected String specifiedName;
    protected String defaultName;
    protected String idClass;
    protected final OrmTable table = this.getJpaFactory().buildOrmTable(this);
    protected boolean specifiedTableIsAllowed;
    protected boolean tableIsUndefined;
    protected final List<OrmSecondaryTable> specifiedSecondaryTables = new ArrayList<OrmSecondaryTable>();
    protected final List<OrmSecondaryTable> virtualSecondaryTables = new ArrayList<OrmSecondaryTable>();
    protected final List<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns;
    protected final List<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String defaultDiscriminatorValue;
    protected String specifiedDiscriminatorValue;
    protected boolean specifiedDiscriminatorValueIsAllowed;
    protected boolean discriminatorValueIsUndefined;
    protected final OrmDiscriminatorColumn discriminatorColumn = this.buildDiscriminatorColumn();
    protected boolean specifiedDiscriminatorColumnIsAllowed;
    protected boolean discriminatorColumnIsUndefined;
    protected OrmSequenceGenerator sequenceGenerator;
    protected OrmTableGenerator tableGenerator;
    protected final List<OrmAttributeOverride> specifiedAttributeOverrides;
    protected final List<OrmAttributeOverride> virtualAttributeOverrides;
    protected final List<OrmAssociationOverride> specifiedAssociationOverrides;
    protected final List<OrmAssociationOverride> virtualAssociationOverrides;
    protected final List<OrmNamedQuery> namedQueries;
    protected final List<OrmNamedNativeQuery> namedNativeQueries;
    protected Entity rootEntity;
    private static final org.eclipse.jpt.db.Table[] EMPTY_DB_TABLE_ARRAY = new org.eclipse.jpt.db.Table[0];

    protected AbstractOrmEntity(OrmPersistentType parent, XmlEntity resourceMapping) {
        super(parent, resourceMapping);
        this.specifiedPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
        this.defaultPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
        this.specifiedAttributeOverrides = new ArrayList<OrmAttributeOverride>();
        this.virtualAttributeOverrides = new ArrayList<OrmAttributeOverride>();
        this.specifiedAssociationOverrides = new ArrayList<OrmAssociationOverride>();
        this.virtualAssociationOverrides = new ArrayList<OrmAssociationOverride>();
        this.namedQueries = new ArrayList<OrmNamedQuery>();
        this.namedNativeQueries = new ArrayList<OrmNamedNativeQuery>();
        this.specifiedName = ((XmlEntity)this.resourceTypeMapping).getName();
        this.defaultName = this.buildDefaultName();
        this.rootEntity = this.calculateRootEntity();
        this.initializeInheritance(this.getResourceInheritance());
        this.specifiedDiscriminatorColumnIsAllowed = this.buildSpecifiedDiscriminatorColumnIsAllowed();
        this.discriminatorColumnIsUndefined = this.buildDiscriminatorColumnIsUndefined();
        this.discriminatorColumn.initialize((XmlEntity)this.resourceTypeMapping);
        this.specifiedDiscriminatorValueIsAllowed = this.buildSpecifiedDiscriminatorValueIsAllowed();
        this.discriminatorValueIsUndefined = this.buildDiscriminatorValueIsUndefined();
        this.specifiedDiscriminatorValue = ((XmlEntity)this.resourceTypeMapping).getDiscriminatorValue();
        this.defaultDiscriminatorValue = this.buildDefaultDiscriminatorValue();
        this.specifiedTableIsAllowed = this.buildSpecifiedTableIsAllowed();
        this.tableIsUndefined = this.buildTableIsUndefined();
        this.table.initialize((XmlEntity)this.resourceTypeMapping);
        this.initializeSpecifiedSecondaryTables();
        this.initializeVirtualSecondaryTables();
        this.initializeSequenceGenerator();
        this.initializeTableGenerator();
        this.initializeSpecifiedPrimaryKeyJoinColumns();
        this.initializeDefaultPrimaryKeyJoinColumns();
        this.initializeSpecifiedAttributeOverrides();
        this.initializeSpecifiedAssociationOverrides();
        this.initializeNamedQueries();
        this.initializeNamedNativeQueries();
        this.initializeIdClass(this.getResourceIdClass());
    }

    protected OrmDiscriminatorColumn buildDiscriminatorColumn() {
        return this.getJpaFactory().buildOrmDiscriminatorColumn(this, this.buildDiscriminatorColumnOwner());
    }

    protected OrmDiscriminatorColumn.Owner buildDiscriminatorColumnOwner() {
        return new OrmDiscriminatorColumn.Owner(){

            public org.eclipse.jpt.db.Table getDbTable(String tableName) {
                return AbstractOrmEntity.this.getDbTable(tableName);
            }

            public TypeMapping getTypeMapping() {
                return AbstractOrmEntity.this;
            }

            public String getDefaultColumnName() {
                if (((XmlEntity)AbstractOrmEntity.this.getResourceTypeMapping()).getDiscriminatorColumn() == null && !AbstractOrmEntity.this.isMetadataComplete() && AbstractOrmEntity.this.getJavaEntity() != null && AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName() != null) {
                    return AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName();
                }
                return AbstractOrmEntity.this.isDescendant() ? AbstractOrmEntity.this.getRootEntity().getDiscriminatorColumn().getName() : (AbstractOrmEntity.this.isTablePerClass() ? null : "DTYPE");
            }

            public int getDefaultLength() {
                if (((XmlEntity)AbstractOrmEntity.this.getResourceTypeMapping()).getDiscriminatorColumn() == null && !AbstractOrmEntity.this.isMetadataComplete() && AbstractOrmEntity.this.getJavaEntity() != null && AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength() != null) {
                    return AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength();
                }
                return AbstractOrmEntity.this.isDescendant() ? AbstractOrmEntity.this.getRootEntity().getDiscriminatorColumn().getLength() : (AbstractOrmEntity.this.isTablePerClass() ? 0 : 31);
            }

            public DiscriminatorType getDefaultDiscriminatorType() {
                if (((XmlEntity)AbstractOrmEntity.this.getResourceTypeMapping()).getDiscriminatorColumn() == null && !AbstractOrmEntity.this.isMetadataComplete() && AbstractOrmEntity.this.getJavaEntity() != null && AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType() != null) {
                    return AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType();
                }
                return AbstractOrmEntity.this.isDescendant() ? AbstractOrmEntity.this.getRootEntity().getDiscriminatorColumn().getDiscriminatorType() : (AbstractOrmEntity.this.isTablePerClass() ? null : DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE);
            }

            public TextRange getValidationTextRange() {
                return AbstractOrmEntity.this.getValidationTextRange();
            }
        };
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public String getPrimaryTableName() {
        return this.table.getName();
    }

    @Override
    public org.eclipse.jpt.db.Table getPrimaryDbTable() {
        return this.table.getDbTable();
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable(String tableName) {
        return (org.eclipse.jpt.db.Table)this.getDataSource().selectDatabaseObjectForIdentifier((DatabaseObject[])((org.eclipse.jpt.db.Table[])CollectionTools.array(this.associatedDbTablesIncludingInherited(), (Object[])EMPTY_DB_TABLE_ARRAY)), tableName);
    }

    private Iterator<org.eclipse.jpt.db.Table> associatedDbTablesIncludingInherited() {
        return new FilteringIterator<org.eclipse.jpt.db.Table, org.eclipse.jpt.db.Table>(this.associatedDbTablesIncludingInherited_()){

            protected boolean accept(org.eclipse.jpt.db.Table t) {
                return t != null;
            }
        };
    }

    private Iterator<org.eclipse.jpt.db.Table> associatedDbTablesIncludingInherited_() {
        return new TransformationIterator<Table, org.eclipse.jpt.db.Table>(this.associatedTablesIncludingInherited()){

            protected org.eclipse.jpt.db.Table transform(Table t) {
                return t.getDbTable();
            }
        };
    }

    @Override
    public Schema getDbSchema() {
        return this.table.getDbSchema();
    }

    @Override
    public JavaEntity getJavaEntity() {
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        if (javaPersistentType != null && javaPersistentType.getMappingKey() == "entity") {
            return (JavaEntity)javaPersistentType.getMapping();
        }
        return null;
    }

    protected JavaEntity getJavaEntityForDefaults() {
        if (this.isMetadataComplete()) {
            return null;
        }
        return this.getJavaEntity();
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        ((XmlEntity)this.resourceTypeMapping).setName(newSpecifiedName);
        this.firePropertyChanged("specifiedName", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultName", oldDefaultName, newDefaultName);
    }

    @Override
    public OrmTable getTable() {
        return this.table;
    }

    @Override
    public ListIterator<OrmSecondaryTable> secondaryTables() {
        if (this.specifiedSecondaryTablesSize() > 0) {
            return this.specifiedSecondaryTables();
        }
        return this.virtualSecondaryTables();
    }

    @Override
    public int secondaryTablesSize() {
        if (this.specifiedSecondaryTablesSize() > 0) {
            return this.specifiedSecondaryTablesSize();
        }
        return this.virtualSecondaryTablesSize();
    }

    @Override
    public ListIterator<OrmSecondaryTable> virtualSecondaryTables() {
        return new CloneListIterator(this.virtualSecondaryTables);
    }

    @Override
    public int virtualSecondaryTablesSize() {
        return this.virtualSecondaryTables.size();
    }

    protected void addVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.addItemToList(secondaryTable, this.virtualSecondaryTables, "virtualSecondaryTables");
    }

    protected void removeVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.virtualSecondaryTables, "virtualSecondaryTables");
    }

    @Override
    public ListIterator<OrmSecondaryTable> specifiedSecondaryTables() {
        return new CloneListIterator(this.specifiedSecondaryTables);
    }

    @Override
    public int specifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTables.size();
    }

    @Override
    public OrmSecondaryTable addSpecifiedSecondaryTable(int index) {
        if (!this.secondaryTablesDefinedInXml()) {
            throw new IllegalStateException("Virtual secondary tables exist, must first call setSecondaryTablesDefinedInXml(true)");
        }
        XmlSecondaryTableImpl secondaryTableResource = OrmFactory.eINSTANCE.createXmlSecondaryTableImpl();
        OrmSecondaryTable secondaryTable = this.buildSecondaryTable(secondaryTableResource);
        this.specifiedSecondaryTables.add(index, secondaryTable);
        ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().add(index, (Object)secondaryTableResource);
        this.fireItemAdded("specifiedSecondaryTables", index, secondaryTable);
        return secondaryTable;
    }

    @Override
    public OrmSecondaryTable addSpecifiedSecondaryTable() {
        return this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size());
    }

    protected void addSpecifiedSecondaryTable(int index, OrmSecondaryTable secondaryTable) {
        this.addItemToList(index, secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    protected void addSpecifiedSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size(), secondaryTable);
    }

    @Override
    public void removeSpecifiedSecondaryTable(SecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTables.indexOf(secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        OrmSecondaryTable removedSecondaryTable = this.specifiedSecondaryTables.remove(index);
        ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().remove(index);
        this.fireItemRemoved("specifiedSecondaryTables", index, removedSecondaryTable);
    }

    protected void removeSpecifiedSecondaryTable_(OrmSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedSecondaryTables, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedSecondaryTables", targetIndex, sourceIndex);
    }

    public boolean containsSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.secondaryTables());
    }

    public boolean containsSpecifiedSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.specifiedSecondaryTables());
    }

    public boolean containsVirtualSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.virtualSecondaryTables());
    }

    @Override
    public boolean containsVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        return this.virtualSecondaryTables.contains(secondaryTable);
    }

    protected boolean containsSecondaryTable(String name, ListIterator<OrmSecondaryTable> secondaryTables) {
        for (OrmSecondaryTable secondaryTable : CollectionTools.iterable(secondaryTables)) {
            String secondaryTableName = secondaryTable.getName();
            if (secondaryTableName == null || !secondaryTableName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean secondaryTablesDefinedInXml() {
        return this.virtualSecondaryTablesSize() == 0;
    }

    @Override
    public void setSecondaryTablesDefinedInXml(boolean defineInXml) {
        if (defineInXml == this.secondaryTablesDefinedInXml()) {
            return;
        }
        if (defineInXml) {
            this.specifySecondaryTablesInXml();
        } else {
            this.removeSecondaryTablesFromXml();
        }
    }

    protected void specifySecondaryTablesInXml() {
        if (this.virtualSecondaryTablesSize() != 0) {
            ArrayList virtualSecondaryTables1 = CollectionTools.list(this.virtualSecondaryTables());
            ArrayList virtualSecondaryTables2 = CollectionTools.list(this.virtualSecondaryTables());
            for (OrmSecondaryTable virtualSecondaryTable : CollectionTools.iterable(this.virtualSecondaryTables())) {
                this.virtualSecondaryTables.remove(virtualSecondaryTable);
            }
            for (OrmSecondaryTable virtualSecondaryTable : virtualSecondaryTables2) {
                XmlSecondaryTableImpl secondaryTableResource = OrmFactory.eINSTANCE.createXmlSecondaryTableImpl();
                OrmSecondaryTable specifiedSecondaryTable = this.buildSecondaryTable(secondaryTableResource);
                this.specifiedSecondaryTables.add(specifiedSecondaryTable);
                ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().add((Object)secondaryTableResource);
                specifiedSecondaryTable.initializeFrom(virtualSecondaryTable);
            }
            this.fireItemsRemoved("virtualSecondaryTables", 0, virtualSecondaryTables1);
            this.fireItemsAdded("specifiedSecondaryTables", 0, this.specifiedSecondaryTables);
        }
    }

    protected void removeSecondaryTablesFromXml() {
        if (this.specifiedSecondaryTablesSize() != 0) {
            ArrayList specifiedSecondaryTablesCopy = CollectionTools.list(this.specifiedSecondaryTables());
            for (OrmSecondaryTable specifiedSecondaryTable : CollectionTools.iterable(this.specifiedSecondaryTables())) {
                int index = this.specifiedSecondaryTables.indexOf(specifiedSecondaryTable);
                this.specifiedSecondaryTables.remove(specifiedSecondaryTable);
                if (this.specifiedSecondaryTables.size() == 0) {
                    this.initializeVirtualSecondaryTables();
                }
                ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().remove(index);
            }
            this.fireItemsRemoved("specifiedSecondaryTables", 0, specifiedSecondaryTablesCopy);
            if (this.virtualSecondaryTables.size() != 0) {
                this.fireItemsAdded("virtualSecondaryTables", 0, this.virtualSecondaryTables);
            }
        }
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator<Table, String>(tables){

            protected String transform(Table t) {
                return t.getName();
            }
        };
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return this.nonNullTableNames(this.associatedTablesIncludingInherited());
    }

    protected Iterator<String> nonNullTableNames(Iterator<Table> tables) {
        return new FilteringIterator<String, String>(this.tableNames(tables)){

            protected boolean accept(String o) {
                return o != null;
            }
        };
    }

    @Override
    public Iterator<Table> associatedTables() {
        return new CompositeIterator((Object)this.table, this.secondaryTables());
    }

    @Override
    public Iterator<Table> associatedTablesIncludingInherited() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<Table>>(this.inheritanceHierarchy()){

            protected Iterator<Table> transform(TypeMapping mapping) {
                return new FilteringIterator<Table, Table>(mapping.associatedTables()){

                    protected boolean accept(Table o) {
                        return true;
                    }
                };
            }
        });
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !CollectionTools.contains(this.associatedTableNamesIncludingInherited(), (Object)tableName);
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return super.shouldValidateAgainstDatabase() && !this.isAbstractTablePerClass();
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.getSpecifiedInheritanceStrategy() == null ? this.getDefaultInheritanceStrategy() : this.getSpecifiedInheritanceStrategy();
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        if (oldInheritanceType != newInheritanceType) {
            if (this.getResourceInheritance() != null) {
                this.getResourceInheritance().setStrategy(InheritanceType.toOrmResourceModel(newInheritanceType));
                if (this.getResourceInheritance().isUnset()) {
                    this.removeResourceInheritance();
                }
            } else if (newInheritanceType != null) {
                this.addResourceInheritance();
                this.getResourceInheritance().setStrategy(InheritanceType.toOrmResourceModel(newInheritanceType));
            }
        }
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected Inheritance getResourceInheritance() {
        return ((XmlEntity)this.resourceTypeMapping).getInheritance();
    }

    protected void addResourceInheritance() {
        ((XmlEntity)this.resourceTypeMapping).setInheritance(OrmFactory.eINSTANCE.createInheritance());
    }

    protected void removeResourceInheritance() {
        ((XmlEntity)this.resourceTypeMapping).setInheritance(null);
    }

    @Override
    public OrmDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        XmlSequenceGeneratorImpl resourceSequenceGenerator = OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl();
        this.sequenceGenerator = this.buildSequenceGenerator(resourceSequenceGenerator);
        ((XmlEntity)this.resourceTypeMapping).setSequenceGenerator(resourceSequenceGenerator);
        this.firePropertyChanged("sequenceGenerator", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        ((XmlEntity)this.resourceTypeMapping).setSequenceGenerator(null);
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, null);
    }

    @Override
    public OrmSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(OrmSequenceGenerator newSequenceGenerator) {
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, newSequenceGenerator);
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        XmlTableGeneratorImpl resourceTableGenerator = OrmFactory.eINSTANCE.createXmlTableGeneratorImpl();
        this.tableGenerator = this.buildTableGenerator(resourceTableGenerator);
        ((XmlEntity)this.resourceTypeMapping).setTableGenerator(resourceTableGenerator);
        this.firePropertyChanged("tableGenerator", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        ((XmlEntity)this.resourceTypeMapping).setTableGenerator(null);
        this.firePropertyChanged("tableGenerator", oldTableGenerator, null);
    }

    @Override
    public OrmTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(OrmTableGenerator newTableGenerator) {
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGenerator", oldTableGenerator, newTableGenerator);
    }

    protected Iterator<OrmGenerator> generators() {
        ArrayList<OrmGenerator> generators = new ArrayList<OrmGenerator>();
        this.addGeneratorsTo(generators);
        return generators.iterator();
    }

    protected void addGeneratorsTo(ArrayList<OrmGenerator> generators) {
        if (this.sequenceGenerator != null) {
            generators.add(this.sequenceGenerator);
        }
        if (this.tableGenerator != null) {
            generators.add(this.tableGenerator);
        }
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String newDefaultDiscriminatorValue) {
        String oldDefaultDiscriminatorValue = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = newDefaultDiscriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValue", oldDefaultDiscriminatorValue, newDefaultDiscriminatorValue);
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        ((XmlEntity)this.resourceTypeMapping).setDiscriminatorValue(newSpecifiedDiscriminatorValue);
        this.firePropertyChanged("specifiedDiscriminatorValue", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getSpecifiedDiscriminatorValue() == null ? this.getDefaultDiscriminatorValue() : this.getSpecifiedDiscriminatorValue();
    }

    @Override
    public boolean specifiedDiscriminatorValueIsAllowed() {
        return this.specifiedDiscriminatorValueIsAllowed;
    }

    protected void setSpecifiedDiscriminatorValueIsAllowed(boolean specifiedDiscriminatorValueIsAllowed) {
        boolean old = this.specifiedDiscriminatorValueIsAllowed;
        this.specifiedDiscriminatorValueIsAllowed = specifiedDiscriminatorValueIsAllowed;
        this.firePropertyChanged("discriminatorValueIsAllowed", old, specifiedDiscriminatorValueIsAllowed);
    }

    @Override
    public boolean discriminatorValueIsUndefined() {
        return this.discriminatorValueIsUndefined;
    }

    protected void setDiscriminatorValueIsUndefined(boolean discriminatorValueIsUndefined) {
        boolean old = this.discriminatorValueIsUndefined;
        this.discriminatorValueIsUndefined = discriminatorValueIsUndefined;
        this.firePropertyChanged("discriminatorValueIsUndefined", old, discriminatorValueIsUndefined);
    }

    @Override
    public boolean specifiedDiscriminatorColumnIsAllowed() {
        return this.specifiedDiscriminatorColumnIsAllowed;
    }

    protected void setSpecifiedDiscriminatorColumnIsAllowed(boolean specifiedDiscriminatorColumnIsAllowed) {
        boolean old = this.specifiedDiscriminatorColumnIsAllowed;
        this.specifiedDiscriminatorColumnIsAllowed = specifiedDiscriminatorColumnIsAllowed;
        this.firePropertyChanged("specifiedDiscriminatorColumnIsAllowed", old, specifiedDiscriminatorColumnIsAllowed);
    }

    @Override
    public boolean discriminatorColumnIsUndefined() {
        return this.discriminatorColumnIsUndefined;
    }

    protected void setDiscriminatorColumnIsUndefined(boolean discriminatorColumnIsUndefined) {
        boolean old = this.discriminatorColumnIsUndefined;
        this.discriminatorColumnIsUndefined = discriminatorColumnIsUndefined;
        this.firePropertyChanged("discriminatorColumnIsUndefined", old, discriminatorColumnIsUndefined);
    }

    @Override
    public boolean specifiedTableIsAllowed() {
        return this.specifiedTableIsAllowed;
    }

    protected void setSpecifiedTableIsAllowed(boolean specifiedTableIsAllowed) {
        boolean old = this.specifiedTableIsAllowed;
        this.specifiedTableIsAllowed = specifiedTableIsAllowed;
        this.firePropertyChanged("specifiedTableIsAllowed", old, specifiedTableIsAllowed);
    }

    @Override
    public boolean tableIsUndefined() {
        return this.tableIsUndefined;
    }

    protected void setTableIsUndefined(boolean tableIsUndefined) {
        boolean old = this.tableIsUndefined;
        this.tableIsUndefined = tableIsUndefined;
        this.firePropertyChanged("tableIsUndefined", old, tableIsUndefined);
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.defaultPrimaryKeyJoinColumns);
    }

    public int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumns.size();
    }

    @Override
    public OrmPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        throw new UnsupportedOperationException("use defaultPrimaryKeyJoinColumns() instead");
    }

    protected void addDefaultPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn defaultPkJoinColumn) {
        this.addItemToList(defaultPkJoinColumn, this.defaultPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumns");
    }

    protected void removeDefaultPrimaryKeyJoinColumn(PrimaryKeyJoinColumn defaultPkJoinColumn) {
        this.removeItemFromList(defaultPkJoinColumn, this.defaultPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumns");
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.specifiedPrimaryKeyJoinColumns.isEmpty() ? this.defaultPrimaryKeyJoinColumns() : this.specifiedPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.isEmpty() ? this.defaultPrimaryKeyJoinColumnsSize() : this.specifiedPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.specifiedPrimaryKeyJoinColumns.isEmpty();
    }

    @Override
    public OrmPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        if (!this.defaultPrimaryKeyJoinColumns.isEmpty()) {
            this.defaultPrimaryKeyJoinColumns.clear();
        }
        XmlPrimaryKeyJoinColumnImpl resourcePkJoinColumn = OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumnImpl();
        OrmPrimaryKeyJoinColumn contextPkJoinColumn = this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn);
        this.specifiedPrimaryKeyJoinColumns.add(index, contextPkJoinColumn);
        ((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns().add(index, (Object)resourcePkJoinColumn);
        this.fireItemAdded("specifiedPrimaryKeyJoinColumns", index, contextPkJoinColumn);
        this.fireListCleared("defaultPrimaryKeyJoinColumns");
        return contextPkJoinColumn;
    }

    protected OrmBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.size(), primaryKeyJoinColumn);
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(primaryKeyJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        if (!this.containsSpecifiedPrimaryKeyJoinColumns()) {
            this.initializeDefaultPrimaryKeyJoinColumns();
        }
        ((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns().remove(index);
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumns", index, removedPrimaryKeyJoinColumn);
        if (!this.defaultPrimaryKeyJoinColumns.isEmpty()) {
            this.fireListChanged("defaultPrimaryKeyJoinColumns");
        }
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedPrimaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedPrimaryKeyJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return this.specifiedAttributeOverridesSize() + this.virtualAttributeOverridesSize();
    }

    @Override
    public ListIterator<OrmAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.virtualAttributeOverrides);
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.virtualAttributeOverrides.size();
    }

    protected void addVirtualAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.addItemToList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    protected void removeVirtualAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    protected OrmAttributeOverride setAttributeOverrideVirtual(boolean virtual, OrmAttributeOverride attributeOverride) {
        if (virtual) {
            return this.setAttributeOverrideVirtual(attributeOverride);
        }
        return this.setAttributeOverrideSpecified(attributeOverride);
    }

    protected OrmAttributeOverride setAttributeOverrideVirtual(OrmAttributeOverride attributeOverride) {
        int index = this.specifiedAttributeOverrides.indexOf(attributeOverride);
        this.specifiedAttributeOverrides.remove(index);
        String attributeOverrideName = attributeOverride.getName();
        OrmAttributeOverride virtualAttributeOverride = null;
        if (attributeOverrideName != null) {
            for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
                if (!persistentAttribute.getName().equals(attributeOverrideName)) continue;
                JavaAttributeOverride javaAttributeOverride = null;
                if (this.getJavaEntity() != null) {
                    javaAttributeOverride = this.getJavaEntity().getAttributeOverrideNamed(attributeOverrideName);
                }
                virtualAttributeOverride = this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride);
                this.virtualAttributeOverrides.add(virtualAttributeOverride);
            }
        }
        ((XmlEntity)this.resourceTypeMapping).getAttributeOverrides().remove(index);
        this.fireItemRemoved("specifiedAttributeOverrides", index, attributeOverride);
        if (virtualAttributeOverride != null) {
            this.fireItemAdded("virtualAttributeOverrides", this.virtualAttributeOverridesSize() - 1, virtualAttributeOverride);
        }
        return virtualAttributeOverride;
    }

    protected OrmAttributeOverride setAttributeOverrideSpecified(OrmAttributeOverride oldAttributeOverride) {
        int index = this.specifiedAttributeOverridesSize();
        XmlAttributeOverrideImpl xmlAttributeOverride = OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl();
        OrmAttributeOverride newAttributeOverride = this.getJpaFactory().buildOrmAttributeOverride(this, this.createAttributeOverrideOwner(), xmlAttributeOverride);
        this.specifiedAttributeOverrides.add(index, newAttributeOverride);
        ((XmlEntity)this.resourceTypeMapping).getAttributeOverrides().add((Object)xmlAttributeOverride);
        int defaultIndex = this.virtualAttributeOverrides.indexOf(oldAttributeOverride);
        this.virtualAttributeOverrides.remove(defaultIndex);
        newAttributeOverride.setName(oldAttributeOverride.getName());
        newAttributeOverride.getColumn().setSpecifiedName(oldAttributeOverride.getColumn().getName());
        this.fireItemRemoved("virtualAttributeOverrides", defaultIndex, oldAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverrides", index, newAttributeOverride);
        return newAttributeOverride;
    }

    @Override
    public ListIterator<OrmAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected void addSpecifiedAttributeOverride(int index, OrmAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    protected void addSpecifiedAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.addSpecifiedAttributeOverride(this.specifiedAttributeOverrides.size(), attributeOverride);
    }

    protected void removeSpecifiedAttributeOverride_(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.resourceTypeMapping).getAttributeOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAttributeOverrides", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmAssociationOverride> associationOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAssociationOverrides(), this.virtualAssociationOverrides()});
    }

    @Override
    public int associationOverridesSize() {
        return this.specifiedAssociationOverridesSize() + this.virtualAssociationOverridesSize();
    }

    @Override
    public ListIterator<OrmAssociationOverride> virtualAssociationOverrides() {
        return new CloneListIterator(this.virtualAssociationOverrides);
    }

    @Override
    public int virtualAssociationOverridesSize() {
        return this.virtualAssociationOverrides.size();
    }

    @Override
    public ListIterator<OrmAssociationOverride> specifiedAssociationOverrides() {
        return new CloneListIterator(this.specifiedAssociationOverrides);
    }

    @Override
    public int specifiedAssociationOverridesSize() {
        return this.specifiedAssociationOverrides.size();
    }

    protected void addSpecifiedAssociationOverride(int index, OrmAssociationOverride associationOverride) {
        this.addItemToList(index, associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    protected void addSpecifiedAssociationOverride(OrmAssociationOverride associationOverride) {
        this.addSpecifiedAssociationOverride(this.specifiedAssociationOverrides.size(), associationOverride);
    }

    protected void removeSpecifiedAssociationOverride_(OrmAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    @Override
    public void moveSpecifiedAssociationOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAssociationOverrides, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.resourceTypeMapping).getAssociationOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAssociationOverrides", targetIndex, sourceIndex);
    }

    @Override
    public OrmAttributeOverride getAttributeOverrideNamed(String name) {
        return (OrmAttributeOverride)this.getOverrideNamed(name, this.attributeOverrides());
    }

    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, this.attributeOverrides());
    }

    public boolean containsDefaultAttributeOverride(String name) {
        return this.containsOverride(name, this.virtualAttributeOverrides());
    }

    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, this.specifiedAttributeOverrides());
    }

    public OrmAssociationOverride getAssociationOverrideNamed(String name) {
        return (OrmAssociationOverride)this.getOverrideNamed(name, this.associationOverrides());
    }

    public boolean containsAssociationOverride(String name) {
        return this.containsOverride(name, this.associationOverrides());
    }

    public boolean containsSpecifiedAssociationOverride(String name) {
        return this.containsOverride(name, this.specifiedAssociationOverrides());
    }

    public boolean containsDefaultAssociationOverride(String name) {
        return this.containsOverride(name, this.virtualAssociationOverrides());
    }

    private BaseOverride getOverrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    private boolean containsOverride(String name, ListIterator<? extends BaseOverride> overrides) {
        return this.getOverrideNamed(name, overrides) != null;
    }

    @Override
    public ListIterator<OrmNamedQuery> namedQueries() {
        return new CloneListIterator(this.namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.namedQueries.size();
    }

    @Override
    public OrmNamedQuery addNamedQuery(int index) {
        XmlNamedQuery resourceNamedQuery = OrmFactory.eINSTANCE.createXmlNamedQuery();
        OrmNamedQuery contextNamedQuery = this.buildNamedQuery(resourceNamedQuery);
        this.namedQueries.add(index, contextNamedQuery);
        ((XmlEntity)this.resourceTypeMapping).getNamedQueries().add(index, (Object)resourceNamedQuery);
        this.fireItemAdded("namedQueries", index, contextNamedQuery);
        return contextNamedQuery;
    }

    protected void addNamedQuery(int index, OrmNamedQuery namedQuery) {
        this.addItemToList(index, namedQuery, this.namedQueries, "namedQueries");
    }

    protected void addNamedQuery(OrmNamedQuery namedQuery) {
        this.addNamedQuery(this.namedQueries.size(), namedQuery);
    }

    @Override
    public void removeNamedQuery(NamedQuery namedQuery) {
        this.removeNamedQuery(this.namedQueries.indexOf(namedQuery));
    }

    @Override
    public void removeNamedQuery(int index) {
        OrmNamedQuery namedQuery = this.namedQueries.remove(index);
        ((XmlEntity)this.resourceTypeMapping).getNamedQueries().remove(index);
        this.fireItemRemoved("namedQueries", index, namedQuery);
    }

    protected void removeNamedQuery_(OrmNamedQuery namedQuery) {
        this.removeItemFromList(namedQuery, this.namedQueries, "namedQueries");
    }

    @Override
    public void moveNamedQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedQueries, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.resourceTypeMapping).getNamedQueries().move(targetIndex, sourceIndex);
        this.fireItemMoved("namedQueries", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmNamedNativeQuery> namedNativeQueries() {
        return new CloneListIterator(this.namedNativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.namedNativeQueries.size();
    }

    @Override
    public OrmNamedNativeQuery addNamedNativeQuery(int index) {
        XmlNamedNativeQuery resourceNamedNativeQuery = OrmFactory.eINSTANCE.createXmlNamedNativeQuery();
        OrmNamedNativeQuery contextNamedNativeQuery = this.buildNamedNativeQuery(resourceNamedNativeQuery);
        this.namedNativeQueries.add(index, contextNamedNativeQuery);
        ((XmlEntity)this.resourceTypeMapping).getNamedNativeQueries().add(index, (Object)resourceNamedNativeQuery);
        this.fireItemAdded("namedNativeQueries", index, contextNamedNativeQuery);
        return contextNamedNativeQuery;
    }

    protected void addNamedNativeQuery(int index, OrmNamedNativeQuery namedNativeQuery) {
        this.addItemToList(index, namedNativeQuery, this.namedNativeQueries, "namedNativeQueries");
    }

    protected void addNamedNativeQuery(OrmNamedNativeQuery namedNativeQuery) {
        this.addNamedNativeQuery(this.namedNativeQueries.size(), namedNativeQuery);
    }

    @Override
    public void removeNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.removeNamedNativeQuery(this.namedNativeQueries.indexOf(namedNativeQuery));
    }

    @Override
    public void removeNamedNativeQuery(int index) {
        OrmNamedNativeQuery namedNativeQuery = this.namedNativeQueries.remove(index);
        ((XmlEntity)this.resourceTypeMapping).getNamedNativeQueries().remove(index);
        this.fireItemRemoved("namedNativeQueries", index, namedNativeQuery);
    }

    protected void removeNamedNativeQuery_(OrmNamedNativeQuery namedNativeQuery) {
        this.removeItemFromList(namedNativeQuery, this.namedNativeQueries, "namedNativeQueries");
    }

    @Override
    public void moveNamedNativeQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedNativeQueries, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.resourceTypeMapping).getNamedNativeQueries().move(targetIndex, sourceIndex);
        this.fireItemMoved("namedNativeQueries", targetIndex, sourceIndex);
    }

    public Iterator<OrmQuery> queries() {
        return new CompositeIterator(new Iterator[]{this.namedQueries(), this.namedNativeQueries()});
    }

    @Override
    public char getIdClassEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (oldIdClass != newIdClass) {
            if (this.getResourceIdClass() != null) {
                this.getResourceIdClass().setClassName(newIdClass);
                if (this.getResourceIdClass().isUnset()) {
                    this.removeResourceIdClass();
                }
            } else if (newIdClass != null) {
                this.addResourceIdClass();
                this.getResourceIdClass().setClassName(newIdClass);
            }
        }
        this.firePropertyChanged("idClass", oldIdClass, newIdClass);
    }

    protected void setIdClass_(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClass", oldIdClass, newIdClass);
    }

    protected XmlIdClass getResourceIdClass() {
        return ((XmlEntity)this.resourceTypeMapping).getIdClass();
    }

    protected void addResourceIdClass() {
        ((XmlEntity)this.resourceTypeMapping).setIdClass(OrmFactory.eINSTANCE.createXmlIdClass());
    }

    protected void removeResourceIdClass() {
        ((XmlEntity)this.resourceTypeMapping).setIdClass(null);
    }

    @Override
    public Entity getParentEntity() {
        Iterator<PersistentType> stream = this.getPersistentType().ancestors();
        while (stream.hasNext()) {
            TypeMapping tm = stream.next().getMapping();
            if (!(tm instanceof Entity)) continue;
            return (Entity)tm;
        }
        return this;
    }

    protected Entity getRootEntity() {
        return this.rootEntity;
    }

    @Override
    public String getDefaultTableName() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null) {
            JavaTable javaTable = javaEntity.getTable();
            if (!this.isMetadataComplete() && !this.table.isResourceSpecified() && javaTable.getSpecifiedName() != null) {
                return javaTable.getSpecifiedName();
            }
        }
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getName() : (this.isAbstractTablePerClass() ? null : this.getName());
    }

    @Override
    public String getDefaultSchema() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null) {
            JavaTable javaTable = javaEntity.getTable();
            if (!this.isMetadataComplete() && !this.table.isResourceSpecified() && javaTable.getSpecifiedSchema() != null) {
                return javaTable.getSpecifiedSchema();
            }
        }
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getSchema() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultSchema());
    }

    @Override
    public String getDefaultCatalog() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null) {
            JavaTable javaTable = javaEntity.getTable();
            if (!this.isMetadataComplete() && !this.table.isResourceSpecified() && javaTable.getSpecifiedCatalog() != null) {
                return javaTable.getSpecifiedCatalog();
            }
        }
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getCatalog() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultCatalog());
    }

    protected boolean isSingleTableDescendant() {
        return this.isDescendant() && this.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE;
    }

    protected boolean isDescendant() {
        return !this.isRoot();
    }

    protected boolean isRoot() {
        return this == this.getRootEntity();
    }

    protected boolean isRootNoDescendantsNoStrategyDefined() {
        return this.isRoot() && !this.getPersistenceUnit().isRootWithSubEntities(this.getName()) && this.getSpecifiedInheritanceStrategy() == null;
    }

    protected boolean isAbstractTablePerClass() {
        return this.isAbstract() && this.isTablePerClass();
    }

    protected boolean isTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected boolean isAbstract() {
        JavaResourcePersistentType javaResourcePersistentType = this.getJavaResourcePersistentType();
        return javaResourcePersistentType == null ? false : javaResourcePersistentType.isAbstract();
    }

    @Override
    public int getXmlSequence() {
        return 1;
    }

    protected Iterator<TypeMapping> inheritanceHierarchy() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().inheritanceHierarchy()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    protected Iterator<TypeMapping> ancestors() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().ancestors()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<OrmPersistentAttribute> overridableAttributes() {
        if (!this.isTablePerClass()) {
            return EmptyIterator.instance();
        }
        return new FilteringIterator<OrmPersistentAttribute, OrmPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(OrmPersistentAttribute o) {
                return o.isOverridableAttribute();
            }
        };
    }

    @Override
    public Iterator<OrmPersistentAttribute> overridableAssociations() {
        if (!this.isTablePerClass()) {
            return EmptyIterator.instance();
        }
        return new FilteringIterator<OrmPersistentAttribute, OrmPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(OrmPersistentAttribute o) {
                return o.isOverridableAssociation();
            }
        };
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<PersistentAttribute>>(this.ancestors()){

            protected Iterator<PersistentAttribute> transform(TypeMapping mapping) {
                return mapping.overridableAttributes();
            }
        });
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAssociations() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<PersistentAttribute>>(this.ancestors()){

            protected Iterator<PersistentAttribute> transform(TypeMapping mapping) {
                return mapping.overridableAssociations();
            }
        });
    }

    protected void initializeInheritance(Inheritance inheritanceResource) {
        this.specifiedInheritanceStrategy = this.getResourceInheritanceStrategy(inheritanceResource);
    }

    protected void initializeSpecifiedSecondaryTables() {
        for (XmlSecondaryTable secondaryTable : ((XmlEntity)this.resourceTypeMapping).getSecondaryTables()) {
            this.specifiedSecondaryTables.add(this.buildSecondaryTable(secondaryTable));
        }
    }

    protected void initializeVirtualSecondaryTables() {
        if (this.isMetadataComplete()) {
            return;
        }
        if (this.getJavaEntity() == null) {
            return;
        }
        if (this.specifiedSecondaryTablesSize() > 0) {
            return;
        }
        ListIterator<JavaSecondaryTable> javaSecondaryTables = this.getJavaEntity().secondaryTables();
        while (javaSecondaryTables.hasNext()) {
            JavaSecondaryTable javaSecondaryTable = javaSecondaryTables.next();
            if (javaSecondaryTable.getName() == null) continue;
            this.virtualSecondaryTables.add(this.buildVirtualSecondaryTable(javaSecondaryTable));
        }
    }

    protected void initializeDefaultPrimaryKeyJoinColumns() {
        if (this.isMetadataComplete()) {
            return;
        }
        if (this.getJavaEntity() == null) {
            this.defaultPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(null));
            return;
        }
        if (this.specifiedPrimaryKeyJoinColumnsSize() > 0) {
            return;
        }
        ListIterator<JavaPrimaryKeyJoinColumn> javaPkJoinColumns = this.getJavaEntity().primaryKeyJoinColumns();
        while (javaPkJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn javaPkJoinColumn = javaPkJoinColumns.next();
            if (javaPkJoinColumn.getName() == null) continue;
            this.defaultPrimaryKeyJoinColumns.add(this.buildVirtualPrimaryKeyJoinColumn(javaPkJoinColumn));
        }
    }

    protected void initializeTableGenerator() {
        if (((XmlEntity)this.resourceTypeMapping).getTableGenerator() != null) {
            this.tableGenerator = this.buildTableGenerator(((XmlEntity)this.resourceTypeMapping).getTableGenerator());
        }
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator resourceTableGenerator) {
        return this.getJpaFactory().buildOrmTableGenerator(this, resourceTableGenerator);
    }

    protected void initializeSequenceGenerator() {
        if (((XmlEntity)this.resourceTypeMapping).getSequenceGenerator() != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(((XmlEntity)this.resourceTypeMapping).getSequenceGenerator());
        }
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator resourceSequenceGenerator) {
        return this.getJpaFactory().buildOrmSequenceGenerator(this, resourceSequenceGenerator);
    }

    protected void initializeSpecifiedPrimaryKeyJoinColumns() {
        for (XmlPrimaryKeyJoinColumn resourcePkJoinColumn : ((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn));
        }
    }

    protected void initializeSpecifiedAttributeOverrides() {
        for (XmlAttributeOverride attributeOverride : ((XmlEntity)this.resourceTypeMapping).getAttributeOverrides()) {
            this.specifiedAttributeOverrides.add(this.buildAttributeOverride(attributeOverride));
        }
    }

    protected OrmAttributeOverride buildVirtualAttributeOverride(PersistentAttribute persistentAttribute, JavaAttributeOverride javaAttributeOverride) {
        return this.buildAttributeOverride(this.buildVirtualXmlAttributeOverride(persistentAttribute, javaAttributeOverride));
    }

    protected XmlAttributeOverride buildVirtualXmlAttributeOverride(PersistentAttribute persistentAttribute, JavaAttributeOverride javaAttributeOverride) {
        VirtualXmlColumn xmlColumn;
        if (javaAttributeOverride == null) {
            ColumnMapping columnMapping = (ColumnMapping)((Object)persistentAttribute.getMapping());
            xmlColumn = new VirtualXmlColumn(this, columnMapping.getColumn());
        } else {
            xmlColumn = new VirtualXmlColumn(this, javaAttributeOverride.getColumn());
        }
        return new VirtualXmlAttributeOverride(persistentAttribute.getName(), xmlColumn);
    }

    protected void initializeSpecifiedAssociationOverrides() {
        for (XmlAssociationOverride associationOverride : ((XmlEntity)this.resourceTypeMapping).getAssociationOverrides()) {
            this.specifiedAssociationOverrides.add(this.buildAssociationOverride(associationOverride));
        }
    }

    protected void initializeNamedQueries() {
        for (XmlNamedQuery namedQuery : ((XmlEntity)this.resourceTypeMapping).getNamedQueries()) {
            this.namedQueries.add(this.buildNamedQuery(namedQuery));
        }
    }

    protected void initializeNamedNativeQueries() {
        for (XmlNamedNativeQuery namedNativeQuery : ((XmlEntity)this.resourceTypeMapping).getNamedNativeQueries()) {
            this.namedNativeQueries.add(this.buildNamedNativeQuery(namedNativeQuery));
        }
    }

    protected void initializeIdClass(XmlIdClass idClassResource) {
        this.idClass = this.getResourceIdClass(idClassResource);
    }

    protected String getResourceIdClass(XmlIdClass idClassResource) {
        return idClassResource == null ? null : idClassResource.getClassName();
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedName(((XmlEntity)this.resourceTypeMapping).getName());
        this.setDefaultName(this.buildDefaultName());
        this.updateInheritance(this.getResourceInheritance());
        this.updateRootEntity();
        this.updateDiscriminatorColumn();
        this.updateDiscriminatorValue();
        this.setSpecifiedTableIsAllowed(this.buildSpecifiedTableIsAllowed());
        this.setTableIsUndefined(this.buildTableIsUndefined());
        this.table.update((XmlEntity)this.resourceTypeMapping);
        this.updateSpecifiedSecondaryTables();
        this.updateVirtualSecondaryTables();
        this.updateSequenceGenerator();
        this.updateTableGenerator();
        this.updateSpecifiedPrimaryKeyJoinColumns();
        this.updateDefaultPrimaryKeyJoinColumns();
        this.updateSpecifiedAttributeOverrides();
        this.updateVirtualAttributeOverrides();
        this.updateSpecifiedAssociationOverrides();
        this.updateNamedQueries();
        this.updateNamedNativeQueries();
        this.updateIdClass(this.getResourceIdClass());
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.setDiscriminatorColumnIsUndefined(this.buildDiscriminatorColumnIsUndefined());
        this.getDiscriminatorColumn().postUpdate();
        this.postUpdateDiscriminatorValue();
    }

    protected String buildDefaultName() {
        JavaEntity javaEntity;
        if (!this.isMetadataComplete() && (javaEntity = this.getJavaEntity()) != null) {
            return javaEntity.getName();
        }
        String className = this.getClass_();
        if (className != null) {
            return ClassTools.shortNameForClassNamed((String)className);
        }
        return null;
    }

    protected void updateDiscriminatorColumn() {
        this.setSpecifiedDiscriminatorColumnIsAllowed(this.buildSpecifiedDiscriminatorColumnIsAllowed());
        this.getDiscriminatorColumn().update((XmlEntity)this.resourceTypeMapping);
    }

    protected void postUpdateDiscriminatorColumn() {
        this.setDiscriminatorColumnIsUndefined(this.buildDiscriminatorColumnIsUndefined());
        this.getDiscriminatorColumn().postUpdate();
    }

    protected void updateDiscriminatorValue() {
        this.setSpecifiedDiscriminatorValueIsAllowed(this.buildSpecifiedDiscriminatorValueIsAllowed());
        this.setSpecifiedDiscriminatorValue(((XmlEntity)this.resourceTypeMapping).getDiscriminatorValue());
    }

    protected void postUpdateDiscriminatorValue() {
        this.setDiscriminatorValueIsUndefined(this.buildDiscriminatorValueIsUndefined());
        this.setDefaultDiscriminatorValue(this.buildDefaultDiscriminatorValue());
    }

    protected String buildDefaultDiscriminatorValue() {
        if (!this.isMetadataComplete() && this.getJavaEntity() != null) {
            return this.getJavaEntity().getDiscriminatorValue();
        }
        if (this.discriminatorValueIsUndefined()) {
            return null;
        }
        if (this.getDiscriminatorType() != DiscriminatorType.STRING) {
            return null;
        }
        return this.getName();
    }

    protected DiscriminatorType getDiscriminatorType() {
        return this.getDiscriminatorColumn().getDiscriminatorType();
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType() {
        if (this.getPersistentType().getJavaPersistentType() != null) {
            return this.getPersistentType().getJavaPersistentType().getResourcePersistentType();
        }
        return null;
    }

    protected boolean buildSpecifiedDiscriminatorValueIsAllowed() {
        return !this.isTablePerClass() && !this.isAbstract();
    }

    protected boolean buildDiscriminatorValueIsUndefined() {
        return this.isTablePerClass() || this.isAbstract() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return !this.isTablePerClass() && this.isRoot();
    }

    protected boolean buildDiscriminatorColumnIsUndefined() {
        return this.isTablePerClass() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected boolean buildSpecifiedTableIsAllowed() {
        return !this.isAbstractTablePerClass() && !this.isSingleTableDescendant();
    }

    protected boolean buildTableIsUndefined() {
        return this.isAbstractTablePerClass();
    }

    protected void updateInheritance(Inheritance inheritanceResource) {
        this.setSpecifiedInheritanceStrategy_(this.getResourceInheritanceStrategy(inheritanceResource));
        this.setDefaultInheritanceStrategy(this.buildDefaultInheritanceStrategy());
    }

    protected void updateRootEntity() {
        this.rootEntity = this.calculateRootEntity();
        if (this.rootEntity != this) {
            this.rootEntity.addSubEntity(this);
        }
    }

    protected Entity calculateRootEntity() {
        Entity rootEntity = this;
        Iterator<PersistentType> stream = this.getPersistentType().inheritanceHierarchy();
        while (stream.hasNext()) {
            PersistentType persistentType = stream.next();
            if (!(persistentType.getMapping() instanceof Entity)) continue;
            rootEntity = (Entity)persistentType.getMapping();
        }
        return rootEntity;
    }

    @Override
    public void addSubEntity(Entity subEntity) {
        this.getPersistenceUnit().addRootWithSubEntities(this.getName());
    }

    protected void updateSpecifiedSecondaryTables() {
        CloneIterator xmlTables = new CloneIterator(((XmlEntity)this.resourceTypeMapping).getSecondaryTables());
        ListIterator<OrmSecondaryTable> contextTables = this.specifiedSecondaryTables();
        while (contextTables.hasNext()) {
            OrmSecondaryTable contextTable = (OrmSecondaryTable)contextTables.next();
            if (xmlTables.hasNext()) {
                contextTable.update((XmlSecondaryTable)xmlTables.next());
                continue;
            }
            this.removeSpecifiedSecondaryTable_(contextTable);
        }
        while (xmlTables.hasNext()) {
            this.addSpecifiedSecondaryTable(this.buildSecondaryTable((XmlSecondaryTable)xmlTables.next()));
        }
    }

    protected void updateVirtualSecondaryTables() {
        ListIterator<OrmSecondaryTable> secondaryTables = this.virtualSecondaryTables();
        ListIterator<JavaSecondaryTable> javaSecondaryTables = EmptyListIterator.instance();
        if (this.getJavaEntity() != null && !this.isMetadataComplete() && this.specifiedSecondaryTablesSize() == 0) {
            javaSecondaryTables = this.getJavaEntity().secondaryTables();
        }
        while (secondaryTables.hasNext()) {
            OrmSecondaryTable virtualSecondaryTable = secondaryTables.next();
            if (javaSecondaryTables.hasNext()) {
                JavaSecondaryTable javaSecondaryTable = javaSecondaryTables.next();
                virtualSecondaryTable.update(new VirtualXmlSecondaryTable(javaSecondaryTable));
                continue;
            }
            this.removeVirtualSecondaryTable(virtualSecondaryTable);
        }
        while (javaSecondaryTables.hasNext()) {
            JavaSecondaryTable javaSecondaryTable = (JavaSecondaryTable)javaSecondaryTables.next();
            this.addVirtualSecondaryTable(this.buildVirtualSecondaryTable(javaSecondaryTable));
        }
    }

    protected OrmSecondaryTable buildSecondaryTable(XmlSecondaryTable xmlSecondaryTable) {
        return this.getJpaFactory().buildOrmSecondaryTable(this, xmlSecondaryTable);
    }

    protected OrmSecondaryTable buildVirtualSecondaryTable(JavaSecondaryTable javaSecondaryTable) {
        return this.buildSecondaryTable(new VirtualXmlSecondaryTable(javaSecondaryTable));
    }

    protected void updateTableGenerator() {
        if (((XmlEntity)this.resourceTypeMapping).getTableGenerator() == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(((XmlEntity)this.resourceTypeMapping).getTableGenerator()));
        } else {
            this.getTableGenerator().update(((XmlEntity)this.resourceTypeMapping).getTableGenerator());
        }
    }

    protected void updateSequenceGenerator() {
        if (((XmlEntity)this.resourceTypeMapping).getSequenceGenerator() == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(((XmlEntity)this.resourceTypeMapping).getSequenceGenerator()));
        } else {
            this.getSequenceGenerator().update(((XmlEntity)this.resourceTypeMapping).getSequenceGenerator());
        }
    }

    protected InheritanceType getResourceInheritanceStrategy(Inheritance inheritanceResource) {
        if (inheritanceResource == null) {
            return null;
        }
        return InheritanceType.fromOrmResourceModel(inheritanceResource.getStrategy());
    }

    protected InheritanceType buildDefaultInheritanceStrategy() {
        if (this.getResourceInheritance() == null && !this.isMetadataComplete() && this.getJavaEntity() != null) {
            return this.getJavaEntity().getInheritanceStrategy();
        }
        return this.isRoot() ? InheritanceType.SINGLE_TABLE : this.getRootEntity().getInheritanceStrategy();
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns() {
        CloneIterator xmlPkJoinColumns = new CloneIterator(((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns());
        ListIterator<OrmPrimaryKeyJoinColumn> contextPkJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        while (contextPkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn contextPkJoinColumn = (OrmPrimaryKeyJoinColumn)contextPkJoinColumns.next();
            if (xmlPkJoinColumns.hasNext()) {
                contextPkJoinColumn.update((XmlPrimaryKeyJoinColumn)xmlPkJoinColumns.next());
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(contextPkJoinColumn);
        }
        while (xmlPkJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((XmlPrimaryKeyJoinColumn)xmlPkJoinColumns.next()));
        }
    }

    protected void updateDefaultPrimaryKeyJoinColumns() {
        ListIterator<OrmPrimaryKeyJoinColumn> defaultPkJoinColumns = this.defaultPrimaryKeyJoinColumns();
        ListIterator<JavaPrimaryKeyJoinColumn> javaPkJoinColumns = EmptyListIterator.instance();
        if (this.getJavaEntity() != null && !this.isMetadataComplete() && this.specifiedPrimaryKeyJoinColumnsSize() == 0) {
            javaPkJoinColumns = this.getJavaEntity().primaryKeyJoinColumns();
        }
        while (defaultPkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn defaultPkJoinColumn = defaultPkJoinColumns.next();
            if (javaPkJoinColumns.hasNext()) {
                JavaPrimaryKeyJoinColumn javaPkJoinColumn = javaPkJoinColumns.next();
                defaultPkJoinColumn.update(new VirtualXmlPrimaryKeyJoinColumn(javaPkJoinColumn));
                continue;
            }
            if (this.defaultPrimaryKeyJoinColumnsSize() == 1) {
                defaultPkJoinColumn.update(null);
                continue;
            }
            this.removeDefaultPrimaryKeyJoinColumn(defaultPkJoinColumn);
        }
        while (javaPkJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn javaPkJoinColumn = (JavaPrimaryKeyJoinColumn)javaPkJoinColumns.next();
            this.addDefaultPrimaryKeyJoinColumn(this.buildVirtualPrimaryKeyJoinColumn(javaPkJoinColumn));
        }
        if (this.defaultPrimaryKeyJoinColumnsSize() == 0 && this.specifiedPrimaryKeyJoinColumnsSize() == 0) {
            this.addDefaultPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn(null));
        }
    }

    protected OrmPrimaryKeyJoinColumn buildVirtualPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn javaSecondaryTable) {
        return this.buildPrimaryKeyJoinColumn(new VirtualXmlPrimaryKeyJoinColumn(javaSecondaryTable));
    }

    protected OrmPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn resourcePkJoinColumn) {
        return this.getJpaFactory().buildOrmPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner(), resourcePkJoinColumn);
    }

    protected void updateSpecifiedAttributeOverrides() {
        CloneIterator xmlOverrides = new CloneIterator(((XmlEntity)this.resourceTypeMapping).getAttributeOverrides());
        ListIterator<OrmAttributeOverride> contextOverrides = this.specifiedAttributeOverrides();
        while (contextOverrides.hasNext()) {
            OrmAttributeOverride contextOverride = (OrmAttributeOverride)contextOverrides.next();
            if (xmlOverrides.hasNext()) {
                contextOverride.update((XmlAttributeOverride)xmlOverrides.next());
                continue;
            }
            this.removeSpecifiedAttributeOverride_(contextOverride);
        }
        while (xmlOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.buildAttributeOverride((XmlAttributeOverride)xmlOverrides.next()));
        }
    }

    protected void updateVirtualAttributeOverrides() {
        Iterator<PersistentAttribute> overridableAttributes = this.allOverridableAttributes();
        ListIterator<OrmAttributeOverride> virtualAttributeOverridesCopy = this.virtualAttributeOverrides();
        for (PersistentAttribute persistentAttribute : CollectionTools.iterable(overridableAttributes)) {
            OrmAttributeOverride ormAttributeOverride = this.getAttributeOverrideNamed(persistentAttribute.getName());
            if (ormAttributeOverride != null && !ormAttributeOverride.isVirtual()) continue;
            JavaAttributeOverride javaAttributeOverride = null;
            if (this.getJavaEntity() != null) {
                javaAttributeOverride = this.getJavaEntity().getAttributeOverrideNamed(persistentAttribute.getName());
            }
            if (ormAttributeOverride != null) {
                if (virtualAttributeOverridesCopy.hasNext()) {
                    OrmAttributeOverride virtualAttributeOverride = virtualAttributeOverridesCopy.next();
                    virtualAttributeOverride.update(this.buildVirtualXmlAttributeOverride(persistentAttribute, javaAttributeOverride));
                    continue;
                }
                this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride));
                continue;
            }
            this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride));
        }
        for (OrmAttributeOverride virtualAttributeOverride : CollectionTools.iterable(virtualAttributeOverridesCopy)) {
            this.removeVirtualAttributeOverride(virtualAttributeOverride);
        }
    }

    protected OrmAttributeOverride buildAttributeOverride(XmlAttributeOverride attributeOverride) {
        return this.getJpaFactory().buildOrmAttributeOverride(this, this.createAttributeOverrideOwner(), attributeOverride);
    }

    protected AttributeOverride.Owner createAttributeOverrideOwner() {
        return new AttributeOverrideOwner();
    }

    protected void updateSpecifiedAssociationOverrides() {
        CloneIterator xmlOverrides = new CloneIterator(((XmlEntity)this.resourceTypeMapping).getAssociationOverrides());
        ListIterator<OrmAssociationOverride> contextOverrides = this.specifiedAssociationOverrides();
        while (contextOverrides.hasNext()) {
            OrmAssociationOverride contextOverride = (OrmAssociationOverride)contextOverrides.next();
            if (xmlOverrides.hasNext()) {
                contextOverride.update((XmlAssociationOverride)xmlOverrides.next());
                continue;
            }
            this.removeSpecifiedAssociationOverride_(contextOverride);
        }
        while (xmlOverrides.hasNext()) {
            this.addSpecifiedAssociationOverride(this.buildAssociationOverride((XmlAssociationOverride)xmlOverrides.next()));
        }
    }

    protected OrmAssociationOverride buildAssociationOverride(XmlAssociationOverride associationOverride) {
        return this.getJpaFactory().buildOrmAssociationOverride(this, this.createAssociationOverrideOwner(), associationOverride);
    }

    protected AssociationOverride.Owner createAssociationOverrideOwner() {
        return new AssociationOverrideOwner();
    }

    protected void updateNamedQueries() {
        CloneIterator xmlQueries = new CloneIterator(((XmlEntity)this.resourceTypeMapping).getNamedQueries());
        ListIterator<OrmNamedQuery> contextQueries = this.namedQueries();
        while (contextQueries.hasNext()) {
            OrmNamedQuery contextQuery = (OrmNamedQuery)contextQueries.next();
            if (xmlQueries.hasNext()) {
                contextQuery.update((XmlNamedQuery)xmlQueries.next());
                continue;
            }
            this.removeNamedQuery_(contextQuery);
        }
        while (xmlQueries.hasNext()) {
            this.addNamedQuery(this.buildNamedQuery((XmlNamedQuery)xmlQueries.next()));
        }
    }

    protected OrmNamedQuery buildNamedQuery(XmlNamedQuery resourceNamedQuery) {
        return this.getJpaFactory().buildOrmNamedQuery(this, resourceNamedQuery);
    }

    protected void updateNamedNativeQueries() {
        CloneIterator xmlQueries = new CloneIterator(((XmlEntity)this.resourceTypeMapping).getNamedNativeQueries());
        ListIterator<OrmNamedNativeQuery> contextQueries = this.namedNativeQueries();
        while (contextQueries.hasNext()) {
            OrmNamedNativeQuery contextQuery = (OrmNamedNativeQuery)contextQueries.next();
            if (xmlQueries.hasNext()) {
                contextQuery.update((XmlNamedNativeQuery)xmlQueries.next());
                continue;
            }
            this.removeNamedNativeQuery_(contextQuery);
        }
        while (xmlQueries.hasNext()) {
            this.addNamedNativeQuery(this.buildNamedNativeQuery((XmlNamedNativeQuery)xmlQueries.next()));
        }
    }

    protected OrmNamedNativeQuery buildNamedNativeQuery(XmlNamedNativeQuery resourceNamedNativeQuery) {
        return this.getJpaFactory().buildOrmNamedNativeQuery(this, resourceNamedNativeQuery);
    }

    protected void updateIdClass(XmlIdClass idClassResource) {
        this.setIdClass_(this.getResourceIdClass(idClassResource));
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getPrimaryKeyColumnName(this.getPersistentType().allAttributes());
    }

    public String getPrimaryKeyColumnName(Iterator<PersistentAttribute> attributes) {
        String pkColumnName = null;
        Iterator<PersistentAttribute> stream = attributes;
        while (stream.hasNext()) {
            OrmAttributeOverride attributeOverride;
            PersistentAttribute attribute = stream.next();
            String name = attribute.getPrimaryKeyColumnName();
            if (name != null && (attributeOverride = this.getAttributeOverrideNamed(attribute.getName())) != null) {
                name = attributeOverride.getColumn().getName();
            }
            if (pkColumnName == null) {
                pkColumnName = name;
                continue;
            }
            if (name == null) continue;
            return null;
        }
        return pkColumnName;
    }

    @Override
    public void addToResourceModel(XmlEntityMappings entityMappings) {
        entityMappings.getEntities().add((Object)((XmlEntity)this.resourceTypeMapping));
    }

    @Override
    public void removeFromResourceModel(XmlEntityMappings entityMappings) {
        entityMappings.getEntities().remove((Object)this.resourceTypeMapping);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateTable(messages, reporter);
        this.validateId(messages);
        this.validateInheritance(messages, reporter);
        this.validateGenerators(messages);
        this.validateQueries(messages);
        ListIterator<XmlContextNode> stream = this.secondaryTables();
        while (stream.hasNext()) {
            ((OrmSecondaryTable)stream.next()).validate(messages, reporter);
        }
        stream = this.attributeOverrides();
        while (stream.hasNext()) {
            ((OrmAttributeOverride)stream.next()).validate(messages, reporter);
        }
        stream = this.associationOverrides();
        while (stream.hasNext()) {
            ((OrmAssociationOverride)stream.next()).validate(messages, reporter);
        }
    }

    protected void validateTable(List<IMessage> messages, IReporter reporter) {
        if (this.isAbstractTablePerClass()) {
            if (this.table.isResourceSpecified()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE", new String[]{this.getName()}, this, this.getTable().getValidationTextRange()));
            }
            return;
        }
        if (this.isSingleTableDescendant()) {
            if (this.table.isResourceSpecified()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE", new String[]{this.getName()}, this, this.getTable().getValidationTextRange()));
            }
            return;
        }
        this.table.validate(messages, reporter);
    }

    protected void validateId(List<IMessage> messages) {
        if (this.entityHasNoId()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NO_ID", new String[]{this.getName()}, this, this.getValidationTextRange()));
        }
    }

    protected void validateInheritance(List<IMessage> messages, IReporter reporter) {
        this.validateInheritanceStrategy(messages);
        this.validateDiscriminatorColumn(messages, reporter);
        this.validateDiscriminatorValue(messages);
    }

    protected void validateDiscriminatorColumn(List<IMessage> messages, IReporter reporter) {
        if (this.specifiedDiscriminatorColumnIsAllowed() && !this.discriminatorColumnIsUndefined()) {
            this.getDiscriminatorColumn().validate(messages, reporter);
        } else if (this.getDiscriminatorColumn().isResourceSpecified()) {
            if (!this.isRoot()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange()));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange()));
            }
        }
    }

    protected void validateDiscriminatorValue(List<IMessage> messages) {
        if (this.discriminatorValueIsUndefined() && this.getSpecifiedDiscriminatorValue() != null) {
            if (this.isAbstract()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange()));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange()));
            }
        }
    }

    protected void validateInheritanceStrategy(List<IMessage> messages) {
        JpaValidation.Supported tablePerConcreteClassInheritanceIsSupported = this.getJpaValidation().getTablePerConcreteClassInheritanceIsSupported();
        if (tablePerConcreteClassInheritanceIsSupported == JpaValidation.Supported.YES) {
            return;
        }
        if (this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS && this.isRoot()) {
            if (tablePerConcreteClassInheritanceIsSupported == JpaValidation.Supported.NO) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange()));
            }
        }
    }

    protected TextRange getDiscriminatorValueTextRange() {
        return ((XmlEntity)this.resourceTypeMapping).getDiscriminatorValueTextRange();
    }

    protected TextRange getDiscriminatorColumnTextRange() {
        return ((XmlEntity)this.resourceTypeMapping).getDiscriminatorColumn().getValidationTextRange();
    }

    protected TextRange getInheritanceStrategyTextRange() {
        return ((XmlEntity)this.resourceTypeMapping).getInheritanceStrategyTextRange();
    }

    private boolean entityHasNoId() {
        return !this.entityHasId();
    }

    private boolean entityHasId() {
        Iterator<PersistentAttribute> stream = this.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isIdAttribute()) continue;
            return true;
        }
        return false;
    }

    protected void validateGenerators(List<IMessage> messages) {
        Iterator<OrmGenerator> localGenerators = this.generators();
        while (localGenerators.hasNext()) {
            OrmGenerator localGenerator = localGenerators.next();
            ListIterator<Generator> globalGenerators = this.getPersistenceUnit().generators();
            while (globalGenerators.hasNext()) {
                if (!localGenerator.duplicates((Generator)globalGenerators.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{localGenerator.getName()}, localGenerator, localGenerator.getNameTextRange()));
            }
        }
    }

    protected void validateQueries(List<IMessage> messages) {
        Iterator<OrmQuery> localQueries = this.queries();
        while (localQueries.hasNext()) {
            OrmQuery localQuery = localQueries.next();
            ListIterator<Query> globalQueries = this.getPersistenceUnit().queries();
            while (globalQueries.hasNext()) {
                if (!localQuery.duplicates((Query)globalQueries.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", new String[]{localQuery.getName()}, localQuery, localQuery.getNameTextRange()));
            }
        }
    }

    class AssociationOverrideOwner
    implements AssociationOverride.Owner {
        AssociationOverrideOwner() {
        }

        public RelationshipMapping getRelationshipMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = AbstractOrmEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof RelationshipMapping)) continue;
                return (RelationshipMapping)persAttribute.getMapping();
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return AbstractOrmEntity.this.virtualAssociationOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
            return null;
        }

        public TypeMapping getTypeMapping() {
            return AbstractOrmEntity.this;
        }
    }

    class AttributeOverrideOwner
    implements AttributeOverride.Owner {
        AttributeOverrideOwner() {
        }

        public ColumnMapping getColumnMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = AbstractOrmEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
                return (ColumnMapping)((Object)persAttribute.getMapping());
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return AbstractOrmEntity.this.virtualAttributeOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
            return AbstractOrmEntity.this.setAttributeOverrideVirtual(virtual, (OrmAttributeOverride)override);
        }

        public TypeMapping getTypeMapping() {
            return AbstractOrmEntity.this;
        }
    }

    class PrimaryKeyJoinColumnOwner
    implements OrmBaseJoinColumn.Owner {
        PrimaryKeyJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return AbstractOrmEntity.this;
        }

        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return AbstractOrmEntity.this.getDbTable(tableName);
        }

        public org.eclipse.jpt.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = AbstractOrmEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return AbstractOrmEntity.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return AbstractOrmEntity.this.defaultPrimaryKeyJoinColumns.contains(joinColumn);
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            return AbstractOrmEntity.this.getParentEntity().getPrimaryKeyColumnName();
        }

        public TextRange getValidationTextRange() {
            return null;
        }
    }
}

