/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaNode;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JarFile;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.context.AbstractJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJarFile
extends AbstractJpaContextNode
implements JarFile,
PersistentType.Owner {
    protected JavaResourcePackageFragmentRoot jarResourcePackageFragmentRoot;
    protected final Vector<JavaPersistentType> javaPersistentTypes = new Vector();

    public GenericJarFile(JpaNode parent, JavaResourcePackageFragmentRoot jarResourcePackageFragmentRoot) {
        super(parent);
        this.jarResourcePackageFragmentRoot = jarResourcePackageFragmentRoot;
        CollectionTools.addAll(this.javaPersistentTypes, this.buildJavaPersistentTypes());
    }

    protected Iterator<JavaPersistentType> buildJavaPersistentTypes() {
        return new TransformationIterator<JavaResourcePersistentType, JavaPersistentType>(this.javaResourcePersistentTypes()){

            protected JavaPersistentType transform(JavaResourcePersistentType jrpt) {
                return GenericJarFile.this.buildJavaPersistentType(jrpt);
            }
        };
    }

    protected Iterator<JavaResourcePersistentType> javaResourcePersistentTypes() {
        return this.jarResourcePackageFragmentRoot.persistentTypes();
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourcePersistentType jrpt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrpt);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public IContentType getContentType() {
        return JptCorePlugin.JAR_CONTENT_TYPE;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public JavaPersistentType getPersistentType(String typeName) {
        for (JavaPersistentType pt : this.getJavaPersistentTypes()) {
            if (!pt.getName().equals(typeName)) continue;
            return pt;
        }
        return null;
    }

    @Override
    public Iterator<JavaPersistentType> javaPersistentTypes() {
        return new CloneIterator(this.javaPersistentTypes);
    }

    protected Iterable<JavaPersistentType> getJavaPersistentTypes() {
        return new CloneIterable(this.javaPersistentTypes);
    }

    @Override
    public int javaPersistentTypesSize() {
        return this.javaPersistentTypes.size();
    }

    protected JavaPersistentType addJavaPersistentType(JavaResourcePersistentType jrpt) {
        JavaPersistentType javaPersistentType = this.buildJavaPersistentType(jrpt);
        this.addItemToCollection(javaPersistentType, this.javaPersistentTypes, "javaPersistentTypes");
        return javaPersistentType;
    }

    protected void removeJavaPersistentType(JavaPersistentType javaPersistentType) {
        this.removeItemFromCollection(javaPersistentType, this.javaPersistentTypes, "javaPersistentTypes");
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return null;
    }

    @Override
    public IResource getResource() {
        return this.jarResourcePackageFragmentRoot.getFile();
    }

    @Override
    public void update(JavaResourcePackageFragmentRoot jrpfr) {
        this.jarResourcePackageFragmentRoot = jrpfr;
        this.updateJavaPersistentTypes();
    }

    protected void updateJavaPersistentTypes() {
        HashBag contextTypesToRemove = CollectionTools.bag(this.javaPersistentTypes(), (int)this.javaPersistentTypes.size());
        ArrayList<JavaPersistentType> contextTypesToUpdate = new ArrayList<JavaPersistentType>(this.javaPersistentTypes.size());
        Iterator<JavaResourcePersistentType> resourceTypes = this.javaResourcePersistentTypes();
        while (resourceTypes.hasNext()) {
            JavaResourcePersistentType resourceType = resourceTypes.next();
            boolean match = false;
            Iterator contextTypes = contextTypesToRemove.iterator();
            while (contextTypes.hasNext()) {
                JavaPersistentType contextType = (JavaPersistentType)contextTypes.next();
                if (contextType.getResourcePersistentType() != resourceType) continue;
                contextTypes.remove();
                contextTypesToUpdate.add(contextType);
                match = true;
                break;
            }
            if (match) continue;
            this.addJavaPersistentType(resourceType);
        }
        for (JavaPersistentType contextType : contextTypesToRemove) {
            this.removeJavaPersistentType(contextType);
        }
        for (JavaPersistentType contextType : contextTypesToUpdate) {
            contextType.update();
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
    }
}

