/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.ArrayList;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jpt.db.internal.vendor.AbstractVendor;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.FoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.NonFoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.SimpleCatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.Vendor;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Sybase
extends AbstractVendor {
    private final String dtpVendorName;
    static final Vendor ASA = new Sybase("Sybase_ASA");
    static final Vendor ASE = new Sybase("Sybase_ASE");
    private static final String DEFAULT_SCHEMA_NAME = "dbo";
    private static final char[] EXTENDED_NORMAL_NAME_START_CHARACTERS = new char[]{'_', '@'};
    private static final char[] EXTENDED_NORMAL_NAME_PART_CHARACTERS = new char[]{'$', '\u00a5', '\u00a3', '#'};

    static Vendor asa() {
        return ASA;
    }

    static Vendor ase() {
        return ASE;
    }

    private Sybase(String dtpVendorName) {
        this.dtpVendorName = dtpVendorName;
    }

    @Override
    public String getDTPVendorName() {
        return this.dtpVendorName;
    }

    @Override
    CatalogStrategy getCatalogStrategy() {
        return SimpleCatalogStrategy.instance();
    }

    @Override
    FoldingStrategy getFoldingStrategy() {
        return NonFoldingStrategy.instance();
    }

    @Override
    void addDefaultSchemaIdentifiersTo(Database database, String userName, ArrayList<String> identifiers) {
        identifiers.add(DEFAULT_SCHEMA_NAME);
    }

    @Override
    char[] getExtendedNormalNameStartCharacters() {
        return EXTENDED_NORMAL_NAME_START_CHARACTERS;
    }

    @Override
    char[] getExtendedNormalNamePartCharacters() {
        return EXTENDED_NORMAL_NAME_PART_CHARACTERS;
    }

    @Override
    boolean identifierIsDelimited(String identifier) {
        return StringTools.stringIsBracketed((String)identifier) || super.identifierIsDelimited(identifier);
    }
}

