/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineColumnLoader;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;

public class JDBCUDFColumnLoader
extends JDBCRoutineColumnLoader {
    public JDBCUDFColumnLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCUDFColumnLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        assert (catalogObject instanceof UserDefinedFunction);
    }

    public List loadColumns() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadParameters(retVal, Collections.EMPTY_SET);
        List routineResultTables = this.loadRoutineResultTables();
        if (routineResultTables.size() > 0) {
            retVal.add(routineResultTables.get(0));
        }
        return retVal;
    }

    protected void initParameter(Parameter parameter, ResultSet rs) throws SQLException {
        parameter.setName(rs.getString("COLUMN_NAME"));
        parameter.setDescription(rs.getString("REMARKS"));
        switch (rs.getShort("COLUMN_TYPE")) {
            case 1: {
                parameter.setMode(ParameterMode.IN_LITERAL);
                break;
            }
            case 2: {
                parameter.setMode(ParameterMode.INOUT_LITERAL);
                break;
            }
            case 4: {
                parameter.setMode(ParameterMode.OUT_LITERAL);
                break;
            }
            case 5: {
                parameter.setMode(ParameterMode.OUT_LITERAL);
                break;
            }
            default: {
                parameter.setMode(ParameterMode.IN_LITERAL);
            }
        }
        this.initType((TypedElement)parameter, rs);
    }
}

