/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.views;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Tree;

public class ContextNodeOpenListener
implements IOpenListener,
IDoubleClickListener,
MouseListener {
    private final Viewer viewer;

    public ContextNodeOpenListener(Viewer viewer) {
        this.viewer = viewer;
    }

    public void open(OpenEvent event) {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        Object object = selection.getFirstElement();
        IInteractionElement node = null;
        if (object instanceof IInteractionElement) {
            node = (IInteractionElement)object;
        } else if (!(object instanceof IInteractionRelation)) {
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)object);
            String handle = bridge.getHandleIdentifier(object);
            node = ContextCore.getContextManager().getElement(handle);
        }
        if (node != null) {
            ContextUi.getUiBridge(node.getContentType()).open(node);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.open(null);
    }

    public void mouseDoubleClick(MouseEvent event) {
        this.setSelection(event);
    }

    public void mouseDown(MouseEvent event) {
        this.setSelection(event);
    }

    private void setSelection(MouseEvent event) {
        try {
            Object selection = ((Tree)event.getSource()).getSelection()[0].getData();
            this.viewer.setSelection((ISelection)new StructuredSelection(selection));
            this.open(null);
        }
        catch (Exception exception) {}
    }

    public void mouseUp(MouseEvent e) {
    }
}

