/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.search;

import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemDecoratingLabelProvider;
import org.eclipse.rse.internal.ui.view.SystemTableTreeView;
import org.eclipse.rse.internal.ui.view.SystemTableTreeViewProvider;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class SystemSearchTableView
extends SystemTableTreeView {
    private boolean _firstRefresh = true;
    private IHostSearchResultSet resultSet;

    public SystemSearchTableView(Tree tabletree, IHostSearchResultSet resultSet, ISystemMessageLine msgLine) {
        super(tabletree, msgLine);
        this.resultSet = resultSet;
        this._provider.disableDeferredQueries(true);
        this.setLabelProvider((IBaseLabelProvider)new SystemDecoratingLabelProvider(this._provider, RSEUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
    }

    public IHostSearchResultSet getResultSet() {
        return this.resultSet;
    }

    public void systemRemoteResourceChanged(ISystemRemoteChangeEvent event) {
        int eventType = event.getEventType();
        SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)this.getContentProvider();
        IHostSearchResultSet resultSet = null;
        if (this.getInput() instanceof IHostSearchResultSet) {
            resultSet = (IHostSearchResultSet)this.getInput();
        }
        if (resultSet == null) {
            return;
        }
        switch (eventType) {
            case 2: {
                Object remoteResource = event.getResource();
                Vector<Object> remoteResourceNames = null;
                if (remoteResource instanceof List) {
                    remoteResourceNames = (Vector<Object>)remoteResource;
                    remoteResource = remoteResourceNames.get(0);
                } else {
                    remoteResourceNames = new Vector<Object>();
                    remoteResourceNames.add(remoteResource);
                }
                int d = 0;
                while (d < remoteResourceNames.size()) {
                    Object dchild = remoteResourceNames.get(d);
                    ISystemViewElementAdapter dadapt = this.getViewAdapter(dchild);
                    ISubSystem dSubSystem = dadapt.getSubSystem(dchild);
                    String dkey = dadapt.getAbsoluteName(dchild);
                    Object[] children = provider.getChildren(resultSet);
                    int i = 0;
                    while (i < children.length) {
                        ISystemViewElementAdapter eadapt;
                        ISubSystem eSubSystem;
                        Object existingChild = children[i];
                        if (existingChild != null && dSubSystem == (eSubSystem = (eadapt = this.getViewAdapter(existingChild)).getSubSystem(existingChild))) {
                            String ekey = eadapt.getAbsoluteName(existingChild);
                            boolean matches = false;
                            matches = dSubSystem.getSubSystemConfiguration().isCaseSensitive() ? ekey.equals(dkey) : ekey.equalsIgnoreCase(dkey);
                            if (matches) {
                                resultSet.removeResult(existingChild);
                                provider.setCache(resultSet.getAllResults());
                                this.remove(existingChild);
                            }
                        }
                        ++i;
                    }
                    Widget widget = this.findItem(dchild);
                    if (widget != null) {
                        Object data = widget.getData();
                        this.remove(data);
                    }
                    ++d;
                }
                break;
            }
            case 8: {
                event.getResource();
                return;
            }
            default: {
                super.systemRemoteResourceChanged(event);
            }
        }
    }

    protected void doUpdateItem(Widget widget, Object element, boolean flag) {
        if (this._firstRefresh) {
            this.computeLayout(true);
            this._firstRefresh = false;
        }
        super.doUpdateItem(widget, element, flag);
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        Object actualSource = event.getSource();
        switch (event.getType()) {
            case 82: {
                int deltaSize;
                IHostSearchResultConfiguration config;
                IHostSearchResultSet resultSet;
                if (actualSource == null) {
                    return;
                }
                SystemTableTreeViewProvider provider = (SystemTableTreeViewProvider)this.getContentProvider();
                if (provider == null) {
                    return;
                }
                if (!(actualSource instanceof IHostSearchResultConfiguration) || (resultSet = (config = (IHostSearchResultConfiguration)actualSource).getParentResultSet()) != this.getInput()) break;
                Object[] previousResults = provider.getCachedObjects(resultSet);
                Object[] newResults = resultSet.getAllResults();
                int newSize = newResults.length;
                if ((previousResults == null || previousResults.length == 0) && newResults.length != 0) {
                    provider.flushCache();
                    this.refresh(this.getInput());
                    break;
                }
                if (previousResults == null || (deltaSize = newSize - previousResults.length) <= 0) break;
                Object[] delta = new Object[deltaSize];
                int d = 0;
                int i = 0;
                while (i < newSize) {
                    Object nobj = newResults[i];
                    if (previousResults.length > i) {
                        Object pobj = previousResults[i];
                        if (pobj == null) {
                            delta[d] = nobj;
                            ++d;
                        }
                    } else {
                        delta[d] = nobj;
                        ++d;
                    }
                    ++i;
                }
                provider.setCache(newResults);
                provider.setCachedObjects(resultSet, newResults);
                if (delta.length > 2000) {
                    this.internalRefresh(this.getInput());
                    break;
                }
                this.add(this.getInput(), delta);
                break;
            }
            default: {
                super.systemResourceChanged(event);
            }
        }
    }

    protected Object getParentForContent(Object element) {
        return this.getViewAdapter(element).getParent(element);
    }

    protected void handleKeyPressed(KeyEvent event) {
    }
}

