/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile.internal;

import java.io.File;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;

public class OdaProfileFactory {
    private static final String NAME_SEPARATOR = " ";

    public static IConnectionProfile createProfile(String name, String description, String odaDataSourceId, Properties baseProperties) throws OdaException {
        String uniqueName = OdaProfileFactory.getUniqueProfileName(name);
        try {
            IConnectionProfile newProfile = ProfileManager.getInstance().createProfile(uniqueName, description, odaDataSourceId, baseProperties);
            return new OdaConnectionProfile(newProfile);
        }
        catch (ConnectionProfileException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    public static boolean isProfileNameUsed(String profileName) {
        IConnectionProfile existingProfile = InternalProfileManager.getInstance().getProfileByName(profileName, false);
        return existingProfile != null;
    }

    private static String getUniqueProfileName(String profileName) {
        if (!OdaProfileFactory.isProfileNameUsed(profileName)) {
            return profileName;
        }
        int nameCounter = 1;
        String newName = OdaProfileFactory.formatProfileName(profileName, nameCounter);
        while (OdaProfileFactory.isProfileNameUsed(newName)) {
            newName = OdaProfileFactory.formatProfileName(profileName, ++nameCounter);
        }
        return newName;
    }

    private static String formatProfileName(String profileName, int nameCounter) {
        return String.valueOf(profileName) + NAME_SEPARATOR + nameCounter;
    }

    public static File defaultProfileStoreFile() {
        return ConnectionProfileMgmt.getStorageLocation().append("ServerProfiles.dat").toFile();
    }
}

