/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.editor.ui.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import org.eclipse.datatools.sqltools.editor.ui.internal.core.SQLDevToolsUIConfigRegistry;

public final class SQLDevToolsUIConfigRegistryImpl
implements SQLDevToolsUIConfigRegistry {
    public static final SQLDevToolsUIConfigRegistry INSTANCE = new SQLDevToolsUIConfigRegistryImpl();
    private static SQLDevToolsUIConfiguration DEFAULT_CONFIG = SQLDevToolsUIConfiguration.getDefaultInstance();
    private static ArrayList _listeners = new ArrayList();
    private Boolean _factoriesLoaded = Boolean.FALSE;
    private Map _products = new TreeMap();
    private Map _factoriesById = new TreeMap();
    private Map _factoriesByVendorIdentifier = new TreeMap();
    private Map _factoriesByName = new TreeMap();

    public Collection getProducts() {
        this.init();
        return this._products.keySet();
    }

    public Collection getVersions(String product) {
        this.init();
        Map versions = (Map)this._products.get(product);
        if (versions == null) {
            return new TreeMap().keySet();
        }
        return versions.keySet();
    }

    public Collection getConfigurations() {
        this.init();
        return this._factoriesById.values();
    }

    public SQLDevToolsUIConfiguration getConfiguration(String product, String version) {
        this.init();
        Map versions = (Map)this._products.get(product);
        if (versions == null) {
            return null;
        }
        return (SQLDevToolsUIConfiguration)versions.get(version);
    }

    public SQLDevToolsUIConfiguration getConfigurationById(String id) {
        this.init();
        return (SQLDevToolsUIConfiguration)this._factoriesById.get(id);
    }

    public SQLDevToolsUIConfiguration getConfigurationByVendorIdentifier(DatabaseVendorDefinitionId id) {
        this.init();
        return (SQLDevToolsUIConfiguration)this._factoriesByVendorIdentifier.get(id);
    }

    public SQLDevToolsUIConfiguration getConfigurationByName(String name) {
        this.init();
        return (SQLDevToolsUIConfiguration)this._factoriesByName.get(name);
    }

    private SQLDevToolsUIConfigRegistryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() {
        Boolean bl = this._factoriesLoaded;
        synchronized (bl) {
            if (this._factoriesLoaded.booleanValue()) {
                return;
            }
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.sqltools.editor.core.ui", "dbUIConfigurations");
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getName().equals("dbUIConfiguration")) {
                        String product = configElements[j].getAttribute("product");
                        String version = configElements[j].getAttribute("version");
                        String name = String.valueOf(product) + "_" + version;
                        String id = configElements[j].getAttribute("id");
                        String isDefault = configElements[j].getAttribute("default");
                        if (id == null) {
                            id = name;
                        }
                        String className = configElements[j].getAttribute("configurationClass");
                        try {
                            DatabaseVendorDefinitionId identifier;
                            SQLDevToolsUIConfiguration factory = (SQLDevToolsUIConfiguration)configElements[j].createExecutableExtension("configurationClass");
                            DatabaseVendorDefinitionId dbVendorId = new DatabaseVendorDefinitionId(product, version);
                            factory.setDatabaseVendorDefinitionId(dbVendorId);
                            if (this._products.containsKey(product)) {
                                ((Map)this._products.get(product)).put(version, factory);
                            } else {
                                TreeMap<String, SQLDevToolsUIConfiguration> versions = new TreeMap<String, SQLDevToolsUIConfiguration>();
                                versions.put(version, factory);
                                this._products.put(product, versions);
                            }
                            if (!this._factoriesById.containsKey(id)) {
                                this._factoriesById.put(id, factory);
                            }
                            if (!this._factoriesByVendorIdentifier.containsKey(identifier = new DatabaseVendorDefinitionId(product, version))) {
                                this._factoriesByVendorIdentifier.put(identifier, factory);
                            }
                            if (!this._factoriesByName.containsKey(name)) {
                                this._factoriesByName.put(name, factory);
                            }
                            if ("true".equals(isDefault)) {
                                DEFAULT_CONFIG = factory;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                Status status = new Status(4, "org.eclipse.datatools.sqltools.editor.core", 4, "The error was detected when creating the database recognizer " + className, (Throwable)e);
                                EditorCorePlugin.getDefault().log((IStatus)status);
                            }
                            catch (Exception ee) {
                                ee.printStackTrace();
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            this._factoriesLoaded = Boolean.TRUE;
        }
    }

    public static SQLDevToolsUIConfiguration getDefaultConfiguration() {
        ((SQLDevToolsUIConfigRegistryImpl)INSTANCE).init();
        return DEFAULT_CONFIG;
    }

    public static class DBFactoryVersionComparator
    implements Comparator {
        public int compare(Object left, Object right) {
            SQLDevToolsUIConfiguration f1 = (SQLDevToolsUIConfiguration)left;
            SQLDevToolsUIConfiguration f2 = (SQLDevToolsUIConfiguration)right;
            return new DatabaseVendorDefinitionId.VersionComparator().compare((Object)f1.getDatabaseVendorDefinitionId().getVersion(), (Object)f2.getDatabaseVendorDefinitionId().getVersion());
        }
    }
}

