/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ApiUseReportConverter {
    private static boolean DEBUG = Util.DEBUG;
    private static final String DEFAULT_XSLT = "/references.xsl";
    HashSet reports = null;
    private File htmlRoot = null;
    private File reportsRoot = null;
    private String xmlLocation = null;
    private String htmlLocation = null;
    private File htmlIndex = null;
    public static final int FRAGMENT_PERMISSIBLE = 5;
    static /* synthetic */ Class class$0;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public ApiUseReportConverter(String htmlroot, String xmlroot) {
        this.xmlLocation = xmlroot;
        this.htmlLocation = htmlroot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convert(String xslt, IProgressMonitor monitor) throws Exception {
        if (this.htmlLocation == null) {
            return;
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.ApiUseReportConverter_preparing_report_metadata, (int)8);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = null;
            try {
                parser = factory.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            if (parser == null) {
                throw new Exception(SearchMessages.could_not_create_sax_parser);
            }
            localmonitor.setTaskName(SearchMessages.ApiUseReportConverter_preparing_html_root);
            if (localmonitor.isCanceled()) {
                return;
            }
            localmonitor.worked(1);
            this.htmlRoot = new File(this.htmlLocation);
            if (!this.htmlRoot.exists()) {
                if (!this.htmlRoot.mkdirs()) {
                    throw new Exception(SearchMessages.bind((String)SearchMessages.could_not_create_file, (Object)this.htmlLocation));
                }
            } else {
                this.htmlRoot.mkdirs();
            }
            localmonitor.setTaskName(SearchMessages.ApiUseReportConverter_preparing_xml_root);
            if (localmonitor.isCanceled()) {
                return;
            }
            localmonitor.worked(1);
            if (this.xmlLocation == null) {
                throw new Exception(SearchMessages.missing_xml_files_location);
            }
            this.reportsRoot = new File(this.xmlLocation);
            if (!this.reportsRoot.exists()) throw new Exception(SearchMessages.bind((String)SearchMessages.invalid_directory_name, (Object)this.xmlLocation));
            if (!this.reportsRoot.isDirectory()) {
                throw new Exception(SearchMessages.bind((String)SearchMessages.invalid_directory_name, (Object)this.xmlLocation));
            }
            localmonitor.setTaskName(SearchMessages.ApiUseReportConverter_preparing_xslt_file);
            if (localmonitor.isCanceled()) {
                return;
            }
            localmonitor.worked(1);
            File xsltFile = null;
            if (xslt != null) {
                xsltFile = new File(xslt);
                if (!xsltFile.exists()) throw new Exception(SearchMessages.ApiUseReportConverter_xslt_file_not_valid);
                if (!xsltFile.isFile()) {
                    throw new Exception(SearchMessages.ApiUseReportConverter_xslt_file_not_valid);
                }
            }
            long start = 0L;
            if (DEBUG) {
                System.out.println("Preparing to write indexes...");
                start = System.currentTimeMillis();
            }
            localmonitor.setTaskName(SearchMessages.ApiUseReportConverter_collecting_dir_info);
            if (localmonitor.isCanceled()) {
                return;
            }
            localmonitor.worked(1);
            File[] referees = this.getDirectories(this.reportsRoot);
            this.reports = new HashSet(referees.length + 1);
            Report report = null;
            File[] origins = null;
            File[] xmlfiles = null;
            UseDefaultHandler handler = null;
            CountGroup counts = null;
            SubMonitor smonitor = localmonitor.newChild(1);
            smonitor.setWorkRemaining(referees.length);
            try {
                int i = 0;
                while (i < referees.length) {
                    report = new Report();
                    report.referee = referees[i];
                    smonitor.setTaskName(SearchMessages.bind((String)SearchMessages.ApiUseReportConverter_preparing_report_info_for, (Object[])new String[]{referees[i].getName()}));
                    origins = this.getDirectories(referees[i]);
                    int j = 0;
                    while (j < origins.length) {
                        xmlfiles = Util.getAllFiles(origins[j], new FileFilter(){

                            public boolean accept(File pathname) {
                                return pathname.isDirectory() || pathname.getName().endsWith(".xml");
                            }
                        });
                        if (xmlfiles != null) {
                            report.origintorefslist.put(origins[j], xmlfiles);
                        }
                        counts = new CountGroup();
                        report.origintocountgroup.put(origins[j], counts);
                        if (xmlfiles != null) {
                            int k = 0;
                            while (k < xmlfiles.length) {
                                try {
                                    handler = new UseDefaultHandler(report, this.getTypeFromFileName(xmlfiles[k]), counts);
                                    parser.parse(xmlfiles[k], (DefaultHandler)handler);
                                }
                                catch (SAXException sAXException) {
                                }
                                catch (IOException iOException) {}
                                ++k;
                            }
                        }
                        ++j;
                    }
                    this.reports.add(report);
                    if (smonitor.isCanceled()) {
                        return;
                    }
                    smonitor.worked(1);
                    ++i;
                }
            }
            finally {
                if (!smonitor.isCanceled()) {
                    smonitor.done();
                }
            }
            ArrayList sortedreports = new ArrayList(this.reports);
            Collections.sort(sortedreports, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof Report && o2 instanceof Report) {
                        return ((Report)o1).referee.getName().compareTo(((Report)o2).referee.getName());
                    }
                    return 0;
                }
            });
            if (DEBUG) {
                System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
                System.out.println("Writing not searched index...");
                start = System.currentTimeMillis();
            }
            localmonitor.setTaskName(SearchMessages.ApiUseReportConverter_writing_not_searched);
            this.writeNotSearched(this.htmlRoot);
            if (localmonitor.isCanceled()) {
                return;
            }
            localmonitor.worked(1);
            if (DEBUG) {
                System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
                System.out.println("Writing root index.html...");
                start = System.currentTimeMillis();
            }
            localmonitor.setTaskName(SearchMessages.ApiUseReportConverter_writing_root_index);
            this.writeIndexFile(sortedreports, this.htmlRoot);
            if (localmonitor.isCanceled()) {
                return;
            }
            localmonitor.worked(1);
            if (DEBUG) {
                System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
            }
            TreeMap originstorefs = null;
            smonitor = localmonitor.newChild(1);
            smonitor.setWorkRemaining(sortedreports.size());
            try {
                Iterator iter = sortedreports.iterator();
                while (iter.hasNext()) {
                    report = (Report)iter.next();
                    localmonitor.setTaskName(SearchMessages.bind((String)SearchMessages.ApiUseReportConverter_writing_group_reports_for, (Object[])new String[]{report.referee.getName()}));
                    if (DEBUG) {
                        start = System.currentTimeMillis();
                        System.out.println("Writing report for " + report.referee.getName() + "...");
                    }
                    this.writeRefereeIndex(report);
                    originstorefs = report.origintorefslist;
                    Iterator iter2 = originstorefs.entrySet().iterator();
                    while (iter2.hasNext()) {
                        Map.Entry entry = iter2.next();
                        File origin = (File)entry.getKey();
                        this.writeOriginEntry(report, xmlfiles, origin, (CountGroup)report.origintocountgroup.get(origin));
                        xmlfiles = (File[])entry.getValue();
                        this.tranformXml(xmlfiles, xsltFile);
                    }
                    if (DEBUG) {
                        System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
                    }
                    if (smonitor.isCanceled()) {
                        return;
                    }
                    smonitor.worked(1);
                }
                return;
            }
            finally {
                if (!smonitor.isCanceled()) {
                    smonitor.done();
                }
            }
        }
        finally {
            if (localmonitor != null) {
                localmonitor.done();
            }
        }
    }

    public File getReportIndex() {
        return this.htmlIndex;
    }

    private void applyXSLT(File xsltFile, File xmlfile, File htmloutput) throws TransformerException, Exception {
        StreamSource xml = new StreamSource(xmlfile);
        StreamSource xslt = null;
        if (xsltFile != null) {
            xslt = new StreamSource(xsltFile);
        } else {
            InputStream defaultXsltInputStream;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.api.tools.internal.search.ApiUseReportConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((defaultXsltInputStream = clazz.getResourceAsStream(DEFAULT_XSLT)) != null) {
                xslt = new StreamSource(new BufferedInputStream(defaultXsltInputStream));
            }
        }
        if (xslt == null) {
            throw new Exception(SearchMessages.ApiUseReportConverter_no_xstl_specified);
        }
        StreamResult html = new StreamResult(htmloutput);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer former = factory.newTransformer(xslt);
        former.transform(xml, html);
    }

    private void tranformXml(File[] xmlfiles, File xsltFile) {
        File html = null;
        int i = 0;
        while (i < xmlfiles.length) {
            try {
                File htmlroot = new File(this.htmlLocation, this.getHTMLFileLocation(this.reportsRoot, xmlfiles[i]));
                if (!htmlroot.exists()) {
                    htmlroot.mkdirs();
                }
                html = new File(this.getNameFromXMLFilename(xmlfiles[i]));
                this.applyXSLT(xsltFile, xmlfiles[i], html);
            }
            catch (TransformerException transformerException) {
            }
            catch (Exception e) {
                ApiPlugin.log(e);
            }
            ++i;
        }
    }

    private String getHTMLFileLocation(File reportroot, File xmlfile) {
        Path report;
        Path xml = new Path(xmlfile.getPath());
        int segments = xml.matchingFirstSegments((IPath)(report = new Path(reportroot.getPath())));
        if (segments > 0) {
            if (xml.getDevice() != null) {
                xml = xml.setDevice(null);
            }
            IPath html = xml.removeFirstSegments(segments);
            return html.removeLastSegments(1).toOSString();
        }
        return null;
    }

    private String getNameFromXMLFilename(File xmlFile) {
        String fileName = xmlFile.getAbsolutePath();
        int index = fileName.lastIndexOf(46);
        StringBuffer buffer = new StringBuffer();
        buffer.append(fileName.substring(this.reportsRoot.getAbsolutePath().length(), index)).append(".html");
        File htmlFile = new File(this.htmlLocation, String.valueOf(buffer));
        return htmlFile.getAbsolutePath();
    }

    private void writeNotSearched(File htmlroot) throws Exception {
        PrintWriter writer = null;
        File originhtml = null;
        try {
            try {
                String filename = "not_searched";
                originhtml = new File(htmlroot, String.valueOf(filename) + ".html");
                if (!originhtml.exists()) {
                    originhtml.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(originhtml);
                writer = new PrintWriter(new BufferedWriter(fileWriter));
                File xml = new File(this.reportsRoot, String.valueOf(filename) + ".xml");
                writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_bundle_list_header, (Object[])new String[]{SearchMessages.ApiUseReportConverter_that_were_not_searched}));
                if (!xml.exists()) {
                    writer.println(SearchMessages.ApiUseReportConverter_no_bundles);
                } else {
                    writer.println(SearchMessages.ApiUseReportConverter_bundle_list_table_header);
                    this.writeComponentList(writer, xml);
                    this.writeTableEnd(writer);
                }
                this.writeBackToBundleIndex(writer, "./index");
                this.writeW3Footer(writer);
            }
            catch (IOException iOException) {
                throw new Exception(SearchMessages.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
            }
            catch (CoreException coreException) {
                throw new Exception(SearchMessages.bind((String)SearchMessages.ApiUseReportConverter_coreexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void writeBackToBundleIndex(PrintWriter writer, String indexname) {
        writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_back_to_bundle_index, (Object[])new String[]{String.valueOf(indexname) + ".html"}));
    }

    private void writeW3Footer(PrintWriter writer) {
        writer.println(SearchMessages.W3C_page_footer);
    }

    private void writeTableEnd(PrintWriter writer) {
        writer.println(SearchMessages.ApiUseReportConverter_table_end);
    }

    private void writeComponentList(PrintWriter writer, File xml) throws CoreException {
        Element root = Util.parseDocument(Util.getFileContentAsString(xml));
        NodeList components = root.getElementsByTagName("component");
        Element component = null;
        String id = null;
        String nodesc = null;
        String excluded = null;
        String resolveerrors = null;
        int i = 0;
        while (i < components.getLength()) {
            component = (Element)components.item(i);
            id = component.getAttribute("id");
            nodesc = component.getAttribute("no_description");
            excluded = component.getAttribute("excluded");
            resolveerrors = component.getAttribute("resolution_errors");
            if (!"".equals(id)) {
                writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_not_searched_component_list, (Object[])new String[]{id, nodesc, excluded, resolveerrors}));
            }
            ++i;
        }
    }

    private void writeRefereeIndex(Report report) throws Exception {
        PrintWriter writer = null;
        File originhtml = null;
        try {
            try {
                File htmlroot = new File(this.htmlLocation, this.getHTMLFileLocation(this.reportsRoot, report.referee));
                if (!htmlroot.exists()) {
                    htmlroot.mkdirs();
                }
                String refereetext = report.referee.getName();
                File root = new File(htmlroot, report.referee.getName());
                if (!root.exists()) {
                    root.mkdir();
                }
                if (!(originhtml = new File(root, String.valueOf(refereetext) + ".html")).exists()) {
                    originhtml.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(originhtml);
                writer = new PrintWriter(new BufferedWriter(fileWriter));
                writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_referee_index_header, (Object[])new String[]{report.referee.getName()}));
                this.writeRefereeIndexEntries(writer, report);
                this.writeTableEnd(writer);
                this.writeBackToBundleIndex(writer, "../index");
                this.writeW3Footer(writer);
            }
            catch (IOException iOException) {
                throw new Exception(SearchMessages.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void writeRefereeIndexEntries(PrintWriter writer, Report report) {
        TreeMap map = report.origintocountgroup;
        File origin = null;
        CountGroup counts = null;
        String link = null;
        File summary = null;
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            origin = (File)entry.getKey();
            counts = (CountGroup)entry.getValue();
            summary = new File(origin, String.valueOf(origin.getName()) + ".html");
            link = this.extractLinkFrom(report.referee, summary.getAbsolutePath());
            writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_referee_index_entry, (Object[])new String[]{link, origin.getName(), Integer.toString(counts.getTotalApiRefCount()), Integer.toString(counts.getTotalInternalRefCount()), Integer.toString(counts.getTotalPermissableRefCount()), Integer.toString(counts.getTotalFragmentPermissibleRefCount()), Integer.toString(counts.getTotalOtherRefCount())}));
        }
    }

    private String extractLinkFrom(File root, String fileName) {
        StringBuffer buffer = new StringBuffer();
        String substring = fileName.substring(root.getAbsolutePath().length()).replace('\\', '/');
        buffer.append('.');
        if (substring.charAt(0) != '/') {
            buffer.append('/');
        }
        buffer.append(substring);
        return String.valueOf(buffer);
    }

    private void writeOriginSummaryEntry(PrintWriter writer, File origin, String vis, int vismodifier, int typecount, int methodcount, int fieldcount) {
        writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_origin_summary_table_entry, (Object[])new String[]{vis, this.getOriginSummaryCountLink(vismodifier, "type", origin, typecount), this.getOriginSummaryCountLink(vismodifier, "method", origin, methodcount), this.getOriginSummaryCountLink(vismodifier, "field", origin, fieldcount)}));
    }

    private String getOriginSummaryCountLink(int vis, String type, File origin, int count) {
        if (count == 0) {
            return Integer.toString(count);
        }
        String vname = VisibilityModifiers.getVisibilityName(vis);
        File linked = new File(origin, String.valueOf(vname) + File.separator + type + "_references.html");
        String link = this.extractLinkFrom(origin, linked.getAbsolutePath());
        return MessageFormat.format((String)SearchMessages.ApiUseReportConverter_origin_summary_count_link, (Object[])new String[]{link, Integer.toString(count)});
    }

    private void writeIndexFile(List sortedreports, File reportsRoot) throws Exception {
        PrintWriter writer = null;
        try {
            try {
                this.htmlIndex = new File(this.htmlLocation, "index.html");
                if (!this.htmlIndex.exists()) {
                    this.htmlIndex.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(this.htmlIndex);
                writer = new PrintWriter(new BufferedWriter(fileWriter));
                writer.println(SearchMessages.ApiUseReportConverter_search_html_index_file_header);
                Report report = null;
                Iterator iter = sortedreports.iterator();
                while (iter.hasNext()) {
                    report = (Report)iter.next();
                    if (report == null) continue;
                    this.writeIndexEntry(writer, report);
                }
                this.writeTableEnd(writer);
                this.writeW3Footer(writer);
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(SearchMessages.bind((String)SearchMessages.ioexception_writing_html_file, (Object)this.htmlIndex.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void writeIndexEntry(PrintWriter writer, Report report) throws IOException {
        File refereehtml = new File(report.referee, String.valueOf(report.referee.getName()) + ".html");
        String link = this.extractLinkFrom(this.reportsRoot, refereehtml.getAbsolutePath());
        writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_referee_index_entry, (Object[])new String[]{link, report.referee.getName(), Integer.toString(report.counts.getTotalApiRefCount()), Integer.toString(report.counts.getTotalInternalRefCount()), Integer.toString(report.counts.getTotalPermissableRefCount()), Integer.toString(report.counts.getTotalFragmentPermissibleRefCount()), Integer.toString(report.counts.getTotalOtherRefCount())}));
    }

    private void writeOriginEntry(Report report, File[] xmlfiles, File origin, CountGroup counts) throws Exception {
        PrintWriter writer = null;
        File originhtml = null;
        try {
            try {
                File htmlroot = new File(this.htmlLocation, this.getHTMLFileLocation(this.reportsRoot, origin));
                if (!htmlroot.exists()) {
                    htmlroot.mkdirs();
                }
                String origintext = origin.getName();
                File root = new File(htmlroot, origin.getName());
                if (!root.exists()) {
                    root.mkdir();
                }
                if (!(originhtml = new File(root, String.valueOf(origintext) + ".html")).exists()) {
                    originhtml.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(originhtml);
                writer = new PrintWriter(new BufferedWriter(fileWriter));
                writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_origin_html_header, (Object[])new String[]{origin.getName(), report.referee.getName()}));
                this.writeOriginSummary(writer, report, origin, counts);
                this.writeBackToBundleIndex(writer, "../" + report.referee.getName());
                this.writeW3Footer(writer);
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(SearchMessages.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void writeOriginSummary(PrintWriter writer, Report report, File origin, CountGroup counts) {
        writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_origin_summary_header, (Object[])new String[]{origin.getName(), Integer.toString(counts.getTotalRefCount()), report.referee.getName()}));
        writer.println(MessageFormat.format((String)SearchMessages.ApiUseReportConverter_origin_summary_table_entry_bold, (Object[])new String[]{SearchMessages.ApiUseReportConverter_visibility, SearchMessages.ApiUseReportConverter_type, SearchMessages.ApiUseReportConverter_method, SearchMessages.ApiUseReportConverter_field}));
        this.writeOriginSummaryEntry(writer, origin, SearchMessages.ApiUseReportConverter_api, 1, counts.total_api_type_count, counts.total_api_method_count, counts.total_api_field_count);
        this.writeOriginSummaryEntry(writer, origin, SearchMessages.ApiUseReportConverter_internal, 2, counts.total_private_type_count, counts.total_private_method_count, counts.total_private_field_count);
        this.writeOriginSummaryEntry(writer, origin, SearchMessages.ApiUseReportConverter_internal_permissable, 8, counts.total_permissable_type_count, counts.total_permissable_method_count, counts.total_permissable_field_count);
        this.writeOriginSummaryEntry(writer, origin, SearchMessages.ApiUseReportConverter_fragment_permissible, 5, counts.total_fragment_permissible_type_count, counts.total_fragment_permissible_method_count, counts.total_fragment_permissible_field_count);
        this.writeOriginSummaryEntry(writer, origin, SearchMessages.ApiUseReportConverter_other, 65535, counts.total_other_type_count, counts.total_other_method_count, counts.total_other_field_count);
        this.writeTableEnd(writer);
    }

    private int getTypeFromFileName(File xmlfile) {
        if (xmlfile.getName().indexOf("type_references") > -1) {
            return 1;
        }
        if (xmlfile.getName().indexOf("method_references") > -1) {
            return 3;
        }
        return 2;
    }

    private File[] getDirectories(File file) {
        File[] directories = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.isHidden();
            }
        });
        return directories;
    }

    static final class CountGroup {
        private int total_api_field_count = 0;
        private int total_private_field_count = 0;
        private int total_permissable_field_count = 0;
        private int total_fragment_permissible_field_count = 0;
        private int total_other_field_count = 0;
        private int total_api_method_count = 0;
        private int total_private_method_count = 0;
        private int total_permissable_method_count = 0;
        private int total_fragment_permissible_method_count = 0;
        private int total_other_method_count = 0;
        private int total_api_type_count = 0;
        private int total_private_type_count = 0;
        private int total_permissable_type_count = 0;
        private int total_fragment_permissible_type_count = 0;
        private int total_other_type_count = 0;

        CountGroup() {
        }

        public int getTotalRefCount() {
            return this.total_api_field_count + this.total_api_method_count + this.total_api_type_count + this.total_other_field_count + this.total_other_method_count + this.total_other_type_count + this.total_private_field_count + this.total_private_method_count + this.total_private_type_count + this.total_permissable_field_count + this.total_permissable_method_count + this.total_permissable_type_count + this.total_fragment_permissible_field_count + this.total_fragment_permissible_method_count + this.total_fragment_permissible_type_count;
        }

        public int getTotalApiRefCount() {
            return this.total_api_field_count + this.total_api_method_count + this.total_api_type_count;
        }

        public int getTotalInternalRefCount() {
            return this.total_private_field_count + this.total_private_method_count + this.total_private_type_count;
        }

        public int getTotalOtherRefCount() {
            return this.total_other_field_count + this.total_other_method_count + this.total_other_type_count;
        }

        public int getTotalPermissableRefCount() {
            return this.total_permissable_field_count + this.total_permissable_method_count + this.total_permissable_type_count;
        }

        public int getTotalFragmentPermissibleRefCount() {
            return this.total_fragment_permissible_field_count + this.total_fragment_permissible_method_count + this.total_fragment_permissible_type_count;
        }
    }

    private static final class Report {
        private File referee = null;
        private TreeMap origintorefslist = new TreeMap(Util.filesorter);
        private TreeMap origintocountgroup = new TreeMap(Util.filesorter);
        private CountGroup counts = new CountGroup();

        private Report() {
        }
    }

    static final class UseDefaultHandler
    extends DefaultHandler {
        private Report lreport = null;
        private int type = 0;
        private CountGroup counts = null;

        public UseDefaultHandler(Report report, int type, CountGroup counts) {
            this.lreport = report;
            this.type = type;
            this.counts = counts;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("references".equals(name)) {
                String vis = attributes.getValue("reference_visibility");
                String value = attributes.getValue("reference_count");
                int count = Integer.parseInt(value);
                block0 : switch (Integer.parseInt(vis)) {
                    case 1: {
                        switch (this.type) {
                            case 1: {
                                this.counts.total_api_type_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_api_type_count = countGroup.total_api_type_count + count;
                                break;
                            }
                            case 3: {
                                this.counts.total_api_method_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_api_method_count = countGroup.total_api_method_count + count;
                                break;
                            }
                            case 2: {
                                this.counts.total_api_field_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_api_field_count = countGroup.total_api_field_count + count;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (this.type) {
                            case 1: {
                                this.counts.total_private_type_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_private_type_count = countGroup.total_private_type_count + count;
                                break;
                            }
                            case 3: {
                                this.counts.total_private_method_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_private_method_count = countGroup.total_private_method_count + count;
                                break;
                            }
                            case 2: {
                                this.counts.total_private_field_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_private_field_count = countGroup.total_private_field_count + count;
                            }
                        }
                        break;
                    }
                    case 8: {
                        switch (this.type) {
                            case 1: {
                                this.counts.total_permissable_type_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_permissable_type_count = countGroup.total_permissable_type_count + count;
                                break;
                            }
                            case 3: {
                                this.counts.total_permissable_method_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_permissable_method_count = countGroup.total_permissable_method_count + count;
                                break;
                            }
                            case 2: {
                                this.counts.total_permissable_field_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_permissable_field_count = countGroup.total_permissable_field_count + count;
                            }
                        }
                        break;
                    }
                    case 65535: {
                        switch (this.type) {
                            case 1: {
                                this.counts.total_other_type_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_other_type_count = countGroup.total_other_type_count + count;
                                break;
                            }
                            case 3: {
                                this.counts.total_other_method_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_other_method_count = countGroup.total_other_method_count + count;
                                break;
                            }
                            case 2: {
                                this.counts.total_other_field_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_other_field_count = countGroup.total_other_field_count + count;
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (this.type) {
                            case 1: {
                                this.counts.total_fragment_permissible_type_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_fragment_permissible_type_count = countGroup.total_fragment_permissible_type_count + count;
                                break block0;
                            }
                            case 3: {
                                this.counts.total_fragment_permissible_method_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_fragment_permissible_method_count = countGroup.total_fragment_permissible_method_count + count;
                                break block0;
                            }
                            case 2: {
                                this.counts.total_fragment_permissible_field_count = count;
                                CountGroup countGroup = this.lreport.counts;
                                countGroup.total_fragment_permissible_field_count = countGroup.total_fragment_permissible_field_count + count;
                            }
                        }
                    }
                }
            }
        }
    }
}

