/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.api.tools.internal.ProjectApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiAccess;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;

public class CompositeApiDescription
implements IApiDescription {
    private IApiDescription[] fDescriptions;

    public CompositeApiDescription(IApiDescription[] descriptions) {
        this.fDescriptions = descriptions;
    }

    public void accept(ApiDescriptionVisitor visitor) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            this.fDescriptions[i].accept(visitor);
            ++i;
        }
    }

    public IApiAnnotations resolveAnnotations(IElementDescriptor element) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            IApiAnnotations ann = this.fDescriptions[i].resolveAnnotations(element);
            if (ann != null) {
                return ann;
            }
            ++i;
        }
        return null;
    }

    public IStatus setRestrictions(IElementDescriptor element, int restrictions) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            IStatus status = this.fDescriptions[i].setRestrictions(element, restrictions);
            if (status.isOK() || i == this.fDescriptions.length - 1) {
                return status;
            }
            ++i;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus setAddedProfile(IElementDescriptor element, int addedProfile) {
        return Status.OK_STATUS;
    }

    public IStatus setRemovedProfile(IElementDescriptor element, int removedProfile) {
        return Status.OK_STATUS;
    }

    public IStatus setSuperclass(IElementDescriptor element, String superclass) {
        return Status.OK_STATUS;
    }

    public IStatus setSuperinterfaces(IElementDescriptor element, String superinterfaces) {
        return Status.OK_STATUS;
    }

    public IStatus setInterface(IElementDescriptor element, boolean interfaceFlag) {
        return Status.OK_STATUS;
    }

    public IStatus setVisibility(IElementDescriptor element, int visibility) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            IStatus status = this.fDescriptions[i].setVisibility(element, visibility);
            if (status.isOK() || i == this.fDescriptions.length - 1) {
                return status;
            }
            ++i;
        }
        return Status.CANCEL_STATUS;
    }

    public void disconnect(BundleDescription bundle) {
        int i = 0;
        while (i < this.fDescriptions.length) {
            ProjectApiDescription pad;
            IApiDescription description = this.fDescriptions[i];
            if (description instanceof ProjectApiDescription && bundle.equals((pad = (ProjectApiDescription)description).getConnection())) {
                pad.disconnect(bundle);
                return;
            }
            ++i;
        }
    }

    public void setAccessLevel(IElementDescriptor element, IPackageDescriptor pelement, int access) {
    }

    public IApiAccess resolveAccessLevel(IElementDescriptor element, IPackageDescriptor pelement) {
        IApiAccess access = null;
        int i = 0;
        while (i < this.fDescriptions.length) {
            access = this.fDescriptions[i].resolveAccessLevel(element, pelement);
            if (access != null) {
                return access;
            }
            ++i;
        }
        return null;
    }
}

