/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.connector;

import com.google.common.io.Closer;
import io.takari.aether.client.AetherClient;
import io.takari.aether.client.AetherClientAuthentication;
import io.takari.aether.client.AetherClientConfig;
import io.takari.aether.client.AetherClientProxy;
import io.takari.aether.client.Response;
import io.takari.aether.client.RetryableSource;
import io.takari.aether.connector.AuthorizationException;
import io.takari.aether.connector.ResourceDoesNotExistException;
import io.takari.aether.connector.TransferException;
import io.takari.aether.okhttp.OkHttpAetherClient;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocketFactory;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactTransfer;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataTransfer;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.Transfer;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AetherRepositoryConnector
implements RepositoryConnector {
    private static final Map<String, String> checksumAlgos;
    private final Logger logger = LoggerFactory.getLogger(AetherRepositoryConnector.class);
    private final RepositoryLayout layout;
    private final RepositorySystemSession session;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final AetherClient aetherClient;
    private static final ExceptionWrapper<MetadataTransfer> METADATA;
    private static final ExceptionWrapper<ArtifactTransfer> ARTIFACT;

    static {
        LinkedHashMap<String, String> _checksumAlgos = new LinkedHashMap<String, String>();
        _checksumAlgos.put("SHA-1", ".sha1");
        _checksumAlgos.put("MD5", ".md5");
        checksumAlgos = Collections.unmodifiableMap(_checksumAlgos);
        METADATA = new ExceptionWrapper<MetadataTransfer>(){

            @Override
            public void wrap(MetadataTransfer transfer, Exception e, RemoteRepository repository) {
                MetadataNotFoundException ex = null;
                if (e instanceof ResourceDoesNotExistException) {
                    ex = new MetadataNotFoundException(transfer.getMetadata(), repository);
                } else if (e != null) {
                    ex = new MetadataTransferException(transfer.getMetadata(), repository, (Throwable)e);
                }
                transfer.setException(ex);
            }
        };
        ARTIFACT = new ExceptionWrapper<ArtifactTransfer>(){

            @Override
            public void wrap(ArtifactTransfer transfer, Exception e, RemoteRepository repository) {
                ArtifactNotFoundException ex = null;
                if (e instanceof ResourceDoesNotExistException) {
                    ex = new ArtifactNotFoundException(transfer.getArtifact(), repository);
                } else if (e != null) {
                    ex = new ArtifactTransferException(transfer.getArtifact(), repository, (Throwable)e);
                }
                transfer.setException(ex);
            }
        };
    }

    public AetherRepositoryConnector(RemoteRepository repository, RepositorySystemSession session, FileProcessor fileProcessor) throws NoRepositoryConnectorException {
        this(repository, session, fileProcessor, null);
    }

    public AetherRepositoryConnector(RemoteRepository repository, RepositorySystemSession session, FileProcessor fileProcessor, SSLSocketFactory sslSocketFactory) throws NoRepositoryConnectorException {
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryConnectorException(repository);
        }
        if (!repository.getProtocol().regionMatches(true, 0, "http", 0, "http".length())) {
            throw new NoRepositoryConnectorException(repository);
        }
        this.repository = repository;
        this.fileProcessor = fileProcessor;
        this.session = session;
        try {
            this.layout = new Maven2RepositoryLayoutFactory().newInstance(session, repository);
        }
        catch (NoRepositoryLayoutException e) {
            throw new NoRepositoryConnectorException(repository, (Throwable)e);
        }
        this.aetherClient = AetherRepositoryConnector.newAetherClient(repository, session, sslSocketFactory);
    }

    private static OkHttpAetherClient newAetherClient(RemoteRepository repository, RepositorySystemSession session, SSLSocketFactory sslSocketFactory) {
        AuthenticationContext repoAuthenticationContext;
        PlexusConfiguration[] properties;
        PlexusConfiguration httpHeaders;
        PlexusConfiguration wagonConfig;
        AetherClientConfig config = new AetherClientConfig();
        HashMap<String, String> commonHeaders = new HashMap<String, String>();
        Map headers = ConfigUtils.getMap((RepositorySystemSession)session, null, (String[])new String[]{"aether.connector.http.headers." + repository.getId(), "aether.connector.http.headers"});
        if (headers != null) {
            commonHeaders.putAll(headers);
        }
        if ((wagonConfig = (PlexusConfiguration)ConfigUtils.getObject((RepositorySystemSession)session, null, (String[])new String[]{"aether.connector.wagon.config." + repository.getId()})) != null && (httpHeaders = wagonConfig.getChild("httpHeaders")) != null && (properties = httpHeaders.getChildren("property")) != null) {
            PlexusConfiguration[] plexusConfigurationArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                PlexusConfiguration property = plexusConfigurationArray[n2];
                commonHeaders.put(property.getChild("name").getValue(), property.getChild("value").getValue());
                ++n2;
            }
        }
        config.setHeaders(commonHeaders);
        config.setUserAgent(ConfigUtils.getString((RepositorySystemSession)session, (String)"Aether", (String[])new String[]{"aether.connector.userAgent"}));
        if (repository.getProxy() != null) {
            AetherClientProxy proxy = new AetherClientProxy();
            proxy.setHost(repository.getProxy().getHost());
            proxy.setPort(repository.getProxy().getPort());
            AuthenticationContext proxyAuthenticationContext = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repository);
            if (proxyAuthenticationContext != null) {
                try {
                    String username = proxyAuthenticationContext.get("username");
                    String password = proxyAuthenticationContext.get("password");
                    proxy.setAuthentication(new AetherClientAuthentication(username, password));
                }
                finally {
                    AuthenticationContext.close((AuthenticationContext)proxyAuthenticationContext);
                }
            }
            config.setProxy(proxy);
        }
        if ((repoAuthenticationContext = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repository)) != null) {
            try {
                String username = repoAuthenticationContext.get("username");
                String password = repoAuthenticationContext.get("password");
                AetherClientAuthentication authentication = new AetherClientAuthentication(username, password);
                config.setAuthentication(authentication);
            }
            finally {
                AuthenticationContext.close((AuthenticationContext)repoAuthenticationContext);
            }
        }
        int connectTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)10000, (String[])new String[]{"aether.connector.connectTimeout"});
        int readTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)1800000, (String[])new String[]{"aether.connector.requestTimeout"});
        config.setConnectionTimeout(connectTimeout);
        config.setRequestTimeout(readTimeout);
        config.setSslSocketFactory(sslSocketFactory);
        return new OkHttpAetherClient(config);
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        GetTask task;
        String resource;
        artifactDownloads = this.safe(artifactDownloads);
        metadataDownloads = this.safe(metadataDownloads);
        CountDownLatch latch = new CountDownLatch(artifactDownloads.size() + metadataDownloads.size());
        ArrayList<GetTask> tasks = new ArrayList<GetTask>();
        for (MetadataDownload metadataDownload : metadataDownloads) {
            resource = this.layout.getLocation(metadataDownload.getMetadata(), false).getPath();
            task = new GetTask(this, resource, metadataDownload.getFile(), metadataDownload.getChecksumPolicy(), latch, (Transfer)metadataDownload, METADATA);
            tasks.add(task);
            task.run();
        }
        for (ArtifactDownload artifactDownload : artifactDownloads) {
            resource = this.layout.getLocation(artifactDownload.getArtifact(), false).getPath();
            task = new GetTask(this, resource, artifactDownload.isExistenceCheck() ? null : artifactDownload.getFile(), artifactDownload.getChecksumPolicy(), latch, (Transfer)artifactDownload, ARTIFACT);
            tasks.add(task);
            task.run();
        }
        this.await(latch);
        for (GetTask getTask : tasks) {
            getTask.flush();
        }
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        PutTask task;
        String path;
        artifactUploads = this.safe(artifactUploads);
        metadataUploads = this.safe(metadataUploads);
        CountDownLatch latch = new CountDownLatch(artifactUploads.size() + metadataUploads.size());
        ArrayList<PutTask> tasks = new ArrayList<PutTask>();
        for (ArtifactUpload artifactUpload : artifactUploads) {
            path = this.layout.getLocation(artifactUpload.getArtifact(), true).getPath();
            task = new PutTask(this, path, artifactUpload.getFile(), latch, (Transfer)artifactUpload, ARTIFACT);
            tasks.add(task);
            task.run();
        }
        for (MetadataUpload metadataUpload : metadataUploads) {
            path = this.layout.getLocation(metadataUpload.getMetadata(), true).getPath();
            task = new PutTask(this, path, metadataUpload.getFile(), latch, (Transfer)metadataUpload, METADATA);
            tasks.add(task);
            task.run();
        }
        this.await(latch);
        for (PutTask putTask : tasks) {
            putTask.flush();
        }
    }

    private void await(CountDownLatch latch) {
        boolean interrupted = false;
        while (latch.getCount() > 0L) {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void handleResponseCode(String url, int responseCode, String responseMsg) throws AuthorizationException, ResourceDoesNotExistException, TransferException {
        if (responseCode == 404) {
            throw new ResourceDoesNotExistException(String.format("Unable to locate resource %s. Error code %s", url, responseCode));
        }
        if (responseCode == 403 || responseCode == 401 || responseCode == 407) {
            throw new AuthorizationException(String.format("Access denied to %s. Error code %s, %s", url, responseCode, responseMsg));
        }
        if (responseCode >= 300) {
            throw new TransferException(String.format("Failed to transfer %s. Error code %s, %s", url, responseCode, responseMsg));
        }
    }

    private TransferEvent.Builder newEvent(TransferResource resource, TransferEvent.RequestType requestType, TransferEvent.EventType eventType) {
        return this.newEvent(resource, null, requestType, eventType);
    }

    private TransferEvent.Builder newEvent(TransferResource resource, Exception e, TransferEvent.RequestType requestType, TransferEvent.EventType eventType) {
        TransferEvent.Builder event = new TransferEvent.Builder(this.session, resource);
        event.setType(eventType);
        event.setRequestType(requestType);
        event.setException(e);
        return event;
    }

    private void uploadChecksum(File file, String uri, String algo, Object checksum) throws IOException {
        try {
            if (checksum instanceof Exception) {
                throw (Exception)checksum;
            }
            final byte[] bytes = String.valueOf(checksum).getBytes("UTF-8");
            String ext = checksumAlgos.get(algo);
            Response response = this.aetherClient.put(String.valueOf(uri) + ext, new RetryableSource(){

                @Override
                public void copyTo(OutputStream os) throws IOException {
                    os.write(bytes);
                }

                @Override
                public long length() {
                    return bytes.length;
                }
            });
            int statusCode = response.getStatusCode();
            response.close();
            if (statusCode >= 400) {
                throw new TransferException(String.format("Upload checksum failed for %s with status code %s", String.valueOf(uri) + ext, "RESPONSE" == null ? 500 : statusCode));
            }
        }
        catch (Exception e) {
            String msg = "Failed to upload " + algo + " checksum for " + file + ": " + e.getMessage();
            if (this.logger.isDebugEnabled()) {
                this.logger.warn(msg, (Throwable)e);
            }
            this.logger.warn(msg);
        }
    }

    private String buildUrl(String path) {
        String repoUrl = this.repository.getUrl();
        path = path.replace(' ', '+');
        if (repoUrl.charAt(repoUrl.length() - 1) != '/') {
            return String.valueOf(repoUrl) + '/' + path;
        }
        return String.valueOf(repoUrl) + path;
    }

    public void close() {
    }

    private <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    private File getTmpFile(String path) {
        File file;
        File f = new File(path);
        while ((file = new File(f.getParentFile(), "aether-" + UUID.randomUUID() + "-" + f.getName() + "-in-progress")).exists()) {
        }
        return file;
    }

    protected void transferInitiated(Transfer transfer, TransferEvent event) throws TransferCancelledException {
        if (transfer.getListener() != null) {
            transfer.getListener().transferInitiated(event);
        }
    }

    protected void transferSucceeded(Transfer transfer, TransferEvent event) {
        if (transfer.getListener() != null) {
            transfer.getListener().transferSucceeded(event);
        }
    }

    protected void transferFailed(Transfer transfer, TransferEvent event) {
        if (transfer.getListener() != null) {
            transfer.getListener().transferFailed(event);
        }
    }

    protected void transferStarted(Transfer transfer, TransferEvent event) throws TransferCancelledException {
        if (transfer.getListener() != null) {
            transfer.getListener().transferStarted(event);
        }
    }

    protected void transferProgressed(Transfer transfer, TransferEvent event) throws TransferCancelledException {
        if (transfer.getListener() != null) {
            transfer.getListener().transferProgressed(event);
        }
    }

    protected void transferCorrupted(Transfer transfer, TransferEvent event) throws TransferCancelledException {
        if (transfer.getListener() != null) {
            transfer.getListener().transferCorrupted(event);
        }
    }

    static interface ExceptionWrapper<T> {
        public void wrap(T var1, Exception var2, RemoteRepository var3);
    }

    class FileSource
    implements RetryableSource {
        private long bytesTransferred = 0L;
        private final TransferResource resource;
        private TransferCancelledException exception;
        private final Transfer transfer;

        public FileSource(Transfer transfer, TransferResource transferResource) {
            this.transfer = transfer;
            this.resource = transferResource;
        }

        @Override
        public void copyTo(OutputStream os) throws IOException {
            try (Closer closer = Closer.create();){
                try {
                    InputStream is = (InputStream)closer.register((Closeable)new FileInputStream(this.resource.getFile()));
                    closer.register((Closeable)os);
                    int n = 0;
                    byte[] buffer = new byte[4096];
                    while (-1 != (n = is.read(buffer))) {
                        os.write(buffer, 0, n);
                        AetherRepositoryConnector.this.transferProgressed(this.transfer, AetherRepositoryConnector.this.newEvent(this.resource, null, TransferEvent.RequestType.PUT, TransferEvent.EventType.PROGRESSED).setTransferredBytes(this.bytesTransferred).setDataBuffer(buffer, 0, n).build());
                        this.bytesTransferred += (long)n;
                    }
                }
                catch (TransferCancelledException e) {
                    this.exception = e;
                    closer.close();
                }
            }
        }

        @Override
        public long length() {
            return this.resource.getFile().length();
        }

        public TransferCancelledException getException() {
            return this.exception;
        }

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }
    }

    static class GetTask<T extends Transfer>
    implements Runnable {
        private final T download;
        private final String path;
        private final File fileInLocalRepository;
        private final String checksumPolicy;
        private final LatchGuard latch;
        private volatile Exception exception;
        private final ExceptionWrapper<T> wrapper;
        final /* synthetic */ AetherRepositoryConnector this$0;

        public GetTask(String path, File fileInLocalRepository, String checksumPolicy, CountDownLatch latch, T download, ExceptionWrapper<T> wrapper) {
            this.this$0 = var1_1;
            this.path = path;
            this.fileInLocalRepository = fileInLocalRepository;
            this.checksumPolicy = checksumPolicy;
            this.latch = var1_1.new LatchGuard(latch);
            this.download = download;
            this.wrapper = wrapper;
        }

        public T getDownload() {
            return this.download;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public void run() {
            String uri = this.this$0.buildUrl(this.path);
            TransferResource transferResource = new TransferResource(this.this$0.repository.getUrl(), this.path, this.fileInLocalRepository, this.download.getTrace());
            try {
                this.this$0.transferInitiated((Transfer)this.download, this.this$0.newEvent(transferResource, TransferEvent.RequestType.GET, TransferEvent.EventType.INITIATED).build());
                if (this.fileInLocalRepository == null) {
                    if (!this.resourceExist(uri)) {
                        throw new ResourceDoesNotExistException("Could not find " + uri + " in " + this.this$0.repository.getUrl());
                    }
                    this.latch.countDown();
                    return;
                }
                this.this$0.fileProcessor.mkdirs(this.fileInLocalRepository.getParentFile());
                try {
                    FileTransfer temporaryFileInLocalRepository = this.resumableGet(uri, this.fileInLocalRepository, transferResource, TransferEvent.RequestType.GET, true);
                    this.validateChecksums(temporaryFileInLocalRepository.file, this.fileInLocalRepository, uri, transferResource);
                    this.rename(temporaryFileInLocalRepository.file, this.fileInLocalRepository);
                    this.this$0.transferSucceeded((Transfer)this.download, this.this$0.newEvent(transferResource, TransferEvent.RequestType.GET, TransferEvent.EventType.SUCCEEDED).setTransferredBytes(temporaryFileInLocalRepository.bytesTransferred).build());
                }
                catch (Throwable t) {
                    this.exception = Exception.class.isAssignableFrom(t.getClass()) ? (Exception)Exception.class.cast(t) : new Exception(t);
                    this.this$0.transferFailed((Transfer)this.download, this.this$0.newEvent(transferResource, this.exception, TransferEvent.RequestType.GET, TransferEvent.EventType.FAILED).build());
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean resourceExist(String uri) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Response head = this.this$0.aetherClient.head(uri);){
                return head.getStatusCode() == 200;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }

        private void validateChecksums(File temporaryFileInLocalRepository, File fileInLocalRepository, String uri, TransferResource transferResource) throws Exception {
            block3: {
                boolean failOnInvalidOrMissingCheckums = "fail".equals(this.checksumPolicy);
                try {
                    Map checksums = ChecksumUtils.calc((File)temporaryFileInLocalRepository, checksumAlgos.keySet());
                    if (!this.verifyChecksums(temporaryFileInLocalRepository, fileInLocalRepository, uri, checksums)) {
                        throw new ChecksumFailureException("Checksum validation failed, no checksums available from the repository");
                    }
                }
                catch (Exception e) {
                    this.this$0.transferCorrupted((Transfer)this.download, this.this$0.newEvent(transferResource, e, TransferEvent.RequestType.GET, TransferEvent.EventType.CORRUPTED).build());
                    if (!failOnInvalidOrMissingCheckums) break block3;
                    this.this$0.transferFailed((Transfer)this.download, this.this$0.newEvent(transferResource, e, TransferEvent.RequestType.GET, TransferEvent.EventType.FAILED).build());
                    throw e;
                }
            }
        }

        private boolean verifyChecksums(File temporaryFileInLocalRepository, File fileInLocalRepository, String uri, Map<String, Object> checksums) throws ChecksumFailureException {
            for (Map.Entry algo : checksumAlgos.entrySet()) {
                String ext = (String)algo.getValue();
                String actual = (String)checksums.get(algo.getKey());
                String checksumUri = String.valueOf(uri) + ext;
                File checksumFileInLocalRepository = new File(temporaryFileInLocalRepository.getParentFile(), String.valueOf(fileInLocalRepository.getName()) + ext);
                TransferResource transferResource = new TransferResource(this.this$0.repository.getUrl(), checksumUri, checksumFileInLocalRepository, this.download.getTrace());
                try {
                    FileTransfer temporaryChecksumFile = this.resumableGet(checksumUri, checksumFileInLocalRepository, transferResource, TransferEvent.RequestType.GET, false);
                    String expected = ChecksumUtils.read((File)temporaryChecksumFile.file);
                    if (!expected.equalsIgnoreCase(actual)) {
                        throw new ChecksumFailureException(expected, actual);
                    }
                    this.rename(temporaryChecksumFile.file, checksumFileInLocalRepository);
                    return true;
                }
                catch (ResourceDoesNotExistException resourceDoesNotExistException) {
                }
                catch (Exception e) {
                    throw new ChecksumFailureException((Throwable)e);
                }
            }
            return false;
        }

        private FileTransfer resumableGet(String uri, File fileInLocalRepository, TransferResource transferResource, TransferEvent.RequestType requestType, boolean emitProgressEvent) throws Exception {
            long bytesTransferred = 0L;
            boolean downloadSuccessful = false;
            boolean resumeDownloadInProgress = false;
            Serializable temporaryFileInLocalRepository = null;
            int retries = 0;
            while (retries < 10) {
                block45: {
                    Serializable inProgress;
                    File[] files;
                    File[] fileArray = files = fileInLocalRepository.getParentFile().listFiles();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        inProgress = fileArray[n2];
                        if (((File)inProgress).getName().startsWith("aether") && ((File)inProgress).getName().endsWith(String.valueOf(fileInLocalRepository.getName()) + "-in-progress")) {
                            temporaryFileInLocalRepository = inProgress;
                            resumeDownloadInProgress = true;
                            break;
                        }
                        ++n2;
                    }
                    if (temporaryFileInLocalRepository == null) {
                        temporaryFileInLocalRepository = this.this$0.getTmpFile(fileInLocalRepository.getPath());
                    }
                    try {
                        try {
                            inProgress = null;
                            Object var14_16 = null;
                            try {
                                Response response = this.getResponse(uri, resumeDownloadInProgress, (File)temporaryFileInLocalRepository);
                                try {
                                    try (InputStream is = response.getInputStream();){
                                        String contentLength;
                                        this.this$0.handleResponseCode(uri, response.getStatusCode(), response.getStatusMessage());
                                        if (resumeDownloadInProgress && response.getHeader("Accept-Ranges") == null && response.getStatusCode() == 200) {
                                            ((File)temporaryFileInLocalRepository).delete();
                                        }
                                        if (emitProgressEvent && (contentLength = response.getHeader("Content-Length")) != null) {
                                            long length = Long.parseLong(contentLength);
                                            transferResource.setContentLength(length);
                                            this.this$0.transferStarted((Transfer)this.download, this.this$0.newEvent(transferResource, null, requestType, TransferEvent.EventType.STARTED).setTransferredBytes(bytesTransferred).build());
                                        }
                                        byte[] buffer = new byte[0x100000];
                                        int n3 = 0;
                                        Throwable throwable = null;
                                        Object var20_28 = null;
                                        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream((File)temporaryFileInLocalRepository, resumeDownloadInProgress));){
                                            while (-1 != (n3 = is.read(buffer))) {
                                                ((OutputStream)os).write(buffer, 0, n3);
                                                if (emitProgressEvent) {
                                                    this.this$0.transferProgressed((Transfer)this.download, this.this$0.newEvent(transferResource, null, requestType, TransferEvent.EventType.PROGRESSED).setTransferredBytes((long)n3).setDataBuffer(buffer, 0, n3).build());
                                                }
                                                bytesTransferred += (long)n3;
                                            }
                                            downloadSuccessful = true;
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    if (response != null) {
                                        response.close();
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (inProgress == null) {
                                        inProgress = throwable;
                                    } else if (inProgress != throwable) {
                                        ((Throwable)inProgress).addSuppressed(throwable);
                                    }
                                    if (response != null) {
                                        response.close();
                                    }
                                    throw inProgress;
                                }
                            }
                            catch (Throwable throwable) {
                                if (inProgress == null) {
                                    inProgress = throwable;
                                } else if (inProgress != throwable) {
                                    ((Throwable)inProgress).addSuppressed(throwable);
                                }
                                throw inProgress;
                            }
                        }
                        catch (IOException e) {
                            this.exception = e;
                            if (downloadSuccessful) {
                                this.exception = null;
                                break;
                            }
                            break block45;
                        }
                    }
                    catch (Throwable throwable) {
                        if (downloadSuccessful) {
                            this.exception = null;
                            break;
                        }
                        throw throwable;
                    }
                    if (downloadSuccessful) {
                        this.exception = null;
                        break;
                    }
                }
                ++retries;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return new FileTransfer((File)temporaryFileInLocalRepository, bytesTransferred);
        }

        private Response getResponse(String uri, boolean resumeDownloadInProgress, File temporaryFileInLocalRepository) throws IOException {
            Response response;
            if (resumeDownloadInProgress) {
                HashMap<String, String> requestHeaders = new HashMap<String, String>();
                requestHeaders.put("Range", "bytes=" + temporaryFileInLocalRepository.length() + "-");
                requestHeaders.put("Accept-Encoding", "identity");
                response = this.this$0.aetherClient.get(uri, requestHeaders);
                if (response.getStatusCode() == 416) {
                    response.close();
                    response = this.this$0.aetherClient.get(uri);
                }
            } else {
                response = this.this$0.aetherClient.get(uri);
            }
            return response;
        }

        public void flush() {
            this.wrapper.wrap(this.download, this.exception, this.this$0.repository);
        }

        private void rename(File from, File to) throws IOException {
            this.this$0.fileProcessor.move(from, to);
        }

        class FileTransfer {
            File file;
            long bytesTransferred;

            FileTransfer(File file, long bytesTransferred) {
                this.file = file;
                this.bytesTransferred = bytesTransferred;
            }
        }
    }

    private class LatchGuard {
        private final CountDownLatch latch;
        private final AtomicBoolean done = new AtomicBoolean(false);

        public LatchGuard(CountDownLatch latch) {
            this.latch = latch;
        }

        public void countDown() {
            if (!this.done.getAndSet(true)) {
                this.latch.countDown();
            }
        }
    }

    static class PutTask<T extends Transfer>
    implements Runnable {
        private final T upload;
        private final ExceptionWrapper<T> wrapper;
        private final String path;
        private final File file;
        private volatile Exception exception;
        private final LatchGuard latch;
        final /* synthetic */ AetherRepositoryConnector this$0;

        public PutTask(String path, File file, CountDownLatch latch, T upload, ExceptionWrapper<T> wrapper) {
            this.this$0 = var1_1;
            this.path = path;
            this.file = file;
            this.upload = upload;
            this.wrapper = wrapper;
            this.latch = var1_1.new LatchGuard(latch);
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public void run() {
            TransferResource transferResource = new TransferResource(this.this$0.repository.getUrl(), this.path, this.file, this.upload.getTrace());
            try {
                try {
                    String uri = this.this$0.buildUrl(this.path);
                    this.this$0.transferInitiated((Transfer)this.upload, this.this$0.newEvent(transferResource, this.exception, TransferEvent.RequestType.PUT, TransferEvent.EventType.INITIATED).build());
                    transferResource.setContentLength(this.file.length());
                    this.this$0.transferStarted((Transfer)this.upload, this.this$0.newEvent(transferResource, null, TransferEvent.RequestType.PUT, TransferEvent.EventType.STARTED).build());
                    FileSource source = this.this$0.new FileSource((Transfer)this.upload, transferResource);
                    Throwable throwable = null;
                    Object var5_9 = null;
                    try (Response response = this.this$0.aetherClient.put(uri, source);){
                        this.this$0.handleResponseCode(uri, response.getStatusCode(), response.getStatusMessage());
                        int statusCode = response.getStatusCode();
                        if (statusCode >= 400) {
                            throw new TransferException(String.format("Upload failed for %s with status code %s", uri, "RESPONSE" == null ? 500 : statusCode));
                        }
                        this.this$0.transferSucceeded((Transfer)this.upload, this.this$0.newEvent(transferResource, null, TransferEvent.RequestType.PUT, TransferEvent.EventType.SUCCEEDED).setTransferredBytes(source.getBytesTransferred()).build());
                        this.uploadChecksums(this.file, uri);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    try {
                        this.exception = e;
                    }
                    finally {
                        this.this$0.transferFailed((Transfer)this.upload, this.this$0.newEvent(transferResource, this.exception, TransferEvent.RequestType.PUT, TransferEvent.EventType.FAILED).build());
                    }
                    this.latch.countDown();
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        public void flush() {
            this.wrapper.wrap(this.upload, this.exception, this.this$0.repository);
        }

        private void uploadChecksums(File file, String uri) {
            try {
                Map checksums = ChecksumUtils.calc((File)file, checksumAlgos.keySet());
                for (Map.Entry entry : checksums.entrySet()) {
                    this.this$0.uploadChecksum(file, uri, (String)entry.getKey(), entry.getValue());
                }
            }
            catch (IOException e) {
                this.this$0.logger.debug("Failed to upload checksums for " + file + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

