/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.recommenders.internal.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.rcp.l10n.Messages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.rcp.Browsers;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class BundleResolutionFailureDialog
extends MessageDialogWithToggle {
    private static final String RECOMMENDERS_FAQ_URL = "https://www.eclipse.org/recommenders/faq/";
    private static final String BUGZILLA_URL = "https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Recommenders&version={0}&bug_severity=enhancement&short_desc=Your%20short%20description&comment=A%20longer%20description%0D%0DUnresolved bundles:%0D{1}&component=Core&rep_platform=All";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String CMD_VMARGS = "-vmargs";
    private static final String NEW_LINE = "\n";
    private final Version recommendersVersion;
    private final Collection<Bundle> unresolvedBundles;

    public BundleResolutionFailureDialog(Shell parentShell, Version recommendersVersion, Collection<Bundle> unresolvedBundles) {
        super(parentShell, Messages.DIALOG_TITLE_BUNDLE_RESOLUTION_FAILURE, null, Messages.DIALOG_MESSAGE_BUNDLE_RESOLUTION_FAILURE, 1, new String[]{IDialogConstants.CANCEL_LABEL, Messages.DIALOG_BUTTON_RESTART}, 1, Messages.DIALOG_TOGGLE_IGNORE_BUNDLE_RESOLUTION_FAILURES, false);
        this.recommendersVersion = recommendersVersion;
        this.unresolvedBundles = unresolvedBundles;
        this.setPrefStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.rcp"));
        this.setPrefKey("ignore.bundle.resolution.failures");
    }

    protected Control createCustomArea(Composite parent) {
        Label bundleListLabel = new Label(parent, 0);
        bundleListLabel.setText(Messages.DIALOG_LABEL_BUNDLE_LIST);
        List bundleList = new List(parent, 2564);
        for (Bundle bundle : this.unresolvedBundles) {
            bundleList.add(bundle.getSymbolicName());
        }
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)bundleList);
        this.addLink(parent, Messages.DIALOG_MESSAGE_BUNDLE_RESOLUTION_FAQ, RECOMMENDERS_FAQ_URL);
        Collection unresolvedBundleNames = Collections2.transform(this.unresolvedBundles, (Function)new Function<Bundle, String>(){

            public String apply(Bundle input) {
                return input.getSymbolicName();
            }
        });
        String version = String.valueOf(this.recommendersVersion.getMajor()) + "." + this.recommendersVersion.getMinor() + "." + this.recommendersVersion.getMicro();
        String bugLinkUrl = MessageFormat.format(BUGZILLA_URL, version, StringUtils.join((Iterable)unresolvedBundleNames, (char)'\n'));
        this.addLink(parent, Messages.DIALOG_MESSAGE_BUNDLE_RESOLUTION_FILE_A_BUG, bugLinkUrl);
        return parent;
    }

    private void addLink(Composite parent, String text, String url) {
        Link link = new Link(parent, 1);
        link.setText(MessageFormat.format(text, url));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Browsers.tryOpenInExternalBrowser((String)event.text);
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
        if (this.getToggleState() && this.getPrefStore() != null && this.getPrefKey() != null) {
            this.getPrefStore().setValue(this.getPrefKey(), "always");
            try {
                ((ScopedPreferenceStore)this.getPrefStore()).save();
            }
            catch (IOException e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_PREFERENCES_NOT_SAVED, (Throwable)e);
            }
        }
        if (buttonId == 256) {
            String commandLine = this.buildCommandLine();
            if (commandLine == null) {
                return;
            }
            System.setProperty(PROP_EXIT_CODE, Integer.toString(24));
            System.setProperty(PROP_EXIT_DATA, this.buildCommandLine());
            PlatformUI.getWorkbench().restart();
        }
    }

    public boolean isIgnored() {
        return this.getPrefStore().getString(this.getPrefKey()).equals("always");
    }

    private String buildCommandLine() {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_DIALOG_RESTART_NOT_POSSIBLE);
            return null;
        }
        StringBuilder result = new StringBuilder(512);
        result.append(property);
        result.append(NEW_LINE);
        String vmargs = System.getProperty(PROP_VMARGS);
        if (vmargs != null) {
            result.append(vmargs);
        }
        result.append("-clean");
        result.append(NEW_LINE);
        property = System.getProperty(PROP_COMMANDS);
        result.append(property);
        result.append(NEW_LINE);
        if (vmargs != null) {
            result.append(CMD_VMARGS);
            result.append(NEW_LINE);
            result.append(vmargs);
        }
        return result.toString();
    }
}

