/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.discovery;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryImages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

final class ShowNatureProposalsDialog
extends TitleAreaDialog {
    private Image wizban;
    private final Map<String, Collection<INode>> candidates;
    private CheckboxTableViewer naturesCheckList;
    private final Set<String> selectedNatures;

    ShowNatureProposalsDialog(Shell parentShell, Map<String, Collection<INode>> candidates) {
        super(parentShell);
        this.candidates = candidates;
        this.selectedNatures = new LinkedHashSet<String>(candidates.keySet());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.MissingNatureDetector_Title);
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public Control createDialogArea(Composite parent) {
        this.setTitle(Messages.MissingNatureDetector_Title);
        this.setMessage(Messages.MissingNatureDetector_Desc);
        this.wizban = DiscoveryImages.BANNER_DISOVERY.createImage();
        this.setTitleImage(this.wizban);
        Composite res = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, -1).applyTo((Control)res);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).equalWidth(false).applyTo(res);
        Label label = new Label(res, 64);
        label.setText(Messages.MissingNatureDetector_Message);
        this.naturesCheckList = CheckboxTableViewer.newCheckList((Composite)res, (int)68354);
        this.naturesCheckList.setContentProvider((IContentProvider)((IStructuredContentProvider)inputElement -> ((Set)inputElement).toArray()));
        this.naturesCheckList.setComparator(new ViewerComparator());
        this.naturesCheckList.setInput(this.candidates.keySet());
        this.naturesCheckList.setAllChecked(true);
        GridDataFactory.fillDefaults().applyTo(this.naturesCheckList.getControl());
        this.naturesCheckList.addCheckStateListener(event -> {
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(this.canComplete());
            }
            this.updateSelectedNatures();
        });
        Link preferencesLink = new Link(res, 0);
        preferencesLink.setText(Messages.MissingNatureDetector_linkToPreferences);
        preferencesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)ShowNatureProposalsDialog.this.getShell(), (String)"org.eclipse.epp.mpc.projectnatures", null, null);
                pref.setBlockOnOpen(false);
                pref.open();
            }
        });
        return res;
    }

    private void updateSelectedNatures() {
        this.selectedNatures.clear();
        Object[] checkedElements = this.naturesCheckList.getCheckedElements();
        if (checkedElements == null) {
            return;
        }
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            this.selectedNatures.add(selected.toString());
            ++n2;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setText(Messages.MissingNatureDetector_ShowSolutions);
        okButton.setEnabled(this.canComplete());
    }

    protected boolean canComplete() {
        Object[] checkedElements = this.naturesCheckList.getCheckedElements();
        return checkedElements != null && checkedElements.length > 0;
    }

    public boolean close() {
        this.updateSelectedNatures();
        if (super.close()) {
            this.wizban.dispose();
        }
        return false;
    }

    public Set<String> getSelectedNatures() {
        return this.selectedNatures;
    }
}

