/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ide.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.tips.ide.internal.IDETipManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;

public class TipsPreferences
extends AbstractPreferenceInitializer {
    private static final String FALSE = "false";
    public static final String PREF_STARTUP_BEHAVIOR = "activate_at_startup";
    public static final String PREF_SERVE_READ_TIPS = "serve_read_tips";

    public void initializeDefaultPreferences() {
        IEclipsePreferences node = TipsPreferences.getPreferences();
        node.putInt(PREF_STARTUP_BEHAVIOR, 0);
        node.putBoolean(PREF_SERVE_READ_TIPS, false);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, List<Integer>> getReadState() {
        HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>();
        try {
            File stateLocation = TipsPreferences.getStateLocation();
            String[] stringArray = stateLocation.list(TipsPreferences.getStateFileNameFilter(stateLocation));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                PreferenceStore store = new PreferenceStore(new File(stateLocation, key).getAbsolutePath());
                store.load();
                ArrayList<Integer> tips = new ArrayList<Integer>();
                String[] stringArray2 = store.preferenceNames();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String tipKey = stringArray2[n4];
                    if (!"provider".equals(tipKey)) {
                        tips.add(store.getInt(tipKey));
                    }
                    ++n4;
                }
                result.put(store.getString("provider"), tips);
                ++n2;
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.tips.ide", e.getMessage(), (Throwable)e);
            TipsPreferences.log((IStatus)status);
        }
        return result;
    }

    private static FilenameFilter getStateFileNameFilter(File stateLocation) {
        return (pDir, pName) -> pDir.equals(stateLocation) && pName.endsWith(".state");
    }

    private static File getStateLocation() throws Exception {
        File file = new File(IDETipManager.getStateLocation(), "org.eclipse.tips.ide.state");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static IStatus saveReadState(Map<String, List<Integer>> pReadTips) {
        try {
            File stateLocation = TipsPreferences.getStateLocation();
            for (String child : pReadTips.keySet()) {
                PreferenceStore store = new PreferenceStore(new File(stateLocation, String.valueOf(child.trim()) + ".state").getAbsolutePath());
                pReadTips.get(child).forEach(value -> store.setValue(value.toString(), value.intValue()));
                store.setValue("provider", child);
                store.save();
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "org.eclipse.tips.ide", e.getMessage(), (Throwable)e);
        }
    }

    public static IEclipsePreferences getPreferences() {
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode("org.eclipse.tips.ide");
        return node;
    }

    public static void log(IStatus status) {
        if (status.matches(6) || TipsPreferences.isDebug()) {
            Bundle bundle = FrameworkUtil.getBundle(TipsPreferences.class);
            Platform.getLog((Bundle)bundle).log(status);
        }
        if (TipsPreferences.isConsoleLog()) {
            System.out.println(String.format("%1$tR:%1$tS:%1$tN - %2$s", Calendar.getInstance().getTime(), TipsPreferences.format(status)));
        }
    }

    private static Object format(IStatus pStatus) {
        String statusLine;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String origin = "<unknown>";
        if (stackTrace.length > 3) {
            StackTraceElement ste = stackTrace[4];
            String[] fqcn = ste.getClassName().split("\\.");
            String clazz = fqcn[fqcn.length - 1];
            origin = String.valueOf(clazz) + "#" + ste.getMethodName() + "(" + ste.getLineNumber() + ")";
        }
        if ((statusLine = pStatus.toString()).endsWith(" null")) {
            statusLine = statusLine.substring(0, statusLine.length() - " null".length());
        }
        return String.valueOf(statusLine) + " : " + origin;
    }

    public static int getStartupBehavior() {
        return TipsPreferences.getPreferences().getInt(PREF_STARTUP_BEHAVIOR, TipsPreferences.getDefaultStartupBehavior());
    }

    private static int getDefaultStartupBehavior() {
        String startupBehavior = System.getProperty("org.eclipse.tips.startup");
        if ("dialog".equals(startupBehavior)) {
            return 0;
        }
        if ("background".equals(startupBehavior)) {
            return 1;
        }
        if ("disable".equals(startupBehavior)) {
            return 2;
        }
        return 1;
    }

    public static boolean isServeReadTips() {
        return TipsPreferences.getPreferences().getBoolean(PREF_SERVE_READ_TIPS, false);
    }

    public static void setStartupBehavior(int startupBehavior) {
        IEclipsePreferences node = TipsPreferences.getPreferences();
        node.putInt(PREF_STARTUP_BEHAVIOR, startupBehavior);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setServeReadTips(boolean serveReadTips) {
        IEclipsePreferences node = TipsPreferences.getPreferences();
        node.putBoolean(PREF_SERVE_READ_TIPS, serveReadTips);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isDebug() {
        return !System.getProperty("org.eclipse.tips.debug", FALSE).equals(FALSE);
    }

    public static boolean isConsoleLog() {
        return !System.getProperty("org.eclipse.tips.consolelog", FALSE).equals(FALSE);
    }
}

