/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.IContextDisposalListener;
import org.eclipse.epp.logging.aeri.core.Constants;
import org.eclipse.epp.logging.aeri.core.IModelFactory;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.epp.logging.aeri.core.handlers.ResetSendModeHandler;
import org.eclipse.epp.logging.aeri.core.handlers.SetSendModeHandler;
import org.eclipse.epp.logging.aeri.core.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.jdt.annotation.Nullable;

public class SystemControl {
    private static final IEclipseContext SYSTEM_CONTEXT = SystemControl.init();
    private static volatile boolean DISPOSED;

    private static EclipseContext init() {
        EclipseContext local = new EclipseContext(null);
        local.set("debugString", (Object)"AERI System Context");
        local.set(ISystemSettings.class, (Object)IModelFactory.eINSTANCE.createSystemSettings());
        for (Class clazz : ImmutableList.of(SetSendModeHandler.class, ResetSendModeHandler.class)) {
            Object handler = ContextInjectionFactory.make((Class)clazz, (IEclipseContext)local);
            local.declareModifiable(clazz);
            local.set(clazz.getName(), handler);
        }
        local.notifyOnDisposal(new IContextDisposalListener(){

            public void disposed(IEclipseContext context) {
                SystemControl.setDisposed(true);
            }
        });
        return local;
    }

    public static IEclipseContext getSystemContext() {
        return SYSTEM_CONTEXT;
    }

    public static ISystemSettings getSystemSettings() {
        return (ISystemSettings)Preconditions.checkNotNull((Object)SystemControl.get(ISystemSettings.class));
    }

    @Nullable
    public static <T> T get(String key) {
        return (T)SYSTEM_CONTEXT.get(key);
    }

    @Nullable
    public static <T> T get(Class<T> key) {
        return (T)SYSTEM_CONTEXT.get(key);
    }

    public static boolean isActive() {
        block6: {
            try {
                if (!Boolean.getBoolean("org.eclipse.epp.logging.aeri.skipReports") && !Boolean.getBoolean("org.eclipse.epp.logging.aeri.ui.skipReports") && !SystemControl.isDisposed()) break block6;
                return false;
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_AERI_FAILURE, e, e.getMessage());
                return false;
            }
        }
        SendMode mode = (SendMode)((Object)SystemControl.executeHandler(ResetSendModeHandler.class));
        switch (mode) {
            case NEVER: {
                return false;
            }
        }
        return true;
    }

    public static boolean isDebug() {
        return Constants.DEBUG || SystemControl.getSystemSettings().isDebugEnabled();
    }

    public static void registerHandlers(Class<?> ... handlers) {
        Class<?>[] classArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            Object handler = ContextInjectionFactory.make(clazz, (IEclipseContext)SYSTEM_CONTEXT);
            SYSTEM_CONTEXT.declareModifiable(clazz);
            SYSTEM_CONTEXT.set(clazz.getName(), handler);
            ++n2;
        }
    }

    @Nullable
    public static Object executeHandler(Class<?> clazz) {
        Object handler = SYSTEM_CONTEXT.get(clazz);
        return ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)SYSTEM_CONTEXT);
    }

    @Nullable
    public static Object executeHandler(Class<?> clazz, IEclipseContext localContext) {
        Object handler = SYSTEM_CONTEXT.get(clazz);
        return ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)SYSTEM_CONTEXT, (IEclipseContext)localContext, null);
    }

    private static void setDisposed(boolean value) {
        DISPOSED = value;
    }

    private static boolean isDisposed() {
        return DISPOSED;
    }
}

