/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.commands.AbstractMarketplaceWizardCommand;
import org.eclipse.epp.internal.mpc.ui.commands.ImportFavoritesWizardCommand;
import org.eclipse.epp.internal.mpc.ui.commands.MarketplaceWizardCommand;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.epp.mpc.ui.IMarketplaceClientService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceClientService
implements IMarketplaceClientService {
    @Override
    public IMarketplaceClientConfiguration newConfiguration() {
        return new MarketplaceCatalogConfiguration();
    }

    @Override
    public void open(IMarketplaceClientConfiguration configuration) {
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setConfiguration(configuration);
        MarketplaceWizard.WizardState wizardState = new MarketplaceWizard.WizardState();
        this.setInitialContentType(configuration, wizardState);
        wizardState.setProceedWithInstallation(false);
        command.setWizardDialogState(wizardState);
        this.execute(command);
    }

    private void setInitialContentType(IMarketplaceClientConfiguration configuration, MarketplaceWizard.WizardState wizardState) {
        MarketplaceCatalogConfiguration catalogConfiguration;
        MarketplaceViewer.ContentType initialContentType;
        if (configuration instanceof MarketplaceCatalogConfiguration && (initialContentType = (catalogConfiguration = (MarketplaceCatalogConfiguration)configuration).getInitialContentType()) != null) {
            wizardState.setContentType(initialContentType);
        }
    }

    @Override
    public void openSelected(IMarketplaceClientConfiguration configuration) {
        this.checkInitialState(configuration);
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setConfiguration(configuration);
        MarketplaceWizard.WizardState wizardState = new MarketplaceWizard.WizardState();
        wizardState.setContentType(MarketplaceViewer.ContentType.SELECTION);
        wizardState.setProceedWithInstallation(false);
        command.setWizardDialogState(wizardState);
        this.execute(command);
    }

    @Override
    public void openInstalled(IMarketplaceClientConfiguration configuration) {
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setConfiguration(configuration);
        MarketplaceWizard.WizardState wizardState = new MarketplaceWizard.WizardState();
        wizardState.setContentType(MarketplaceViewer.ContentType.INSTALLED);
        wizardState.setProceedWithInstallation(false);
        command.setWizardDialogState(wizardState);
        this.execute(command);
    }

    @Override
    public void openSearch(IMarketplaceClientConfiguration configuration, IMarket market, ICategory category, String query) {
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setConfiguration(configuration);
        MarketplaceWizard.WizardState wizardState = new MarketplaceWizard.WizardState();
        wizardState.setContentType(MarketplaceViewer.ContentType.SEARCH);
        wizardState.setFilterMarket(market);
        wizardState.setFilterCategory(category);
        wizardState.setFilterQuery(query);
        wizardState.setProceedWithInstallation(false);
        command.setWizardDialogState(wizardState);
        this.execute(command);
    }

    @Override
    public void open(IMarketplaceClientConfiguration configuration, Set<INode> nodes) {
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setConfiguration(configuration);
        MarketplaceWizard.WizardState wizardState = new MarketplaceWizard.WizardState();
        this.setInitialContentType(configuration, wizardState);
        wizardState.setContent(nodes);
        wizardState.setProceedWithInstallation(false);
        command.setWizardDialogState(wizardState);
        this.execute(command);
    }

    @Override
    public void openProvisioning(IMarketplaceClientConfiguration configuration) {
        this.checkInitialState(configuration);
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setConfiguration(configuration);
        MarketplaceWizard.WizardState wizardState = new MarketplaceWizard.WizardState();
        wizardState.setProceedWithInstallation(true);
        command.setWizardDialogState(wizardState);
        this.execute(command);
    }

    @Override
    public void openFavorites(IMarketplaceClientConfiguration configuration) {
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setConfiguration(configuration);
        MarketplaceWizard.WizardState wizardState = new MarketplaceWizard.WizardState();
        wizardState.setContentType(MarketplaceViewer.ContentType.FAVORITES);
        wizardState.setProceedWithInstallation(false);
        command.setWizardDialogState(wizardState);
        this.execute(command);
    }

    @Override
    public void openFavoritesImport(IMarketplaceClientConfiguration configuration, String favoritesUrl) {
        ImportFavoritesWizardCommand command = new ImportFavoritesWizardCommand();
        command.setConfiguration(configuration);
        command.setFavoritesUrl(favoritesUrl);
        this.execute(command);
    }

    private void checkInitialState(IMarketplaceClientConfiguration configuration) {
        if (configuration.getInitialState() == null && (configuration.getInitialOperations() == null || configuration.getInitialOperations().isEmpty())) {
            throw new IllegalArgumentException(Messages.MarketplaceClientService_noProvisioningOperation);
        }
    }

    private void execute(AbstractMarketplaceWizardCommand command) {
        try {
            command.execute(new ExecutionEvent());
        }
        catch (ExecutionException e) {
            MarketplaceClientUi.handle(MarketplaceClientCore.computeStatus((Throwable)e, (String)Messages.MarketplaceClientService_ExecuteError), 7);
        }
    }
}

