/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.epp.internal.mpc.core.service.xml.CatalogBrandingContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.CatalogContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.CatalogsContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.CategoriesContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.CategoryContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.DefaultContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.FavoritesContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.FeaturedContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.IusContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.MarketContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.MarketplaceContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.NewsContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.NodeContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.PlatformsContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.PopularContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.RecentContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.RelatedContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.SearchContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.TagContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.TagsContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.UnmarshalContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Unmarshaller
extends DefaultHandler {
    private static SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private static EntityResolver emptyResolver;
    private final Map<String, UnmarshalContentHandler> elementNameToUnmarshalContentHandler = new HashMap<String, UnmarshalContentHandler>();
    private UnmarshalContentHandler currentHandler;
    private Object model;

    static {
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(false);
        Unmarshaller.setFeature(parserFactory, "http://xml.org/sax/features/namespaces", true);
        Unmarshaller.setFeature(parserFactory, "http://xml.org/sax/features/validation", false);
        Unmarshaller.setFeature(parserFactory, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        Unmarshaller.setFeature(parserFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        emptyResolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputSource emptyInputSource = new InputSource(new StringReader(""));
                emptyInputSource.setPublicId(publicId);
                emptyInputSource.setSystemId(systemId);
                return emptyInputSource;
            }
        };
    }

    public Unmarshaller() {
        this.elementNameToUnmarshalContentHandler.put("marketplace", new MarketplaceContentHandler());
        this.elementNameToUnmarshalContentHandler.put("market", new MarketContentHandler());
        this.elementNameToUnmarshalContentHandler.put("category", new CategoryContentHandler());
        this.elementNameToUnmarshalContentHandler.put("node", new NodeContentHandler());
        this.elementNameToUnmarshalContentHandler.put("categories", new CategoriesContentHandler());
        this.elementNameToUnmarshalContentHandler.put("catalogs", new CatalogsContentHandler());
        this.elementNameToUnmarshalContentHandler.put("catalog", new CatalogContentHandler());
        this.elementNameToUnmarshalContentHandler.put("wizard", new CatalogBrandingContentHandler());
        this.elementNameToUnmarshalContentHandler.put("tags", new TagsContentHandler());
        this.elementNameToUnmarshalContentHandler.put("tag", new TagContentHandler());
        this.elementNameToUnmarshalContentHandler.put("ius", new IusContentHandler());
        this.elementNameToUnmarshalContentHandler.put("platforms", new PlatformsContentHandler());
        this.elementNameToUnmarshalContentHandler.put("search", new SearchContentHandler());
        this.elementNameToUnmarshalContentHandler.put("recent", new RecentContentHandler());
        this.elementNameToUnmarshalContentHandler.put("featured", new FeaturedContentHandler());
        this.elementNameToUnmarshalContentHandler.put("popular", new PopularContentHandler());
        this.elementNameToUnmarshalContentHandler.put("related", new RelatedContentHandler());
        this.elementNameToUnmarshalContentHandler.put("favorites", new FavoritesContentHandler());
        this.elementNameToUnmarshalContentHandler.put("news", new NewsContentHandler());
    }

    public static XMLReader createXMLReader(Unmarshaller unmarshaller) {
        try {
            XMLReader xmlReader = parserFactory.newSAXParser().getXMLReader();
            xmlReader.setEntityResolver(emptyResolver);
            xmlReader.setContentHandler(unmarshaller);
            return xmlReader;
        }
        catch (Exception e1) {
            throw new IllegalStateException(e1);
        }
    }

    private static void setFeature(SAXParserFactory parserFactory, String feature, boolean enablement) {
        try {
            parserFactory.setFeature(feature, enablement);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public static Object parse(InputSource input) throws IOException, SAXException {
        Unmarshaller unmarshaller = new Unmarshaller();
        XMLReader xmlReader = Unmarshaller.createXMLReader(unmarshaller);
        xmlReader.parse(input);
        return unmarshaller.getModel();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.computeHandler(localName);
        this.currentHandler.startElement(uri, localName, attributes);
    }

    private void computeHandler(String localName) {
        if (this.currentHandler == null) {
            this.currentHandler = this.getHandler(localName);
            if (this.currentHandler == null) {
                this.currentHandler = new DefaultContentHandler();
            }
            this.currentHandler.setUnmarshaller(this);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentHandler.endElement(uri, localName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentHandler != null) {
            this.currentHandler.characters(ch, start, length);
        }
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    protected UnmarshalContentHandler getCurrentHandler() {
        return this.currentHandler;
    }

    protected void setCurrentHandler(UnmarshalContentHandler currentHandler) {
        this.currentHandler = currentHandler;
    }

    public UnmarshalContentHandler getHandler(String localName) {
        return this.elementNameToUnmarshalContentHandler.get(localName);
    }
}

