/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.internal.models.rcp.RepositoryDetailsDialog;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.utils.Uris;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;

public class ModelRepositoriesFieldEditor
extends FieldEditor {
    private TableViewer tableViewer;
    private Composite buttonBox;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private final ModelsRcpPreferences preferences;
    private final SharedImages images;

    public ModelRepositoriesFieldEditor(String name, Composite parent, ModelsRcpPreferences preferences, SharedImages images) {
        super(name, Messages.FIELD_LABEL_REPOSITORY_URIS, parent);
        this.preferences = preferences;
        this.images = images;
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridDataFactory.swtDefaults().span(numColumns, 1).applyTo((Control)control);
        this.tableViewer = this.getTableControl(parent);
        GridDataFactory.fillDefaults().align(4, 4).span(numColumns - 1, 1).grab(true, true).applyTo((Control)this.tableViewer.getTable());
        this.buttonBox = this.getButtonControl(parent);
        this.updateButtonStatus();
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buttonBox);
    }

    private TableViewer getTableControl(Composite parent) {
        final TableViewer tableViewer = new TableViewer(parent, 67584);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String repositoryUrl = (String)element;
                URI uri = (URI)Uris.parseURI((String)repositoryUrl).orNull();
                if (uri == null) {
                    return repositoryUrl;
                }
                return Uris.toStringWithMaskedPassword((URI)uri, (char)'*');
            }

            public Image getImage(Object element) {
                String repositoryUrl = (String)element;
                URI uri = (URI)Uris.parseURI((String)repositoryUrl).orNull();
                if (uri == null) {
                    return ModelRepositoriesFieldEditor.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_REPOSITORY);
                }
                if (Uris.isPasswordProtected((URI)uri)) {
                    return ModelRepositoriesFieldEditor.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_LOCKED_REPOSITORY);
                }
                if (ModelRepositoriesFieldEditor.this.preferences.hasPassword(repositoryUrl)) {
                    return ModelRepositoriesFieldEditor.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_LOCKED_REPOSITORY);
                }
                return ModelRepositoriesFieldEditor.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_REPOSITORY);
            }
        });
        tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelRepositoriesFieldEditor.this.updateButtonStatus();
            }
        });
        tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                boolean isClickOnCheckbox;
                TableItem item = tableViewer.getTable().getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                Rectangle bounds = item.getBounds();
                boolean bl = isClickOnCheckbox = e.x < bounds.x;
                if (isClickOnCheckbox) {
                    return;
                }
                String selectedRepository = ModelRepositoriesFieldEditor.this.getSelectedRepository();
                ModelRepositoriesFieldEditor.this.editRepository(selectedRepository);
                ModelRepositoriesFieldEditor.this.updateButtonStatus();
            }
        });
        return tableViewer;
    }

    private Composite getButtonControl(Composite parent) {
        Composite box = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(box);
        this.addButton = this.createButton(box, Messages.PREFPAGE_BUTTON_ADD);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelRepositoriesFieldEditor.this.addNewRepository();
                ModelRepositoriesFieldEditor.this.updateButtonStatus();
            }
        });
        this.editButton = this.createButton(box, Messages.PREFPAGE_BUTTON_EDIT);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelRepositoriesFieldEditor.this.editRepository(ModelRepositoriesFieldEditor.this.getSelectedRepository());
                ModelRepositoriesFieldEditor.this.updateButtonStatus();
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = this.createButton(box, Messages.PREFPAGE_BUTTON_REMOVE);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelRepositoriesFieldEditor.this.removeRepository(ModelRepositoriesFieldEditor.this.getSelectedRepository());
                ModelRepositoriesFieldEditor.this.updateButtonStatus();
            }
        });
        this.upButton = this.createButton(box, Messages.PREFPAGE_BUTTON_UP);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelRepositoriesFieldEditor.this.moveRepositoryUp(ModelRepositoriesFieldEditor.this.getSelectedRepository());
                ModelRepositoriesFieldEditor.this.updateButtonStatus();
            }
        });
        this.downButton = this.createButton(box, Messages.PREFPAGE_BUTTON_DOWN);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelRepositoriesFieldEditor.this.moveRepositoryDown(ModelRepositoriesFieldEditor.this.getSelectedRepository());
                ModelRepositoriesFieldEditor.this.updateButtonStatus();
            }
        });
        return box;
    }

    private String getSelectedRepository() {
        List<String> tableInput = this.getTableViewerInput();
        if (tableInput == null) {
            return null;
        }
        int index = this.tableViewer.getTable().getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return tableInput.get(index);
    }

    private List<String> getTableViewerInput() {
        return (List)this.tableViewer.getInput();
    }

    private void updateButtonStatus() {
        int selectionIndex = this.tableViewer.getTable().getSelectionIndex();
        String selectedRepository = this.getSelectedRepository();
        if (selectedRepository == null) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        this.editButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.upButton.setEnabled(selectionIndex > 0);
        this.downButton.setEnabled(selectionIndex < this.tableViewer.getTable().getItemCount() - 1);
    }

    private void removeRepository(String selectedRepository) {
        List<String> list = this.getTableViewerInput();
        list.remove(selectedRepository);
        this.tableViewer.refresh();
    }

    private void addNewRepository() {
        RepositoryDetailsDialog newRepositoryDialog = new RepositoryDetailsDialog(null, null, this.getTableViewerInput(), this.preferences);
        if (newRepositoryDialog.open() == 0) {
            String newRepositoryUrl = newRepositoryDialog.getRepositoryUrl();
            List<String> list = this.getTableViewerInput();
            list.add(newRepositoryUrl);
            this.tableViewer.refresh();
        }
    }

    private void editRepository(String selectedRepository) {
        RepositoryDetailsDialog editRepositoryDialog = new RepositoryDetailsDialog(null, selectedRepository, this.getTableViewerInput(), this.preferences);
        if (editRepositoryDialog.open() == 0) {
            String updatedRepositoryUrl = editRepositoryDialog.getRepositoryUrl();
            List<String> list = this.getTableViewerInput();
            int indexOfOriginalRepository = list.indexOf(selectedRepository);
            list.remove(indexOfOriginalRepository);
            list.add(indexOfOriginalRepository, updatedRepositoryUrl);
            this.tableViewer.refresh();
        }
    }

    private void moveRepositoryUp(String selectedRepository) {
        List<String> list = this.getTableViewerInput();
        int indexOfRepository = list.indexOf(selectedRepository);
        list.remove(indexOfRepository);
        list.add(indexOfRepository - 1, selectedRepository);
        this.tableViewer.refresh();
    }

    private void moveRepositoryDown(String selectedRepository) {
        List<String> list = this.getTableViewerInput();
        int indexOfRepository = list.indexOf(selectedRepository);
        list.remove(indexOfRepository);
        list.add(indexOfRepository + 1, selectedRepository);
        this.tableViewer.refresh();
    }

    private Button createButton(Composite box, String text) {
        Button button = new Button(box, 8);
        button.setText(text);
        int widthHint = Math.max(this.convertHorizontalDLUsToPixels((Control)button, 61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
        GridDataFactory.swtDefaults().align(4, 0x1000000).hint(widthHint, -1).applyTo((Control)button);
        return button;
    }

    protected void doLoad() {
        this.tableViewer.setInput((Object)Lists.newArrayList((Object[])this.preferences.remotes));
    }

    protected void doLoadDefault() {
        String defaultRemotes = this.getPreferenceStore().getDefaultString("repository.url.list");
        this.tableViewer.setInput((Object)Lists.newArrayList((Object[])ModelsRcpPreferences.splitRemoteRepositoryString(defaultRemotes)));
    }

    protected void doStore() {
        List<String> repositories = this.getTableViewerInput();
        this.getPreferenceStore().setValue("repository.url.list", ModelsRcpPreferences.joinRemoteRepositoriesToString(repositories));
    }

    public int getNumberOfControls() {
        return 2;
    }
}

