/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.HyperlinkDetectorRegistry;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class TextSourceViewerConfiguration
extends SourceViewerConfiguration {
    protected IPreferenceStore fPreferenceStore;

    public TextSourceViewerConfiguration() {
    }

    public TextSourceViewerConfiguration(IPreferenceStore preferenceStore) {
        this.fPreferenceStore = preferenceStore;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return TextSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    protected boolean isShowInVerticalRuler(Annotation annotation) {
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return true;
        }
        String key = preference.getVerticalRulerPreferenceKey();
        return key == null || this.fPreferenceStore.getBoolean(key);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover(true){

            protected boolean isIncluded(Annotation annotation) {
                return TextSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    protected boolean isShowInOverviewRuler(Annotation annotation) {
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return true;
        }
        String key = preference.getOverviewRulerPreferenceKey();
        return key != null && this.fPreferenceStore.getBoolean(key);
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        return new int[]{255};
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new TextHover(sourceViewer);
    }

    protected boolean isShownInText(Annotation annotation) {
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return false;
        }
        String key = preference.getTextPreferenceKey();
        return !(key != null ? !this.fPreferenceStore.getBoolean(key) : (key = preference.getHighlightPreferenceKey()) == null || !this.fPreferenceStore.getBoolean(key));
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation == null || this.fPreferenceStore == null) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.fPreferenceStore.getInt("tabWidth");
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        String[] indentPrefixes = this.getIndentPrefixesForTab(this.getTabWidth(sourceViewer));
        if (indentPrefixes == null) {
            return null;
        }
        int length = indentPrefixes.length;
        if (length > 2 && this.fPreferenceStore != null && this.fPreferenceStore.getBoolean("spacesForTabs")) {
            String first = indentPrefixes[0];
            indentPrefixes[0] = indentPrefixes[length - 2];
            indentPrefixes[length - 2] = first;
        }
        return indentPrefixes;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || this.fPreferenceStore == null) {
            return super.getHyperlinkDetectors(sourceViewer);
        }
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        return this.getRegisteredHyperlinkDetectors(sourceViewer);
    }

    protected final IHyperlinkDetector[] getRegisteredHyperlinkDetectors(ISourceViewer sourceViewer) {
        HyperlinkDetectorRegistry registry = EditorsUI.getHyperlinkDetectorRegistry();
        Map<String, IAdaptable> targets = this.getHyperlinkDetectorTargets(sourceViewer);
        Assert.isNotNull(targets);
        IHyperlinkDetector[] result = null;
        for (Map.Entry<String, IAdaptable> target : targets.entrySet()) {
            String targetId = target.getKey();
            IAdaptable context = target.getValue();
            result = this.merge(result, registry.createHyperlinkDetectors(targetId, context));
        }
        return result;
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        HashMap<String, IAdaptable> targets = new HashMap<String, IAdaptable>();
        targets.put("org.eclipse.ui.DefaultTextEditor", null);
        return targets;
    }

    public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getHyperlinkStateMask(sourceViewer);
        }
        String modifiers = this.fPreferenceStore.getString("hyperlinkKeyModifier");
        int modifierMask = TextSourceViewerConfiguration.computeStateMask(modifiers);
        if (modifierMask == -1) {
            modifierMask = this.fPreferenceStore.getInt("hyperlinkKeyModifierMask");
        }
        return modifierMask;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return new MultipleHyperlinkPresenter(new RGB(0, 0, 255));
        }
        return new MultipleHyperlinkPresenter(this.fPreferenceStore);
    }

    protected static final int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    protected static final int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = TextSourceViewerConfiguration.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.contains("undoHistorySize")) {
            return super.getUndoManager(sourceViewer);
        }
        int undoHistorySize = this.fPreferenceStore.getInt("undoHistorySize");
        return new TextViewerUndoManager(undoHistorySize);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingService spellingService = EditorsUI.getSpellingService();
        if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) == null) {
            return null;
        }
        SpellingReconcileStrategy strategy = new SpellingReconcileStrategy(sourceViewer, spellingService);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        reconciler.setDelay(500);
        return reconciler;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        assistant.setQuickAssistProcessor((IQuickAssistProcessor)new SpellingCorrectionProcessor());
        assistant.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
        assistant.setInformationControlCreator(this.getQuickAssistAssistantInformationControlCreator());
        return assistant;
    }

    private IInformationControlCreator getQuickAssistAssistantInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, EditorsPlugin.getAdditionalInfoAffordanceString());
            }
        };
    }

    private IHyperlinkDetector[] merge(IHyperlinkDetector[] array1, IHyperlinkDetector[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null) {
            return array2;
        }
        if (array2 == null) {
            return array1;
        }
        int size = array1.length + array2.length;
        IHyperlinkDetector[] allHyperlinkDetectors = new IHyperlinkDetector[size];
        System.arraycopy(array1, 0, allHyperlinkDetectors, 0, array1.length);
        System.arraycopy(array2, 0, allHyperlinkDetectors, array1.length, array2.length);
        return allHyperlinkDetectors;
    }

    private final class TextHover
    extends DefaultTextHover
    implements ITextHoverExtension {
        public TextHover(ISourceViewer sourceViewer) {
            super(sourceViewer);
        }

        protected boolean isIncluded(Annotation annotation) {
            return TextSourceViewerConfiguration.this.isShownInText(annotation);
        }

        public IInformationControlCreator getHoverControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
                }
            };
        }
    }
}

