/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class CachingTokenFilter
extends TokenFilter {
    private List cache;
    private Iterator iterator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CachingTokenFilter(TokenStream input) {
        super(input);
    }

    public Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        if (this.cache == null) {
            this.cache = new LinkedList();
            this.fillCache(reusableToken);
            this.iterator = this.cache.iterator();
        }
        if (!this.iterator.hasNext()) {
            return null;
        }
        Token nextToken = (Token)this.iterator.next();
        return (Token)nextToken.clone();
    }

    public void reset() throws IOException {
        if (this.cache != null) {
            this.iterator = this.cache.iterator();
        }
    }

    private void fillCache(Token reusableToken) throws IOException {
        Token nextToken = this.input.next(reusableToken);
        while (nextToken != null) {
            this.cache.add(nextToken.clone());
            nextToken = this.input.next(reusableToken);
        }
    }

    static {
        $assertionsDisabled = !CachingTokenFilter.class.desiredAssertionStatus();
    }
}

