/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineFilterProcessor;

public class ConfigurableContentOutlinePage
extends ContentOutlinePage
implements IAdaptable {
    protected static final ContentOutlineConfiguration NULL_CONFIGURATION = new ContentOutlineConfiguration(){

        public IContentProvider getContentProvider(TreeViewer viewer) {
            return new ITreeContentProvider(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void dispose() {
                }

                public Object[] getChildren(Object parentElement) {
                    return null;
                }

                public Object[] getElements(Object inputElement) {
                    return null;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
        }
    };
    private static final String OUTLINE_CONTEXT_MENU_ID = "org.eclipse.wst.sse.ui.StructuredTextEditor.OutlineContext";
    private static final String OUTLINE_CONTEXT_MENU_SUFFIX = ".source.OutlineContext";
    private static final boolean _DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/contentOutline"));
    private long _DEBUG_TIME = 0L;
    private TransferDragSourceListener[] fActiveDragListeners;
    private TransferDropTargetListener[] fActiveDropListeners;
    private ContentOutlineConfiguration fConfiguration;
    private Menu fContextMenu;
    private String fContextMenuId;
    private MenuManager fContextMenuManager;
    private DoubleClickProvider fDoubleClickProvider = null;
    private DelegatingDragAdapter fDragAdapter;
    private DragSource fDragSource;
    private DelegatingDropAdapter fDropAdapter;
    private DropTarget fDropTarget;
    private IEditorPart fEditor;
    private IMenuListener fGroupAdder = new AdditionGroupAdder();
    private Object fInput = null;
    private String fInputContentTypeIdentifier = null;
    private ISelectionListener fSelectionListener = null;
    SelectionProvider fSelectionProvider = new SelectionProvider();
    boolean fIsReceivingSelection;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void addDoubleClickListener(IDoubleClickListener newListener) {
        if (this.fDoubleClickProvider == null) {
            this.fDoubleClickProvider = new DoubleClickProvider();
        }
        this.fDoubleClickProvider.addDoubleClickListener(newListener);
    }

    private String computeContextMenuID() {
        String id = null;
        if (this.fInputContentTypeIdentifier != null) {
            id = String.valueOf(this.fInputContentTypeIdentifier) + OUTLINE_CONTEXT_MENU_SUFFIX;
        }
        return id;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
        if (page != null) {
            this.fEditor = page.getActiveEditor();
        }
        this.fDragAdapter = new DelegatingDragAdapter();
        this.fDragSource = new DragSource(this.getControl(), 3);
        this.fDropAdapter = new DelegatingDropAdapter();
        this.fDropTarget = new DropTarget(this.getControl(), 3);
        this.setConfiguration(this.getConfiguration());
        this.getTreeViewer().addPostSelectionChangedListener(this.fSelectionProvider.getPostSelectionChangedListener());
        this.getTreeViewer().addSelectionChangedListener(this.fSelectionProvider.getSelectionChangedListener());
        if (this.fDoubleClickProvider == null) {
            this.fDoubleClickProvider = new DoubleClickProvider();
        }
        this.getTreeViewer().addDoubleClickListener((IDoubleClickListener)this.fDoubleClickProvider);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.getSelectionServiceListener());
        if (this.fDoubleClickProvider != null) {
            this.getTreeViewer().removeDoubleClickListener((IDoubleClickListener)this.fDoubleClickProvider);
        }
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        if (this.fContextMenuManager != null) {
            this.fContextMenuManager.removeMenuListener(this.fGroupAdder);
            this.fContextMenuManager.removeAll();
            this.fContextMenuManager.dispose();
        }
        this.fDropTarget.dispose();
        this.fDragSource.dispose();
        IStatusLineManager statusLineManager = this.getSite().getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            statusLineManager.setMessage(null);
        }
        this.unconfigure();
        super.dispose();
    }

    public Object getAdapter(Class key) {
        Object adapter = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            adapter = new ShowInTarget();
        } else {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.ui.part.IShowInSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (key.equals(clazz2)) {
                adapter = new ShowInSource();
            } else {
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (key.equals(clazz3) && this.fEditor != null) {
                    adapter = this.fEditor.getAdapter(key);
                }
            }
        }
        return adapter;
    }

    public ContentOutlineConfiguration getConfiguration() {
        if (this.fConfiguration == null) {
            this.fConfiguration = NULL_CONFIGURATION;
        }
        return this.fConfiguration;
    }

    public ISelection getSelection() {
        return this.fSelectionProvider.getSelection();
    }

    ISelectionListener getSelectionServiceListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new PostSelectionServiceListener();
        }
        return this.fSelectionListener;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.getSelectionServiceListener());
    }

    public void removeDoubleClickListener(IDoubleClickListener oldListener) {
        if (this.fDoubleClickProvider != null) {
            this.fDoubleClickProvider.removeDoubleClickListener(oldListener);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.fIsReceivingSelection) {
            super.selectionChanged(event);
        }
    }

    public void setConfiguration(ContentOutlineConfiguration configuration) {
        this.unconfigure();
        this.fConfiguration = configuration;
        if (this.getTreeViewer() != null && this.getControl() != null && !this.getControl().isDisposed()) {
            KeyListener[] listeners;
            int i;
            IContributionItem[] menuItems;
            IMenuManager menu;
            IContributionItem[] toolbarItems;
            ILabelProvider labelProvider = this.getConfiguration().getLabelProvider(this.getTreeViewer());
            if (labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
                this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider));
            } else {
                this.getTreeViewer().setLabelProvider((IBaseLabelProvider)labelProvider);
            }
            this.getTreeViewer().setContentProvider(this.getConfiguration().getContentProvider(this.getTreeViewer()));
            IToolBarManager toolbar = this.getSite().getActionBars().getToolBarManager();
            if (toolbar != null && (toolbarItems = this.getConfiguration().getToolbarContributions(this.getTreeViewer())) != null) {
                int i2 = 0;
                while (i2 < toolbarItems.length) {
                    toolbar.add(toolbarItems[i2]);
                    ++i2;
                }
                toolbar.update(true);
            }
            if ((menu = this.getSite().getActionBars().getMenuManager()) != null && (menuItems = this.getConfiguration().getMenuContributions(this.getTreeViewer())) != null) {
                i = 0;
                while (i < menuItems.length) {
                    menuItems[i].setVisible(true);
                    menu.add(menuItems[i]);
                    menuItems[i].update();
                    ++i;
                }
                menu.update(true);
            }
            TransferDragSourceListener[] dragListeners = this.getConfiguration().getTransferDragSourceListeners(this.getTreeViewer());
            if (this.fDragAdapter != null && dragListeners.length > 0) {
                i = 0;
                while (i < dragListeners.length) {
                    this.fDragAdapter.addDragSourceListener(dragListeners[i]);
                    ++i;
                }
                this.fActiveDragListeners = dragListeners;
                this.fDragSource.addDragListener((DragSourceListener)this.fDragAdapter);
                this.fDragSource.setTransfer(this.fDragAdapter.getTransfers());
            }
            TransferDropTargetListener[] dropListeners = this.getConfiguration().getTransferDropTargetListeners(this.getTreeViewer());
            if (this.fDropAdapter != null && dropListeners.length > 0) {
                int i3 = 0;
                while (i3 < dropListeners.length) {
                    this.fDropAdapter.addDropTargetListener(dropListeners[i3]);
                    ++i3;
                }
                this.fActiveDropListeners = dropListeners;
                this.fDropTarget.addDropListener((DropTargetListener)this.fDropAdapter);
                this.fDropTarget.setTransfer(this.fDropAdapter.getTransfers());
            }
            if ((listeners = this.getConfiguration().getKeyListeners(this.getTreeViewer())) != null) {
                int i4 = 0;
                while (i4 < listeners.length) {
                    this.getControl().addKeyListener(listeners[i4]);
                    ++i4;
                }
            }
        }
        if (this.fInput != null) {
            this.setInput(this.fInput);
        }
    }

    private void unconfigure() {
        if (this.getTreeViewer() != null) {
            IContributionItem[] menuItems;
            IMenuManager menubar;
            IContributionItem[] toolbarItems;
            IToolBarManager toolbar;
            KeyListener[] listeners;
            if (this.getControl() != null && !this.getControl().isDisposed() && (listeners = this.getConfiguration().getKeyListeners(this.getTreeViewer())) != null) {
                int i = 0;
                while (i < listeners.length) {
                    this.getControl().removeKeyListener(listeners[i]);
                    ++i;
                }
            }
            if ((toolbar = this.getSite().getActionBars().getToolBarManager()) != null && !toolbar.isEmpty() && (toolbarItems = this.getConfiguration().getToolbarContributions(this.getTreeViewer())) != null && toolbarItems.length > 0) {
                int i = 0;
                while (i < toolbarItems.length) {
                    toolbar.remove(toolbarItems[i]);
                    ++i;
                }
                toolbar.update(false);
            }
            if ((menubar = this.getSite().getActionBars().getMenuManager()) != null && !menubar.isEmpty() && (menuItems = this.getConfiguration().getMenuContributions(this.getTreeViewer())) != null && menuItems.length > 0) {
                int i = 0;
                while (i < menuItems.length) {
                    menubar.remove(menuItems[i]);
                    ++i;
                }
                menubar.remove("additions");
                menubar.update(false);
            }
            if (this.fDragAdapter != null && !this.fDragAdapter.isEmpty() && this.fDragSource != null && !this.fDragSource.isDisposed() && this.fDragSource.getTransfer().length > 0) {
                if (this.fActiveDragListeners != null) {
                    int i = 0;
                    while (i < this.fActiveDragListeners.length) {
                        this.fDragAdapter.removeDragSourceListener(this.fActiveDragListeners[i]);
                        ++i;
                    }
                }
                this.fActiveDragListeners = null;
                this.fDragSource.removeDragListener((DragSourceListener)this.fDragAdapter);
                this.fDragSource.setTransfer(new Transfer[0]);
            }
            if (this.fDropAdapter != null && !this.fDropAdapter.isEmpty() && this.fDropTarget != null && !this.fDropTarget.isDisposed() && this.fDropTarget.getTransfer().length > 0) {
                if (this.fActiveDropListeners != null) {
                    int i = 0;
                    while (i < this.fActiveDropListeners.length) {
                        this.fDropAdapter.removeDropTargetListener(this.fActiveDropListeners[i]);
                        ++i;
                    }
                }
                this.fActiveDropListeners = null;
                this.fDropTarget.removeDropListener((DropTargetListener)this.fDropAdapter);
                this.fDropTarget.setTransfer(new Transfer[0]);
            }
            this.getConfiguration().getContentProvider(this.getTreeViewer()).inputChanged((Viewer)this.getTreeViewer(), this.fInput, null);
            this.getConfiguration().unconfigure(this.getTreeViewer());
        }
    }

    public void setEditorPart(IEditorPart editor) {
        this.fEditor = editor;
    }

    public void setInput(Object newInput) {
        this.fInput = newInput;
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getTreeViewer().setInput(this.fInput);
            this.updateContextMenuId();
        }
    }

    public void setInputContentTypeIdentifier(String id) {
        this.fInputContentTypeIdentifier = id;
    }

    private void updateContextMenuId() {
        IWorkbenchPage page;
        String computedContextMenuId = null;
        if (this.fEditor == null && (page = this.getSite().getWorkbenchWindow().getActivePage()) != null) {
            this.fEditor = page.getActiveEditor();
        }
        if ((computedContextMenuId = this.computeContextMenuID()) == null) {
            computedContextMenuId = OUTLINE_CONTEXT_MENU_ID;
        }
        if (!computedContextMenuId.equals(this.fContextMenuId) || this.fContextMenu == null) {
            this.fContextMenuId = computedContextMenuId;
            if (this.getControl() != null && !this.getControl().isDisposed()) {
                String partId;
                if (this.fContextMenu != null) {
                    this.fContextMenu.dispose();
                }
                if (this.fContextMenuManager != null) {
                    this.fContextMenuManager.removeMenuListener(this.fGroupAdder);
                    this.fContextMenuManager.removeAll();
                    this.fContextMenuManager.dispose();
                }
                this.fContextMenuManager = new MenuManager(this.fContextMenuId, this.fContextMenuId);
                this.fContextMenuManager.setRemoveAllWhenShown(true);
                this.fContextMenuManager.addMenuListener(this.fGroupAdder);
                this.fContextMenu = this.fContextMenuManager.createContextMenu(this.getControl());
                this.getControl().setMenu(this.fContextMenu);
                this.getSite().registerContextMenu(this.fContextMenuId, this.fContextMenuManager, (ISelectionProvider)this);
                if (this.fEditor != null && this.fEditor.getSite() != null && (partId = this.fEditor.getSite().getId()) != null) {
                    this.getSite().registerContextMenu(String.valueOf(partId) + OUTLINE_CONTEXT_MENU_SUFFIX, this.fContextMenuManager, (ISelectionProvider)this);
                }
                this.getSite().registerContextMenu(OUTLINE_CONTEXT_MENU_ID, this.fContextMenuManager, (ISelectionProvider)this);
            }
        }
    }

    void updateStatusLine(IStatusLineManager mgr, ISelection selection) {
        String text = null;
        Image image = null;
        ILabelProvider statusLineLabelProvider = this.getConfiguration().getStatusLineLabelProvider(this.getTreeViewer());
        if (statusLineLabelProvider != null && selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            text = statusLineLabelProvider.getText(firstElement);
            image = statusLineLabelProvider.getImage(firstElement);
        }
        if (image == null) {
            mgr.setMessage(text);
        } else {
            mgr.setMessage(image, text);
        }
    }

    public ContentOutlineFilterProcessor getOutlineFilterProcessor() {
        return this.getConfiguration().getOutlineFilterProcessor(this.getTreeViewer());
    }

    class AdditionGroupAdder
    implements IMenuListener {
        AdditionGroupAdder() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            IContributionItem[] items = manager.getItems();
            IMenuListener listener = ConfigurableContentOutlinePage.this.getConfiguration().getMenuListener(ConfigurableContentOutlinePage.this.getTreeViewer());
            if (listener != null) {
                listener.menuAboutToShow(manager);
                manager.add((IContributionItem)new Separator());
            }
            if (items.length > 0 && items[items.length - 1].getId() != null) {
                manager.insertAfter(items[items.length - 1].getId(), (IContributionItem)new GroupMarker("additions"));
            } else {
                manager.add((IContributionItem)new GroupMarker("additions"));
            }
        }
    }

    class DoubleClickProvider
    implements IDoubleClickListener {
        private IDoubleClickListener[] listeners = null;

        DoubleClickProvider() {
        }

        void addDoubleClickListener(IDoubleClickListener newListener) {
            if (this.listeners == null) {
                this.listeners = new IDoubleClickListener[]{newListener};
            } else {
                IDoubleClickListener[] newListeners = new IDoubleClickListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
                newListeners[this.listeners.length] = newListener;
                this.listeners = newListeners;
            }
        }

        public void doubleClick(DoubleClickEvent event) {
            this.fireDoubleClickEvent(event);
        }

        private void fireDoubleClickEvent(DoubleClickEvent event) {
            IDoubleClickListener[] firingListeners = this.listeners;
            int i = 0;
            while (i < firingListeners.length) {
                IDoubleClickListener l = firingListeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(this, l, event){
                    final /* synthetic */ DoubleClickProvider this$1;
                    private final /* synthetic */ IDoubleClickListener val$l;
                    private final /* synthetic */ DoubleClickEvent val$event;
                    {
                        this.this$1 = doubleClickProvider;
                        this.val$l = iDoubleClickListener;
                        this.val$event = doubleClickEvent;
                    }

                    public void run() {
                        this.val$l.doubleClick(this.val$event);
                    }
                });
                ++i;
            }
        }

        void removeDoubleClickListener(IDoubleClickListener oldListener) {
            if (this.listeners != null) {
                if (this.listeners.length == 1 && this.listeners[0].equals(oldListener)) {
                    this.listeners = null;
                } else {
                    ArrayList<IDoubleClickListener> newListeners = new ArrayList<IDoubleClickListener>(Arrays.asList(this.listeners));
                    newListeners.remove(oldListener);
                    this.listeners = newListeners.toArray(new IDoubleClickListener[this.listeners.length - 1]);
                }
            }
        }
    }

    class PostSelectionServiceListener
    implements ISelectionListener {
        PostSelectionServiceListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            block12: {
                block11: {
                    if (_DEBUG) {
                        ConfigurableContentOutlinePage.this._DEBUG_TIME = System.currentTimeMillis();
                    }
                    if (part == null) break block11;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    if (part.getAdapter((Class)clazz) != ConfigurableContentOutlinePage.this) break block12;
                }
                ISelection validContentSelection = ConfigurableContentOutlinePage.this.getConfiguration().getSelection(ConfigurableContentOutlinePage.this.getTreeViewer(), selection);
                boolean isLinked = ConfigurableContentOutlinePage.this.getConfiguration().isLinkedWithEditor(ConfigurableContentOutlinePage.this.getTreeViewer());
                if (isLinked && !ConfigurableContentOutlinePage.this.getTreeViewer().getSelection().equals(validContentSelection)) {
                    try {
                        ConfigurableContentOutlinePage.this.fIsReceivingSelection = true;
                        ConfigurableContentOutlinePage.this.getTreeViewer().setSelection(validContentSelection, true);
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        ConfigurableContentOutlinePage.this.fIsReceivingSelection = false;
                        throw throwable;
                    }
                    {
                        Object var5_7 = null;
                        ConfigurableContentOutlinePage.this.fIsReceivingSelection = false;
                    }
                }
            }
            if (_DEBUG) {
                System.out.println("(O:" + (System.currentTimeMillis() - ConfigurableContentOutlinePage.this._DEBUG_TIME) + "ms) " + part + " : " + selection);
            }
        }
    }

    private class SelectionProvider
    implements IPostSelectionProvider {
        private boolean isFiringSelection = false;
        private ListenerList listeners = new ListenerList();
        private ListenerList postListeners = new ListenerList();
        private ISelectionChangedListener postSelectionChangedListener = new PostSelectionChangedListener();
        private ISelectionChangedListener selectionChangedListener = new SelectionChangedListener();

        private SelectionProvider() {
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postListeners.add((Object)listener);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add((Object)listener);
        }

        public void fireSelectionChanged(SelectionChangedEvent event, ListenerList listenerList) {
            this.isFiringSelection = true;
            Object[] listeners = listenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(this, l, event){
                    final /* synthetic */ SelectionProvider this$1;
                    private final /* synthetic */ ISelectionChangedListener val$l;
                    private final /* synthetic */ SelectionChangedEvent val$event;
                    {
                        this.this$1 = selectionProvider;
                        this.val$l = iSelectionChangedListener;
                        this.val$event = selectionChangedEvent;
                    }

                    public void run() {
                        this.val$l.selectionChanged(this.val$event);
                    }
                });
                ++i;
            }
            this.isFiringSelection = false;
        }

        public ISelectionChangedListener getPostSelectionChangedListener() {
            return this.postSelectionChangedListener;
        }

        public ISelection getSelection() {
            if (ConfigurableContentOutlinePage.this.getTreeViewer() != null) {
                return ConfigurableContentOutlinePage.this.getTreeViewer().getSelection();
            }
            return StructuredSelection.EMPTY;
        }

        public ISelectionChangedListener getSelectionChangedListener() {
            return this.selectionChangedListener;
        }

        public boolean isFiringSelection() {
            return this.isFiringSelection;
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postListeners.remove((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            if (!this.isFiringSelection) {
                ConfigurableContentOutlinePage.this.getTreeViewer().setSelection(selection);
            }
        }

        private class PostSelectionChangedListener
        implements ISelectionChangedListener {
            private PostSelectionChangedListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (!SelectionProvider.this.isFiringSelection() && !((SelectionProvider)SelectionProvider.this).ConfigurableContentOutlinePage.this.fIsReceivingSelection) {
                    SelectionProvider.this.fireSelectionChanged(event, SelectionProvider.this.postListeners);
                    ConfigurableContentOutlinePage.this.updateStatusLine(ConfigurableContentOutlinePage.this.getSite().getActionBars().getStatusLineManager(), event.getSelection());
                }
            }
        }

        private class SelectionChangedListener
        implements ISelectionChangedListener {
            private SelectionChangedListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (!SelectionProvider.this.isFiringSelection() && !((SelectionProvider)SelectionProvider.this).ConfigurableContentOutlinePage.this.fIsReceivingSelection) {
                    SelectionProvider.this.fireSelectionChanged(event, SelectionProvider.this.listeners);
                }
            }
        }
    }

    private class ShowInSource
    implements IShowInSource {
        private ShowInSource() {
        }

        public ShowInContext getShowInContext() {
            if (ConfigurableContentOutlinePage.this.fEditor != null && ConfigurableContentOutlinePage.this.fEditor.getEditorSite() != null) {
                return new ShowInContext((Object)ConfigurableContentOutlinePage.this.fEditor.getEditorInput(), ConfigurableContentOutlinePage.this.fEditor.getEditorSite().getSelectionProvider().getSelection());
            }
            return null;
        }
    }

    private class ShowInTarget
    implements IShowInTarget {
        private ShowInTarget() {
        }

        public boolean show(ShowInContext context) {
            ConfigurableContentOutlinePage.this.setSelection(context.getSelection());
            return ConfigurableContentOutlinePage.this.getTreeViewer().getSelection().equals(context.getSelection());
        }
    }
}

