/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.recommenders.internal.rcp.JavaElementSelections;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.rcp.Selections;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class JavaElementSelectionService
implements ISelectionListener {
    @VisibleForTesting
    protected ScheduledThreadPoolExecutor d = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("Recommenders-Timeout-Manager").build());
    private final EventBus bus;
    private JavaElementSelectionEvent lastEvent = new JavaElementSelectionEvent(null, null);
    volatile ISelection activeSelection;

    @Inject
    public JavaElementSelectionService(EventBus bus) {
        this.bus = bus;
        bus.register((Object)this);
    }

    @Subscribe
    public void onExternalJavaSelectionChange(JavaElementSelectionEvent newSelectionEvent) {
        this.lastEvent = newSelectionEvent;
    }

    public void selectionChanged(final IWorkbenchPart part, final ISelection nextSelection) {
        this.activeSelection = nextSelection;
        this.d.schedule(new Runnable(){

            @Override
            public void run() {
                if (JavaElementSelectionService.this.activeSelection != nextSelection) {
                    return;
                }
                if (nextSelection instanceof IStructuredSelection) {
                    JavaElementSelectionService.this.handleSelectionFromViewer(nextSelection);
                } else if (nextSelection instanceof ITextSelection && part instanceof JavaEditor) {
                    JavaElementSelectionService.this.handleSelectionInEditor(part, nextSelection);
                }
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }

    private void handleSelectionFromViewer(ISelection selection) {
        Optional element = Selections.safeFirstElement((ISelection)selection, IJavaElement.class);
        if (element.isPresent()) {
            JavaElementSelectionEvent.JavaElementSelectionLocation location = JavaElementSelections.resolveSelectionLocationFromJavaElement((IJavaElement)element.get());
            this.fireEventIfNew((IJavaElement)element.get(), location, null);
        }
    }

    private void fireEventIfNew(IJavaElement element, JavaElementSelectionEvent.JavaElementSelectionLocation location, ASTNode selectedNode) {
        JavaElementSelectionEvent event = new JavaElementSelectionEvent(element, location, selectedNode);
        if (!this.lastEvent.equals(event)) {
            this.lastEvent = event;
            this.bus.post((Object)event);
        }
    }

    private void handleSelectionInEditor(IWorkbenchPart part, ISelection selection) {
        ITextSelection textSelection;
        JavaEditor editor = (JavaEditor)Checks.cast((Object)part);
        Optional<IJavaElement> element = JavaElementSelections.resolveJavaElementFromEditor((IEditorPart)editor, textSelection = (ITextSelection)Checks.cast((Object)selection));
        if (element.isPresent()) {
            ASTNode node = (ASTNode)JdtUtils.findAstNodeFromEditorSelection(editor, textSelection).orNull();
            JavaElementSelectionEvent.JavaElementSelectionLocation location = JavaElementSelections.resolveSelectionLocationFromAstNode(node);
            this.fireEventIfNew((IJavaElement)element.get(), location, node);
        }
    }
}

