/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.ClasspathDescriptor;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.jdt.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaProjectConfigurator
extends AbstractProjectConfigurator {
    private static final IPath[] DEFAULT_INCLUSIONS = new IPath[0];
    private static final Logger log = LoggerFactory.getLogger(AbstractJavaProjectConfigurator.class);
    private static final String GOAL_COMPILE = "compile";
    private static final String GOAL_TESTCOMPILE = "testCompile";
    public static final String COMPILER_PLUGIN_ARTIFACT_ID = "maven-compiler-plugin";
    public static final String COMPILER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    protected static final List<String> SOURCES = Arrays.asList("1.1,1.2,1.3,1.4,1.5,5,1.6,6,1.7,7,1.8,8,1.9,9".split(","));
    protected static final List<String> TARGETS = Arrays.asList("1.1,1.2,1.3,1.4,jsr14,1.5,5,1.6,6,1.7,7,1.8,8,1.9,9".split(","));
    private static final String GOAL_RESOURCES = "resources";
    private static final String GOAL_TESTRESOURCES = "testResources";
    private static final String RESOURCES_PLUGIN_ARTIFACT_ID = "maven-resources-plugin";
    private static final String RESOURCES_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    protected static final LinkedHashMap<String, String> ENVIRONMENTS = new LinkedHashMap();
    protected static final String DEFAULT_COMPILER_LEVEL = "1.5";

    static {
        ENVIRONMENTS.put("1.1", "JRE-1.1");
        ENVIRONMENTS.put("1.2", "J2SE-1.2");
        ENVIRONMENTS.put("1.3", "J2SE-1.3");
        ENVIRONMENTS.put("1.4", "J2SE-1.4");
        ENVIRONMENTS.put(DEFAULT_COMPILER_LEVEL, "J2SE-1.5");
        ENVIRONMENTS.put("jsr14", "J2SE-1.5");
        ENVIRONMENTS.put("1.6", "JavaSE-1.6");
        ENVIRONMENTS.put("1.7", "JavaSE-1.7");
        ENVIRONMENTS.put("1.8", "JavaSE-1.8");
        ENVIRONMENTS.put("1.9", "JavaSE-9");
        ENVIRONMENTS.put("9", "JavaSE-9");
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = request.getProject();
        monitor.setTaskName(String.valueOf(Messages.AbstractJavaProjectConfigurator_task_name) + project.getName());
        this.addJavaNature(project, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        HashMap<String, String> options = new HashMap<String, String>();
        this.addJavaProjectOptions(options, request, monitor);
        ClasspathDescriptor classpath = new ClasspathDescriptor(javaProject);
        this.addProjectSourceFolders(classpath, request, monitor);
        String environmentId = this.getExecutionEnvironmentId(options);
        this.addJREClasspathContainer(classpath, environmentId);
        this.addMavenClasspathContainer(classpath);
        this.addCustomClasspathEntries(javaProject, classpath);
        this.invokeJavaProjectConfigurators(classpath, request, monitor);
        for (Map.Entry option : options.entrySet()) {
            javaProject.setOption((String)option.getKey(), (String)option.getValue());
        }
        IContainer classesFolder = this.getOutputLocation(request, project);
        javaProject.setRawClasspath(classpath.getEntries(), classesFolder.getFullPath(), monitor);
        MavenJdtPlugin.getDefault().getBuildpathManager().updateClasspath(project, monitor);
    }

    protected IContainer getOutputLocation(ProjectConfigurationRequest request, IProject project) {
        MavenProject mavenProject = request.getMavenProject();
        return this.getFolder(project, mavenProject.getBuild().getOutputDirectory());
    }

    protected String getExecutionEnvironmentId(Map<String, String> options) {
        return ENVIRONMENTS.get(options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"));
    }

    protected void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        AbstractJavaProjectConfigurator.addNature((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
    }

    protected void addCustomClasspathEntries(IJavaProject javaProject, IClasspathDescriptor classpath) throws JavaModelException {
    }

    protected void invokeJavaProjectConfigurators(IClasspathDescriptor classpath, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = request.getMavenProjectFacade();
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        ILifecycleMapping lifecycleMapping = configurationManager.getLifecycleMapping(facade);
        if (lifecycleMapping == null) {
            return;
        }
        for (AbstractProjectConfigurator configurator : lifecycleMapping.getProjectConfigurators(facade, monitor)) {
            if (!(configurator instanceof IJavaProjectConfigurator)) continue;
            ((IJavaProjectConfigurator)configurator).configureRawClasspath(request, classpath, monitor);
        }
    }

    protected void addJREClasspathContainer(IClasspathDescriptor classpath, String environmentId) {
        IClasspathEntry cpe;
        IExecutionEnvironment executionEnvironment = this.getExecutionEnvironment(environmentId);
        if (executionEnvironment == null) {
            cpe = JavaRuntime.getDefaultJREContainerEntry();
        } else {
            IPath containerPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)executionEnvironment);
            cpe = JavaCore.newContainerEntry((IPath)containerPath);
        }
        IClasspathEntryDescriptor cped = classpath.replaceEntry(new IClasspathDescriptor.EntryFilter(){

            @Override
            public boolean accept(IClasspathEntryDescriptor descriptor) {
                return JavaRuntime.JRE_CONTAINER.equals(descriptor.getPath().segment(0));
            }
        }, cpe);
        if (cped == null) {
            classpath.addEntry(cpe);
        }
    }

    private IExecutionEnvironment getExecutionEnvironment(String environmentId) {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = manager.getExecutionEnvironments();
        int n = iExecutionEnvironmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
            if (environment.getId().equals(environmentId)) {
                return environment;
            }
            ++n2;
        }
        return null;
    }

    protected void addMavenClasspathContainer(IClasspathDescriptor classpath) {
        List<IClasspathEntryDescriptor> descriptors = classpath.getEntryDescriptors();
        boolean isExported = false;
        for (IClasspathEntryDescriptor descriptor : descriptors) {
            if (!MavenClasspathHelpers.isMaven2ClasspathContainer(descriptor.getPath())) continue;
            isExported = descriptor.isExported();
            break;
        }
        IClasspathEntry cpe = MavenClasspathHelpers.getDefaultContainerEntry();
        IClasspathEntryDescriptor entryDescriptor = classpath.addEntry(cpe);
        entryDescriptor.setExported(isExported);
    }

    protected void addProjectSourceFolders(IClasspathDescriptor classpath, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        try {
            IProject project = request.getProject();
            MavenProject mavenProject = request.getMavenProject();
            IMavenProjectFacade projectFacade = request.getMavenProjectFacade();
            IFolder classes = this.getFolder(project, mavenProject.getBuild().getOutputDirectory());
            IFolder testClasses = this.getFolder(project, mavenProject.getBuild().getTestOutputDirectory());
            M2EUtils.createFolder((IFolder)classes, (boolean)true, (IProgressMonitor)mon.newChild(1));
            M2EUtils.createFolder((IFolder)testClasses, (boolean)true, (IProgressMonitor)mon.newChild(1));
            IPath[] inclusion = new IPath[]{};
            IPath[] exclusion = new IPath[]{};
            IPath[] inclusionTest = new IPath[]{};
            IPath[] exclusionTest = new IPath[]{};
            String mainSourceEncoding = null;
            String testSourceEncoding = null;
            String mainResourcesEncoding = null;
            String testResourcesEncoding = null;
            List<MojoExecution> executions = this.getCompilerMojoExecutions(request, (IProgressMonitor)mon.newChild(1));
            for (MojoExecution compile : executions) {
                if (!this.isCompileExecution(compile)) continue;
                mainSourceEncoding = (String)this.maven.getMojoParameterValue(mavenProject, compile, "encoding", String.class, monitor);
                try {
                    inclusion = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "includes", String[].class, monitor));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler inclusions, assuming defaults", (Throwable)ex);
                }
                try {
                    exclusion = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "excludes", String[].class, monitor));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler exclusions, assuming defaults", (Throwable)ex);
                }
            }
            for (MojoExecution compile : executions) {
                if (!this.isTestCompileExecution(compile)) continue;
                testSourceEncoding = (String)this.maven.getMojoParameterValue(mavenProject, compile, "encoding", String.class, monitor);
                try {
                    inclusionTest = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "testIncludes", String[].class, monitor));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler test inclusions, assuming defaults", (Throwable)ex);
                }
                try {
                    exclusionTest = this.toPaths((String[])this.maven.getMojoParameterValue(mavenProject, compile, "testExcludes", String[].class, monitor));
                }
                catch (CoreException ex) {
                    log.error("Failed to determine compiler test exclusions, assuming defaults", (Throwable)ex);
                }
            }
            for (MojoExecution resources : projectFacade.getMojoExecutions("org.apache.maven.plugins", RESOURCES_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_RESOURCES})) {
                mainResourcesEncoding = (String)this.maven.getMojoParameterValue(mavenProject, resources, "encoding", String.class, monitor);
            }
            for (MojoExecution resources : projectFacade.getMojoExecutions("org.apache.maven.plugins", RESOURCES_PLUGIN_ARTIFACT_ID, (IProgressMonitor)mon.newChild(1), new String[]{GOAL_TESTRESOURCES})) {
                testResourcesEncoding = (String)this.maven.getMojoParameterValue(mavenProject, resources, "encoding", String.class, monitor);
            }
            this.addSourceDirs(classpath, project, mavenProject.getCompileSourceRoots(), classes.getFullPath(), inclusion, exclusion, mainSourceEncoding, (IProgressMonitor)mon.newChild(1));
            this.addResourceDirs(classpath, project, mavenProject, mavenProject.getBuild().getResources(), classes.getFullPath(), mainResourcesEncoding, (IProgressMonitor)mon.newChild(1));
            this.addSourceDirs(classpath, project, mavenProject.getTestCompileSourceRoots(), testClasses.getFullPath(), inclusionTest, exclusionTest, testSourceEncoding, (IProgressMonitor)mon.newChild(1));
            this.addResourceDirs(classpath, project, mavenProject, mavenProject.getBuild().getTestResources(), testClasses.getFullPath(), testResourcesEncoding, (IProgressMonitor)mon.newChild(1));
        }
        finally {
            mon.done();
        }
    }

    protected boolean isTestCompileExecution(MojoExecution execution) {
        return GOAL_TESTCOMPILE.equals(execution.getGoal());
    }

    protected boolean isCompileExecution(MojoExecution execution) {
        return GOAL_COMPILE.equals(execution.getGoal());
    }

    private IPath[] toPaths(String[] values) {
        if (values == null) {
            return new IPath[0];
        }
        IPath[] paths = new IPath[values.length];
        int i = 0;
        while (i < values.length) {
            if (values[i] != null && !"".equals(values[i].trim())) {
                paths[i] = new Path(values[i]);
            }
            ++i;
        }
        return paths;
    }

    private void addSourceDirs(IClasspathDescriptor classpath, IProject project, List<String> sourceRoots, IPath outputPath, IPath[] inclusion, IPath[] exclusion, String sourceEncoding, IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < sourceRoots.size()) {
            IFolder sourceFolder = this.getFolder(project, sourceRoots.get(i));
            if (sourceFolder != null) {
                sourceFolder.refreshLocal(0, monitor);
                if (!sourceFolder.exists() || sourceFolder.getProject().equals((Object)project)) {
                    IClasspathEntryDescriptor enclosing;
                    if (sourceFolder.exists()) {
                        sourceFolder.setDefaultCharset(sourceEncoding, monitor);
                    }
                    if ((enclosing = this.getEnclosingEntryDescriptor(classpath, sourceFolder.getFullPath())) == null || this.getEntryDescriptor(classpath, sourceFolder.getFullPath()) != null) {
                        log.info("Adding source folder " + sourceFolder.getFullPath());
                        classpath.addSourceEntry(sourceFolder.getFullPath(), outputPath, inclusion, exclusion, true);
                    } else {
                        log.info("Not adding source folder " + sourceFolder.getFullPath() + " because it overlaps with " + enclosing.getPath());
                    }
                }
            }
            ++i;
        }
    }

    private IClasspathEntryDescriptor getEnclosingEntryDescriptor(IClasspathDescriptor classpath, IPath fullPath) {
        for (IClasspathEntryDescriptor cped : classpath.getEntryDescriptors()) {
            if (!cped.getPath().isPrefixOf(fullPath)) continue;
            return cped;
        }
        return null;
    }

    private IClasspathEntryDescriptor getEntryDescriptor(IClasspathDescriptor classpath, IPath fullPath) {
        for (IClasspathEntryDescriptor cped : classpath.getEntryDescriptors()) {
            if (!cped.getPath().equals((Object)fullPath)) continue;
            return cped;
        }
        return null;
    }

    private void addResourceDirs(IClasspathDescriptor classpath, IProject project, MavenProject mavenProject, List<Resource> resources, IPath outputPath, String resourceEncoding, IProgressMonitor monitor) throws CoreException {
        for (Resource resource : resources) {
            File resourceDirectory;
            String directory = resource.getDirectory();
            if (directory == null || !(resourceDirectory = new File(directory)).isDirectory()) continue;
            IPath relativePath = this.getProjectRelativePath(project, directory);
            IResource r = project.findMember(relativePath);
            if (r == project) {
                log.error("Skipping resource folder " + r.getFullPath());
                continue;
            }
            if (r != null && project.equals((Object)r.getProject())) {
                IPath path = r.getFullPath();
                IClasspathEntryDescriptor enclosing = this.getEnclosingEntryDescriptor(classpath, path);
                if (enclosing != null && this.overlapsWithSourceFolder(path, project, mavenProject)) {
                    this.configureOverlapWithSource(classpath, enclosing, path);
                } else if (this.overlapsWithOtherResourceFolder(path, project, mavenProject)) {
                    log.info("Skipping resource folder " + path + " since it's contained by another resource folder");
                } else {
                    this.addResourceFolder(classpath, path, outputPath);
                }
                IFolder resourceFolder = project.getFolder(relativePath);
                resourceFolder.setDefaultCharset(resourceEncoding, monitor);
                continue;
            }
            log.info("Not adding resources folder " + resourceDirectory.getAbsolutePath());
        }
    }

    private void addResourceFolder(IClasspathDescriptor classpath, IPath resourceFolder, IPath outputPath) {
        log.info("Adding resource folder " + resourceFolder);
        classpath.addSourceEntry(resourceFolder, outputPath, DEFAULT_INCLUSIONS, new IPath[]{new Path("**")}, false);
    }

    private void configureOverlapWithSource(IClasspathDescriptor classpath, IClasspathEntryDescriptor enclosing, IPath resourceFolder) {
        log.info("Resources folder " + resourceFolder + " overlaps with sources folder " + enclosing.getPath());
        enclosing.addInclusionPattern((IPath)new Path("**/*.java"));
        enclosing.removeExclusionPattern((IPath)new Path("**"));
        classpath.touchEntry(resourceFolder);
    }

    private boolean overlapsWithSourceFolder(IPath path, IProject project, MavenProject mavenProject) {
        IPath relPath = path.makeRelativeTo(project.getFullPath());
        List compile = mavenProject.getCompileSourceRoots();
        List test = mavenProject.getTestCompileSourceRoots();
        return this.isContained(relPath, project, this.getSourceFolders(project, compile)) || this.isContained(relPath, project, this.getSourceFolders(project, test));
    }

    private boolean overlapsWithOtherResourceFolder(IPath path, IProject project, MavenProject mavenProject) {
        IPath relPath = path.makeRelativeTo(project.getFullPath());
        return this.isContained(relPath, project, this.getOtherResourceFolders(project, mavenProject.getResources(), relPath)) || this.isContained(relPath, project, this.getOtherResourceFolders(project, mavenProject.getTestResources(), relPath));
    }

    private IPath[] getSourceFolders(IProject project, List<String> sources) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (String source : sources) {
            paths.add(this.getProjectRelativePath(project, source));
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    private IPath[] getOtherResourceFolders(IProject project, List<Resource> resources, IPath curPath) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (Resource res : resources) {
            IPath path = this.getProjectRelativePath(project, res.getDirectory());
            if (path.equals((Object)curPath)) continue;
            paths.add(path);
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    private boolean isContained(IPath path, IProject project, IPath[] otherPaths) {
        IPath[] iPathArray = otherPaths;
        int n = otherPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath otherPath = iPathArray[n2];
            if (otherPath.isPrefixOf(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void addJavaProjectOptions(Map<String, String> options, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        String source = null;
        String target = null;
        for (MojoExecution execution : this.getCompilerMojoExecutions(request, monitor)) {
            source = this.getCompilerLevel(request.getMavenProject(), execution, "source", source, SOURCES, monitor);
            target = this.getCompilerLevel(request.getMavenProject(), execution, "target", target, TARGETS, monitor);
        }
        if (source == null) {
            source = this.getDefaultSourceLevel();
            log.warn("Could not determine source level, using default " + source);
        }
        if (target == null) {
            target = this.getDefaultTargetLevel(source);
            log.warn("Could not determine target level, using default " + target);
        }
        source = this.sanitizeJavaVersion(source);
        target = this.sanitizeJavaVersion(target);
        options.put("org.eclipse.jdt.core.compiler.source", source);
        options.put("org.eclipse.jdt.core.compiler.compliance", source);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", target);
        IJavaProject jp = JavaCore.create((IProject)request.getProject());
        if (jp != null && jp.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", false) == null) {
            options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "warning");
        }
    }

    private String sanitizeJavaVersion(String version) {
        switch (version) {
            case "5": 
            case "6": 
            case "7": 
            case "8": 
            case "9": {
                version = "1." + version;
                break;
            }
        }
        return version;
    }

    protected String getDefaultTargetLevel(String source) {
        return DEFAULT_COMPILER_LEVEL;
    }

    protected String getDefaultSourceLevel() {
        return DEFAULT_COMPILER_LEVEL;
    }

    protected List<MojoExecution> getCompilerMojoExecutions(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        return request.getMavenProjectFacade().getMojoExecutions("org.apache.maven.plugins", COMPILER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_COMPILE, GOAL_TESTCOMPILE});
    }

    private String getCompilerLevel(MavenProject mavenProject, MojoExecution execution, String parameter, String source, List<String> levels, IProgressMonitor monitor) {
        int levelIdx = this.getLevelIndex(source, levels);
        try {
            source = (String)this.maven.getMojoParameterValue(mavenProject, execution, parameter, String.class, monitor);
        }
        catch (CoreException ex) {
            log.error("Failed to determine compiler " + parameter + " setting, assuming default", (Throwable)ex);
        }
        int newLevelIdx = this.getLevelIndex(source, levels);
        if (newLevelIdx > levelIdx) {
            levelIdx = newLevelIdx;
        }
        if (levelIdx < 0) {
            return null;
        }
        return levels.get(levelIdx);
    }

    private int getLevelIndex(String level, List<String> levels) {
        return level != null ? levels.indexOf(level) : -1;
    }

    public void unconfigure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        super.unconfigure(request, monitor);
        this.removeMavenClasspathContainer(request.getProject());
    }

    private void removeMavenClasspathContainer(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                    newEntries.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
    }

    protected IFolder getFolder(IProject project, String absolutePath) {
        if (project.getLocation().makeAbsolute().equals((Object)Path.fromOSString((String)absolutePath))) {
            return project.getFolder(project.getLocation());
        }
        return project.getFolder(this.getProjectRelativePath(project, absolutePath));
    }

    protected IPath getProjectRelativePath(IProject project, String absolutePath) {
        File basedir = project.getLocation().toFile();
        String relative = absolutePath.equals(basedir.getAbsolutePath()) ? "." : (absolutePath.startsWith(basedir.getAbsolutePath()) ? absolutePath.substring(basedir.getAbsolutePath().length() + 1) : absolutePath);
        return new Path(relative.replace('\\', '/'));
    }
}

