/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QuotedCSV
implements Iterable<String> {
    private final List<String> _values = new ArrayList<String>();
    private final boolean _keepQuotes;

    public QuotedCSV(String ... values) {
        this(true, values);
    }

    public QuotedCSV(boolean keepQuotes, String ... values) {
        this._keepQuotes = keepQuotes;
        for (String v : values) {
            this.addValue(v);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addValue(String value) {
        buffer = new StringBuffer();
        l = value.length();
        state = State.VALUE;
        quoted = false;
        sloshed = false;
        nws_length = 0;
        last_length = 0;
        block15: for (i = 0; i <= l; ++i) {
            block20: {
                block21: {
                    v0 = c = i == l ? '\u0000' : value.charAt(i);
                    if (!quoted || c == '\u0000') break block20;
                    if (!sloshed) break block21;
                    sloshed = false;
                    ** GOTO lbl-1000
                }
                switch (c) {
                    case '\\': {
                        sloshed = true;
                        if (!this._keepQuotes) {
                            break;
                        }
                        ** GOTO lbl24
                    }
                    case '\"': {
                        quoted = false;
                        if (!this._keepQuotes) break;
                    }
lbl24:
                    // 3 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        buffer.append(c);
                        nws_length = buffer.length();
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\t': 
                case ' ': {
                    if (buffer.length() <= last_length) continue block15;
                    buffer.append(c);
                    continue block15;
                }
                case '\"': {
                    quoted = true;
                    if (this._keepQuotes) {
                        buffer.append(c);
                    }
                    nws_length = buffer.length();
                    continue block15;
                }
                case ';': {
                    buffer.setLength(nws_length);
                    buffer.append(c);
                    last_length = ++nws_length;
                    state = State.PARAM_NAME;
                    continue block15;
                }
                case '\u0000': 
                case ',': {
                    if (nws_length > 0) {
                        buffer.setLength(nws_length);
                        this._values.add(buffer.toString());
                    }
                    buffer.setLength(0);
                    last_length = 0;
                    nws_length = 0;
                    state = State.VALUE;
                    continue block15;
                }
                default: {
                    switch (1.$SwitchMap$org$eclipse$jetty$http$QuotedCSV$State[state.ordinal()]) {
                        case 1: {
                            buffer.append(c);
                            nws_length = buffer.length();
                            continue block15;
                        }
                        case 2: {
                            if (c == '=') {
                                buffer.setLength(nws_length);
                                buffer.append(c);
                                last_length = ++nws_length;
                                state = State.PARAM_VALUE;
                                continue block15;
                            }
                            buffer.append(c);
                            nws_length = buffer.length();
                            continue block15;
                        }
                        case 3: {
                            buffer.append(c);
                            nws_length = buffer.length();
                            continue block15;
                        }
                    }
                }
            }
        }
    }

    public List<String> getValues() {
        return this._values;
    }

    @Override
    public Iterator<String> iterator() {
        return this._values.iterator();
    }

    public static String unquote(String s) {
        char c;
        int i;
        int l = s.length();
        if (s == null || l == 0) {
            return s;
        }
        for (i = 0; i < l && (c = s.charAt(i)) != '\"'; ++i) {
        }
        if (i == l) {
            return s;
        }
        boolean quoted = true;
        boolean sloshed = false;
        StringBuffer buffer = new StringBuffer();
        buffer.append(s, 0, i);
        ++i;
        while (i < l) {
            char c2 = s.charAt(i);
            if (quoted) {
                if (sloshed) {
                    buffer.append(c2);
                    sloshed = false;
                } else if (c2 == '\"') {
                    quoted = false;
                } else if (c2 == '\\') {
                    sloshed = true;
                } else {
                    buffer.append(c2);
                }
            } else if (c2 == '\"') {
                quoted = true;
            } else {
                buffer.append(c2);
            }
            ++i;
        }
        return buffer.toString();
    }

    private static enum State {
        VALUE,
        PARAM_NAME,
        PARAM_VALUE;

    }
}

