/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.io.xdsl;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.recommenders.internal.jayes.io.util.XMLUtil;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.io.IBayesNetReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XDSLReader
implements IBayesNetReader {
    private final InputStream str;

    public XDSLReader(InputStream str) {
        this.str = str;
    }

    @Override
    public BayesNet read() throws IOException {
        Document doc = this.obtainDocument(this.str);
        return this.readFromDocument(doc);
    }

    public BayesNet readFromString(String xdslString) throws IOException {
        Document doc = this.obtainDocument(new ByteArrayInputStream(xdslString.getBytes()));
        return this.readFromDocument(doc);
    }

    private Document obtainDocument(InputStream xdslStream) throws IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBldr = docBuilderFactory.newDocumentBuilder();
            Document doc = docBldr.parse(xdslStream);
            doc.normalize();
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Bad parser configuration, probably missing dependency", e);
        }
        catch (SAXException e) {
            throw new IOException("Parse failed", e);
        }
    }

    private BayesNet readFromDocument(Document doc) {
        BayesNet net = new BayesNet();
        Node smileNode = doc.getElementsByTagName("smile").item(0);
        String networkName = this.getId(smileNode);
        net.setName(XMLUtil.unescape(networkName));
        this.intializeNodes(doc, net);
        this.initializeNodeOutcomes(doc, net);
        this.setParents(doc, net);
        this.parseProbabilities(doc, net);
        return net;
    }

    private void intializeNodes(Document doc, BayesNet net) {
        NodeList nodelist = doc.getElementsByTagName("cpt");
        int i = 0;
        while (i < nodelist.getLength()) {
            net.createNode(this.getId(nodelist.item(i)));
            ++i;
        }
    }

    private String getId(Node node) {
        return XMLUtil.unescape(node.getAttributes().getNamedItem("id").getTextContent());
    }

    private void initializeNodeOutcomes(Document doc, BayesNet net) {
        NodeList nodelist = doc.getElementsByTagName("state");
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node = nodelist.item(i);
            BayesNode bNode = net.getNode(this.getId(node.getParentNode()));
            bNode.addOutcome(this.getId(node));
            ++i;
        }
    }

    private void setParents(Document doc, BayesNet net) {
        NodeList nodelist = doc.getElementsByTagName("parents");
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node = nodelist.item(i);
            BayesNode bNode = net.getNode(this.getId(node.getParentNode()));
            ArrayList parentNames = Lists.newArrayList();
            Iterables.addAll((Collection)parentNames, (Iterable)Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().split((CharSequence)node.getTextContent()));
            ArrayList parents = Lists.newArrayList();
            for (String parentname : parentNames) {
                parents.add(net.getNode(XMLUtil.unescape(parentname)));
            }
            bNode.setParents((List)parents);
            ++i;
        }
    }

    private void parseProbabilities(Document doc, BayesNet net) {
        NodeList nodelist = doc.getElementsByTagName("probabilities");
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node = nodelist.item(i);
            BayesNode bNode = net.getNode(this.getId(node.getParentNode()));
            String table = node.getTextContent();
            ArrayList probabilities = Lists.newArrayList();
            StringTokenizer tok = new StringTokenizer(table);
            while (tok.hasMoreTokens()) {
                probabilities.add(Double.valueOf(tok.nextToken()));
            }
            bNode.setProbabilities(Doubles.toArray((Collection)probabilities));
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        this.str.close();
    }
}

